/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class ArrayNew
extends Procedure1
implements Inlineable,
Externalizable {
    Type element_type;

    public ArrayNew(Type element_type) {
        this.element_type = element_type;
    }

    @Override
    public Object apply1(Object count) {
        return Array.newInstance(this.element_type.getReflectClass(), ((Number)count).intValue());
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        exp.getArgs()[0].compile(comp, Type.int_type);
        CodeAttr code = comp.getCode();
        code.emitNewArray(this.element_type);
        target.compileFromStack(comp, ArrayType.make(this.element_type));
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return ArrayType.make(this.element_type);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element_type);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element_type = (Type)in.readObject();
    }
}

