/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure3;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class ArraySet
extends Procedure3
implements Inlineable,
Externalizable {
    Type element_type;

    public ArraySet(Type element_type) {
        this.element_type = element_type;
    }

    @Override
    public Object apply3(Object array, Object index, Object value) {
        Array.set(array, ((Number)index).intValue(), this.element_type.coerceFromObject(value));
        return Values.empty;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        args[0].compile(comp, ArrayType.make(this.element_type));
        args[1].compile(comp, Type.int_type);
        args[2].compile(comp, this.element_type);
        comp.getCode().emitArrayStore(this.element_type);
        comp.compileConstant(Values.empty, target);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.void_type;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element_type);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element_type = (Type)in.readObject();
    }
}

