/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KAttr;
import gnu.kawa.xml.KCDATASection;
import gnu.kawa.xml.KComment;
import gnu.kawa.xml.KDocument;
import gnu.kawa.xml.KElement;
import gnu.kawa.xml.KProcessingInstruction;
import gnu.kawa.xml.KText;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.TreePosition;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.text.Path;
import gnu.xml.NodeTree;
import gnu.xml.XMLPrinter;

public abstract class KNode
extends SeqPosition
implements Consumable {
    public KNode(NodeTree seq, int ipos) {
        super(seq, ipos);
    }

    public static Object atomicValue(Object value) {
        if (value instanceof KNode) {
            KNode node = (KNode)value;
            return ((NodeTree)node.sequence).typedValue(node.ipos);
        }
        return value;
    }

    public static KNode coerce(Object value) {
        if (value instanceof KNode) {
            return (KNode)value;
        }
        if (value instanceof NodeTree) {
            NodeTree ntree = (NodeTree)value;
            return KNode.make(ntree, ntree.startPos());
        }
        if (value instanceof SeqPosition && !(value instanceof TreePosition)) {
            SeqPosition seqp = (SeqPosition)value;
            if (seqp.sequence instanceof NodeTree) {
                return KNode.make((NodeTree)seqp.sequence, seqp.ipos);
            }
        }
        return null;
    }

    public static KNode make(NodeTree seq, int ipos) {
        int index = seq.posToDataIndex(ipos);
        while (index < seq.data.length && seq.data[index] == '\uf112') {
            if ((index += 5) == seq.gapStart) {
                index = seq.gapEnd;
            }
            ipos = index << 1;
        }
        int kind = seq.getNextKindI(seq.posToDataIndex(ipos));
        switch (kind) {
            case 33: {
                return new KElement(seq, ipos);
            }
            case 35: {
                return new KAttr(seq, ipos);
            }
            case 34: {
                return new KDocument(seq, ipos);
            }
            case 31: {
                return new KCDATASection(seq, ipos);
            }
            case 36: {
                return new KComment(seq, ipos);
            }
            case 37: {
                return new KProcessingInstruction(seq, ipos);
            }
            case 0: {
                if (seq.isEmpty()) break;
                return null;
            }
        }
        return new KText(seq, ipos);
    }

    @Override
    public SeqPosition copy() {
        return KNode.make((NodeTree)this.sequence, this.sequence.copyPos(this.getPos()));
    }

    public static KNode make(NodeTree seq) {
        return KNode.make(seq, 0);
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNodeName() {
        return this.sequence.getNextTypeName(this.ipos);
    }

    public Symbol getNodeSymbol() {
        Object type = ((NodeTree)this.sequence).getNextTypeObject(this.ipos);
        if (type == null) {
            return null;
        }
        if (type instanceof Symbol) {
            return (Symbol)type;
        }
        return Namespace.EmptyNamespace.getSymbol(type.toString().intern());
    }

    public Object getNodeNameObject() {
        return ((NodeTree)this.sequence).getNextTypeObject(this.ipos);
    }

    public String getNamespaceURI() {
        return ((NodeTree)this.sequence).posNamespaceURI(this.ipos);
    }

    public String getPrefix() {
        return ((NodeTree)this.sequence).posPrefix(this.ipos);
    }

    public String getLocalName() {
        return ((NodeTree)this.sequence).posLocalName(this.ipos);
    }

    public static String getNodeValue(NodeTree seq, int ipos) {
        StringBuffer sbuf = new StringBuffer();
        KNode.getNodeValue(seq, ipos, sbuf);
        return sbuf.toString();
    }

    public static void getNodeValue(NodeTree seq, int ipos, StringBuffer sbuf) {
        seq.stringValue(seq.posToDataIndex(ipos), sbuf);
    }

    public String getNodeValue() {
        StringBuffer sbuf = new StringBuffer();
        this.getNodeValue(sbuf);
        return sbuf.toString();
    }

    public void getNodeValue(StringBuffer sbuf) {
        KNode.getNodeValue((NodeTree)this.sequence, this.ipos, sbuf);
    }

    public boolean hasChildNodes() {
        return ((NodeTree)this.sequence).posFirstChild(this.ipos) >= 0;
    }

    public String getTextContent() {
        StringBuffer sbuf = new StringBuffer();
        this.getTextContent(sbuf);
        return sbuf.toString();
    }

    protected void getTextContent(StringBuffer sbuf) {
        this.getNodeValue(sbuf);
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return ((NodeTree)this.sequence).posIsDefaultNamespace(this.ipos, namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return ((NodeTree)this.sequence).posLookupNamespaceURI(this.ipos, prefix);
    }

    public String lookupPrefix(String namespaceURI) {
        return ((NodeTree)this.sequence).posLookupPrefix(this.ipos, namespaceURI);
    }

    public String getBaseURI() {
        Path uri = ((NodeTree)this.sequence).baseUriOfPos(this.ipos, true);
        return uri == null ? null : uri.toString();
    }

    public Path baseURI() {
        return ((NodeTree)this.sequence).baseUriOfPos(this.ipos, true);
    }

    @Override
    public String toString() {
        CharArrayOutPort wr = new CharArrayOutPort();
        XMLPrinter xp = new XMLPrinter(wr);
        ((NodeTree)this.sequence).consumeNext(this.ipos, xp);
        xp.close();
        wr.close();
        return wr.toString();
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public void consume(Consumer out) {
        if (out instanceof PositionConsumer) {
            ((PositionConsumer)((Object)out)).consume(this);
        } else {
            ((NodeTree)this.sequence).consumeNext(this.ipos, out);
        }
    }
}

