/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.GapVector;
import gnu.lists.SimpleVector;

public class StableVector
extends GapVector {
    protected int[] positions;
    protected int free;
    protected static final int FREE_POSITION = -2;
    static final int START_POSITION = 0;
    static final int END_POSITION = 1;

    protected void chainFreelist() {
        this.free = -1;
        int i = this.positions.length;
        while (--i > 1) {
            int pos = this.positions[i];
            if (pos != -2) continue;
            this.positions[i] = this.free;
            this.free = i;
        }
    }

    protected void unchainFreelist() {
        int i = this.free;
        while (i >= 0) {
            int next = this.positions[i];
            this.positions[i] = -2;
            i = next;
        }
        this.free = -2;
    }

    @Override
    public int startPos() {
        return 0;
    }

    @Override
    public int endPos() {
        return 1;
    }

    public StableVector(SimpleVector base) {
        super(base);
        this.positions = new int[16];
        this.positions[0] = 0;
        this.positions[1] = base.getBufferLength() << 1 | 1;
        this.free = -1;
        int i = this.positions.length;
        while (--i >= 2) {
            this.positions[i] = this.free;
            this.free = i;
        }
    }

    protected StableVector() {
    }

    protected int allocPositionIndex() {
        if (this.free == -2) {
            this.chainFreelist();
        }
        if (this.free < 0) {
            int oldLength = this.positions.length;
            int[] tmp = new int[2 * oldLength];
            System.arraycopy(this.positions, 0, tmp, 0, oldLength);
            int i = 2 * oldLength;
            while (--i >= oldLength) {
                tmp[i] = this.free;
                this.free = i;
            }
            this.positions = tmp;
        }
        int pos = this.free;
        this.free = this.positions[this.free];
        return pos;
    }

    @Override
    public int createPos(int index, boolean isAfter) {
        if (index == 0 && !isAfter) {
            return 0;
        }
        if (isAfter && index == this.size()) {
            return 1;
        }
        if (index > this.gapStart || index == this.gapStart && isAfter) {
            index += this.gapEnd - this.gapStart;
        }
        int ipos = this.allocPositionIndex();
        this.positions[ipos] = index << 1 | (isAfter ? 1 : 0);
        return ipos;
    }

    @Override
    protected boolean isAfterPos(int ipos) {
        return (this.positions[ipos] & 1) != 0;
    }

    @Override
    public boolean hasNext(int ipos) {
        int ppos = this.positions[ipos];
        int index = ppos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        return index < this.base.getBufferLength();
    }

    @Override
    public int nextPos(int ipos) {
        int ppos = this.positions[ipos];
        int index = ppos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if (index >= this.base.getBufferLength()) {
            this.releasePos(ipos);
            return 0;
        }
        if (ipos == 0) {
            ipos = this.createPos(0, true);
        }
        this.positions[ipos] = ppos | 1;
        return ipos;
    }

    @Override
    public int nextIndex(int ipos) {
        int index = this.positions[ipos] >>> 1;
        if (index > this.gapStart) {
            index -= this.gapEnd - this.gapStart;
        }
        return index;
    }

    @Override
    public void releasePos(int ipos) {
        if (ipos >= 2) {
            if (this.free == -2) {
                this.chainFreelist();
            }
            this.positions[ipos] = this.free;
            this.free = ipos;
        }
    }

    @Override
    public int copyPos(int ipos) {
        if (ipos > 1) {
            int i = this.allocPositionIndex();
            this.positions[i] = this.positions[ipos];
            ipos = i;
        }
        return ipos;
    }

    @Override
    public void fillPosRange(int fromPos, int toPos, Object value) {
        this.fillPosRange(this.positions[fromPos], this.positions[toPos], value);
    }

    @Override
    protected void shiftGap(int newGapStart) {
        int adjust;
        int high;
        int low;
        int oldGapStart = this.gapStart;
        int delta = newGapStart - oldGapStart;
        if (delta > 0) {
            low = this.gapEnd;
            high = low + delta;
            adjust = oldGapStart - low << 1;
            low <<= 1;
            high = (high << 1) - 1;
        } else {
            if (newGapStart == oldGapStart) {
                return;
            }
            low = (newGapStart << 1) + 1;
            high = oldGapStart << 1;
            adjust = this.gapEnd - oldGapStart << 1;
        }
        super.shiftGap(newGapStart);
        this.adjustPositions(low, high, adjust);
    }

    protected void adjustPositions(int low, int high, int delta) {
        if (this.free >= 0) {
            this.unchainFreelist();
        }
        low ^= Integer.MIN_VALUE;
        high ^= Integer.MIN_VALUE;
        int i = this.positions.length;
        while (--i > 0) {
            int index;
            int pos = this.positions[i];
            if (pos == -2 || (index = pos ^ Integer.MIN_VALUE) < low || index > high) continue;
            this.positions[i] = pos + delta;
        }
    }

    @Override
    protected void gapReserve(int size) {
        int oldGapEnd = this.gapEnd;
        int oldLength = this.base.getBufferLength();
        super.gapReserve(size);
        int newLength = this.base.getBufferLength();
        this.adjustPositions(oldGapEnd << 1, newLength << 1 | 1, newLength - oldLength << 1);
    }

    @Override
    protected int addPos(int ipos, Object value) {
        int ppos = this.positions[ipos];
        int index = ppos >>> 1;
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        if ((ppos & 1) == 0) {
            if (ipos == 0) {
                ipos = this.createPos(0, true);
            } else {
                this.positions[ipos] = ppos | 1;
            }
        }
        this.add(index, value);
        return ipos;
    }

    @Override
    protected void removePosRange(int ipos0, int ipos1) {
        super.removePosRange(this.positions[ipos0], this.positions[ipos1]);
        int low = this.gapStart;
        int high = this.gapEnd;
        if (this.free >= 0) {
            this.unchainFreelist();
        }
        int i = this.positions.length;
        while (--i > 0) {
            boolean isAfter;
            int pos = this.positions[i];
            if (pos == -2) continue;
            int index = pos >> 1;
            boolean bl = isAfter = (pos & 1) != 0;
            if (isAfter) {
                if (index < low || index >= high) continue;
                this.positions[i] = this.gapEnd << 1 | 1;
                continue;
            }
            if (index <= low || index > high) continue;
            this.positions[i] = this.gapStart << 1;
        }
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        super.consumePosRange(this.positions[iposStart], this.positions[iposEnd], out);
    }
}

