/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.InheritingEnvironment;
import gnu.mapping.Location;
import gnu.mapping.NamedLocation;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.SharedLocation;
import gnu.mapping.Symbol;

public class RunnableClosure
implements Runnable {
    Object result;
    CallContext context;
    public Environment environment;
    private InPort in;
    private OutPort out;
    private OutPort err;
    Throwable exception;
    Procedure action;
    String name;
    static int nrunnables = 0;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RunnableClosure(Procedure action, CallContext parentContext) {
        this(action, parentContext, parentContext.getEnvironment());
    }

    public RunnableClosure(Procedure action, CallContext parentContext, Environment penvironment) {
        this.setName("r" + nrunnables++);
        this.action = action;
        InheritingEnvironment env = Environment.make(this.getName(), penvironment);
        env.flags |= 8;
        env.flags &= 0xFFFFFFEF;
        this.environment = env;
        int n = parentContext.pushedFluidsCount;
        for (int i = 0; i < n; ++i) {
            Location loc = parentContext.pushedFluids[i];
            Symbol name = loc.getKeySymbol();
            Object property = loc.getKeyProperty();
            if (name == null || !(loc instanceof NamedLocation)) continue;
            NamedLocation nloc = (NamedLocation)loc;
            if (nloc.base == null) {
                SharedLocation sloc = new SharedLocation(name, property, 0);
                sloc.value = nloc.value;
                nloc.base = sloc;
                nloc.value = null;
                nloc = sloc;
            }
            int hash = name.hashCode() ^ System.identityHashCode(property);
            NamedLocation xloc = env.addUnboundLocation(name, property, hash);
            xloc.base = nloc;
        }
    }

    public RunnableClosure(Procedure action, Environment penvironment, InPort in, OutPort out, OutPort err) {
        this(action, CallContext.getInstance(), penvironment);
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public RunnableClosure(Procedure action) {
        this(action, CallContext.getInstance());
    }

    public final CallContext getCallContext() {
        return this.context;
    }

    @Override
    public void run() {
        try {
            if (this.context == null) {
                this.context = CallContext.getInstance();
            } else {
                CallContext.setInstance(this.context);
            }
            this.context.curEnvironment = this.environment;
            if (this.in != null) {
                InPort.setInDefault(this.in);
            }
            if (this.out != null) {
                OutPort.setOutDefault(this.out);
            }
            if (this.err != null) {
                OutPort.setErrDefault(this.err);
            }
            this.result = this.action.apply0();
        }
        catch (Throwable ex) {
            this.exception = ex;
        }
    }

    Object getResult() throws Throwable {
        Throwable ex = this.exception;
        if (ex != null) {
            throw ex;
        }
        return this.result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("#<runnable ");
        buf.append(this.getName());
        buf.append(">");
        return buf.toString();
    }
}

