/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DFloNum;
import gnu.math.ExponentialFormat;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.math.RealNum;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class FixedRealFormat
extends Format {
    private int i;
    private int d;
    public int width;
    public int scale;
    public char padChar;
    public boolean showPlus;
    public boolean internalPad;
    public char overflowChar;

    public int getMaximumFractionDigits() {
        return this.d;
    }

    public int getMinimumIntegerDigits() {
        return this.i;
    }

    public void setMaximumFractionDigits(int d) {
        this.d = d;
    }

    public void setMinimumIntegerDigits(int i) {
        this.i = i;
    }

    public void format(RatNum number, boolean negative, StringBuffer sbuf, FieldPosition fpos) {
        int length;
        int digits;
        int i;
        String string;
        int decimals = this.getMaximumFractionDigits();
        int oldSize = sbuf.length();
        int signLen = 1;
        if (negative) {
            sbuf.append('-');
        } else if (this.showPlus) {
            sbuf.append('+');
        } else {
            signLen = 0;
        }
        if (decimals < 0) {
            char skip;
            int nextDigit;
            double val = number.doubleValue();
            int log = (int)(Math.log(val) / ExponentialFormat.LOG10);
            int cur_scale = log == Integer.MIN_VALUE ? 0 : 17 - log;
            string = RealNum.toScaledInt(val, cur_scale).toString();
            i = string.length();
            digits = i - cur_scale + this.scale;
            decimals = this.width > 0 ? this.width - signLen - 1 - digits : (i > 16 ? 16 : i) - digits;
            if (decimals < 0) {
                decimals = 0;
            }
            sbuf.append(string);
            int digStart = oldSize + signLen;
            int digEnd = digStart + digits + decimals;
            i = sbuf.length();
            if (digEnd >= i) {
                digEnd = i;
                nextDigit = 48;
            } else {
                nextDigit = sbuf.charAt(digEnd);
            }
            boolean addOne = nextDigit >= 53;
            char c = skip = addOne ? (char)'9' : '0';
            while (digEnd > digStart + digits && sbuf.charAt(digEnd - 1) == skip) {
                --digEnd;
            }
            length = digEnd - digStart;
            decimals = length - digits;
            if (addOne && ExponentialFormat.addOne(sbuf, digStart, digEnd)) {
                decimals = 0;
                length = ++digits;
            }
            if (decimals == 0 && (this.width <= 0 || signLen + digits + 1 < this.width)) {
                decimals = 1;
                ++length;
                sbuf.insert(digStart + digits, '0');
            }
            sbuf.setLength(digStart + length);
        } else {
            string = RealNum.toScaledInt(number, decimals + this.scale).toString();
            sbuf.append(string);
            length = string.length();
            digits = length - decimals;
        }
        int total_digits = digits + decimals;
        int zero_digits = this.getMinimumIntegerDigits();
        zero_digits = digits >= 0 && digits > zero_digits ? 0 : (zero_digits -= digits);
        if (digits + zero_digits <= 0 && (this.width <= 0 || this.width > decimals + 1 + signLen)) {
            ++zero_digits;
        }
        int needed = signLen + length + zero_digits + 1;
        int padding = this.width - needed;
        i = zero_digits;
        while (--i >= 0) {
            sbuf.insert(oldSize + signLen, '0');
        }
        if (padding >= 0) {
            i = oldSize;
            if (this.internalPad && signLen > 0) {
                ++i;
            }
            while (--padding >= 0) {
                sbuf.insert(i, this.padChar);
            }
        } else if (this.overflowChar != '\u0000') {
            sbuf.setLength(oldSize);
            this.i = this.width;
            while (--this.i >= 0) {
                sbuf.append(this.overflowChar);
            }
            return;
        }
        int newSize = sbuf.length();
        sbuf.insert(newSize - decimals, '.');
    }

    public void format(RatNum number, StringBuffer sbuf, FieldPosition fpos) {
        boolean negative = number.isNegative();
        if (negative) {
            number = (RatNum)number.rneg();
        }
        this.format(number, negative, sbuf, fpos);
    }

    public void format(RealNum number, StringBuffer sbuf, FieldPosition fpos) {
        if (number instanceof RatNum) {
            this.format((RatNum)number, sbuf, fpos);
        } else {
            this.format(number.doubleValue(), sbuf, fpos);
        }
    }

    public StringBuffer format(long num, StringBuffer sbuf, FieldPosition fpos) {
        this.format(IntNum.make(num), sbuf, fpos);
        return sbuf;
    }

    public StringBuffer format(double num, StringBuffer sbuf, FieldPosition fpos) {
        boolean negative;
        if (num < 0.0) {
            negative = true;
            num = -num;
        } else {
            negative = false;
        }
        this.format(DFloNum.toExact(num), negative, sbuf, fpos);
        return sbuf;
    }

    @Override
    public StringBuffer format(Object num, StringBuffer sbuf, FieldPosition fpos) {
        return this.format(((RealNum)num).doubleValue(), sbuf, fpos);
    }

    public Number parse(String text, ParsePosition status) {
        throw new Error("RealFixedFormat.parse - not implemented");
    }

    @Override
    public Object parseObject(String text, ParsePosition status) {
        throw new Error("RealFixedFormat.parseObject - not implemented");
    }
}

