/*
 * Decompiled with CFR 0.152.
 */
package gnu.q2.lang;

import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.xml.MakeAttribute;
import gnu.lists.LList;
import gnu.lists.PairWithPosition;
import gnu.lists.Sequence;
import gnu.mapping.InPort;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;

public class Q2Read
extends LispReader {
    String expressionStartFile;
    int expressionStartLine;
    int expressionStartColumn;

    void init() {
        this.initialColonIsKeyword = false;
        ((InPort)this.port).readState = (char)32;
    }

    public Q2Read(InPort port) {
        super(port);
        this.init();
    }

    public Q2Read(InPort port, SourceMessages messages) {
        super(port, messages);
        this.init();
    }

    int skipIndentation() throws IOException, SyntaxException {
        int numTabs = 0;
        int numSpaces = 0;
        int ch = this.port.read();
        while (ch == 9) {
            ++numTabs;
            ch = this.port.read();
        }
        while (ch == 32) {
            ++numSpaces;
            ch = this.port.read();
        }
        if (ch < 0) {
            return -1;
        }
        this.port.unread();
        return (numTabs << 16) + numSpaces;
    }

    boolean singleLine() {
        return this.interactive && this.nesting == 0;
    }

    @Override
    public Object readCommand() throws IOException, SyntaxException {
        return this.readCommand(false);
    }

    public Object readCommand(boolean forceList) throws IOException, SyntaxException {
        int ch;
        int startColumn;
        int line = this.port.getLineNumber();
        int lastColumn = startColumn = this.port.getColumnNumber();
        Object obj = LList.Empty;
        PairWithPosition pair = null;
        PairWithPosition last = null;
        while ((ch = this.read()) >= 0) {
            Object next;
            if (ch == 32 || ch == 9) continue;
            this.unread();
            if (ch == 41) break;
            line = this.port.getLineNumber();
            int column = this.port.getColumnNumber();
            while (ch == 13 || ch == 10) {
                if (this.singleLine()) {
                    return obj;
                }
                ch = this.read();
                this.skipIndentation();
                column = this.port.getColumnNumber();
                ch = this.peek();
                if (column > startColumn) continue;
            }
            if (column <= startColumn && last != null) break;
            if (column == lastColumn && last != null) {
                next = this.readCommand();
            } else if (column < lastColumn && last != null) {
                Object n;
                PairWithPosition p = pair;
                while ((n = p.cdr) != LList.Empty) {
                    PairWithPosition np = (PairWithPosition)n;
                    int pColumn = np.getColumnNumber() - 1;
                    if (pColumn >= column) {
                        if (pColumn > column) {
                            this.error('e', "some tokens on previous line indented more than current line");
                        }
                        if ((n = np.cdr) == LList.Empty) break;
                        if (((PairWithPosition)n).getColumnNumber() - 1 == column) {
                            p = (PairWithPosition)n;
                            continue;
                        }
                        last = (PairWithPosition)this.makePair(np, this.port.getLineNumber(), column);
                        p.cdr = last;
                        break;
                    }
                    p = np;
                }
                next = this.readCommand();
            } else {
                next = this.readObject();
            }
            if (next == Sequence.eofValue) break;
            lastColumn = column;
            String filename = this.port.getName();
            PairWithPosition cur = PairWithPosition.make(next, LList.Empty, filename, line + 1, column + 1);
            if (last == null) {
                pair = cur;
                obj = cur;
            } else {
                if (last.car instanceof Keyword) {
                    QuoteExp name = new QuoteExp((Object)((Keyword)last.car).getName());
                    last.car = new PairWithPosition(last, MakeAttribute.makeAttribute, new PairWithPosition(last, name, cur));
                    continue;
                }
                last.cdr = cur;
            }
            last = cur;
        }
        if (!forceList) {
            if (obj == last) {
                obj = last.car;
            } else if (last == null) {
                obj = QuoteExp.voidExp;
            }
        }
        return obj;
    }

    public static Object readObject(InPort port) throws IOException, SyntaxException {
        return new Q2Read(port).readObject();
    }

    void saveExpressionStartPosition() {
        this.expressionStartFile = this.port.getName();
        this.expressionStartLine = this.port.getLineNumber();
        this.expressionStartColumn = this.port.getColumnNumber();
    }
}

