/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.math.IntNum;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prorate.export.Prorate;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelDo;
import jp.sourceforge.gnp.prubae.PrubaeModelFunction;
import jp.sourceforge.gnp.prubae.PrubaeModelJudge;
import jp.sourceforge.gnp.prubae.PrubaeReader;
import jp.sourceforge.gnp.prubae.PrubaeView;
import jp.sourceforge.gnp.prubae.PrubaeWriter;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.xml.PrubaeReaderXml;
import jp.sourceforge.gnp.rulebase.xml.PrubaeWriterXml;

public class Prubae
implements ActionListener {
    public static final String propertyFile = "jp/sourceforge/gnp/prubae.properties";
    public static final String PrubaeEditFile = "file";
    public static final String PrubaeEditUrl = "url";
    public static final String prubaercFile = "jp/sourceforge/gnp/prubae/prubaerc";
    private JPanel rootPanel = null;
    private JPanel mainPanel = null;
    private JPanel treePanel = null;
    private JPanel partPanel = null;
    private JMenu fileMenu = null;
    private JMenu editMenu = null;
    private JMenu helpMenu = null;
    private JScrollPane scrollPane = null;
    private JTree tree = null;
    private String editType = null;
    private String filename = null;
    private String urlname = null;
    private String rulebaseDirectory;
    private String additionalPropertyFilename = null;
    private DefaultTreeModel treeModel = null;
    private JFileChooser chooser = null;
    private LList configList = (LList)Lisp.nil;
    private LList doList = (LList)Lisp.nil;
    private LList judgeList = (LList)Lisp.nil;
    private LList valueList = (LList)Lisp.nil;
    private LList varList = (LList)Lisp.nil;
    private LList constList = (LList)Lisp.nil;
    private LList settablevarList = (LList)Lisp.nil;
    private LList savedVarList = null;
    protected PrubaeModel model = null;
    protected PrubaeView view = null;
    protected PrubaeController controller = null;
    protected PrubaeReader reader = null;
    protected PrubaeWriter writer = null;
    protected PrubaeModel yank = null;

    public Prubae() {
        System.err.println("new Prubae()");
    }

    public void initialize() {
        String confFileName;
        ClassLoader loader;
        File propFile;
        String propPath;
        this.setAdditionalPropertyFilename(System.getProperty("PRUBAE_PROPERTIES_FILE"));
        if (this.getAdditionalPropertyFilename() == null) {
            propPath = System.getProperty("user.dir");
            propPath = propPath + System.getProperty("file.separator");
            propFile = new File(propPath = propPath + ".prubae.properties");
            if (propFile.exists()) {
                this.setAdditionalPropertyFilename(propPath);
            }
        }
        if (this.getAdditionalPropertyFilename() == null) {
            propPath = System.getProperty("user.home");
            propPath = propPath + System.getProperty("file.separator");
            propFile = new File(propPath = propPath + ".prubae.properties");
            if (propFile.exists()) {
                this.setAdditionalPropertyFilename(propPath);
            }
        }
        String ruleDir = null;
        ruleDir = System.getProperty("GNP_RULE_DIR");
        System.err.println("Prubae.initialize(): GNP_RULE_DIR, ruleDir = " + ruleDir);
        Properties properties = new Properties();
        if (ruleDir == null) {
            String propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
            if (propertyFileName == null) {
                propertyFileName = System.getProperty("user.home");
                propertyFileName = propertyFileName + System.getProperty("file.separator");
                propertyFileName = propertyFileName + ".prorate.properties";
            }
            FileInputStream propertyFile = null;
            try {
                propertyFile = new FileInputStream(propertyFileName);
            }
            catch (FileNotFoundException e) {
                propertyFile = null;
            }
            System.err.println("propertyFileName = " + propertyFileName + ", propertyFile = " + propertyFile);
            InputStream is = null;
            if (propertyFile == null) {
                loader = Prorate.class.getClassLoader();
                is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
            } else {
                is = propertyFile;
            }
            try {
                properties.load(is);
            }
            catch (IOException eProperty) {
                System.err.println("IOException in Prubae.initialize() in reading jp/sourceforge/gnp/prorate.properties: " + eProperty.getMessage());
            }
            ruleDir = properties.getProperty("GNP_RULE_DIR", "/usr/local/gnp/rulebase");
        }
        System.err.println("Prubae.initialize(): ruleDir = " + ruleDir);
        if (this.getAdditionalPropertyFilename() != null) {
            String propFile2 = this.getAdditionalPropertyFilename();
            FileInputStream propIn = null;
            if (!propFile2.startsWith("http:")) {
                try {
                    propIn = new FileInputStream(propFile2);
                }
                catch (FileNotFoundException e) {
                    propIn = null;
                }
                if (propIn != null) {
                    try {
                        properties.load(propIn);
                    }
                    catch (IOException eAdditionalProperty) {
                        System.err.println("IOException in Prubae.initialize() in reading " + this.getAdditionalPropertyFilename() + " : " + eAdditionalProperty.getMessage());
                    }
                }
            }
        }
        this.setRulebaseDirectory(ruleDir);
        if (this.getWriter() == null) {
            this.setWriter(new PrubaeWriterXml());
            this.getWriter().setEditor(this);
        }
        System.err.println("Prubae(): before getReader() and new PrubaeReaderXml()");
        if (this.getReader() == null) {
            System.err.println("Prubae(): getReader()==" + this.getReader() + ", before new PrubaeReaderXml()");
            this.setReader(new PrubaeReaderXml());
            this.getReader().setEditor(this);
            this.getReader().initialize();
            System.err.println("Prubae(): getReader()==" + this.getReader() + ", after new PrubaeReaderXml()");
            this.getReader().setEditor(this);
        }
        if ((confFileName = System.getProperty("PRUBAERC")) == null) {
            confFileName = System.getProperty("user.home");
            confFileName = confFileName + System.getProperty("file.separator");
            confFileName = confFileName + ".prubaerc";
        }
        FileReader confFile = null;
        try {
            confFile = new FileReader(confFileName);
        }
        catch (FileNotFoundException e) {
            confFile = null;
        }
        System.err.println("confFileName = " + confFileName + ", confFile = " + confFile);
        LList tree = null;
        try {
            if (confFile != null) {
                tree = Lisp.read(confFile);
            } else {
                loader = Prubae.class.getClassLoader();
                InputStream is = loader.getResourceAsStream(prubaercFile);
                tree = Lisp.read(is);
            }
        }
        catch (Exception e) {
            System.err.println("configuration read error : " + e.getMessage());
            return;
        }
        this.initConfTree(tree);
    }

    public void initConfTree(LList tree) {
        Object obj;
        this.configList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeConfig", tree)));
        this.doList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeDoFunctions", tree)));
        this.judgeList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeJudgeFunctions", tree)));
        this.valueList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeValueFunctions", tree)));
        this.varList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeVariables", tree)));
        this.constList = (LList)Lisp.cdr(Lisp.assoc("prubaeConstantValues", tree));
        this.settablevarList = (LList)Lisp.car(Lisp.cdr(Lisp.assoc("prubaeSettableVariables", tree)));
        List extfDoList = this.getReader().getAllActionExtfs();
        System.err.println("initConfTree: extfDoList.size() = " + extfDoList.size());
        for (int i = 0; i < extfDoList.size(); ++i) {
            List objs = (List)extfDoList.get(i);
            obj = objs.get(0);
            int numArgs = objs.size() - 1;
            Object argsList = Lisp.nil;
            for (int j = 0; j < numArgs; ++j) {
                argsList = Lisp.cons("any", argsList);
            }
            IntNum regist = new IntNum(2559);
            IntNum numArgsInt = new IntNum(numArgs);
            Pair insList = Lisp.cons(regist, Lisp.cons(obj, Lisp.cons(obj, Lisp.cons(Lisp.nil, Lisp.cons(numArgsInt, argsList)))));
            this.doList = Lisp.append(this.doList, Lisp.cons(insList, Lisp.nil));
        }
        List partDoList = this.getReader().getAllParts();
        System.err.println("initConfTree: partDoList.size() = " + partDoList.size());
        for (int i = 0; i < partDoList.size(); ++i) {
            obj = partDoList.get(i);
            IntNum regist = new IntNum(313);
            Pair insList = Lisp.cons(regist, Lisp.cons(obj, Lisp.cons(obj, Lisp.cons(Lisp.nil, Lisp.cons(0, Lisp.nil)))));
            this.doList = Lisp.append(this.doList, Lisp.cons(insList, Lisp.nil));
        }
        List extfJudgeList = this.getReader().getAllJudgeExtfs();
        System.err.println("initConfTree: extfJudgeList.size() = " + extfJudgeList.size());
        for (int i = 0; i < extfJudgeList.size(); ++i) {
            List objs = (List)extfJudgeList.get(i);
            Object obj2 = objs.get(0);
            int numArgs = objs.size() - 1;
            Object argsList = Lisp.nil;
            for (int j = 0; j < numArgs; ++j) {
                argsList = Lisp.cons("any", argsList);
            }
            IntNum regist = new IntNum(2559);
            IntNum numArgsInt = new IntNum(numArgs);
            Pair insList = Lisp.cons(regist, Lisp.cons(obj2, Lisp.cons(obj2, Lisp.cons(numArgsInt, argsList))));
            this.judgeList = Lisp.append(this.judgeList, Lisp.cons(insList, Lisp.nil));
        }
        List extfValueList = this.getReader().getAllValueExtfs();
        System.err.println("initConfTree: extfValueList.size() = " + extfValueList.size());
        for (int i = 0; i < extfValueList.size(); ++i) {
            List objs = (List)extfValueList.get(i);
            Object obj3 = objs.get(0);
            int numArgs = objs.size() - 1;
            Object argsList = Lisp.nil;
            for (int j = 0; j < numArgs; ++j) {
                argsList = Lisp.cons("any", argsList);
            }
            IntNum regist = new IntNum(2559);
            IntNum numArgsInt = new IntNum(numArgs);
            Pair insList = Lisp.cons(regist, Lisp.cons(obj3, Lisp.cons(obj3, Lisp.cons("any", Lisp.cons(numArgsInt, argsList)))));
            this.valueList = Lisp.append(this.valueList, Lisp.cons(insList, Lisp.nil));
        }
    }

    public void initPanel() {
        this.setRootPanel(new JPanel());
        this.getRootPanel().setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        this.setFileMenu(new JMenu("File"));
        this.setEditMenu(new JMenu("Edit"));
        this.setHelpMenu(new JMenu("Help"));
        JMenuItem spaItem = new JMenuItem("Spa");
        spaItem.setActionCommand("spa");
        spaItem.addActionListener(this);
        this.getFileMenu().add(spaItem);
        JMenuItem apdpItem = new JMenuItem("Apdp");
        apdpItem.setActionCommand("apdp");
        apdpItem.addActionListener(this);
        this.getFileMenu().add(apdpItem);
        JMenuItem extfItem = new JMenuItem("Extf");
        extfItem.setActionCommand("extf");
        extfItem.addActionListener(this);
        this.getFileMenu().add(extfItem);
        JMenuItem partItem = new JMenuItem("Part");
        partItem.setActionCommand("part");
        partItem.addActionListener(this);
        this.getFileMenu().add(partItem);
        JMenuItem openItem = new JMenuItem("Open");
        openItem.setActionCommand("open");
        openItem.addActionListener(this);
        this.getFileMenu().add(openItem);
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setActionCommand("save");
        saveItem.addActionListener(this);
        this.getFileMenu().add(saveItem);
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.setActionCommand("close");
        closeItem.addActionListener(this);
        this.getFileMenu().add(closeItem);
        menuBar.add(this.getFileMenu());
        JMenuItem undoItem = new JMenuItem("Undo");
        undoItem.setActionCommand("undo");
        undoItem.addActionListener(this);
        undoItem.setEnabled(false);
        this.getEditMenu().add(undoItem);
        JMenuItem cutItem = new JMenuItem("Cut");
        cutItem.setActionCommand("cut");
        cutItem.addActionListener(this);
        this.getEditMenu().add(cutItem);
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setActionCommand("copy");
        copyItem.addActionListener(this);
        this.getEditMenu().add(copyItem);
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setActionCommand("paste");
        pasteItem.addActionListener(this);
        this.getEditMenu().add(pasteItem);
        menuBar.add(this.getEditMenu());
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setActionCommand("about");
        aboutItem.addActionListener(this);
        this.getHelpMenu().add(aboutItem);
        menuBar.add(this.getHelpMenu());
        if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl)) {
            System.err.println("editType = PrubaeEditUrl, disable file menus");
            spaItem.setEnabled(false);
            apdpItem.setEnabled(false);
            extfItem.setEnabled(false);
            partItem.setEnabled(false);
            openItem.setEnabled(false);
            closeItem.setEnabled(false);
        }
        this.setMainPanel(new JPanel());
        this.getMainPanel().setLayout(new BoxLayout(this.getMainPanel(), 0));
        this.setTreePanel(new JPanel());
        this.getTreePanel().setPreferredSize(new Dimension(300, 500));
        this.getTreePanel().setLayout(new BorderLayout());
        this.setPartPanel(new JPanel());
        this.getMainPanel().add(this.getTreePanel());
        JPanel partBorderPane = new JPanel();
        partBorderPane.setLayout(new BorderLayout());
        JScrollPane partScrollPane = new JScrollPane();
        partScrollPane.setPreferredSize(new Dimension(300, 500));
        partScrollPane.getViewport().add(this.getPartPanel());
        partBorderPane.add("Center", partScrollPane);
        this.getMainPanel().add(partBorderPane);
        this.getRootPanel().add("North", menuBar);
        this.getRootPanel().add("Center", this.getMainPanel());
    }

    public PrubaeModel setFunction(PrubaeModel model) {
        if (model == null) {
            return null;
        }
        if (this.getModel() != null) {
            if (this.getModel().equals(model)) {
                return this.getModel();
            }
            int confirm = JOptionPane.showConfirmDialog(null, "Save editing rule?");
            if (confirm == 2) {
                return this.getModel();
            }
            if (confirm == 0 && this.prepareSaveFunction()) {
                this.saveFunction();
            }
            this.closeFunction();
            this.setModel(null);
        }
        this.setModel(model);
        this.getModel().initialize(this, null, null);
        this.setController(this.getModel().getController());
        this.setView(this.getModel().getView());
        DefaultMutableTreeNode root = this.getController().getTreeNode();
        if (root == null) {
            this.closeFunction();
            return null;
        }
        this.setTree(new JTree(root));
        if (this.getTree() == null) {
            this.closeFunction();
            return null;
        }
        this.setTreeModel((DefaultTreeModel)this.getTree().getModel());
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setRootVisible(true);
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                System.err.println("selectionListener.valueChanged");
                TreePath path = evt.getPath();
                for (int i = path.getPathCount() - 1; i >= 0; --i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(i);
                    Object obj = node.getUserObject();
                    if (obj instanceof PrubaeController) {
                        System.err.println("selection class " + i + ":" + obj.getClass());
                        if (Prubae.this.getController() != null) {
                            Prubae.this.getController().close();
                        } else {
                            Prubae.this.getPartPanel().removeAll();
                        }
                        Prubae.this.setController((PrubaeController)obj);
                        Prubae.this.setView(Prubae.this.getController().getView());
                        Prubae.this.getController().open();
                        return;
                    }
                    System.err.println("selection ignore class " + i + ":" + obj.getClass());
                }
            }
        });
        MouseAdapter ml = null;
        ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                int selRow;
                if (evt.isPopupTrigger() && (selRow = Prubae.this.getTree().getRowForLocation(evt.getX(), evt.getY())) != -1) {
                    Prubae.this.getTree().setSelectionRow(selRow);
                    TreePath treePath = Prubae.this.getTree().getPathForRow(selRow);
                    if (treePath != null) {
                        Object[] objs = treePath.getPath();
                        for (int i = 0; i < objs.length; ++i) {
                            DefaultMutableTreeNode node;
                            Object obj;
                            if (!(objs[i] instanceof DefaultMutableTreeNode) || !((obj = (node = (DefaultMutableTreeNode)objs[i]).getUserObject()) instanceof PrubaeController)) continue;
                            PrubaeController cntl = (PrubaeController)obj;
                            Prubae.this.setController(cntl);
                            Prubae.this.setView(cntl.getView());
                            JPopupMenu popup = cntl.getPopupMenu();
                            if (popup == null) continue;
                            popup.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                int selRow;
                if (evt.isPopupTrigger() && (selRow = Prubae.this.getTree().getRowForLocation(evt.getX(), evt.getY())) != -1) {
                    Prubae.this.getTree().setSelectionRow(selRow);
                    TreePath treePath = Prubae.this.getTree().getPathForRow(selRow);
                    if (treePath != null) {
                        Object[] objs = treePath.getPath();
                        for (int i = 0; i < objs.length; ++i) {
                            DefaultMutableTreeNode node;
                            Object obj;
                            if (!(objs[i] instanceof DefaultMutableTreeNode) || !((obj = (node = (DefaultMutableTreeNode)objs[i]).getUserObject()) instanceof PrubaeController)) continue;
                            PrubaeController cntl = (PrubaeController)obj;
                            Prubae.this.setController(cntl);
                            Prubae.this.setView(cntl.getView());
                            JPopupMenu popup = cntl.getPopupMenu();
                            if (popup == null) continue;
                            popup.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                int selRow;
                if (evt.isPopupTrigger() && (selRow = Prubae.this.getTree().getRowForLocation(evt.getX(), evt.getY())) != -1) {
                    Prubae.this.getTree().setSelectionRow(selRow);
                    TreePath treePath = Prubae.this.getTree().getPathForRow(selRow);
                    if (treePath != null) {
                        Object[] objs = treePath.getPath();
                        for (int i = 0; i < objs.length; ++i) {
                            DefaultMutableTreeNode node;
                            Object obj;
                            if (!(objs[i] instanceof DefaultMutableTreeNode) || !((obj = (node = (DefaultMutableTreeNode)objs[i]).getUserObject()) instanceof PrubaeController)) continue;
                            PrubaeController cntl = (PrubaeController)obj;
                            Prubae.this.setController(cntl);
                            Prubae.this.setView(cntl.getView());
                            JPopupMenu popup = cntl.getPopupMenu();
                            if (popup == null) continue;
                            popup.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    }
                }
            }
        };
        this.getTree().addMouseListener(ml);
        if (this.getScrollPane() == null) {
            this.setScrollPane(new JScrollPane());
            this.getScrollPane().setPreferredSize(new Dimension(300, 500));
        }
        this.getScrollPane().getViewport().add(this.tree);
        this.getTreePanel().add("Center", this.getScrollPane());
        this.getTreePanel().setVisible(true);
        this.getController().open();
        this.setTreeSelection(root);
        System.err.println("prubae.setFunction() : nthCdr 35 savedVarList = " + Lisp.nthCdr(35, this.getSavedVarList()));
        if (this.getSavedVarList() == null) {
            this.setSavedVarList(this.getVarList());
        }
        System.err.println("prubae.setFunction() : after nthCdr 35 savedVarList = " + Lisp.nthCdr(35, this.getSavedVarList()));
        return this.getModel();
    }

    public void setTreeSelection(DefaultMutableTreeNode node) {
        TreePath treePath = new TreePath(node.getPath());
        this.getTree().expandPath(treePath);
        this.getTree().setExpandsSelectedPaths(true);
        this.getTree().setSelectionPath(treePath);
    }

    public PrubaeModel newFunction(int type) {
        if (this.getModel() != null) {
            int confirm = JOptionPane.showConfirmDialog(null, "Save editing rule?");
            if (confirm == 2) {
                return this.getModel();
            }
            if (confirm == 0 && this.prepareSaveFunction()) {
                this.saveFunction();
            }
            this.closeFunction();
            this.setModel(null);
        }
        if (this.getEditType() != null && this.getEditType().equals(PrubaeEditFile) && this.getFilename() != null && !this.getFilename().equals("")) {
            this.setUrlname(null);
            this.setFilename(null);
        } else if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl) && this.getUrlname() != null && !this.getUrlname().equals("")) {
            this.setEditType(PrubaeEditFile);
            this.setUrlname(null);
            this.setFilename(null);
        }
        PrubaeModelFunction model = new PrubaeModelFunction();
        model.setFunctionType(type);
        this.setFunction(model);
        return this.getModel();
    }

    public void closeFunction() {
        if (this.getModel() == null) {
            return;
        }
        System.err.println("Prubae.closeFunction() : prubae.varList nthCdr 35 = " + Lisp.nthCdr(35, this.getVarList()));
        this.setVarList(this.getSavedVarList());
        this.setSavedVarList(null);
        System.err.println("Prubae.closeFunction() : closed prubae.varList nthCdr 35 = " + Lisp.nthCdr(35, this.getVarList()));
        if (this.getEditType() != null && this.getEditType().equals(PrubaeEditFile) && this.getFilename() != null && !this.getFilename().equals("")) {
            this.setUrlname(null);
            this.setFilename(null);
        } else if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl) && this.getUrlname() != null && !this.getUrlname().equals("")) {
            this.setEditType(PrubaeEditFile);
            this.setUrlname(null);
            this.setFilename(null);
        }
        this.getModel().close();
        this.setModel(null);
        this.setController(null);
        this.setView(null);
        if (this.getScrollPane() != null) {
            this.getScrollPane().getViewport().remove(this.tree);
            this.getTreePanel().remove(this.getScrollPane());
        }
        this.getTreePanel().setVisible(false);
        this.setTreeModel(null);
        this.setTree(null);
    }

    public void readFunction() {
        PrubaeModel modelSaved = this.getModel();
        PrubaeModel model = null;
        this.getReader().read(this.getFilename());
        model = this.getModel();
        this.setModel(modelSaved);
        this.setFunction(model);
    }

    public void saveFunction() {
        if (this.getEditType() != null && this.getEditType().equals(PrubaeEditFile) && this.getFilename() != null && !this.getFilename().equals("")) {
            int index = this.getFilename().lastIndexOf(47);
            String path = index >= 0 ? this.getFilename().substring(0, index) : this.getFilename();
            this.setFilename(path + "/" + this.getModel().toFilename());
            try {
                this.getWriter().write(this.getFilename());
            }
            catch (ProrateRulebaseException e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
        } else if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl) && this.getUrlname() != null && !this.getUrlname().equals("")) {
            int index = this.getUrlname().lastIndexOf(47);
            String path = index >= 0 ? this.getUrlname().substring(0, index) : this.getUrlname();
            this.setUrlname(path + "/" + this.getModel().toFilename());
            this.getWriter().upload(this.getUrlname());
        }
    }

    public boolean prepareSaveFunction() {
        if (this.getModel() == null) {
            return false;
        }
        if (this.getController() != null) {
            this.getController().update();
        }
        Vector errors = new Vector();
        if (!this.getModel().check(errors)) {
            StringBuffer errorMessage = new StringBuffer();
            for (int i = 0; i < errors.size(); ++i) {
                if (i > 0) {
                    errorMessage.append("\n");
                }
                errorMessage.append(errors.get(i));
            }
            JOptionPane.showMessageDialog(null, errorMessage.toString());
            return false;
        }
        return true;
    }

    public boolean inputFilename() {
        if (this.getChooser() == null) {
            this.setChooser(new JFileChooser());
        }
        File selectedDirectory = new File(this.getRulebaseDirectory());
        this.getChooser().setCurrentDirectory(selectedDirectory);
        int ret = this.getChooser().showOpenDialog(this.getRootPanel());
        if (ret == 0) {
            this.setEditType(PrubaeEditFile);
            this.setFilename(this.getChooser().getSelectedFile().getAbsolutePath());
            this.setUrlname(null);
            return true;
        }
        return false;
    }

    public boolean outputFilename() {
        if (this.getChooser() == null) {
            this.setChooser(new JFileChooser());
        }
        String selectedFilePath = this.getRulebaseDirectory() + System.getProperty("file.separator") + ((PrubaeModelFunction)this.getModel()).toRuleSubdir() + System.getProperty("file.separator") + this.getModel().toFilename();
        File selectedFile = new File(selectedFilePath);
        this.getChooser().setSelectedFile(selectedFile);
        int ret = this.getChooser().showSaveDialog(this.getRootPanel());
        if (ret == 0) {
            this.setEditType(PrubaeEditFile);
            this.setFilename(this.getChooser().getSelectedFile().getAbsolutePath());
            this.setUrlname(null);
            return true;
        }
        return false;
    }

    public void cutFunction() {
        PrubaeController controller = this.getController();
        if (controller == null) {
            return;
        }
        PrubaeModel model = controller.getModel();
        PrubaeModel parent = model.getParent();
        if (parent == null) {
            return;
        }
        this.setYank((PrubaeModel)model.clone());
        if (!(model instanceof PrubaeModelDo)) {
            return;
        }
        model.delete();
        DefaultMutableTreeNode node = parent.getController().getTreeNode();
        this.setTreeSelection(node);
        parent.getController().open();
    }

    public void copyFunction() {
        PrubaeController controller = this.getController();
        if (controller == null) {
            return;
        }
        PrubaeModel model = controller.getModel();
        if (model.getParent() == null) {
            return;
        }
        this.setYank((PrubaeModel)model.clone());
    }

    public void pasteFunction() {
        PrubaeController controller = this.getController();
        if (controller == null) {
            return;
        }
        PrubaeModel model = controller.getModel();
        PrubaeModel parent = model.getParent();
        if (parent == null) {
            return;
        }
        if (!(model instanceof PrubaeModelDo) && !(model instanceof PrubaeModelJudge)) {
            return;
        }
        if (model instanceof PrubaeModelDo && !(this.getYank() instanceof PrubaeModelDo) || model instanceof PrubaeModelJudge && !(this.getYank() instanceof PrubaeModelJudge)) {
            return;
        }
        PrubaeModel paste = (PrubaeModel)this.getYank().clone();
        paste.setParent(null);
        paste.setParentList(null);
        PrubaeController pasteController = paste.getController();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)controller.getTreeNode().getParent();
        pasteController.swapTreeNode(node, controller.getTreeNode());
        paste.swap(model);
        this.setTreeSelection(pasteController.getTreeNode());
        pasteController.close();
        pasteController.open();
    }

    protected void aboutFunction() {
        String title = "About";
        String message = "This is Prubae Proration Rulebase Editor,\nwhich is an Editing Facility of Proration Rulebase Rule Files\nfor the GNP Proration System.\n\nThe Java classes (with related files and documentation) in these packages\nare copyright (C) 2002 - 2009  Hitoshi Guutara Maruyama and GNP Ltd.\n\nThese classes are distributed in the hope that they will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License [included in the source package] for more details.\n\nThese classes are free software.  You can use and re-distribute a class\nwithout restriction (in source or binary form) as long as you use a\nversion has not been modified in any way from a version released\nby Hitoshi Guutara Maruyama, or GNP Ltd.\nYou may make and distribute a modified version, provided you follow\nthe terms of the GNU General Public License; either version 3,\nor (at your option) any later version.\n  (GPL Version 3 is included in the source package.)\n\nIf you have questions, contact Hitoshi Guutara Maruyama\nBy email gnp@sourceforge.jp.";
        JOptionPane.showMessageDialog(this.getRootPanel(), message, title, -1);
    }

    void updateUrlname(short regist, String carrier, String tkCarrier, String name, int fromDate, int toDate) {
        if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl) && this.getUrlname() != null && !this.getUrlname().equals("")) {
            StringBuffer newString = new StringBuffer();
            newString.append(regist == 257 ? "SPA" : (regist == 258 ? "APDP" : (regist == 263 ? "EXTF" : (regist == 264 ? "PART" : ""))));
            if (name != null && !name.equals("") || carrier != null && !carrier.equals("")) {
                newString.append("(");
                newString.append(name);
                newString.append(carrier);
                if (tkCarrier != null && !tkCarrier.equals("")) {
                    newString.append(",");
                    newString.append(tkCarrier);
                }
                newString.append(")");
                newString.append(Integer.toString(fromDate));
                newString.append(Integer.toString(toDate));
                if (newString.length() > 0) {
                    int index = this.getUrlname().lastIndexOf(47);
                    this.setUrlname(this.getUrlname().substring(0, index) + newString.toString());
                }
            }
        }
    }

    void refresh() {
        PrubaeController cntl = this.getController();
        PrubaeView view = cntl.getView();
        cntl.close();
        cntl.open();
        view.display();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("spa")) {
            this.newFunction(1);
        } else if (e.getActionCommand().equals("apdp")) {
            this.newFunction(2);
        } else if (e.getActionCommand().equals("extf")) {
            this.newFunction(3);
        } else if (e.getActionCommand().equals("part")) {
            this.newFunction(4);
        } else if (e.getActionCommand().equals("open")) {
            if (this.inputFilename() && this.getFilename() != null && !this.getFilename().equals("")) {
                this.readFunction();
            }
        } else if (e.getActionCommand().equals("save")) {
            if (this.getEditType() != null && this.getEditType().equals(PrubaeEditUrl)) {
                if (this.getUrlname() != null && !this.getUrlname().equals("") && this.prepareSaveFunction()) {
                    this.saveFunction();
                }
            } else if (this.prepareSaveFunction() && this.outputFilename() && this.getFilename() != null && !this.getFilename().equals("")) {
                this.saveFunction();
            }
        } else if (e.getActionCommand().equals("close")) {
            if (this.getModel() != null) {
                int confirm = JOptionPane.showConfirmDialog(null, "Save editing rule?");
                if (confirm == 2) {
                    return;
                }
                if (confirm == 0 && this.prepareSaveFunction()) {
                    this.saveFunction();
                }
                this.closeFunction();
                this.setModel(null);
            }
        } else if (e.getActionCommand().equals("cut")) {
            this.cutFunction();
        } else if (e.getActionCommand().equals("copy")) {
            this.copyFunction();
        } else if (e.getActionCommand().equals("paste")) {
            this.pasteFunction();
        } else if (e.getActionCommand().equals("about")) {
            this.aboutFunction();
        }
    }

    public void setRootPanel(JPanel theRootPanel) {
        this.rootPanel = theRootPanel;
    }

    public JPanel getRootPanel() {
        return this.rootPanel;
    }

    public void setMainPanel(JPanel theMainPanel) {
        this.mainPanel = theMainPanel;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setTreePanel(JPanel theTreePanel) {
        this.treePanel = theTreePanel;
    }

    public JPanel getTreePanel() {
        return this.treePanel;
    }

    public void setPartPanel(JPanel thePartPanel) {
        this.partPanel = thePartPanel;
    }

    public JPanel getPartPanel() {
        return this.partPanel;
    }

    public void setFileMenu(JMenu theFileMenu) {
        this.fileMenu = theFileMenu;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public void setEditMenu(JMenu editMenu) {
        this.editMenu = editMenu;
    }

    public void setHelpMenu(JMenu theHelpMenu) {
        this.helpMenu = theHelpMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void setTree(JTree theTree) {
        this.tree = theTree;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setScrollPane(JScrollPane theScrollPane) {
        this.scrollPane = theScrollPane;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setFilename(String theFilename) {
        this.filename = theFilename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setTreeModel(DefaultTreeModel theTreeModel) {
        this.treeModel = theTreeModel;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setModel(PrubaeModel theModel) {
        this.model = theModel;
    }

    public PrubaeModel getModel() {
        return this.model;
    }

    public void setView(PrubaeView theView) {
        this.view = theView;
    }

    public PrubaeView getView() {
        return this.view;
    }

    public void setController(PrubaeController theController) {
        this.controller = theController;
    }

    public PrubaeController getController() {
        return this.controller;
    }

    public void setReader(PrubaeReader theReader) {
        this.reader = theReader;
    }

    public PrubaeReader getReader() {
        return this.reader;
    }

    public void setWriter(PrubaeWriter theWriter) {
        this.writer = theWriter;
    }

    public PrubaeWriter getWriter() {
        return this.writer;
    }

    public void setChooser(JFileChooser theChooser) {
        this.chooser = theChooser;
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public void setConfigList(LList theConfigList) {
        this.configList = theConfigList;
    }

    public LList getConfigList() {
        return this.configList;
    }

    public void setDoList(LList theDoList) {
        this.doList = theDoList;
    }

    public LList getDoList() {
        return this.doList;
    }

    public void setJudgeList(LList theJudgeList) {
        this.judgeList = theJudgeList;
    }

    public LList getJudgeList() {
        return this.judgeList;
    }

    public void setValueList(LList theValueList) {
        this.valueList = theValueList;
    }

    public LList getValueList() {
        return this.valueList;
    }

    public void setVarList(LList theVarList) {
        this.varList = theVarList;
    }

    public LList getVarList() {
        return this.varList;
    }

    public void setConstList(LList theConstList) {
        this.constList = theConstList;
    }

    public LList getConstList() {
        return this.constList;
    }

    public void setSettablevarList(LList theSettablevarList) {
        this.settablevarList = theSettablevarList;
    }

    public LList getSettablevarList() {
        return this.settablevarList;
    }

    public String getUrlname() {
        return this.urlname;
    }

    public void setUrlname(String urlname) {
        this.urlname = urlname;
    }

    public String getEditType() {
        return this.editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public PrubaeModel getYank() {
        return this.yank;
    }

    public void setYank(PrubaeModel yank) {
        this.yank = yank;
    }

    public String getAdditionalPropertyFilename() {
        return this.additionalPropertyFilename;
    }

    public void setAdditionalPropertyFilename(String additionalPropertyFilename) {
        this.additionalPropertyFilename = additionalPropertyFilename;
    }

    public String getRulebaseDirectory() {
        return this.rulebaseDirectory;
    }

    public void setRulebaseDirectory(String rulebaseDirectory) {
        this.rulebaseDirectory = rulebaseDirectory;
    }

    public LList getSavedVarList() {
        return this.savedVarList;
    }

    public void setSavedVarList(LList savedVarList) {
        this.savedVarList = savedVarList;
    }
}

