/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.Prubae;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.rulebase.xml.PrubaeReaderXmlUrl;
import jp.sourceforge.gnp.rulebase.xml.PrubaeWriterXml;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PrubaeApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    static final String prubaercFilename = "prubaerc";
    static final String prubaePropertyFilename = "prubae.properties";
    static Logger logger = Logger.getLogger(PrubaeApplet.class.getName());

    public void initialize(Prubae prubae) {
        String baseUrlStr = this.getDocumentBase().toString();
        int index = -1;
        index = baseUrlStr.indexOf(63);
        if (index >= 0) {
            baseUrlStr = baseUrlStr.substring(0, index);
        }
        if ((index = baseUrlStr.lastIndexOf(47)) >= 0) {
            baseUrlStr = baseUrlStr.substring(0, index);
        }
        System.out.println("baseUrlStr = " + baseUrlStr);
        logger.info("baseUrlStr = " + baseUrlStr);
        String propertyFile = baseUrlStr + System.getProperty("file.separator") + prubaePropertyFilename;
        prubae.setAdditionalPropertyFilename(propertyFile);
        System.out.println("propertyFile = " + propertyFile);
        logger.info("propertyFile = " + propertyFile);
        String rcFile = baseUrlStr + System.getProperty("file.separator") + prubaercFilename;
        System.out.println("rcFile = " + rcFile);
        logger.info("rcFile = " + rcFile);
        URL rcUrl = null;
        try {
            rcUrl = new URL(rcFile);
            System.out.println("rcUrl = " + rcUrl);
            logger.info("rcUrl = " + rcUrl);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, rcFile + " : " + "url not found :" + e.getMessage());
            rcUrl = null;
        }
        System.out.println("URL rcUrl = " + rcUrl);
        InputStream rcIn = null;
        if (rcUrl != null) {
            try {
                URLConnection connection = rcUrl.openConnection();
                connection.setUseCaches(false);
                rcIn = connection.getInputStream();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, rcFile + " : " + "IOException in openStream() : " + e.getMessage());
                rcIn = null;
            }
        }
        System.out.println("stream rcIn = " + rcIn);
        logger.info("stream rcIn = " + rcIn);
        LList tree = null;
        try {
            if (rcIn != null) {
                tree = Lisp.read(rcIn);
            } else {
                ClassLoader loader = Prubae.class.getClassLoader();
                InputStream is = loader.getResourceAsStream("jp/sourceforge/gnp/prubae/prubaerc");
                tree = Lisp.read(is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        prubae.initConfTree(tree);
    }

    @Override
    public void init() {
        logger.setLevel(Level.INFO);
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.out.println("Warning: UnsupportedLookAndFeel: " + laf);
            logger.info("Warning: UnsupportedLookAndFeel: " + laf);
        }
        catch (Exception exc) {
            System.out.println("Error loading " + laf + ": " + exc);
            logger.info("Error loading " + laf + ": " + exc);
        }
        Prubae prubae = new Prubae(){

            @Override
            public PrubaeModel setFunction(PrubaeModel model) {
                this.getPartPanel().setVisible(false);
                this.getPartPanel().removeAll();
                PrubaeModel ret = super.setFunction(model);
                this.getPartPanel().setVisible(true);
                return ret;
            }

            @Override
            public void closeFunction() {
                this.getPartPanel().setVisible(false);
                this.getPartPanel().removeAll();
                super.closeFunction();
                this.getPartPanel().setVisible(true);
            }
        };
        if (prubae == null) {
            return;
        }
        String baseUrlStr = this.getDocumentBase().toString();
        int index = -1;
        index = baseUrlStr.indexOf(63);
        if (index >= 0) {
            baseUrlStr = baseUrlStr.substring(0, index);
        }
        if ((index = baseUrlStr.lastIndexOf(47)) >= 0) {
            baseUrlStr = baseUrlStr.substring(0, index);
        }
        System.out.println("baseUrlStr = " + baseUrlStr);
        logger.info("baseUrlStr = " + baseUrlStr);
        if (prubae.getWriter() == null) {
            prubae.setWriter(new PrubaeWriterXml());
            prubae.getWriter().setEditor(prubae);
        }
        System.err.println("Prubae(): before getReader() and new PrubaeReaderXmlUrl()");
        if (prubae.getReader() == null) {
            System.err.println("Prubae(): getReader()==" + prubae.getReader() + ", before new PrubaeReaderXmlUrl()");
            prubae.setReader(new PrubaeReaderXmlUrl());
            prubae.getReader().setEditor(prubae);
            ((PrubaeReaderXmlUrl)prubae.getReader()).setBaseUrl(baseUrlStr);
            prubae.getReader().initialize();
            System.err.println("Prubae(): getReader()==" + prubae.getReader() + ", after new PrubaeReaderXmlUrl()");
            prubae.getReader().setEditor(prubae);
        }
        String urlname = this.getParameter("openurl");
        URL openUrl = null;
        System.out.println("urlname = " + urlname);
        logger.info("urlname = " + urlname);
        if (urlname != null) {
            try {
                openUrl = new URL(urlname);
            }
            catch (MalformedURLException e) {
                String urlFullname = baseUrlStr + System.getProperty("file.separator") + urlname;
                try {
                    openUrl = new URL(urlFullname);
                }
                catch (MalformedURLException e1) {
                    JOptionPane.showMessageDialog(null, urlFullname + " : " + "url not found :" + e.getMessage());
                    openUrl = null;
                }
            }
        }
        System.out.println("initialize");
        logger.info("initialize");
        this.initialize(prubae);
        if (openUrl != null) {
            prubae.setEditType("url");
            prubae.setUrlname(urlname);
            prubae.setFilename(null);
        } else {
            prubae.setEditType("file");
            prubae.setUrlname(null);
            prubae.setFilename(null);
        }
        System.out.println("initPanel");
        logger.info("initPanel");
        prubae.initPanel();
        if (openUrl != null) {
            InputStream in = null;
            InputStreamReader ruleReader = null;
            boolean alreadyDialog = false;
            try {
                URLConnection connection = openUrl.openConnection();
                connection.setUseCaches(false);
                in = connection.getInputStream();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, urlname + " : IOException : " + e.getMessage());
                alreadyDialog = true;
                in = null;
            }
            if (in != null) {
                ruleReader = new InputStreamReader(in);
            }
            if (ruleReader != null) {
                PrubaeModel modelSaved = prubae.getModel();
                PrubaeModel model = null;
                prubae.getReader().read(ruleReader);
                model = prubae.getModel();
                prubae.setModel(modelSaved);
                prubae.setFunction(model);
            } else if (!alreadyDialog) {
                JOptionPane.showMessageDialog(null, urlname + " not found");
            }
        }
        if (prubae.getRootPanel() == null) {
            return;
        }
        this.getContentPane().add("Center", prubae.getRootPanel());
    }

    public static void main(String[] args) {
        PrubaeApplet applet = new PrubaeApplet();
        applet.init();
    }
}

