/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeControllerDo;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelCase;
import jp.sourceforge.gnp.prubae.PrubaeModelSwitch;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerSwitch
extends PrubaeControllerDo {
    private JPanel argsCountPanel;
    private JLabel argsCountLabel;
    private JTextField argsCountField;
    private JButton argsCountButton;
    private int argsCount = 0;

    @Override
    protected void createButtons() {
        this.getPanel().add(new JLabel("SWITCH"));
        JButton caseButton = new JButton("add case");
        caseButton.setActionCommand("case");
        caseButton.addActionListener(this);
        JPanel opPanel = new JPanel();
        opPanel.setLayout(new BoxLayout(opPanel, 1));
        opPanel.add(caseButton);
        this.getPanel().add(opPanel);
        this.setArgsCountPanel(new JPanel());
        this.setArgsCountLabel(new JLabel("COUNT"));
        this.setArgsCountField(new JTextField("", 4));
        this.setArgsCountButton(new JButton("INPUT"));
        this.getArgsCountButton().setActionCommand("set vars");
        this.getArgsCountButton().addActionListener(this);
        this.getArgsCountPanel().setLayout(new BoxLayout(this.getArgsCountPanel(), 0));
        this.getArgsCountPanel().add(this.argsCountLabel);
        this.getArgsCountPanel().add(this.getArgsCountField());
        this.getArgsCountPanel().add(this.argsCountButton);
        this.getPanel().add(this.getArgsCountPanel());
    }

    @Override
    public void initialize() {
        super.initialize();
        List caseList = ((PrubaeModelSwitch)this.getModel()).getCases();
        if (caseList != null) {
            for (int i = 0; i < caseList.size(); ++i) {
                DefaultMutableTreeNode node = ((PrubaeModel)caseList.get(i)).getController().getTreeNode();
                this.getTreeNode().add(node);
            }
        }
        this.setArgsCount(0);
    }

    @Override
    public void update() {
        ((PrubaeModelSwitch)this.getModel()).updateVars();
        super.update();
    }

    @Override
    public void destroyPanel() {
        this.setArgsCountPanel(null);
        this.setArgsCountLabel(null);
        this.setArgsCountField(null);
        this.setArgsCountButton(null);
        super.destroyPanel();
    }

    private void addCases() {
        List casesList = ((PrubaeModelSwitch)this.getModel()).getCases();
        if (casesList != null) {
            PrubaeModelCase last = new PrubaeModelCase();
            last.addToParent(casesList, this.getModel());
            last.getController().addTreeNode(this.getTreeNode());
        }
    }

    private void updateArgsCount() {
        ((PrubaeModelSwitch)this.getModel()).updateVars();
        int numArgs = 0;
        try {
            numArgs = Integer.parseInt(this.getArgsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getArgsCount();
        this.setArgsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addArguments(oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeArguments(numArgs, oldArgsCount);
        }
    }

    private void addArguments(int minArgs, int numArgs) {
        int i;
        PrubaeModelSwitch model = (PrubaeModelSwitch)this.getModel();
        if (model.getVars() == null) {
            model.setVars(new Vector());
        }
        for (i = minArgs; i < numArgs; ++i) {
            PrubaeModelValueStatement ret = new PrubaeModelValueStatement();
            ret.setComment("");
            ret.setStatement("");
            ret.initialize(this.getEditor(), model, model.getVars());
            ((PrubaeModel)ret).openUI();
            model.getVars().add(ret);
            this.getPanel().add(ret.getController().getPanel());
        }
        for (i = 0; i < model.getCases().size(); ++i) {
            PrubaeModelCase caseModel = (PrubaeModelCase)model.getCases().get(i);
            for (int j = 0; j < caseModel.getValues().size(); ++j) {
                PrubaeModelValue caseBranch = (PrubaeModelValue)caseModel.getValues().get(j);
                for (int k = minArgs; k < numArgs; ++k) {
                    PrubaeModelValueStatement value = new PrubaeModelValueStatement();
                    value.setComment("");
                    value.setStatement("");
                    value.initialize(this.getEditor(), caseBranch, caseBranch.getValues());
                    caseBranch.getValues().add(value);
                }
            }
        }
    }

    private void removeArguments(int minArgs, int numArgs) {
        int i;
        PrubaeModelSwitch model = (PrubaeModelSwitch)this.getModel();
        for (i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue ret = (PrubaeModelValue)model.getVars().get(i);
            this.getPanel().remove(ret.getController().getPanel());
            model.getVars().remove(ret);
            ret.closeUI();
        }
        for (i = 0; i < model.getCases().size(); ++i) {
            PrubaeModelCase caseModel = (PrubaeModelCase)model.getCases().get(i);
            for (int j = 0; j < caseModel.getValues().size(); ++j) {
                PrubaeModelValue caseBranch = (PrubaeModelValue)caseModel.getValues().get(j);
                for (int k = numArgs - 1; k >= minArgs; --k) {
                    PrubaeModelValueStatement value = (PrubaeModelValueStatement)caseBranch.getValues().get(k);
                    caseBranch.getValues().remove(value);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            PrubaeController cntl = this.getEditor().getController();
            if (this == cntl) {
                this.deleteAndUp();
            } else {
                this.delete();
            }
        } else if (e.getActionCommand().equals("insert")) {
            this.insert();
        } else {
            System.err.println("action = " + e.getActionCommand());
            if (e.getActionCommand().equals("case")) {
                this.addCases();
            } else if (e.getActionCommand().equals("set vars")) {
                this.updateArgsCount();
            }
            this.getView().display();
        }
    }

    @Override
    void createPopupMenu() {
        JMenuItem mi = null;
        this.setPopupMenu(new JPopupMenu());
        mi = new JMenuItem("delete this action");
        mi.setActionCommand("delete");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
        mi = new JMenuItem("insert action before this");
        mi.setActionCommand("insert");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
    }

    @Override
    public Object clone() {
        PrubaeControllerSwitch clone = null;
        clone = (PrubaeControllerSwitch)super.clone();
        if (this.getArgsCountPanel() != null) {
            clone.setArgsCountPanel(new JPanel());
        }
        if (this.getArgsCountField() != null) {
            clone.setArgsCountField(new JTextField());
        }
        return clone;
    }

    public void setArgsCountPanel(JPanel theArgsCountPanel) {
        this.argsCountPanel = theArgsCountPanel;
    }

    public JPanel getArgsCountPanel() {
        return this.argsCountPanel;
    }

    public void setArgsCountLabel(JLabel theArgsCountLabel) {
        this.argsCountLabel = theArgsCountLabel;
    }

    public JLabel getArgsCountLabel() {
        return this.argsCountLabel;
    }

    public void setArgsCountField(JTextField theArgsCountField) {
        this.argsCountField = theArgsCountField;
    }

    public JTextField getArgsCountField() {
        return this.argsCountField;
    }

    public void setArgsCountButton(JButton theArgsCountButton) {
        this.argsCountButton = theArgsCountButton;
    }

    public JButton getArgsCountButton() {
        return this.argsCountButton;
    }

    public void setArgsCount(int theArgsCount) {
        this.argsCount = theArgsCount;
    }

    public int getArgsCount() {
        return this.argsCount;
    }
}

