/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.text.QueueReader;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.PrintWriter;
import kawa.TextAreaWriter;

public class MessageArea
extends TextArea
implements KeyListener,
TextListener {
    private TextAreaWriter out_stream;
    private PrintWriter out;
    private PrintWriter err;
    QueueReader in;
    public int outputMark = 0;
    public int endMark = -1;
    int length = 0;

    public MessageArea(QueueReader in) {
        this.in = in;
        this.out_stream = new TextAreaWriter(this);
        TextAreaWriter err_stream = new TextAreaWriter(this);
        this.out = new PrintWriter(this.out_stream);
        this.err = new PrintWriter(err_stream);
        this.addKeyListener(this);
        this.addTextListener(this);
    }

    void enter() {
        int lineBefore;
        int pos = this.getCaretPosition();
        String str = this.getText();
        int len = str.length();
        if (len != this.length) {
            System.err.println("(actual) len:" + len + " (saved) length:" + this.length);
        }
        int lineAfter = str.indexOf(10, pos);
        this.endMark = -1;
        if (lineAfter < 0) {
            lineAfter = len;
        }
        int n = lineBefore = pos == 0 ? 0 : 1 + str.lastIndexOf(10, pos - 1);
        if (pos >= this.outputMark || this.outputMark <= lineAfter) {
            lineAfter = str.indexOf(10, this.outputMark);
            if (lineAfter < 0) {
                lineAfter = len;
                this.append("\n");
            } else {
                this.endMark = len;
            }
            str = str.substring(this.outputMark, lineAfter);
            str = str + '\n';
            this.outputMark = lineAfter + 1;
        } else {
            str = str.substring(lineBefore, lineAfter + 1);
            this.out_stream.write(str);
        }
        this.setCaretPosition(this.outputMark);
        if (this.in != null) {
            this.in.append(str);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 10) {
            this.enter();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public synchronized void write(String str) {
        boolean moveCaret = this.getCaretPosition() == this.outputMark;
        this.insert(str, this.outputMark);
        int len = str.length();
        this.outputMark += len;
        if (moveCaret) {
            this.setCaretPosition(this.outputMark);
        }
        if (this.endMark >= 0) {
            this.endMark += len;
        }
    }

    public synchronized void deleteOldText() {
        String str = this.getText();
        int lineBefore = this.outputMark <= 0 ? 0 : str.lastIndexOf(10, this.outputMark - 1) + 1;
        this.setCaretPosition(this.outputMark);
        this.replaceRange("", 0, lineBefore);
    }

    @Override
    public synchronized void textValueChanged(TextEvent e) {
        int pos = this.getCaretPosition();
        String text = this.getText();
        int delta = text.length() - this.length;
        this.length += delta;
        if (pos < this.outputMark) {
            this.outputMark += delta;
        } else if (pos - delta < this.outputMark) {
            this.outputMark = pos;
        }
        if (this.endMark >= 0) {
            if (pos < this.endMark) {
                this.endMark += delta;
            } else if (pos - delta < this.endMark) {
                this.endMark = pos;
            }
        }
    }

    public PrintWriter getStdout() {
        return this.out;
    }

    public PrintWriter getStderr() {
        return this.err;
    }
}

