/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.glj.graph;

import gnu.lists.LList;
import gnu.lists.Pair;
import jp.sourceforge.glj.graph.Symbol;
import jp.sourceforge.glj.lisp.Lisp;

class Clause {
    static int uniqueId;
    LList literals;
    String type;
    int id;
    LList answer;

    Clause() {
    }

    Clause newClause(LList literals, String type, LList answer) {
        this.literals = literals;
        this.type = type;
        this.id = uniqueId++;
        this.answer = answer;
        return this;
    }

    int numLiterals() {
        return this.literals.size();
    }

    boolean isNil() {
        return this.literals.isEmpty();
    }

    void reportSolution() {
        System.out.println("" + this.id + " " + this.literals + " " + this.type + " " + this.answer);
    }

    boolean isClauseEqual(Clause another) {
        return this.literals.equals((Object)another.literals);
    }

    LList resolve(Clause parent) {
        return this.resolvedClauses(this.tryClash(this.rename((LList)new Pair((Object)this.literals, (Object)this.answer)), (LList)new Pair((Object)parent.literals, (Object)parent.answer)), this.id, parent.id);
    }

    LList resolvedClauses(LList literals, int id1, int id2) {
        System.err.println("resolvedClauses = (" + id1 + "," + id2 + ")" + literals);
        LList newClauses = LList.Empty;
        if (literals.isEmpty()) {
            return newClauses;
        }
        String type = "R " + id1 + " " + id2;
        for (int i = 0; i < literals.size(); ++i) {
            Clause newClause = new Clause();
            newClause.newClause((LList)Lisp.car(literals.get(i)), type, (LList)Lisp.cdr(literals.get(i)));
            newClauses = Lisp.append(newClauses, (LList)new Pair((Object)newClause, (Object)LList.Empty));
            if (!newClause.isNil()) continue;
            return newClauses;
        }
        return newClauses;
    }

    Object operator(Object wff) {
        if (!(wff instanceof Pair)) {
            return null;
        }
        if (Lisp.cdr(wff) instanceof LList && ((LList)Lisp.cdr(wff)).isEmpty()) {
            return null;
        }
        if (Lisp.cdr(Lisp.cdr(wff)) instanceof LList && ((LList)Lisp.cdr(Lisp.cdr(wff))).isEmpty()) {
            if (this.isNeg(Lisp.car(wff)) || this.isQuantifier(Lisp.car(wff))) {
                return Lisp.car(wff);
            }
            return null;
        }
        if (Lisp.car(Lisp.cdr(wff)).equals("!") || Lisp.car(Lisp.cdr(wff)).equals("&") || Lisp.car(Lisp.cdr(wff)).equals("=>") || Lisp.car(Lisp.cdr(wff)).equals("==")) {
            return Lisp.car(Lisp.cdr(wff));
        }
        return null;
    }

    boolean isOr(Object operator) {
        if (operator == null || Lisp.isNil(operator)) {
            return false;
        }
        return operator.equals("!");
    }

    boolean isAnd(Object operator) {
        if (operator == null || Lisp.isNil(operator)) {
            return false;
        }
        return operator.equals("&");
    }

    boolean isNeg(Object operator) {
        if (operator == null || Lisp.isNil(operator)) {
            return false;
        }
        return operator.equals("~");
    }

    boolean isQuantifier(Object wff) {
        if (wff == null || Lisp.isNil(wff)) {
            return false;
        }
        if (!(wff instanceof Pair)) {
            return false;
        }
        return Lisp.car(wff).equals("A") || Lisp.car(wff).equals("E");
    }

    boolean isCond(Object operator) {
        if (operator == null || Lisp.isNil(operator)) {
            return false;
        }
        return operator.equals("=>");
    }

    boolean isBicond(Object operator) {
        if (operator == null || Lisp.isNil(operator)) {
            return false;
        }
        return operator.equals("==");
    }

    Symbol gensym(String name) {
        Symbol symbol = new Symbol();
        symbol.putName(name);
        return symbol;
    }

    Symbol newVar() {
        Symbol symbol = this.gensym("x");
        symbol.putType("variable");
        return symbol;
    }

    Symbol newConst() {
        Symbol symbol = this.gensym("C");
        symbol.putType("constant");
        return symbol;
    }

    Symbol newFunc() {
        Symbol symbol = this.gensym("f");
        symbol.putType("function");
        return symbol;
    }

    boolean isVariable(Object sym) {
        return sym instanceof Symbol && ((Symbol)sym).getType().equals("variable");
    }

    boolean isConstant(Object sym) {
        return sym instanceof Symbol && ((Symbol)sym).getType().equals("constant");
    }

    boolean isFunction(Object sym) {
        return sym instanceof Symbol && ((Symbol)sym).getType().equals("function");
    }

    LList variables(LList literal) {
        if (literal.isEmpty()) {
            return LList.Empty;
        }
        Object carPart = Lisp.car(literal);
        if (this.isVariable(carPart)) {
            return Lisp.insert(carPart, this.variables((LList)Lisp.cdr(literal)));
        }
        if (Lisp.isAtom(carPart)) {
            return this.variables((LList)Lisp.cdr(literal));
        }
        return Lisp.merge(this.variables((LList)carPart), this.variables((LList)Lisp.cdr(literal)));
    }

    LList rename(LList literals) {
        LList variableList = this.variables(literals);
        LList substList = LList.Empty;
        for (int i = 0; i < variableList.size(); ++i) {
            Object obj = variableList.get(i);
            substList = Lisp.append(substList, (LList)new Pair((Object)new Pair(obj, (Object)this.newVar()), (Object)LList.Empty));
        }
        return (LList)this.applySubst(substList, literals);
    }

    LList tryClash(LList literals1, LList literals2) {
        LList newLiterals = LList.Empty;
        if (literals1.isEmpty()) {
            return newLiterals;
        }
        LList answer1 = (LList)Lisp.cdr(literals1);
        literals1 = (LList)Lisp.car(literals1);
        if (literals2.isEmpty()) {
            return newLiterals;
        }
        LList answer2 = (LList)Lisp.cdr(literals2);
        literals2 = (LList)Lisp.car(literals2);
        for (int i = 0; i < literals1.size(); ++i) {
            Object literal1 = literals1.get(i);
            for (int j = 0; j < literals2.size(); ++j) {
                LList s = null;
                Object literal2 = literals2.get(j);
                if ((!this.isNeg(this.operator(literal1)) || this.operator(literal2) != null && !Lisp.isNil(literal2) || !(literal1 instanceof Pair) || !(Lisp.cdr(literal1) instanceof Pair) || (s = this.unify((LList)Lisp.car(Lisp.cdr(literal1)), (LList)literal2)) == null) && (this.operator(literal1) != null && !Lisp.isNil(literal1) || !this.isNeg(this.operator(literal2)) || !(literal2 instanceof Pair) || !(Lisp.cdr(literal2) instanceof Pair) || (s = this.unify((LList)Lisp.car(Lisp.cdr(literal2)), (LList)literal1)) == null)) continue;
                Pair newLiteral = new Pair((Object)Lisp.merge((LList)this.applySubst(s, Lisp.remove(literal1, literals1)), (LList)this.applySubst(s, Lisp.remove(literal2, literals2))), (Object)Lisp.merge((LList)this.applySubst(s, Lisp.remove(literal1, answer1)), (LList)this.applySubst(s, Lisp.remove(literal2, answer2))));
                newLiterals = new Pair((Object)newLiteral, (Object)newLiterals);
                if (!newLiteral.isEmpty()) continue;
                return newLiterals;
            }
        }
        return newLiterals;
    }

    LList unify(LList negLiteral, LList literal) {
        LList subs = LList.Empty;
        LList literal1 = negLiteral;
        LList literal2 = literal;
        while (!literal1.equals((Object)literal2)) {
            LList spair = this.unify1(literal1, literal2);
            if (spair == null || Lisp.isNil(spair)) {
                return null;
            }
            System.err.println("unify() spair=" + spair);
            if (spair.isEmpty()) {
                return null;
            }
            spair = new Pair((Object)spair, (Object)LList.Empty);
            System.err.println("unify() spair=" + spair);
            literal1 = (LList)this.applySubst(spair, literal1);
            literal2 = (LList)this.applySubst(spair, literal2);
            subs = this.composeSubst(subs, spair);
        }
        return subs;
    }

    LList unify1(Object literal1, Object literal2) {
        if (this.isVariable(literal1)) {
            if (this.occurIn(literal1, literal2)) {
                return null;
            }
            return new Pair(literal1, literal2);
        }
        if (this.isVariable(literal2)) {
            if (this.occurIn(literal2, literal1)) {
                return null;
            }
            return new Pair(literal2, literal1);
        }
        if (Lisp.isAtom(literal1) || Lisp.isAtom(literal2)) {
            return null;
        }
        if (!(literal1 instanceof LList) || !(literal2 instanceof LList)) {
            return null;
        }
        if (!((LList)literal1).isEmpty() && !((LList)literal2).isEmpty() && Lisp.car(literal1).equals(Lisp.car(literal2))) {
            Object a1 = Lisp.cdr(literal1);
            Object a2 = Lisp.cdr(literal2);
            while (a1 instanceof LList && !((LList)a1).isEmpty() && a2 instanceof LList && !((LList)a2).isEmpty() && Lisp.car(a1).equals(Lisp.car(a2))) {
                a1 = Lisp.cdr(a1);
                a2 = Lisp.cdr(a2);
            }
            return this.unify1(Lisp.car(a1), Lisp.car(a2));
        }
        return null;
    }

    boolean occurIn(Object obj1, Object obj2) {
        if (obj1.equals(obj2)) {
            return true;
        }
        if (Lisp.isAtom(obj2)) {
            return false;
        }
        if (obj2 instanceof Pair) {
            if (this.occurIn(obj1, Lisp.car(obj2))) {
                return true;
            }
            return this.occurIn(obj1, Lisp.cdr(obj2));
        }
        return false;
    }

    Object applySubst(LList subst, Object literals) {
        if (subst.isEmpty()) {
            return literals;
        }
        LList substPair = null;
        if (literals instanceof Symbol) {
            System.err.println("applySubst(sym): " + subst + "/" + literals);
            substPair = Lisp.assoc(literals, subst);
            if (substPair != null && !Lisp.isNil(substPair) && substPair instanceof Pair) {
                return Lisp.cdr(substPair);
            }
            return literals;
        }
        if (!(literals instanceof Pair)) {
            return literals;
        }
        System.err.println("applySubst(obj): " + subst + "/" + literals);
        substPair = Lisp.assoc(literals, subst);
        if (substPair != null && !Lisp.isNil(substPair)) {
            return (LList)Lisp.cdr(substPair);
        }
        System.err.println("applySubst(obj) expand: " + subst + "/" + literals);
        return new Pair(this.applySubst(subst, Lisp.car(literals)), this.applySubst(subst, Lisp.cdr(literals)));
    }

    LList composeSubst(LList substList, LList spair) {
        LList composedList = LList.Empty;
        for (int i = 0; i < substList.size(); ++i) {
            composedList = new Pair((Object)new Pair(Lisp.car(substList.get(i)), this.applySubst(spair, Lisp.cdr(substList.get(i)))), (Object)composedList);
        }
        return this.addnew(spair, composedList);
    }

    LList addnew(LList spair, LList substList) {
        if (spair.isEmpty()) {
            return substList;
        }
        if (substList.isEmpty()) {
            return spair;
        }
        if (!Lisp.isNil(Lisp.assoc(Lisp.car(Lisp.car(spair)), substList))) {
            return this.addnew((LList)Lisp.cdr(spair), substList);
        }
        return new Pair(Lisp.car(substList), (Object)this.addnew((LList)Lisp.cdr(spair), substList));
    }

    LList clauses(LList wff) {
        System.err.println("clauses(" + wff + ")");
        if (this.isAnd(this.operator(wff))) {
            return Lisp.append(this.clauses((LList)Lisp.car(wff)), this.clauses((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff)))));
        }
        if (this.isOr(this.operator(wff))) {
            return new Pair((Object)this.clauseIt(wff), (Object)LList.Empty);
        }
        return new Pair((Object)this.clauseIt(wff), (Object)LList.Empty);
    }

    LList clauseIt(LList wff) {
        if (this.isOr(this.operator(wff))) {
            return Lisp.append(this.clauseIt((LList)Lisp.car(wff)), this.clauseIt((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff)))));
        }
        return new Pair((Object)wff, (Object)LList.Empty);
    }

    LList condelim(LList wff) {
        System.err.println("condelim(" + wff + ")");
        Object op = this.operator(wff);
        if (op == null || Lisp.isNil(op)) {
            return wff;
        }
        if (this.isQuantifier(op) || this.isNeg(op)) {
            return new Pair(Lisp.car(wff), (Object)new Pair((Object)this.condelim((LList)Lisp.car(Lisp.cdr(wff))), (Object)LList.Empty));
        }
        LList left = this.condelim((LList)Lisp.car(wff));
        LList right = this.condelim((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
        if (this.isCond(op)) {
            return new Pair((Object)new Pair((Object)"~", (Object)new Pair((Object)left, (Object)LList.Empty)), (Object)new Pair((Object)"!", (Object)new Pair((Object)right, (Object)LList.Empty)));
        }
        if (this.isBicond(op)) {
            Pair car = new Pair((Object)left, (Object)new Pair((Object)"!", (Object)new Pair((Object)new Pair((Object)"~", (Object)new Pair((Object)left, (Object)LList.Empty)), (Object)LList.Empty)));
            Pair cadr = new Pair((Object)new Pair((Object)"~", (Object)new Pair((Object)left, (Object)LList.Empty)), (Object)new Pair((Object)"!", (Object)new Pair((Object)right, (Object)LList.Empty)));
            return new Pair((Object)car, (Object)new Pair((Object)cadr, (Object)LList.Empty));
        }
        return new Pair((Object)left, (Object)new Pair(Lisp.car(Lisp.cdr(wff)), (Object)new Pair((Object)right, (Object)LList.Empty)));
    }

    LList miniscope(LList wff) {
        System.err.println("miniscope(" + wff + ")");
        Object op = this.operator(wff);
        if (op == null || Lisp.isNil(op)) {
            return wff;
        }
        if (this.isQuantifier(op)) {
            return new Pair(Lisp.car(wff), (Object)new Pair((Object)this.miniscope((LList)Lisp.car(Lisp.cdr(wff))), (Object)LList.Empty));
        }
        if (this.isNeg(op)) {
            return (LList)this.negate((LList)Lisp.car(Lisp.cdr(wff)));
        }
        LList caddr = this.miniscope((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
        return new Pair((Object)this.miniscope((LList)Lisp.car(wff)), (Object)new Pair(Lisp.car(Lisp.cdr(wff)), (Object)new Pair((Object)caddr, (Object)LList.Empty)));
    }

    Object negate(Object wff) {
        System.err.println("negate(" + wff + ")");
        if (wff instanceof String) {
            if (this.isAnd(wff)) {
                return "!";
            }
            if (this.isOr(wff)) {
                return "&";
            }
            return wff;
        }
        if (!(wff instanceof LList)) {
            return wff;
        }
        Object op = this.operator(wff);
        if (op == null || Lisp.isNil(op)) {
            return new Pair((Object)"~", (Object)new Pair(wff, (Object)LList.Empty));
        }
        if (this.isNeg(op)) {
            return this.miniscope((LList)Lisp.car(Lisp.cdr(wff)));
        }
        if (this.isQuantifier(op)) {
            System.err.println("negateQ(" + op + "," + (Lisp.car(op).equals("A") ? "t" : "f") + ")");
            return new Pair((Object)new Pair((Object)(Lisp.car(op).equals("A") ? "E" : "A"), Lisp.cdr(op)), (Object)new Pair((Object)((LList)this.negate(Lisp.car(Lisp.cdr(wff)))), (Object)LList.Empty));
        }
        LList retList = new LList();
        for (int i = 0; i < ((LList)wff).size(); ++i) {
            retList = Lisp.append(retList, (LList)new Pair(this.negate(((LList)wff).get(i)), (Object)LList.Empty));
        }
        return retList;
    }

    LList standardize(LList wff) {
        System.err.println("standardize(" + wff + ")");
        Object op = this.operator(wff);
        if (op == null || Lisp.isNil(op)) {
            return wff;
        }
        if (this.isQuantifier(op)) {
            Object var = Lisp.car(Lisp.cdr(op));
            LList retList = this.standardize((LList)Lisp.car(Lisp.cdr(wff)));
            return Lisp.subst(this.newVar(), var, (LList)new Pair(op, (Object)new Pair((Object)retList, (Object)LList.Empty)));
        }
        LList retList = LList.Empty;
        for (int i = 0; i < wff.size(); ++i) {
            retList = wff.get(i) instanceof LList ? Lisp.append(retList, (LList)new Pair((Object)this.standardize((LList)wff.get(i)), (Object)LList.Empty)) : Lisp.append(retList, (LList)new Pair(wff.get(i), (Object)LList.Empty));
        }
        return retList;
    }

    LList skolemize(LList wff, String type) {
        System.err.println("skolemize(" + wff + ")");
        return this.skolemize(wff, type, LList.Empty);
    }

    LList skolemize(LList wff, String type, LList vars) {
        Object op = this.operator(wff);
        if (wff.isEmpty()) {
            return wff;
        }
        if (this.isQuantifier(op)) {
            if (Lisp.car(op).equals("A")) {
                vars = Lisp.append(vars, (LList)new Pair(Lisp.car(Lisp.cdr(op)), (Object)LList.Empty));
                return this.skolemize((LList)Lisp.car(Lisp.cdr(wff)), type, vars);
            }
            if (vars.isEmpty()) {
                wff = type.equals("conclusion") ? Lisp.subst(this.newVar(), Lisp.car(Lisp.cdr(op)), (LList)Lisp.car(Lisp.cdr(wff))) : Lisp.subst(this.newConst(), Lisp.car(Lisp.cdr(op)), (LList)Lisp.car(Lisp.cdr(wff)));
                return this.skolemize(wff, type, vars);
            }
            wff = type.equals("conclusion") ? Lisp.subst(this.newVar(), Lisp.car(Lisp.cdr(op)), (LList)Lisp.car(Lisp.cdr(wff))) : Lisp.subst(new Pair((Object)this.newFunc(), (Object)vars), Lisp.car(Lisp.cdr(op)), (LList)Lisp.car(Lisp.cdr(wff)));
            return this.skolemize(wff, type, vars);
        }
        LList newList = LList.Empty;
        for (int i = 0; i < wff.size(); ++i) {
            newList = wff.get(i) instanceof LList ? Lisp.append(newList, (LList)new Pair((Object)this.skolemize((LList)wff.get(i), type, vars), (Object)LList.Empty)) : Lisp.append(newList, (LList)new Pair(wff.get(i), (Object)LList.Empty));
        }
        return newList;
    }

    LList cnf(LList wff) {
        System.err.println("cnf(" + wff + ")");
        if (Lisp.isAtom(wff)) {
            return wff;
        }
        LList newList = LList.Empty;
        for (int i = 0; i < wff.size(); ++i) {
            newList = wff.get(i) instanceof Pair ? Lisp.append(newList, (LList)new Pair((Object)this.cnf((LList)wff.get(i)), (Object)LList.Empty)) : Lisp.append(newList, (LList)new Pair(wff.get(i), (Object)LList.Empty));
        }
        wff = newList;
        if (this.isOr(this.operator(wff))) {
            return this.distribute((LList)Lisp.car(wff), (LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
        }
        return wff;
    }

    LList distribute(LList wff1, LList wff2) {
        if (this.isAnd(this.operator(wff1))) {
            LList caddr = (LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff1)));
            return new Pair((Object)this.distribute((LList)Lisp.car(wff1), wff2), (Object)new Pair((Object)"&", (Object)new Pair((Object)this.distribute(caddr, wff2), (Object)LList.Empty)));
        }
        if (this.isAnd(this.operator(wff2))) {
            LList caddr = (LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff2)));
            return new Pair((Object)this.distribute(wff1, (LList)Lisp.car(wff2)), (Object)new Pair((Object)"&", (Object)new Pair((Object)this.distribute(wff1, caddr), (Object)LList.Empty)));
        }
        return new Pair((Object)wff1, (Object)new Pair((Object)"!", (Object)new Pair((Object)wff2, (Object)LList.Empty)));
    }

    LList negateClause(LList literals) {
        if (literals.isEmpty()) {
            return literals;
        }
        if (literals.size() == 1) {
            return (LList)this.negate((LList)literals.get(0));
        }
        LList retLiterals = LList.Empty;
        for (int i = 0; i < literals.size(); ++i) {
            retLiterals = Lisp.append(retLiterals, (LList)new Pair((Object)"!", (Object)new Pair(Lisp.car(literals), (Object)LList.Empty)));
        }
        return this.cnf((LList)this.negate(retLiterals));
    }

    LList makeClauses(LList literals, String type) {
        LList ret = this.clauses(this.cnf(this.skolemize(this.standardize(this.miniscope(this.condelim(literals))), type)));
        return ret;
    }
}

