/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.glj.graph;

import gnu.lists.LList;
import gnu.lists.Pair;
import java.io.StringReader;
import java.util.LinkedList;
import jp.sourceforge.glj.graph.Clause;
import jp.sourceforge.glj.graph.GraphNode;
import jp.sourceforge.glj.graph.GraphSearch;
import jp.sourceforge.glj.graph.GraphSearchA;
import jp.sourceforge.glj.lisp.Lisp;

class ClauseNode
extends GraphNode {
    static GraphSearch graph;
    LList parentClause;

    ClauseNode() {
    }

    @Override
    public boolean isGoal() {
        return ((Clause)this.state).isNil();
    }

    @Override
    public LinkedList operators(int index) {
        return null;
    }

    @Override
    public void reportSolution() {
        int n = graph.getClosed().size();
        for (int i = 0; i < n; ++i) {
            System.err.println("reportSolution(" + n + "/" + i + "/" + (n - i - 1) + ")");
            System.err.println(graph.getClosed().get(n - i - 1));
            ClauseNode node = (ClauseNode)graph.getClosed().get(n - i - 1);
            ((Clause)node.state).reportSolution();
        }
        ((Clause)this.state).reportSolution();
    }

    @Override
    public boolean isStateEqual(Object node) {
        return ((Clause)this.state).isClauseEqual((Clause)((ClauseNode)node).state);
    }

    @Override
    public int hhat() {
        return ((Clause)this.state).numLiterals();
    }

    @Override
    public LinkedList graphExpand() {
        LinkedList<ClauseNode> nodes = null;
        LinkedList applied = graph.getClosed();
        System.err.println("expand = " + this.state);
        for (int i = 0; i < applied.size(); ++i) {
            if (this.isStateEqual((ClauseNode)applied.get(i))) continue;
            System.err.println("applied(" + i + ")= " + ((ClauseNode)applied.get((int)i)).state);
            LList resolved = ((Clause)this.state).resolve((Clause)((ClauseNode)applied.get((int)i)).state);
            boolean isNil = false;
            for (int j = 0; j < resolved.size(); ++j) {
                ClauseNode node;
                if (((Clause)resolved.get(j)).isNil()) {
                    isNil = true;
                }
                if ((node = this.makeSuccessor((LList)new Pair(resolved.get(j), (Object)new Pair((Object)new Integer(0), (Object)LList.Empty)), (ClauseNode)applied.get(i))) == null) continue;
                if (nodes == null) {
                    nodes = new LinkedList<ClauseNode>();
                }
                nodes.add(node);
            }
            if (isNil) break;
        }
        this.setSuccessors(nodes);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.addFirst(nodes);
        ret.addLast(this);
        return ret;
    }

    ClauseNode makeSuccessor(LList stateAndCost, ClauseNode another) {
        ClauseNode node = null;
        if (stateAndCost.isEmpty()) {
            return null;
        }
        try {
            node = (ClauseNode)this.getClass().newInstance();
        }
        catch (Exception e) {
            System.err.println("make instance failed");
        }
        node.setState(stateAndCost.get(0));
        node.setGhat(this.ghat + (Integer)stateAndCost.get(1));
        node.setFhat(node.ghat + this.hhat());
        node.setParent(this);
        node.setSuccessors(null);
        node.setParentClause((LList)new Pair((Object)this, (Object)new Pair((Object)another, (Object)LList.Empty)));
        return node;
    }

    public void setParentClause(LList parentClause) {
        this.parentClause = parentClause;
    }

    public static void main(String[] args) {
        StringReader str = new StringReader(args[0]);
        LList tree = null;
        try {
            tree = Lisp.read(str);
        }
        catch (Exception e) {
            System.err.println("problem read error");
            return;
        }
        System.err.println("input = " + tree);
        LList premis = (LList)Lisp.car(tree);
        LList conclusion = (LList)Lisp.cdr(tree);
        LinkedList<ClauseNode> premisNodes = new LinkedList<ClauseNode>();
        LinkedList<ClauseNode> conclusionNodes = new LinkedList<ClauseNode>();
        graph = new GraphSearchA();
        for (int i = 0; i < premis.size(); ++i) {
            LList literals = (LList)premis.get(i);
            LList cls = new Clause().makeClauses(literals, "premis");
            for (int j = 0; j < cls.size(); ++j) {
                ClauseNode node = new ClauseNode();
                node.setState(new Clause().newClause((LList)cls.get(j), "premis", (LList)cls.get(j)));
                node.setGhat(0);
                node.setFhat(node.ghat + node.hhat());
                node.setParentClause(LList.Empty);
                premisNodes.addFirst(node);
                System.err.println("premis(" + i + ")= " + ((Clause)node.state).literals);
            }
        }
        if (!conclusion.isEmpty()) {
            Pair literals = new Pair((Object)"~", (Object)conclusion);
            System.err.println("conclusion pre = " + literals);
            LList cls = new Clause().makeClauses((LList)literals, "conclusion");
            System.err.println("conclusion = " + cls);
            for (int i = 0; i < cls.size(); ++i) {
                ClauseNode node = new ClauseNode();
                Clause clause = new Clause();
                LList answer = Lisp.append((LList)cls.get(i), (LList)new Pair((Object)clause.negateClause((LList)cls.get(i)), (Object)LList.Empty));
                node.setState(clause.newClause((LList)cls.get(i), "conclusion", answer));
                node.setGhat(0);
                node.setFhat(node.ghat + node.hhat());
                node.setParentClause(LList.Empty);
                conclusionNodes.add(node);
                System.err.println("conclusion = " + ((Clause)node.state).literals);
            }
            graph.setOpen(conclusionNodes);
            graph.setClosed(premisNodes);
        } else {
            graph.setOpen(premisNodes);
        }
        LinkedList solutions = graph.search1();
        ClauseNode.solution(solutions);
    }

    public static void solution(LinkedList solutions) {
        if (solutions != null && !solutions.isEmpty()) {
            System.out.println("solution");
            ((GraphNode)solutions.getFirst()).reportSolution();
        } else {
            ClauseNode.noSolution();
        }
    }

    public static void noSolution() {
        int n = graph.getClosed().size();
        for (int i = 0; i < n; ++i) {
            ClauseNode node = (ClauseNode)graph.getClosed().get(n - i - 1);
            ((Clause)node.state).reportSolution();
        }
    }
}

