/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFareComponentImpl;
import jp.sourceforge.gnp.prorate.ProrateFcalc;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateTax;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateAskTable;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;

public class ProrateAuditImpl {
    ProrateAudit audit;
    public ProrateRulebase rulebase;
    public ProrateDatabase database;
    public ProrateFcalc fcalc;
    public ProrateTrace trace;
    public ProrateTax tax;
    double discountedValue = 0.0;

    public ProrateAuditImpl() {
    }

    public ProrateAuditImpl(ProrateRulebase rulebase_in) {
        this.rulebase = rulebase_in;
    }

    public boolean prorate(ProrateAudit audit) throws Exception {
        this.audit = audit;
        if (!this.preProcess()) {
            return false;
        }
        if (audit.isOwnAudit() && audit.getTicketFare() == 0.0) {
            return this.prorateZero();
        }
        if (!(audit.getComponents() != null && audit.getComponents().length != 0 || this.divideFareComponent())) {
            return false;
        }
        if (audit.getTotalNuc() == 0.0 && audit.getTicketFare() == 0.0) {
            return this.prorateZero();
        }
        for (int i = 0; i < audit.getComponents().length; ++i) {
            ProrateFareComponentImpl fcompImpl = new ProrateFareComponentImpl();
            ProrateFareComponent fcomp = audit.getComponents()[i];
            if (!fcompImpl.prorate(this, audit, fcomp, this.rulebase)) {
                fcompImpl = null;
                return false;
            }
            Object var3_3 = null;
        }
        if (!this.prorateRest()) {
            return false;
        }
        return this.postProcess();
    }

    boolean preProcess() {
        if (this.audit.getAirwayId() == null || this.audit.getAirwayId().equals("")) {
            this.audit.setAirwayId(this.database.getAirwayId(this.audit.getAirwayNumber(), this.audit.getIssueDate()));
            if (this.audit.getAirwayId().equals("")) {
                if (this.database.getResult() > 1) {
                    this.DBError(null, "getAirwayId", this.audit.getAirwayNumber(), this.audit.getIssueDate());
                    return false;
                }
                this.error(65, "Airway No [" + this.audit.getAirwayNumber() + "]");
                return false;
            }
        }
        if (this.audit.isInward() && (this.audit.getInwardId() == null || this.audit.getInwardId().equals(""))) {
            this.audit.setInwardId(this.database.getAirwayId(this.audit.getInwardNumber(), this.audit.getInvoiceMonth()));
            if (this.audit.getInwardId().equals("")) {
                if (this.database.getResult() > 1) {
                    this.DBError(null, "getAirwayId", this.audit.getInwardNumber(), this.audit.getInvoiceMonth());
                    return false;
                }
                this.error(65, "Inward Airway No [" + this.audit.getInwardNumber() + "]");
                return false;
            }
        }
        if (this.audit.getIssueDate().length() == 6) {
            this.audit.setIssueDate(this.audit.getIssueDate() + "01");
        }
        if (this.audit.getInvoiceMonth().equals("")) {
            if ((!this.audit.isOwnAudit() || this.audit.isInward()) && this.audit.getSectors().length > 0 && this.audit.getSectors()[0].getFlightDate().length() > 0) {
                this.audit.setInvoiceMonth(this.audit.getSectors()[0].getFlightDate());
                if (this.audit.getInvoiceMonth().length() == 6) {
                    this.audit.setInvoiceMonth(this.audit.getInvoiceMonth() + "01");
                }
            } else {
                this.audit.setInvoiceMonth(this.audit.getIssueDate());
            }
        }
        if (!this.setFixedFare()) {
            return false;
        }
        if (this.audit.getRoeRate() <= 0.0) {
            this.audit.setRoeRate(this.database.getRoeRate(this.audit.getCurrency(), this.audit.getIssueDate()));
            if (this.audit.getRoeRate() < 0.0) {
                if (this.database.getResult() > 1) {
                    this.DBError(null, "getRoeRate", this.audit.getCurrency(), this.audit.getIssueDate());
                    return false;
                }
                this.error(67, this.audit.getCurrency() + ":" + this.audit.getIssueDate());
                return false;
            }
        }
        if (this.audit.getDay5Rate() <= 0.0) {
            this.audit.setDay5Rate(this.database.getMeanRate(this.audit.getCurrency(), this.audit.getInvoiceMonth()));
            if (this.audit.getDay5Rate() <= 0.0) {
                this.audit.setDay5Rate(this.database.get5dayRate(this.audit.getCurrency(), this.audit.getInvoiceMonth()));
                if (this.audit.getDay5Rate() < 0.0) {
                    if (this.database.getResult() > 1) {
                        this.DBError(null, "get5dayRate", this.audit.getCurrency(), this.audit.getInvoiceMonth());
                        return false;
                    }
                    this.error(68, this.audit.getCurrency() + ":" + this.audit.getInvoiceMonth());
                    return false;
                }
            }
        }
        if (this.audit.getOrigin() == null || this.audit.getOrigin().equals("") && this.audit.getSectors().length > 0) {
            this.audit.setOrigin(this.audit.getSectors()[0].getDepCode());
        }
        if (this.audit.getDestination() == null || this.audit.getDestination().equals("") && this.audit.getSectors().length > 0) {
            int index = this.audit.getSectors().length - 1;
            this.audit.setDestination(this.audit.getSectors()[index].getDestCode());
        }
        boolean isError = false;
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            String op;
            int k;
            ProrateSector sector = this.audit.getSectors()[i];
            if (sector.getFlightDate().length() == 6) {
                sector.setFlightDate(sector.getFlightDate() + "01");
            } else if (sector.getFlightDate().length() == 0) {
                sector.setFlightDate(this.audit.getIssueDate());
            }
            sector.setDepAirport(sector.getDepCode());
            sector.setDepCode(this.database.getCityName(sector.getDepCode()));
            if (sector.getDepCode().equals("") && this.database.getResult() > 1) {
                this.DBError(sector, "getCityName", sector.getDepCode());
                return false;
            }
            sector.setDestAirport(sector.getDestCode());
            sector.setDestCode(this.database.getCityName(sector.getDestCode()));
            if (sector.getDestCode().equals("") && this.database.getResult() > 1) {
                this.DBError(sector, "getCityName", sector.getDestCode());
                return false;
            }
            if (sector.getCarrier().equals("") || sector.getCarrier().equals("  ")) {
                sector.setCarrier("YY");
            }
            if (sector.getCarrier().equals("XX")) continue;
            sector.setFareBasisFullStr(sector.getFareBasis());
            String f_basis = sector.getFareBasis();
            if (f_basis.length() > 4 && f_basis.substring(1, 5).equals("INTL")) {
                String f_basis_tmp = f_basis;
                f_basis = f_basis.substring(0, 1);
                f_basis = f_basis + f_basis_tmp.substring(5);
            } else if (f_basis.length() > 5 && f_basis.substring(2, 6).equals("INTL")) {
                String f_basis_tmp = f_basis;
                f_basis = f_basis.substring(0, 2);
                f_basis = f_basis + f_basis_tmp.substring(6);
            } else if (f_basis.length() > 6 && f_basis.substring(3, 7).equals("INTL")) {
                String f_basis_tmp = f_basis;
                f_basis = f_basis.substring(0, 3);
                f_basis = f_basis + f_basis_tmp.substring(7);
            } else if (f_basis.length() > 1 && f_basis.charAt(0) == ' ') {
                f_basis = f_basis.substring(1);
            }
            int j = f_basis.lastIndexOf("/");
            if (j > 0) {
                f_basis = f_basis.substring(0, j);
            }
            if ((k = f_basis.indexOf("//")) > 0) {
                f_basis = f_basis.substring(0, k);
            }
            sector.setFareBasis(f_basis.toString());
            f_basis = null;
            if ((sector.getProrationType() & 0xF002) > 0) {
                sector.setProrationType(sector.getProrationType() & 0xF002);
            } else {
                sector.setProrationType(0);
            }
            sector.setOpCarrier("");
            if (sector.getFlightNo() == null || sector.getFlightNo().equals("")) {
                sector.setFlightNo("-1");
            }
            if ((op = this.database.getOpCarrier(sector.getCarrier(), sector.getFlightNo(), sector.getFlightDate())).equals("") && this.database.getResult() > 1) {
                this.DBError(sector, "getOpCarrier", sector.getCarrier(), sector.getFlightNo());
                return false;
            }
            if (!op.equals("")) {
                sector.setOpCarrier(op);
            }
            if (!(sector.getProrateFactor() <= 0.0)) continue;
            sector.setProrateFactor(this.database.getProrateFactor(sector.getDepCode(), sector.getDestCode(), this.audit.getIssueDate()));
            if (!(sector.getProrateFactor() < 0.0)) continue;
            if (this.database.getResult() > 1) {
                this.DBError(sector, "getProrateFactor", sector.getDepCode(), sector.getDestCode());
                return false;
            }
            isError = true;
            this.error(sector, 66);
        }
        if (isError) {
            return false;
        }
        ProrateRuleObject.classInitialize(this.database);
        ProrateRuleObject.codeConversionInitialize();
        return true;
    }

    boolean divideFareComponent() {
        int i;
        if (this.audit.getFareCalculation().length() > 0) {
            int i2;
            boolean isFareComponent = false;
            for (i2 = 0; i2 < this.audit.getSectors().length; ++i2) {
                if (!(this.audit.getSectors()[i2].getFareComponent() >= 0.0)) continue;
                isFareComponent = true;
            }
            if (!(isFareComponent || this.audit.isIgnoreFareCalc() || this.fcalc.analyze(this, this.audit))) {
                if (this.audit.getSectors().length == 1) {
                    this.audit.getSectors()[0].setFareComponent(1.0);
                    this.error(0);
                } else if (this.audit.isOneComponent()) {
                    int idx = this.audit.getSectors().length - 1;
                    this.audit.getSectors()[idx].setFareComponent(1.0);
                    this.error(0);
                } else {
                    for (i2 = 0; i2 < this.audit.getSectors().length; ++i2) {
                        ProrateSector sector = this.audit.getSectors()[i2];
                        if (this.audit.getOwnAirwayId().equals(this.audit.getAirwayId()) && (sector.getCarrier().equals(this.audit.getAirwayId()) && sector.getOpCarrier().equals("") || sector.getOpCarrier().equals(this.audit.getAirwayId()))) continue;
                        return false;
                    }
                    this.error(0);
                }
            }
        }
        if (this.audit.getSectors().length == 0) {
            return false;
        }
        int FC_MAX = 20;
        double[] componentValue = new double[21];
        for (int i3 = 0; i3 < 21; ++i3) {
            componentValue[i3] = 0.0;
        }
        int componentIndex = 0;
        int[] sectorsInComponent = new int[21];
        for (int i4 = 0; i4 < 21; ++i4) {
            sectorsInComponent[i4] = 0;
        }
        boolean fetched = false;
        boolean emptyfc = false;
        double totalNucValue = 0.0;
        double totalSideTripValue = 0.0;
        int sideIndex = 0;
        boolean sideIn = false;
        boolean emptyst = false;
        double totalClassDiffPlus = 0.0;
        int diffIndex = 1;
        double[] componentStopOverCharge = new double[21];
        int stopOverCnt = 0;
        double totalSecureCharge = 0.0;
        int secIndex = 1;
        for (i = 0; i < this.audit.getSectors().length; ++i) {
            ProrateSector sector = this.audit.getSectors()[i];
            if (sector.getCarrier().equals("XX")) {
                sector.setComponentIndex(-1);
                sector.setProrationType(1);
                sector.setProrateValue(0.0);
                continue;
            }
            if (sector.getSecureIndex() == 81) {
                sector.setSecureIndex(secIndex);
                if (sector.getSecureCharge() > 0.0) {
                    totalSecureCharge += sector.getSecureCharge();
                    ++secIndex;
                }
            } else {
                sector.setSecureIndex(0);
            }
            if (sector.getClassDiffIndex() == 68) {
                sector.setClassDiffIndex(diffIndex);
                if (sector.getClassDiffPlus() != 0.0) {
                    totalClassDiffPlus += sector.getClassDiffPlus();
                    ++diffIndex;
                }
            } else {
                sector.setClassDiffIndex(0);
            }
            if (sector.getSideTripIndex() == 83) {
                int j = componentIndex + sideIndex + 1;
                emptyst = true;
                sideIn = true;
                sector.setComponentIndex(j);
                int n = j;
                sectorsInComponent[n] = sectorsInComponent[n] + 1;
                if (sector.getSideTripPlus() >= 0.0) {
                    emptyst = false;
                    componentValue[j] = sector.getSideTripPlus();
                    totalNucValue += componentValue[j];
                    componentStopOverCharge[j] = 0.0;
                    totalSideTripValue += sector.getSideTripPlus();
                    ++sideIndex;
                }
            } else {
                emptyfc = true;
                if (sideIn) {
                    sideIn = false;
                    if (emptyst) {
                        this.error(33);
                        return false;
                    }
                }
                sector.setComponentIndex(componentIndex);
                int n = componentIndex;
                sectorsInComponent[n] = sectorsInComponent[n] + 1;
            }
            if (!(sector.getFareComponent() >= 0.0)) continue;
            fetched = true;
            emptyfc = false;
            if (sideIn) {
                sideIn = false;
                if (emptyst) {
                    this.error(33);
                    return false;
                }
            }
            if (sectorsInComponent[componentIndex] == 0) {
                this.error(41);
                return false;
            }
            if (sector.getComponentKind() == 0) {
                sector.setComponentKind(1);
            }
            componentValue[componentIndex] = sector.getFareComponent();
            totalNucValue += componentValue[componentIndex];
            componentStopOverCharge[componentIndex] = 0.0;
            if (this.audit.getStopOverCharge() > 0.0 && sectorsInComponent[componentIndex] > 1) {
                ++stopOverCnt;
                componentStopOverCharge[componentIndex] = 1.0;
            }
            componentIndex += sideIndex;
            sideIndex = 0;
            sectorsInComponent[++componentIndex] = 0;
        }
        if (fetched && emptyfc) {
            this.error(34);
            return false;
        }
        if (emptyfc && this.audit.getTotalNuc() == 0.0 && this.audit.getTicketFare() == 0.0) {
            this.error(34);
            return false;
        }
        if (sideIn) {
            if (emptyst) {
                this.error(35);
                return false;
            }
            int idx = this.audit.getSectors().length - 1;
            if (!emptyfc && this.audit.getSectors()[idx].getFareComponent() < 0.0) {
                int j = 0;
                for (int k = 0; k < sideIndex; ++k) {
                    j = componentIndex + k + 1;
                    for (int i5 = 0; i5 < this.audit.getSectors().length; ++i5) {
                        if (this.audit.getSectors()[i5].getComponentIndex() != j) continue;
                        this.audit.getSectors()[i5].setComponentIndex(j - 1);
                    }
                    componentValue[j - 1] = componentValue[j];
                    componentValue[j] = 0.0;
                    sectorsInComponent[j - 1] = sectorsInComponent[j];
                    sectorsInComponent[j] = 0;
                    componentStopOverCharge[j - 1] = componentStopOverCharge[j];
                    componentStopOverCharge[j] = 0.0;
                }
                componentIndex = j;
            }
        }
        if (emptyfc) {
            if (this.audit.getTotalNuc() > 0.0) {
                componentValue[componentIndex] = this.audit.getTotalNuc() - totalNucValue - this.audit.getStopOverCharge() - (totalSecureCharge + totalClassDiffPlus - this.audit.getLessAmt());
            } else {
                this.audit.setTotalNuc(this.audit.getTicketFare() / this.audit.getRoeRate());
                componentValue[componentIndex] = this.audit.getTotalNuc() - totalNucValue - this.audit.getStopOverCharge() - (totalSecureCharge + totalClassDiffPlus - this.audit.getLessAmt());
            }
            totalNucValue += componentValue[componentIndex];
            componentStopOverCharge[componentIndex] = 0.0;
            if (this.audit.getStopOverCharge() > 0.0 && sectorsInComponent[componentIndex] > 1) {
                ++stopOverCnt;
                componentStopOverCharge[componentIndex] = 1.0;
            }
            componentIndex += sideIndex;
            ++componentIndex;
        }
        totalNucValue += totalSecureCharge + totalClassDiffPlus - this.audit.getLessAmt();
        if (this.audit.getLessAmt() > 0.0) {
            componentValue[0] = totalNucValue - totalSecureCharge - totalClassDiffPlus;
            for (i = 0; i < this.audit.getSectors().length; ++i) {
                this.audit.getSectors()[i].setComponentIndex(0);
            }
            componentIndex = 1;
            if (stopOverCnt > 1) {
                stopOverCnt = 1;
                componentStopOverCharge[0] = 1.0;
            }
        }
        if (this.audit.getStopOverCharge() > 0.0 && stopOverCnt > 0) {
            for (i = 0; i < componentIndex; ++i) {
                if (componentStopOverCharge[i] != 1.0) continue;
                componentStopOverCharge[i] = this.audit.getStopOverCharge() / (double)stopOverCnt;
                int n = i;
                componentValue[n] = componentValue[n] + componentStopOverCharge[i];
                totalNucValue += componentStopOverCharge[i];
            }
        }
        if (totalNucValue == 0.0 && this.audit.getTicketFare() != 0.0) {
            this.error(36);
            return false;
        }
        if (!this.audit.isOwnAudit()) {
            this.audit.setTicketFare(totalNucValue * this.audit.getRoeRate());
            this.audit.setTotalNuc(totalNucValue);
            this.audit.setAmountRatio(1.0);
        } else {
            if (this.audit.getTicketFare() > 0.0) {
                this.audit.setTotalNuc(this.audit.getTicketFare() / this.audit.getRoeRate());
            }
            this.audit.setAmountRatio(this.audit.getTotalNuc() / totalNucValue);
            i = 0;
            while (i < componentIndex) {
                int n = i++;
                componentValue[n] = componentValue[n] * this.audit.getAmountRatio();
            }
        }
        Vector<ProrateFareComponent> components = new Vector<ProrateFareComponent>();
        for (int ix = 0; ix < componentIndex; ++ix) {
            Vector<ProrateSector> fSectors = new Vector<ProrateSector>();
            int componentKind = 0;
            for (int j = 0; j < this.audit.getSectors().length; ++j) {
                ProrateSector sector = this.audit.getSectors()[j];
                if (sector.getComponentIndex() != ix) continue;
                fSectors.add(sector);
                componentKind = sector.getComponentKind();
            }
            ProrateSector[] sectorsArray = new ProrateSector[fSectors.size()];
            for (int j = 0; j < fSectors.size(); ++j) {
                sectorsArray[j] = (ProrateSector)fSectors.get(j);
            }
            ProrateFareComponent component = new ProrateFareComponent(this.audit, sectorsArray);
            component.setValue(componentValue[ix] * this.audit.getRoeRate() / this.audit.getDay5Rate());
            component.setKind(componentKind);
            components.add(component);
            ((ProrateSector)fSectors.get(fSectors.size() - 1)).setFareComponent(component.getValue());
            this.trace.trace(component, ix, componentValue[ix], this.audit.getRoeRate(), this.audit.getDay5Rate());
        }
        ProrateFareComponent[] componentArray = new ProrateFareComponent[components.size()];
        for (int j = 0; j < components.size(); ++j) {
            componentArray[j] = (ProrateFareComponent)components.get(j);
        }
        this.audit.setComponents(componentArray);
        return true;
    }

    boolean prorateRest() {
        double totalProrateValue = 0.0;
        if (this.audit.isNonProrateRest()) {
            return true;
        }
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            totalProrateValue += this.audit.getSectors()[i].getProrateValue();
        }
        double valueRest = this.audit.getTotalNuc() * this.audit.getRoeRate() / this.audit.getDay5Rate() - totalProrateValue;
        if (valueRest != 0.0) {
            ProrateSector sector;
            boolean found = false;
            double totalProrateFactor = 0.0;
            for (int i = 0; i < this.audit.getSectors().length; ++i) {
                sector = this.audit.getSectors()[i];
                if ((!sector.getCarrier().equals(this.audit.getAirwayId()) || !sector.getOpCarrier().equals("")) && !sector.getOpCarrier().equals(this.audit.getAirwayId())) continue;
                totalProrateFactor += sector.getProrateFactor();
                found = true;
            }
            if (!found) {
                return true;
            }
            for (int j = 0; j < this.audit.getSectors().length; ++j) {
                sector = this.audit.getSectors()[j];
                if ((!sector.getCarrier().equals(this.audit.getAirwayId()) || !sector.getOpCarrier().equals("")) && !sector.getOpCarrier().equals(this.audit.getAirwayId())) continue;
                sector.setProrateValue(sector.getProrateValue() + valueRest * sector.getProrateFactor() / totalProrateFactor);
                this.trace.traceRest(this.audit, valueRest, totalProrateFactor, j);
            }
        }
        return true;
    }

    boolean postProcess() {
        if (!this.setDiscountedValue()) {
            return false;
        }
        if (this.audit.isOwnAudit() && this.audit.isTicketing() && !this.audit.isInward() && !this.prorateDiscount()) {
            return false;
        }
        if (!this.audit.isOwnAudit() || !this.audit.isTicketing() || this.tax.divide(this.audit)) {
            // empty if block
        }
        return this.prorateCommission();
    }

    boolean setDiscountedValue() {
        if (!this.audit.getSalesCurrency().equals("") && !this.audit.getSalesCurrency().equals(this.audit.getCurrency())) {
            double d;
            double day5Rate = this.database.getMeanRate(this.audit.getSalesCurrency(), this.audit.getInvoiceMonth());
            if (d <= 0.0) {
                double d2;
                day5Rate = this.database.get5dayRate(this.audit.getSalesCurrency(), this.audit.getInvoiceMonth());
                if (d2 < 0.0) {
                    if (this.database.getResult() > 1) {
                        this.DBError(null, "get5dayRate", this.audit.getSalesCurrency(), this.audit.getInvoiceMonth());
                    }
                    this.error(68, this.audit.getSalesCurrency() + ":" + this.audit.getInvoiceMonth());
                    return false;
                }
            }
            this.discountedValue = this.audit.getSalesFare() / day5Rate;
        } else {
            this.discountedValue = this.audit.getSalesFare() / this.audit.getDay5Rate();
        }
        return true;
    }

    boolean prorateDiscount() {
        ProrateSector sector;
        double totalProrateValue = 0.0;
        if (this.audit.isNonProrateRest()) {
            return true;
        }
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            totalProrateValue += this.audit.getSectors()[i].getProrateValue();
        }
        if (Math.abs(totalProrateValue - this.discountedValue) > 0.01) {
            ProrateSector sector2;
            int i;
            boolean found = false;
            double totalProrateFactor = 0.0;
            double valueRest = this.discountedValue;
            for (i = 0; i < this.audit.getSectors().length; ++i) {
                sector2 = this.audit.getSectors()[i];
                if (sector2.getCarrier().equals(this.audit.getAirwayId()) && sector2.getOpCarrier().equals("") || sector2.getOpCarrier().equals(this.audit.getAirwayId())) {
                    totalProrateFactor += sector2.getProrateFactor();
                    found = true;
                    continue;
                }
                valueRest -= sector2.getProrateValue();
            }
            if (found) {
                for (i = 0; i < this.audit.getSectors().length; ++i) {
                    sector2 = this.audit.getSectors()[i];
                    if ((!sector2.getCarrier().equals(this.audit.getAirwayId()) || !sector2.getOpCarrier().equals("")) && !sector2.getOpCarrier().equals(this.audit.getAirwayId())) continue;
                    sector2.setProrateValue(valueRest * sector2.getProrateFactor() / totalProrateFactor);
                    this.trace.traceDiscount(this.audit, valueRest, false, totalProrateFactor, i);
                }
            } else {
                this.audit.getSectors()[0].setProrateValue(this.audit.getSectors()[0].getProrateValue() + this.discountedValue - totalProrateValue);
                this.trace.traceDiscount(this.audit, this.discountedValue - totalProrateValue, true, 0.0, 0);
            }
            totalProrateValue = 0.0;
            for (int j = 0; j < this.audit.getSectors().length; ++j) {
                totalProrateValue += this.audit.getSectors()[j].getProrateValue();
            }
            if (totalProrateValue != this.discountedValue) {
                for (i = 0; i < this.audit.getSectors().length; ++i) {
                    sector2 = this.audit.getSectors()[i];
                    if (!(sector2.getProrateValue() > 0.0)) continue;
                    sector2.setProrateValue(sector2.getProrateValue() + this.discountedValue - totalProrateValue);
                    this.trace.traceDiscount(this.audit, this.discountedValue - totalProrateValue, true, 0.0, i);
                    break;
                }
            }
        }
        double totalProrateFactor = 0.0;
        boolean found = false;
        for (int j = 0; j < this.audit.getSectors().length; ++j) {
            sector = this.audit.getSectors()[j];
            if (sector.getProrateValue() < 0.0) {
                found = true;
            }
            totalProrateFactor += sector.getProrateFactor();
        }
        if (found) {
            totalProrateValue = 0.0;
            for (int i = 0; i < this.audit.getSectors().length; ++i) {
                sector = this.audit.getSectors()[i];
                sector.setProrateValue(this.discountedValue * sector.getProrateFactor() / totalProrateFactor);
                totalProrateValue += sector.getProrateValue();
                this.trace.traceDiscount(this.audit, this.discountedValue, false, totalProrateFactor, i);
            }
            if (totalProrateValue != this.discountedValue) {
                this.audit.getSectors()[0].setProrateValue(this.audit.getSectors()[0].getProrateValue() + this.discountedValue - totalProrateValue);
                this.trace.traceDiscount(this.audit, this.discountedValue - totalProrateValue, true, 0.0, 0);
            }
        }
        return true;
    }

    boolean prorateZero() {
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            ProrateSector sector = this.audit.getSectors()[i];
            sector.setSrpNuc(0.0);
            sector.setProrateValue(0.0);
            sector.setProrationType(0);
        }
        return true;
    }

    public boolean prorateCommission() {
        if (this.audit.isOwnAudit() && this.audit.isTicketing()) {
            ProrateSector sector;
            int i;
            double commissionTotal = 0.0;
            int restIndex = -1;
            boolean noAmt = false;
            if (this.audit.getCommissionAmt() == 0.0) {
                this.audit.setCommissionAmt(this.discountedValue * this.audit.getCommissionRate() / 100.0);
            } else if (!this.audit.getCommissionCurrency().equals("") && !this.audit.getCommissionCurrency().equals(this.audit.getCurrency())) {
                double d;
                double day5Rate = 0.0;
                day5Rate = this.database.getMeanRate(this.audit.getCommissionCurrency(), this.audit.getInvoiceMonth());
                if (d <= 0.0) {
                    double d2;
                    day5Rate = this.database.get5dayRate(this.audit.getCommissionCurrency(), this.audit.getInvoiceMonth());
                    if (d2 < 0.0) {
                        if (this.database.getResult() > 1) {
                            this.DBError(null, "get5dayRate", this.audit.getCommissionCurrency(), this.audit.getInvoiceMonth());
                            return false;
                        }
                        this.error(68, this.audit.getCommissionCurrency() + ":" + this.audit.getInvoiceMonth());
                        return false;
                    }
                }
                this.audit.setCommissionAmt(this.audit.getCommissionAmt() / day5Rate);
            } else {
                if (this.audit.getDay5Rate() <= 0.0) {
                    this.audit.setDay5Rate(this.database.getMeanRate(this.audit.getCurrency(), this.audit.getInvoiceMonth()));
                    if (this.audit.getDay5Rate() <= 0.0) {
                        this.audit.setDay5Rate(this.database.get5dayRate(this.audit.getCurrency(), this.audit.getInvoiceMonth()));
                        if (this.audit.getDay5Rate() < 0.0) {
                            if (this.database.getResult() > 1) {
                                this.DBError(null, "get5dayRate", this.audit.getCurrency(), this.audit.getInvoiceMonth());
                                return false;
                            }
                            this.error(68, this.audit.getCurrency() + ":" + this.audit.getInvoiceMonth());
                            return false;
                        }
                    }
                }
                this.audit.setCommissionAmt(this.audit.getCommissionAmt() / this.audit.getDay5Rate());
            }
            for (i = 0; i < this.audit.getSectors().length; ++i) {
                sector = this.audit.getSectors()[i];
                if (this.discountedValue != 0.0) {
                    sector.setCommission(sector.getProrateValue() * this.audit.getCommissionAmt() / this.discountedValue);
                } else {
                    sector.setCommission(0.0);
                }
                commissionTotal += sector.getCommission();
                sector.setInvoiceValue(sector.getProrateValue() + sector.getTax() - sector.getCommission());
            }
            if (commissionTotal > this.audit.getCommissionAmt()) {
                for (i = 0; i < this.audit.getSectors().length; ++i) {
                    sector = this.audit.getSectors()[i];
                    if (!sector.getCarrier().equals(this.audit.getAirwayId())) continue;
                    sector.setCommission(sector.getCommission() + commissionTotal - this.audit.getCommissionAmt());
                    restIndex = i;
                    break;
                }
            } else {
                for (i = 0; i < this.audit.getSectors().length; ++i) {
                    sector = this.audit.getSectors()[i];
                    if (sector.getCarrier().equals(this.audit.getAirwayId())) continue;
                    sector.setCommission(sector.getCommission() + commissionTotal - this.audit.getCommissionAmt());
                    restIndex = i;
                    break;
                }
            }
            this.trace.traceCommission(this.audit, noAmt, this.discountedValue, restIndex, commissionTotal - this.audit.getCommissionAmt());
        } else {
            for (int i = 0; i < this.audit.getSectors().length; ++i) {
                ProrateSector sector = this.audit.getSectors()[i];
                sector.setCommission(sector.getProrateValue() * this.audit.getCommissionRate() / 100.0);
                sector.setInvoiceValue(sector.getProrateValue() + sector.getTax() - sector.getCommission());
            }
            this.trace.traceCommission(this.audit, false, this.discountedValue, -1, 0.0);
        }
        return true;
    }

    public String getCountryName(String place) {
        String country = this.database.getCountryName(place, this.audit.getIssueDate());
        if (country.equals("")) {
            for (int i = 0; i < this.audit.getAskTable().length; ++i) {
                ProrateAskTable tbl = this.audit.getAskTable()[i];
                if (tbl.isArea || !tbl.place.equals(place)) continue;
                country = tbl.answer;
                break;
            }
        }
        return country;
    }

    String getAreaName(String place) {
        String area = this.database.getAreaName(place, this.audit.getIssueDate());
        if (area.equals("")) {
            for (int i = 0; i < this.audit.getAskTable().length; ++i) {
                ProrateAskTable tbl = this.audit.getAskTable()[i];
                if (tbl.isArea || !tbl.place.equals(place)) continue;
                area = tbl.answer;
                break;
            }
        }
        return area;
    }

    boolean setFixedFare() {
        this.audit.setFixedFare(this.database.getFixedFare(this.audit.getIssueDate()));
        if (this.audit.getFixedFare() < 0.0) {
            if (this.database.getResult() > 1) {
                this.DBError(null, "getFixedFare", this.audit.getIssueDate());
                return false;
            }
            this.error(73, this.audit.getIssueDate());
            return false;
        }
        return true;
    }

    void DBError(ProrateSector sector, String pointStr) {
        StringBuffer errorStr = new StringBuffer(pointStr);
        errorStr.append(":");
        errorStr.append(this.database.getErrCode());
        errorStr.append(":");
        errorStr.append(this.database.getErrMessage());
        if (sector != null) {
            this.error(sector, 31, errorStr.toString());
            return;
        }
        this.error(63, errorStr.toString());
    }

    void DBError(String pointStr) {
        this.DBError(null, pointStr);
    }

    public void DBError(ProrateSector sector, String pointStr, String arg) {
        StringBuffer errorStr = new StringBuffer(pointStr);
        errorStr.append("(");
        errorStr.append(arg);
        errorStr.append(")");
        this.DBError(sector, errorStr.toString());
    }

    public void DBError(ProrateSector sector, String pointStr, String arg, String arg2) {
        StringBuffer errorStr = new StringBuffer(pointStr);
        errorStr.append("(");
        errorStr.append(arg);
        errorStr.append(",");
        errorStr.append(arg2);
        errorStr.append(")");
        this.DBError(sector, errorStr.toString());
    }

    public void error(int errorNo) {
        this.error(errorNo, "");
    }

    public void error(int errorNo, String errorStr) {
        this.audit.setErrorFlag(errorNo);
        this.audit.setErrorString(errorStr);
    }

    public void error(ProrateSector sector, int errorNo) {
        this.error(sector, errorNo, "");
    }

    public void error(ProrateSector sector, int errorNo, String errorStr) {
        sector.setErrorFlag(errorNo);
        sector.setErrorString(errorStr);
    }

    public ProrateAudit getAudit() {
        return this.audit;
    }

    public void setAudit(ProrateAudit audit) {
        this.audit = audit;
    }

    public ProrateDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(ProrateDatabase database) {
        this.database = database;
    }

    public ProrateFcalc getFcalc() {
        return this.fcalc;
    }

    public void setFcalc(ProrateFcalc fcalc) {
        this.fcalc = fcalc;
    }

    public ProrateRulebase getRulebase() {
        return this.rulebase;
    }

    public void setRulebase(ProrateRulebase rulebase) {
        this.rulebase = rulebase;
    }

    public ProrateTax getTax() {
        return this.tax;
    }

    public void setTax(ProrateTax tax) {
        this.tax = tax;
    }

    public ProrateTrace getTrace() {
        return this.trace;
    }

    public void setTrace(ProrateTrace trace) {
        this.trace = trace;
    }
}

