/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import jp.sourceforge.gnp.prorate.ProrateAuditImpl;
import jp.sourceforge.gnp.prorate.ProrateSectorImpl;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;

public class ProrateFareComponentImpl {
    ProrateAuditImpl auditImpl = null;

    ProrateFareComponentImpl() {
    }

    public boolean prorate(ProrateAuditImpl auditImpl, ProrateAudit audit, ProrateFareComponent fcomp, ProrateRulebase rulebase) throws Exception {
        this.setAuditImpl(auditImpl);
        if (!this.initSectors(fcomp)) {
            return false;
        }
        if (!this.prorateSRP(fcomp)) {
            return false;
        }
        if (!fcomp.getAudit().isNotRuleApply()) {
            fcomp.setFixedFareDiscount(1.0);
            for (int i = 0; i < fcomp.getSectors().length; ++i) {
                ProrateSectorImpl sectorImpl = new ProrateSectorImpl();
                sectorImpl.prorate(this.getAuditImpl(), fcomp.getSectors()[i], fcomp.getAudit(), fcomp, i);
            }
        }
        if (!this.prorateClassDiff(fcomp)) {
            return false;
        }
        if (!this.prorateSecureCharge(fcomp)) {
            return false;
        }
        if (!this.prorateNuc(fcomp)) {
            return false;
        }
        return this.prorateRest(fcomp);
    }

    boolean initSectors(ProrateFareComponent fcomp) {
        for (int i = 0; i < fcomp.getSectors().length; ++i) {
            ProrateSector sector = fcomp.getSectors()[i];
            sector.setProrateValue(0.0);
            sector.setSecureChargeSaved(sector.getSecureCharge());
        }
        return true;
    }

    boolean prorateSRP(ProrateFareComponent fcomp) {
        ProrateSector sector;
        int i;
        double totalProrateFactor = 0.0;
        boolean isError = false;
        for (i = 0; i < fcomp.getSectors().length; ++i) {
            sector = fcomp.getSectors()[i];
            if (sector.getProrateFactor() <= 0.0) {
                sector.setProrateFactor(this.getAuditImpl().database.getProrateFactor(sector.getDepCode(), sector.getDestCode(), fcomp.getAudit().getIssueDate()));
                if (sector.getProrateFactor() < 0.0) {
                    if (this.getAuditImpl().database.getResult() > 1) {
                        this.getAuditImpl().DBError(sector, "getProrateFactor", sector.getDepCode(), sector.getDestCode());
                        return false;
                    }
                    isError = true;
                    this.getAuditImpl().error(sector, 66);
                }
            }
            totalProrateFactor += sector.getProrateFactor();
        }
        if (isError) {
            return false;
        }
        for (i = 0; i < fcomp.getSectors().length; ++i) {
            sector = fcomp.getSectors()[i];
            sector.setSrpNuc(fcomp.getValue() * sector.getProrateFactor() / totalProrateFactor);
        }
        return true;
    }

    boolean prorateNuc(ProrateFareComponent fcomp) {
        ProrateSector sector;
        int i;
        double totalProrateFactor = 0.0;
        double srpProrateFactor = 0.0;
        double valueCheck = 0.0;
        for (i = 0; i < fcomp.getSectors().length; ++i) {
            sector = fcomp.getSectors()[i];
            if ((sector.getProrationType() & 0x1000000) != 0 && (sector.getProrationType() & 0x100) != 0 || (sector.getProrationType() & 0x2000000) != 0) {
                valueCheck += sector.getApdpNuc();
            } else {
                srpProrateFactor += sector.getProrateFactor();
            }
            totalProrateFactor += sector.getProrateFactor();
        }
        if (fcomp.getSectors().length > 1 && this.checkFixedFare(fcomp, fcomp.getValue() - valueCheck, srpProrateFactor)) {
            double valueRest = fcomp.getValue() - valueCheck;
            for (int i2 = 0; i2 < fcomp.getSectors().length; ++i2) {
                ProrateSector sector2 = fcomp.getSectors()[i2];
                sector2.setFixedFareCheck(fcomp.getSectors()[0].getFixedFareCheck());
                sector2.setFixedFareDiscount(fcomp.getSectors()[0].getFixedFareDiscount());
                if ((sector2.getProrationType() & 0x100) != 0 || (sector2.getProrationType() & 0x2000000) != 0) {
                    if ((sector2.getProrationType() & 0x80000) != 0) {
                        if ((sector2.getProrationType() & 0x1000000) != 0) {
                            if (sector2.getApdpNuc() == 0.0) {
                                sector2.setApdpNuc(sector2.getApdpDiscountRate() * sector2.getSrpNuc());
                            }
                            sector2.setSpaBaseAmtType(sector2.getApdpBaseAmtType());
                            sector2.setSpaBaseAmt(sector2.getApdpDiscountRate() * sector2.getApdpBaseAmt());
                            sector2.setSpaNuc(sector2.getSpaDiscountRate() * sector2.getApdpNuc() + sector2.getProratedClassDiff());
                            sector2.setProratedClassDiff(0.0);
                        } else {
                            sector2.setApdpNuc(sector2.getApdpDiscountRate() * sector2.getSrpNuc());
                        }
                    } else if ((sector2.getProrationType() & 0x40000) != 0) {
                        if ((sector2.getProrationType() & 0x1000000) != 0) {
                            sector2.setSpaNuc(sector2.getSpaDiscountRate() * sector2.getSrpNuc() + sector2.getProratedClassDiff());
                            sector2.setProratedClassDiff(0.0);
                        } else {
                            sector2.setApdpNuc(sector2.getApdpDiscountRate() * sector2.getSrpNuc());
                        }
                    }
                    sector2.setNpPvalues(sector2.getApdpNuc());
                    continue;
                }
                if ((sector2.getProrationType() & 0x1000000) != 0 && (sector2.getProrationType() & 0x40000) != 0) {
                    sector2.setSpaNuc(sector2.getSpaDiscountRate() * sector2.getSrpNuc() + sector2.getProratedClassDiff());
                    sector2.setProratedClassDiff(0.0);
                }
                sector2.setSrpNuc(valueRest * sector2.getProrateFactor() / srpProrateFactor);
                sector2.setNpPvalues(sector2.getSrpNuc());
                if ((sector2.getProrationType() & 0x1000000) != 0) {
                    if ((sector2.getProrationType() & 0x80000) == 0) continue;
                    sector2.setSpaNuc(sector2.getSpaDiscountRate() * sector2.getSrpNuc() + sector2.getProratedClassDiff());
                    sector2.setProratedClassDiff(0.0);
                    continue;
                }
                sector2.setProrationType(sector2.getProrationType() | 1);
            }
        } else {
            for (i = 0; i < fcomp.getSectors().length; ++i) {
                sector = fcomp.getSectors()[i];
                sector.setFixedFareCheck(fcomp.getSectors()[0].getFixedFareCheck());
                sector.setFixedFareDiscount(fcomp.getSectors()[0].getFixedFareDiscount());
                sector.setProrationType(sector.getProrationType() & 0xFFFFFEFF);
                if ((sector.getProrationType() & 0x1000000) != 0) {
                    if ((sector.getProrationType() & 0x40000) != 0 || (sector.getProrationType() & 0x80000) != 0) {
                        sector.setSpaNuc(sector.getSpaDiscountRate() * sector.getSrpNuc() + sector.getProratedClassDiff());
                        sector.setProratedClassDiff(0.0);
                    }
                } else {
                    sector.setProrationType(sector.getProrationType() & 0xFDFFFFFF);
                    sector.setProrationType(sector.getProrationType() | 1);
                }
                sector.setNpPvalues(sector.getSrpNuc());
            }
        }
        for (int i3 = 0; i3 < fcomp.getSectors().length; ++i3) {
            sector = fcomp.getSectors()[i3];
            if ((sector.getProrationType() & 0x10000000) != 0) {
                if ((sector.getProrationType() & 0x1000000) != 0) {
                    sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
                    if ((sector.getProrationType() & 0x100) != 0) {
                        if (sector.getSpaNuc() >= sector.getNpPvalues() + sector.getNpClassDiff()) {
                            sector.setProrationType(sector.getProrationType() & 0xFDFFFFFF);
                            sector.setProrationType(sector.getProrationType() & 0xFFFFFFFE);
                            sector.setProrationType(sector.getProrationType() | 0x1000000);
                            sector.setProratedClassDiff(0.0);
                        } else {
                            sector.setProrationType(sector.getProrationType() & 0xFEFFFFFF);
                            sector.setProrationType(sector.getProrationType() | 0x2000000);
                            sector.setProratedClassDiff(sector.getNpClassDiff());
                        }
                    } else if (sector.getSpaNuc() >= sector.getNpPvalues() + sector.getNpClassDiff()) {
                        sector.setProrationType(sector.getProrationType() & 0xFDFFFFFF);
                        sector.setProrationType(sector.getProrationType() & 0xFFFFFFFE);
                        sector.setProrationType(sector.getProrationType() | 0x1000000);
                        sector.setProratedClassDiff(0.0);
                    } else {
                        sector.setProrationType(sector.getProrationType() & 0xFEFFFFFF);
                        sector.setProrationType(sector.getProrationType() | 1);
                        sector.setProratedClassDiff(sector.getNpClassDiff());
                    }
                } else {
                    sector.setProrationType(sector.getProrationType() & 0xEFFFFFFF);
                }
            } else if ((sector.getProrationType() & 0x20000000) != 0) {
                if ((sector.getProrationType() & 0x1000000) != 0) {
                    sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
                    if ((sector.getProrationType() & 0x100) != 0) {
                        if (sector.getSpaNuc() <= sector.getNpPvalues() + sector.getNpClassDiff()) {
                            sector.setProrationType(sector.getProrationType() & 0xFDFFFFFF);
                            sector.setProrationType(sector.getProrationType() & 0xFFFFFFFE);
                            sector.setProrationType(sector.getProrationType() | 0x1000000);
                            sector.setProratedClassDiff(0.0);
                        } else {
                            sector.setProrationType(sector.getProrationType() & 0xFEFFFFFF);
                            sector.setProrationType(sector.getProrationType() | 0x2000000);
                            sector.setProratedClassDiff(sector.getNpClassDiff());
                        }
                    } else if (sector.getSpaNuc() <= sector.getNpPvalues() + sector.getNpClassDiff()) {
                        sector.setProrationType(sector.getProrationType() & 0xFDFFFFFF);
                        sector.setProrationType(sector.getProrationType() & 0xFFFFFFFE);
                        sector.setProrationType(sector.getProrationType() | 0x1000000);
                        sector.setProratedClassDiff(0.0);
                    } else {
                        sector.setProrationType(sector.getProrationType() & 0xFEFFFFFF);
                        sector.setProrationType(sector.getProrationType() | 1);
                        sector.setProratedClassDiff(sector.getNpClassDiff());
                    }
                } else {
                    sector.setProrationType(sector.getProrationType() & 0xDFFFFFFF);
                }
            } else if ((sector.getProrationType() & 0x40000000) != 0) {
                sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
                sector.setProratedClassDiff(0.0);
                if (sector.getSpaNuc() < sector.getFixValue()) {
                    sector.setSpaNuc(sector.getFixValue());
                }
            } else if ((sector.getProrationType() & Integer.MIN_VALUE) != 0) {
                sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
                sector.setProratedClassDiff(0.0);
                if (sector.getSpaNuc() > sector.getFixValue()) {
                    sector.setSpaNuc(sector.getFixValue());
                }
            }
            if ((sector.getProrationType() & 0x1000000) != 0) {
                sector.setSpaNuc(sector.getSpaNuc() + sector.getProratedClassDiff());
                sector.setProratedClassDiff(0.0);
                sector.setProrateValue(sector.getSpaNuc() + sector.getProratedClassDiff() + sector.getProratedSecureCharge());
            }
            if ((sector.getProrationType() & 0x2000000) != 0) {
                sector.setProrateValue(sector.getApdpNuc() + sector.getProratedClassDiff() + sector.getProratedSecureCharge());
            }
            if ((sector.getProrationType() & 1) != 0) {
                sector.setProrateValue(sector.getSrpNuc() + sector.getProratedClassDiff() + sector.getProratedSecureCharge());
            }
            this.getAuditImpl().trace.traceValue(fcomp, i3);
        }
        return true;
    }

    boolean checkFixedFare(ProrateFareComponent fcomp, double valueRest, double totalProrateFactor) {
        ProrateSector sector = fcomp.getSectors()[0];
        if (totalProrateFactor == 0.0) {
            if (valueRest >= 0.0) {
                sector.setFixedFareCheck(0.0);
                this.getAuditImpl().trace.traceFixedFareCheck(true, fcomp);
                return true;
            }
            sector.setFixedFareCheck(-1.0);
            this.getAuditImpl().trace.traceFixedFareCheck(false, fcomp);
            return false;
        }
        sector.setFixedFareCheck(valueRest / totalProrateFactor * 100.0);
        sector.setFixedFareDiscount(fcomp.getFixedFareDiscount());
        if (sector.getFixedFareCheck() >= fcomp.getAudit().getFixedFare() * fcomp.getFixedFareDiscount()) {
            this.getAuditImpl().trace.traceFixedFareCheck(true, fcomp);
            return true;
        }
        this.getAuditImpl().trace.traceFixedFareCheck(false, fcomp);
        return false;
    }

    boolean prorateClassDiff(ProrateFareComponent fcomp) {
        int i;
        int i2 = 1;
        while (true) {
            ProrateSector sector;
            int j;
            double totalProrateFactor = 0.0;
            double totalClassDiff = 0.0;
            boolean found = false;
            for (j = 0; j < fcomp.getSectors().length; ++j) {
                sector = fcomp.getSectors()[j];
                if (sector.getClassDiffIndex() == i2) {
                    found = true;
                    totalProrateFactor += sector.getProrateFactor();
                    totalClassDiff += sector.getClassDiffPlus();
                    continue;
                }
                if (sector.getClassDiffIndex() <= i2) continue;
                found = true;
            }
            if (!found) break;
            if (totalProrateFactor != 0.0 && totalClassDiff != 0.0) {
                totalClassDiff *= fcomp.getAudit().getAmountRatio() * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate();
                for (j = 0; j < fcomp.getSectors().length; ++j) {
                    sector = fcomp.getSectors()[j];
                    if (sector.getClassDiffIndex() != i2) continue;
                    sector.setProratedClassDiff(totalClassDiff * sector.getProrateFactor() / totalProrateFactor);
                    sector.setNpClassDiff(sector.getProratedClassDiff());
                }
            }
            ++i2;
        }
        double totalProrateFactor = 0.0;
        double totalClassDiff = 0.0;
        for (i = 0; i < fcomp.getSectors().length; ++i) {
            ProrateSector sector = fcomp.getSectors()[i];
            if ((sector.getProrationType() & 0x1000000) != 0) {
                if ((sector.getProrationType() & 0x80000) != 0 || (sector.getProrationType() & 0x40000) != 0) {
                    totalClassDiff += sector.getProratedClassDiff();
                    sector.setProratedClassDiff(sector.getProratedClassDiff() * sector.getSpaDiscountRate());
                    totalClassDiff -= sector.getProratedClassDiff();
                    continue;
                }
                totalClassDiff += sector.getProratedClassDiff();
                sector.setProratedClassDiff(0.0);
                continue;
            }
            if ((!sector.getCarrier().equals(fcomp.getAudit().getAirwayId()) || !sector.getOpCarrier().equals("")) && !sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) continue;
            totalProrateFactor += sector.getProrateFactor();
        }
        for (i = 0; i < fcomp.getSectors().length; ++i) {
            ProrateSector sector = fcomp.getSectors()[i];
            if ((sector.getProrationType() & 0x1000000) != 0 || (!sector.getCarrier().equals(fcomp.getAudit().getAirwayId()) || !sector.getOpCarrier().equals("")) && !sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) continue;
            double value = totalClassDiff * sector.getProrateFactor() / totalProrateFactor;
            sector.setProratedClassDiff(sector.getProratedClassDiff() + value);
            sector.setNpClassDiff(sector.getProratedClassDiff());
        }
        return true;
    }

    boolean prorateSecureCharge(ProrateFareComponent fcomp) {
        int i = 1;
        while (true) {
            ProrateSector sector;
            int j;
            double totalProrateFactor = 0.0;
            double totalSecureCharge = 0.0;
            boolean found = false;
            for (j = 0; j < fcomp.getSectors().length; ++j) {
                sector = fcomp.getSectors()[j];
                if (sector.getSecureIndex() == i) {
                    found = true;
                    totalProrateFactor += sector.getProrateFactor();
                    totalSecureCharge += sector.getSecureCharge();
                    continue;
                }
                if (sector.getSecureIndex() <= i) continue;
                found = true;
            }
            if (!found) break;
            if (totalProrateFactor != 0.0 && totalSecureCharge != 0.0) {
                totalSecureCharge *= fcomp.getAudit().getAmountRatio() * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate();
                for (j = 0; j < fcomp.getSectors().length; ++j) {
                    sector = fcomp.getSectors()[j];
                    if (sector.getSecureIndex() != i) continue;
                    sector.setProratedSecureCharge(totalSecureCharge * sector.getProrateFactor() / totalProrateFactor);
                }
            }
            ++i;
        }
        return true;
    }

    boolean prorateRest(ProrateFareComponent fcomp) {
        double totalProrateValue = 0.0;
        double totalSecurityCharge = 0.0;
        double totalClassDiff = 0.0;
        for (int i = 0; i < fcomp.getSectors().length; ++i) {
            ProrateSector sector = fcomp.getSectors()[i];
            if (sector.getCarrier().equals(fcomp.getAudit().getAirwayId()) && sector.getOpCarrier().equals("") || sector.getOpCarrier().equals(fcomp.getAudit().getAirwayId())) {
                return true;
            }
            totalProrateValue += sector.getProrateValue();
            totalSecurityCharge += sector.getSecureCharge();
            totalClassDiff += sector.getClassDiffPlus();
        }
        double valueRest = fcomp.getValue() + (totalSecurityCharge *= fcomp.getAudit().getAmountRatio() * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate()) + (totalClassDiff *= fcomp.getAudit().getAmountRatio() * fcomp.getAudit().getRoeRate() / fcomp.getAudit().getDay5Rate()) - totalProrateValue;
        if (valueRest != 0.0) {
            String sspa;
            ProrateSector sector;
            int i;
            boolean found = false;
            double totalProrateFactor = 0.0;
            for (i = 0; i < fcomp.getSectors().length; ++i) {
                sector = fcomp.getSectors()[i];
                sspa = this.getAuditImpl().database.codeShareSpa(sector.getCarrier(), sector.getFlightNo(), sector.getFlightDate());
                if (sspa.equals("") && this.getAuditImpl().database.getResult() > 1) {
                    this.getAuditImpl().DBError(sector, "codeShareSpa", sector.getCarrier(), sector.getFlightNo());
                    return false;
                }
                if (sspa.equals("")) continue;
                totalProrateFactor += sector.getProrateFactor();
                found = true;
            }
            if (!found) {
                return true;
            }
            for (i = 0; i < fcomp.getSectors().length; ++i) {
                sector = fcomp.getSectors()[i];
                sspa = this.getAuditImpl().database.codeShareSpa(sector.getCarrier(), sector.getFlightNo(), sector.getFlightDate());
                if (sspa.equals("") && this.getAuditImpl().database.getResult() > 1) {
                    this.getAuditImpl().DBError(sector, "codeShareSpa", sector.getCarrier(), sector.getFlightNo());
                    return false;
                }
                if (sspa.equals("")) continue;
                sector.setProrateValue(sector.getProrateValue() + valueRest * sector.getProrateFactor() / totalProrateFactor);
                this.getAuditImpl().trace.traceRest(fcomp, valueRest, totalProrateFactor, i);
            }
        }
        return true;
    }

    public ProrateAuditImpl getAuditImpl() {
        return this.auditImpl;
    }

    public void setAuditImpl(ProrateAuditImpl auditImpl) {
        this.auditImpl = auditImpl;
    }
}

