/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncGateway
extends ProrateFunc {
    ProrateFuncGateway(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(1, "Gateway", runtime)) {
            return null;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject pobj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (pobj == null) {
            this.setErrorObject();
            return null;
        }
        if (pobj.isMultival()) {
            List values = ((ProrateRuleMultival)pobj).getValues();
            for (int i = 0; i < values.size(); ++i) {
                ProrateRuleObject pobj2 = ((ProrateRuleObject)values.get(i)).copy(runtime);
                values.set(i, pobj2.copy(runtime));
                ProrateRuleObject subobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
                if (subobj == null) {
                    this.setErrorObject();
                    return null;
                }
                if (!subobj.isString()) {
                    this.error(2, "Gateway:1", runtime);
                    return null;
                }
                if (!this.gateway(subobj, runtime)) continue;
                this.setEvaluatedObject(new ProrateRuleBool(true));
                return this.evaluatedObject;
            }
            this.setEvaluatedObject(new ProrateRuleBool(false));
            return this.evaluatedObject;
        }
        if (!pobj.isString()) {
            this.error(2, "Gateway:1", runtime);
            return null;
        }
        ProrateRuleBool ret = new ProrateRuleBool(this.gateway(pobj, runtime));
        this.setEvaluatedObject(ret);
        return ret;
    }

    boolean gateway(ProrateRuleObject pobj, ProrateRuntime runtime) {
        String objPort = ((ProrateRuleString)pobj).getValue();
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            ProrateSector sector = runtime.fcomp.getSectors()[i];
            String fromArea = this.getAreaName(runtime, sector.getDepCode());
            fromArea = fromArea.substring(0, 3);
            String toArea = this.getAreaName(runtime, sector.getDestCode());
            if (fromArea.equals(toArea = toArea.substring(0, 3)) || !sector.getDepCode().equals(objPort) && !sector.getDestCode().equals(objPort)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncGateway pobj = new ProrateFuncGateway(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Gateway(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Gateway";
    }
}

