/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRule;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuleTop;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateVarAuto;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncRule
extends ProrateFunc
implements ProrateRule {
    protected String carrier;
    protected String tkCarrier;
    protected boolean isSPA;
    protected List rules;
    protected boolean skipToActions = true;
    protected List autoVars;

    ProrateFuncRule(boolean isSPA, String carrier, String tkCarrier) {
        super(new Vector());
        this.carrier = carrier;
        this.tkCarrier = tkCarrier;
        this.isSPA = isSPA;
        this.rules = null;
        this.setAutoVars(new Vector());
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (runtime.appliedRules.size() > 3) {
            String str = null;
            if (this.isSPA) {
                str = "Apply_SPA(";
                str = str + this.carrier;
                str = str + ",";
                str = str + this.tkCarrier;
                str = str + ")";
            } else {
                str = str + "Apply_APDP(";
                str = str + this.carrier;
                str = str + ")";
            }
            str = str + ": call stack overflow";
            this.error(8, str, runtime);
            return null;
        }
        String key = this.carrier;
        if (this.tkCarrier != null) {
            key = key + this.tkCarrier;
        }
        for (int i = 0; i < runtime.appliedRules.size(); ++i) {
            if (!((String)runtime.appliedRules.get(i)).equals(key)) continue;
            String str = null;
            if (this.isSPA) {
                str = "Apply_SPA(";
                str = str + this.carrier;
                str = str + ",";
                str = str + this.tkCarrier;
                str = str + ")";
            } else {
                str = str + "Apply_APDP(";
                str = str + this.carrier;
                str = str + ")";
            }
            str = str + ": call loops";
            this.error(8, str, runtime);
            return null;
        }
        runtime.appliedRules.add(key);
        this.rules = runtime.getAuditImpl().rulebase.read(this.isSPA, this.carrier, this.tkCarrier, runtime.audit.getIssueDate(), this.skipToActions);
        if (this.rules == null || this.rules.size() == 0) {
            this.setErrorObject(8, "error in loading SPA rule " + this.carrier + "/" + this.tkCarrier + " for " + runtime.audit.getIssueDate());
            return this.evaluatedObject;
        }
        ProrateRuleTop funcCode = new ProrateRuleTop(this.rules);
        ProrateRule funcRule = funcCode.copy(runtime);
        ProrateRule scope = runtime.rule;
        if (this.isSPA) {
            runtime.setSPA(runtime.audit, runtime.fcomp, runtime.sector, funcRule);
        } else {
            runtime.setAPDP(runtime.audit, runtime.fcomp, runtime.sector, funcRule);
        }
        runtime.eval();
        runtime.getAuditImpl().trace.trace(runtime, this.isSPA ? "SPA" : "APDP", this.carrier, this.tkCarrier);
        runtime.getAuditImpl().trace.trace(funcRule, runtime.sector, 1);
        runtime.rule = scope;
        runtime.getAuditImpl().rulebase.close();
        if (!runtime.apply) {
            this.setEvaluatedObject(new ProrateRuleBool(false));
        } else {
            this.setEvaluatedObject(new ProrateRuleBool(true));
        }
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncRule pobj = new ProrateFuncRule(this.isSPA, this.carrier, this.tkCarrier);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public List getAutoVars() {
        return this.autoVars;
    }

    @Override
    public void setAutoVars(List vector) {
        this.autoVars = vector;
    }

    @Override
    public ProrateRuleObject getAutoVar(String name) {
        ProrateRuleObject pobj = null;
        for (int i = 0; i < this.autoVars.size() && !((ProrateVarAuto)(pobj = (ProrateRuleObject)this.autoVars.get(i))).getName().equals(name); ++i) {
        }
        if (pobj != null && ((ProrateVarAuto)pobj).getName().equals(name)) {
            return pobj;
        }
        return null;
    }

    @Override
    public void addAutoVar(ProrateRuleObject pobj) {
        this.autoVars.add(pobj);
    }

    @Override
    public void dump() {
        System.out.print("RULE[" + (this.isSPA ? "SPA" : "APDP") + ":" + this.carrier + ":" + this.tkCarrier + " ](");
        super.dump();
    }

    @Override
    public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer();
        if (this.evaluatedObject != null && this.evaluatedObject != this) {
            traceStr.append(this.evaluatedObject.traceStr());
            traceStr.append("<-");
        }
        traceStr.append(this.traceStr());
        trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        for (int i = 0; i < this.rules.size(); ++i) {
            if (trace.trace((ProrateRuleObject)this.rules.get(i), sector, level + 1)) continue;
            return false;
        }
        return this.traceValue(sector, trace, level + 1);
    }

    @Override
    public String operatorString() {
        StringBuffer strbuf = new StringBuffer("RULE[");
        strbuf.append(this.isSPA ? "SPA" : "APDP");
        strbuf.append(":");
        strbuf.append(this.carrier);
        strbuf.append(":");
        strbuf.append(this.tkCarrier);
        strbuf.append("]");
        return strbuf.toString();
    }

    public boolean isSkipToActions() {
        return this.skipToActions;
    }

    public void setSkipToActions(boolean skipToActions) {
        this.skipToActions = skipToActions;
    }
}

