/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateFuncRule;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateFuncSia
extends ProrateFunc {
    public static final String SIA_TKCARRIER = "ZZ";

    ProrateFuncSia(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(0, "Sia", runtime)) {
            return null;
        }
        if (runtime.isSPA) {
            ProrateDatabase db = runtime.getAuditImpl().database;
            ProrateSector sector = runtime.sector;
            if (!db.checkSia(sector.getCarrier(), sector.getFlightNo(), sector.getFlightDate())) {
                this.setEvaluatedObject(new ProrateRuleBool(false));
                return this.evaluatedObject;
            }
            ProrateFuncRule siaRule = new ProrateFuncRule(true, SIA_TKCARRIER, runtime.audit.getAirwayId());
            siaRule.setSkipToActions(false);
            ProrateRuleObject pobj = ((ProrateRuleObject)siaRule).eval(runtime);
            if (pobj == null) {
                return null;
            }
            if (pobj.isError()) {
                return pobj;
            }
            if ((sector.getProrationType() & 0x1000000) != 0) {
                sector.setProrationType(sector.getProrationType() | 0x4000000);
                this.setEvaluatedObject(new ProrateRuleBool(true));
                return this.evaluatedObject;
            }
            this.setEvaluatedObject(new ProrateRuleBool(false));
            return this.evaluatedObject;
        }
        this.setEvaluatedObject(new ProrateRuleBool(false));
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateFuncSia pobj = new ProrateFuncSia(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Sia(");
        super.dump();
    }

    @Override
    public String operatorString() {
        return "Sia";
    }
}

