/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleCase;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateVarMultiPath;
import jp.sourceforge.gnp.prorate.export.ProrateSector;

class ProrateRuleCaseBranch
extends ProrateRuleObject {
    protected List values;

    ProrateRuleCaseBranch(List in_values) {
        this.values = in_values;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) {
        return this;
    }

    ProrateRuleObject eval(ProrateRuntime runtime, ProrateRuleCase ocase) throws Exception {
        int i;
        ProrateRuleObject ret = null;
        boolean forUnification = false;
        boolean status = true;
        if (ocase.unification()) {
            forUnification = true;
        }
        for (i = 0; i < this.values.size(); ++i) {
            if (!((ProrateRuleObject)this.values.get(i)).unification()) continue;
            forUnification = true;
            break;
        }
        if (forUnification) {
            ret = this.unify(runtime, ocase);
        } else {
            for (i = 0; i < this.values.size(); ++i) {
                ProrateRuleObject pobj = (ProrateRuleObject)this.values.get(i);
                this.values.set(i, pobj.copy(runtime));
                ProrateRuleObject car = ((ProrateRuleObject)this.values.get(i)).eval(runtime);
                if (car == null) {
                    this.setErrorObject();
                    return null;
                }
                ProrateRuleObject cdr = ocase.getArgEvaluated(i);
                if (cdr == null) {
                    this.setErrorObject();
                    return null;
                }
                if (car.isMultiPath()) {
                    car = ((ProrateVarMultiPath)car).makePath(runtime, cdr);
                } else if (cdr.isMultiPath()) {
                    cdr = ((ProrateVarMultiPath)cdr).makePath(runtime, car);
                }
                status = car.equal(cdr);
                if (status) break;
            }
            ret = new ProrateRuleBool(status);
            this.setEvaluatedObject(ret);
        }
        return ret;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRuleCaseBranch pobj = new ProrateRuleCaseBranch(new Vector(this.values));
        pobj.isCopied = true;
        return pobj;
    }

    ProrateRuleObject unify(ProrateRuntime runtime, ProrateRuleCase ocase) throws Exception {
        ProrateRuleObject ret = null;
        boolean status = true;
        for (int i = 0; i < runtime.fcomp.getSectors().length; ++i) {
            runtime.unifiedSector = runtime.fcomp.getSectors()[i];
            for (int j = 0; j < this.values.size(); ++j) {
                ProrateRuleObject pobj = (ProrateRuleObject)this.values.get(j);
                this.values.set(j, pobj.copy(runtime));
                ret = ((ProrateRuleObject)this.values.get(j)).eval(runtime);
                if (ret == null) {
                    this.setErrorObject();
                    return null;
                }
                status = ret.equal(ocase.evalArg(j, runtime));
                if (!status) break;
            }
            if (status) break;
        }
        ret = new ProrateRuleBool(status);
        this.setEvaluatedObject(ret);
        return ret;
    }

    @Override
    public void dump() {
        System.out.print("CASE_BRANCH(");
        for (int i = 0; i < this.values.size(); ++i) {
            ((ProrateRuleObject)this.values.get(i)).dump();
            System.out.print(" ");
        }
        System.out.println(")");
    }

    @Override
    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        StringBuffer traceStr = new StringBuffer();
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                traceStr.append("@");
            }
            ProrateRuleObject pobj = (ProrateRuleObject)this.values.get(i);
            traceStr.append(pobj.traceStr());
            if (traceStr.charAt(traceStr.length() - 1) != '(') continue;
            traceStr.append(")");
        }
        traceStr.append(":");
        traceStr.append(this.evaluatedObject.isTrue() ? "(true)" : "(false)");
        trace.trace(traceStr.toString(), sector.getSequenceNo(), level);
        for (int j = 0; j < this.values.size(); ++j) {
            trace.trace((ProrateRuleObject)this.values.get(j), sector, level + 1);
        }
        return true;
    }
}

