/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateRuleError;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElement;

public abstract class ProrateRuleObject
implements ProrateRulebaseElement {
    static final int FBT_NORMAL_FARE = 1;
    static final int FBT_DISCOUNT_FARE = 2;
    static final int FBT_PROMOTIONAL_FARE = 4;
    static final int FBT_ILLEGAL_FARE = 16;
    static Object[] normal_code = null;
    static Object[] special_code = null;
    static Object[] discount_code = null;
    static Object[] IDCHIN_code = null;
    public static String F_classes = null;
    public static String C_classes = null;
    public static String Y_classes = null;
    static Map codeConversionMap;
    public boolean isCopied;
    ProrateRuleObject evaluatedObject;

    static void classInitialize(ProrateDatabase database) {
        normal_code = database.getNormalCodes();
        special_code = database.getSpecialCodes();
        discount_code = database.getDiscountCodes();
        IDCHIN_code = database.getIDCHINCodes();
        F_classes = database.getFClasses();
        C_classes = database.getCClasses();
        Y_classes = database.getYClasses();
    }

    static void codeConversionInitialize() {
        String[] code1 = new String[]{"A", "F", "P", "R", "C", "I", "J", "Z", "D", "B", "E", "G", "H", "K", "L", "M", "N", "Q", "S", "T", "U", "V", "W", "X", "Y"};
        String[] code2 = new String[]{"FCY", "FCY", "FCY", "FCY", "CY", "CY", "CY", "CY", "CY", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y", "Y"};
        codeConversionMap = new HashMap();
        for (int i = 0; i < code1.length; ++i) {
            codeConversionMap.put(code1[i], code2[i]);
        }
    }

    public abstract ProrateRuleObject eval(ProrateRuntime var1) throws Exception;

    public abstract ProrateRuleObject copy(ProrateRuntime var1);

    public abstract void dump();

    ProrateRuleObject() {
    }

    @Override
    public short getRegist() {
        return 0;
    }

    @Override
    public String getName() {
        return "";
    }

    public void writeModel(ProrateRulebase rulebase) {
    }

    void dumpValue() {
        if (this.evaluatedObject != null && this.evaluatedObject != this) {
            this.evaluatedObject.dumpValue();
        }
    }

    boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        if (!this.isEvaluated()) {
            return false;
        }
        return trace.trace(this.traceStr(), sector.getSequenceNo(), level);
    }

    boolean traceValue(ProrateSector sector, ProrateTrace trace, int level) {
        if (this.evaluatedObject != null && this.evaluatedObject != this) {
            trace.trace(this.evaluatedObject, sector, level);
        }
        return true;
    }

    String traceStr() {
        return "";
    }

    String traceValueStr() {
        if (this.evaluatedObject != null && this.evaluatedObject != this) {
            return "(" + this.evaluatedObject.traceStr() + ")";
        }
        return "";
    }

    boolean isEvaluated() {
        return this.evaluatedObject != null;
    }

    void setEvaluatedObject(ProrateRuleObject pobj) {
        if (this.isCopied) {
            pobj.isCopied = this.isCopied;
        }
        this.evaluatedObject = pobj;
    }

    void setErrorObject(int error_flag, String error_string) {
        this.setEvaluatedObject(new ProrateRuleError(error_flag, error_string));
    }

    void setErrorObject() {
        this.setEvaluatedObject(new ProrateRuleError());
    }

    boolean isTrue() {
        return false;
    }

    boolean isFalse() {
        return false;
    }

    boolean isMultival() {
        return false;
    }

    boolean isInterval() {
        return false;
    }

    boolean isNumber() {
        return false;
    }

    boolean isDate() {
        return false;
    }

    boolean isString() {
        return false;
    }

    boolean isAmount() {
        return false;
    }

    boolean isPath() {
        return false;
    }

    boolean isMultiPath() {
        return false;
    }

    boolean unification() {
        return false;
    }

    boolean isError() {
        return false;
    }

    boolean equal(ProrateRuleObject other) {
        return false;
    }

    boolean gtEq(ProrateRuleObject other) {
        return false;
    }

    boolean ltEq(ProrateRuleObject other) {
        return false;
    }

    boolean include(ProrateRuleObject other) {
        return false;
    }

    boolean isIncluded(ProrateRuleObject other) {
        return false;
    }

    ProrateRuleObject set(ProrateRuleObject value, ProrateRuntime runtime) {
        this.error(2, "SET:1", runtime);
        return value;
    }

    int identifyFare(String fareBasis) {
        char c;
        String f_basis = fareBasis;
        int index = fareBasis.indexOf("//");
        if (index > 0) {
            f_basis = fareBasis.substring(0, index);
        }
        if (f_basis.length() == 1) {
            return 1;
        }
        StringBuffer f_strip = new StringBuffer();
        for (int i = 0; i < f_basis.length(); ++i) {
            char c2 = f_basis.charAt(i);
            if (!Character.isDigit(c2) && !Character.isLowerCase(c2) && !Character.isUpperCase(c2)) continue;
            f_strip.append(c2);
        }
        String f_basis_strip = f_strip.toString();
        int skip = 0;
        for (int i = 0; i < normal_code.length; ++i) {
            String code = (String)normal_code[i];
            if (f_basis_strip.length() < code.length() || !f_basis_strip.substring(0, code.length()).equals(code)) continue;
            for (int j = 0; j < code.length(); ++j) {
                c = f_basis.charAt(skip);
                while (!(Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c))) {
                    c = f_basis.charAt(++skip);
                }
                ++skip;
            }
            break;
        }
        String string = f_basis = skip > 0 ? f_basis.substring(skip) : f_basis.substring(1);
        if (f_basis.equals("")) {
            return 1;
        }
        boolean special_p = false;
        boolean section_special_p = false;
        boolean normal_p = false;
        while (f_basis.length() <= 0) {
            String code;
            int i;
            index = 0;
            c = f_basis.charAt(index);
            while (!(Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c))) {
                if (index >= f_basis.length()) {
                    if (special_p) {
                        return 2;
                    }
                    return 1;
                }
                c = f_basis.charAt(++index);
            }
            f_basis = f_basis.substring(index);
            for (i = 0; i < discount_code.length; ++i) {
                code = (String)discount_code[i];
                if (f_basis.length() < code.length() || !f_basis.substring(0, code.length()).equals(code)) continue;
                normal_p = true;
                break;
            }
            for (i = 0; i < IDCHIN_code.length; ++i) {
                code = (String)discount_code[i];
                if (f_basis.length() < code.length() || !f_basis.substring(0, code.length()).equals(code)) continue;
                normal_p = true;
                break;
            }
            if (!normal_p) {
                for (i = 0; i < special_code.length; ++i) {
                    code = (String)special_code[i];
                    if (f_basis_strip.length() < code.length() || !f_basis.substring(0, code.length()).equals(code)) continue;
                    section_special_p = true;
                    special_p = true;
                    break;
                }
                if (!section_special_p) {
                    return 4;
                }
            }
            skip = -1;
            for (i = 0; i < f_basis.length(); ++i) {
                c = f_basis.charAt(i);
                if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) continue;
                skip = i;
                break;
            }
            f_basis = skip >= 0 ? f_basis.substring(skip) : "";
        }
        return 4;
    }

    String getCountryName(ProrateRuntime runtime, String place) {
        String country = runtime.getAuditImpl().getCountryName(place);
        if (country.equals("")) {
            if (runtime.getAuditImpl().database.getResult() > 1) {
                this.DBError(runtime, "getCountryName", place);
                return country;
            }
            this.errorCat(71, place, runtime);
        }
        return country;
    }

    String getAreaName(ProrateRuntime runtime, String place) {
        String area = runtime.getAuditImpl().getAreaName(place);
        if (area.equals("")) {
            if (runtime.getAuditImpl().database.getResult() > 1) {
                this.DBError(runtime, "getAreaName", place);
                return area;
            }
            this.errorCat(72, place, runtime);
        }
        return area;
    }

    ProrateRuleObject makeMulti(String multiStr) {
        int MULTI_DELIMITOR = 44;
        ProrateRuleString pobj = null;
        if (multiStr.indexOf(MULTI_DELIMITOR) < 0) {
            return new ProrateRuleString(multiStr);
        }
        Vector<ProrateRuleString> values = new Vector<ProrateRuleString>();
        int bi = 0;
        int ei = multiStr.indexOf(MULTI_DELIMITOR);
        while (ei >= 0) {
            pobj = new ProrateRuleString(multiStr.substring(bi, ei - bi));
            values.add(pobj);
            bi = ei + 1;
            ei = multiStr.indexOf(MULTI_DELIMITOR, ei + 1);
        }
        pobj = new ProrateRuleString(multiStr.substring(bi));
        values.add(pobj);
        return new ProrateRuleMultival(values);
    }

    boolean multiEq(String str1, String str2) {
        ProrateRuleObject pobj1 = this.makeMulti(str1);
        ProrateRuleObject pobj2 = this.makeMulti(str2);
        return pobj1.equal(pobj2);
    }

    void error(int errorNo, ProrateRuntime runtime) {
        runtime.getAuditImpl().error(runtime.sector, errorNo);
        runtime.apply = false;
        this.setErrorObject(errorNo, "");
    }

    void error(int errorNo, String errorStr, ProrateRuntime runtime) {
        runtime.getAuditImpl().error(runtime.sector, errorNo, errorStr);
        runtime.apply = false;
        this.setErrorObject(errorNo, errorStr);
    }

    void errorCat(int errorNo, String errorStr, ProrateRuntime runtime) {
        if (runtime.sector.getErrorFlag() == errorNo) {
            if (runtime.sector.getErrorString().equals("")) {
                runtime.getAuditImpl().error(runtime.sector, errorNo, errorStr);
            } else {
                String tmp = runtime.sector.getErrorString() + ":" + errorStr;
                runtime.getAuditImpl().error(runtime.sector, errorNo, tmp);
            }
            runtime.apply = false;
        } else if (runtime.sector.getErrorFlag() == 0) {
            this.error(errorNo, errorStr, runtime);
        }
    }

    void DBError(ProrateRuntime runtime, String pointStr) {
        runtime.getAuditImpl().DBError(runtime.sector, pointStr);
        runtime.apply = false;
        this.setErrorObject(31, pointStr);
    }

    void DBError(ProrateRuntime runtime, String pointStr, String arg) {
        this.DBError(runtime, pointStr + "(" + arg + ")");
    }

    void DBError(ProrateRuntime runtime, String pointStr, String arg, String arg2) {
        this.DBError(runtime, pointStr + "(" + arg + "," + arg2 + ")");
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public void setComment(String comment) {
    }
}

