/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRulePart;
import jp.sourceforge.gnp.prorate.ProrateRuntime;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;

class ProrateRulePartcall
extends ProrateRuleObject {
    protected String name;

    ProrateRulePartcall(String partname) {
        this.name = partname;
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        try {
            if (!runtime.getAuditImpl().rulebase.selectPART(this.name)) {
                String str = this.name + " : undefined PART";
                this.error(8, str, runtime);
                return null;
            }
        }
        catch (ProrateRulebaseException e) {
            String str = "rulebase error in selecting PART " + this.name;
            this.error(8, str, runtime);
            return null;
        }
        List rules = null;
        try {
            rules = runtime.getAuditImpl().rulebase.read();
        }
        catch (ProrateRulebaseException e) {
            String str = "rulebase error in reading PART " + this.name;
            this.error(8, str, runtime);
            return null;
        }
        ProrateRulePart code = new ProrateRulePart(this.name, rules);
        ProrateRuleObject pobj = ((ProrateRuleObject)code).copy(runtime);
        ProrateRuleObject ret = pobj.eval(runtime);
        if (!runtime.apply) {
            if (ret == null) {
                this.setErrorObject();
            } else {
                this.setEvaluatedObject(ret);
            }
        } else {
            this.setEvaluatedObject(ret);
        }
        runtime.getAuditImpl().rulebase.close();
        pobj = null;
        code = null;
        return this.evaluatedObject;
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateRulePartcall pobj = new ProrateRulePartcall(this.name);
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print(this.toString());
    }

    public String toString() {
        return "Partcall " + this.name;
    }

    @Override
    public boolean trace(ProrateSector sector, ProrateTrace trace, int level) {
        trace.trace(this.traceStr(), sector.getSequenceNo(), level);
        return this.evaluatedObject.trace(sector, trace, level + 1);
    }

    @Override
    String traceStr() {
        return this.toString();
    }
}

