/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.io.Serializable;
import jp.sourceforge.gnp.prorate.ProrateAuditImpl;
import jp.sourceforge.gnp.prorate.ProrateTax;
import jp.sourceforge.gnp.prorate.database.ProrateTaxTable;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;

public class ProrateTaxImpl
implements ProrateTax,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int ABORT = -1;
    static final int NO_HITS = 1;
    static final int ALL_HITS = 2;
    static final int FIRST_HIT = 4;
    static final int OK = 0;
    ProrateAudit audit;
    ProrateAuditImpl engine;
    boolean informError;

    @Override
    public boolean divide(ProrateAudit audit) {
        this.audit = audit;
        if (audit.getTax() == null) {
            return true;
        }
        this.informError = true;
        if (audit.getErrorFlag() != 0) {
            this.informError = false;
        }
        if (this.informError) {
            for (int i = 0; i < audit.getSectors().length; ++i) {
                ProrateSector sector = audit.getSectors()[i];
                if (sector.getErrorFlag() == 0) continue;
                this.informError = false;
            }
        }
        if (!audit.isOwnAudit() && !audit.isInward()) {
            return false;
        }
        if (audit.getSectors().length == 0) {
            return false;
        }
        boolean taxDivided = false;
        for (int i = 0; i < audit.getSectors().length; ++i) {
            ProrateSector sector = audit.getSectors()[i];
            if (sector.getTax() > 0.0) {
                return true;
            }
            if (sector.getTaxIndex() <= 0) continue;
            taxDivided = true;
        }
        if (!taxDivided) {
            ProrateTaxData tax;
            int i;
            double totalTax3 = 0.0;
            for (int i2 = 0; i2 < audit.getTax().length; ++i2) {
                ProrateTaxData tax2 = audit.getTax()[i2];
                totalTax3 += tax2.getAmount();
            }
            double totalTax10 = 0.0;
            for (i = 0; i < audit.getTaxMisc().length; ++i) {
                tax = audit.getTaxMisc()[i];
                totalTax10 += tax.getAmount();
            }
            for (i = 0; i < audit.getTaxMisc().length; ++i) {
                String type;
                tax = audit.getTaxMisc()[i];
                if (tax.getAmount() == 0.0 || (type = tax.getType()).length() > 2 && type.substring(0, 2).equals("XF") || type.length() < 2) continue;
                int ret = 1;
                ProrateTaxTable taxTable = this.getEngine().database.getTaxTable(type.substring(0, 2), audit.getIssueDate());
                if (taxTable == null) {
                    if (this.getEngine().database.getResult() > 1) {
                        if (this.informError) {
                            this.getEngine().DBError(null, "getTaxTable", type.substring(0, 2), audit.getIssueDate());
                        }
                        return false;
                    }
                    if (!this.informError) continue;
                    this.getEngine().error(52, type.substring(0, 2));
                    continue;
                }
                for (int j = 0; j < 3 && j < taxTable.id.length && taxTable.id[j] > 0; ++j) {
                    for (int k = 0; k < audit.getSectors().length; ++k) {
                        int retval = 1;
                        ProrateSector sector = audit.getSectors()[k];
                        boolean isStpo = sector.getStopOver() != 0 && sector.getStopOver() != 32 && sector.getStopOver() != 48;
                        retval = this.checkDivide(taxTable, i, j, type.equals("UH") || type.equals("TH") ? sector.getDepAirport() : sector.getDepCode(), type.equals("UH") || type.equals("TH") ? sector.getDestAirport() : sector.getDestCode(), isStpo, k);
                        if (retval != 1) {
                            ret = retval;
                        }
                        if (ret == -1) {
                            return false;
                        }
                        if (ret == 4) break;
                    }
                    if (ret != 1) break;
                }
                if (ret == 1) {
                    ret = this.checkNotApplicable(i);
                }
                if (ret != -1) continue;
                return false;
            }
        }
        if (!audit.isNotDivideTax()) {
            this.doDivide();
        }
        return true;
    }

    int checkDivide(ProrateTaxTable taxTable, int index, int level, String from, String to, boolean isStpo, int sectorIndex) {
        ProrateTaxData tax = this.audit.getTaxMisc()[index];
        if (tax.getType().equals("XY") || tax.getType().equals("XF")) {
            return this.checkDivideXYXF(taxTable, index, level, from, to, isStpo, sectorIndex);
        }
        String fromCountry = this.getEngine().getCountryName(from);
        if (fromCountry.equals("")) {
            if (this.getEngine().database.getResult() > 1) {
                if (this.informError) {
                    this.getEngine().DBError(null, "getCountryName", from);
                }
                return -1;
            }
            if (this.informError) {
                this.getEngine().error(71, from);
            }
            return -1;
        }
        String toCountry = this.getEngine().getCountryName(to);
        if (toCountry.equals("")) {
            if (this.getEngine().database.getResult() > 1) {
                if (this.informError) {
                    this.getEngine().DBError(null, "getCountryName", to);
                }
                return -1;
            }
            if (this.informError) {
                this.getEngine().error(71, to);
            }
            return -1;
        }
        int retval = 1;
        switch (taxTable.id[level]) {
            case 1: {
                retval = this.checkDepFirstIntl(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 2: {
                retval = this.checkDestFirstIntl(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 3: {
                retval = this.checkDepAllIntl(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 4: {
                retval = this.checkDestAllIntl(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 5: {
                retval = this.checkDepFirstIntlNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 6: {
                retval = this.checkDestFirstIntlNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 7: {
                retval = this.checkDepAllIntlNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 8: {
                retval = this.checkDestAllIntlNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 9: {
                retval = this.checkDepDestFirstDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 10: {
                retval = this.checkDepDestAllDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 11: {
                retval = this.checkDepFirstDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 12: {
                retval = this.checkDepAllDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 13: {
                retval = this.checkDestFirstDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 14: {
                retval = this.checkDestAllDomestic(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 15: {
                retval = this.checkDepDestFirstDomesticNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            case 16: {
                retval = this.checkDepDestAllDomesticNoPort(taxTable, index, fromCountry, toCountry, from, to, isStpo, sectorIndex);
                break;
            }
            default: {
                retval = 1;
            }
        }
        return retval;
    }

    int checkDepFirstIntl(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!from.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDestFirstIntl(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!toCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDepAllIntl(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!from.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDestAllIntl(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!toCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDepFirstIntlNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDestFirstIntlNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!toCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDepAllIntlNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDestAllIntlNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!toCountry.equals(taxTable.country) || fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDepDestFirstDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDepDestAllDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDepFirstDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDepAllDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDestFirstDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDestAllDomestic(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        if (taxTable.city.size() > 0) {
            boolean cityMatch = false;
            for (int i = 0; i < taxTable.city.size(); ++i) {
                if (!to.equals(taxTable.city.get(i))) continue;
                cityMatch = true;
                break;
            }
            if (!cityMatch) {
                return 1;
            }
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDepDestFirstDomesticNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 4;
    }

    int checkDepDestAllDomesticNoPort(ProrateTaxTable taxTable, int index, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        if (!fromCountry.equals(taxTable.country) || !fromCountry.equals(toCountry)) {
            return 1;
        }
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        return 2;
    }

    int checkDivideXYXF(ProrateTaxTable taxTable, int index, int level, String from, String to, boolean isStpo, int sectorIndex) {
        String fromCountry = this.getEngine().getCountryName(from);
        if (fromCountry.equals("")) {
            if (this.getEngine().database.getResult() > 1) {
                if (this.informError) {
                    this.getEngine().DBError(null, "getCountryName", from);
                }
                return -1;
            }
            if (this.informError) {
                this.getEngine().error(71, from);
            }
            return -1;
        }
        String toCountry = this.getEngine().getCountryName(to);
        if (toCountry.equals("")) {
            if (this.getEngine().database.getResult() > 1) {
                if (this.informError) {
                    this.getEngine().DBError(null, "getCountryName", to);
                }
                return -1;
            }
            if (this.informError) {
                this.getEngine().error(71, to);
            }
            return -1;
        }
        int retval = 1;
        if (taxTable.id[level] == 98) {
            retval = this.checkXY(taxTable, index, level, fromCountry, toCountry, from, to, isStpo, sectorIndex);
        }
        if (taxTable.id[level] == 99) {
            retval = this.checkXF(taxTable, index, level, fromCountry, toCountry, from, to, isStpo, sectorIndex);
        }
        return retval;
    }

    int checkXY(ProrateTaxTable taxTable, int index, int level, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        ProrateSector sector = this.audit.getSectors()[sectorIndex];
        switch (level) {
            case 0: {
                if (fromCountry.equals(toCountry)) {
                    return 1;
                }
                if (!toCountry.equals("USA")) {
                    return 1;
                }
                sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
                return 4;
            }
            case 1: {
                if (!toCountry.equals(taxTable.country)) {
                    return 1;
                }
                sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
                return 4;
            }
        }
        return 1;
    }

    int checkXF(ProrateTaxTable taxTable, int index, int level, String fromCountry, String toCountry, String from, String to, boolean isStpo, int sectorIndex) {
        ProrateSector sector = this.audit.getSectors()[index];
        switch (level) {
            case 0: {
                if (fromCountry.equals(toCountry)) {
                    return 1;
                }
                if (!fromCountry.equals("USA")) {
                    return 1;
                }
                sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
                return 4;
            }
            case 1: {
                if (!fromCountry.equals(taxTable.country)) {
                    return 1;
                }
                sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
                return 4;
            }
            case 2: {
                if (!fromCountry.equals("USA") || !toCountry.equals("USA")) {
                    return 1;
                }
                sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
                return 4;
            }
        }
        return 1;
    }

    int checkNotApplicable(int index) {
        int foreignIndex = -1;
        int ownIndex = -1;
        for (int i = 0; i < this.audit.getSectors().length; ++i) {
            ProrateSector sector = this.audit.getSectors()[i];
            String fromCountry = this.getEngine().getCountryName(sector.getDepCode());
            if (fromCountry.equals("")) {
                if (this.getEngine().database.getResult() > 1) {
                    if (this.informError) {
                        this.getEngine().DBError(null, "getCountryName", sector.getDepCode());
                    }
                    return -1;
                }
                if (this.informError) {
                    this.getEngine().error(71, sector.getDepCode());
                }
                return -1;
            }
            String toCountry = this.getEngine().getCountryName(sector.getDestCode());
            if (toCountry.equals("")) {
                if (this.getEngine().database.getResult() > 1) {
                    if (this.informError) {
                        this.getEngine().DBError(null, "getCountryName", sector.getDestCode());
                    }
                    return -1;
                }
                if (this.informError) {
                    this.getEngine().error(71, sector.getDestCode());
                }
                return -1;
            }
            if (fromCountry.equals(toCountry)) continue;
            if (foreignIndex < 0) {
                foreignIndex = i;
            }
            if (sector.getCarrier().equals(this.audit.getAirwayId()) && ownIndex < 0) {
                ownIndex = i;
            }
            if (foreignIndex >= 0 && ownIndex >= 0) break;
        }
        if (ownIndex >= 0) {
            ProrateSector sector = this.audit.getSectors()[ownIndex];
            sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        } else if (foreignIndex >= 0) {
            ProrateSector sector = this.audit.getSectors()[foreignIndex];
            sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        } else {
            ProrateSector sector = this.audit.getSectors()[0];
            sector.setTaxIndex(sector.getTaxIndex() | 1 << index);
        }
        return 0;
    }

    void doDivide() {
        block0: for (int i = 0; i < this.audit.getTaxMisc().length; ++i) {
            ProrateTaxData tax = this.audit.getTaxMisc()[i];
            if (tax.getAmount() == 0.0) continue;
            int sectors = 0;
            for (int j = 0; j < this.audit.getSectors().length; ++j) {
                ProrateSector sector = this.audit.getSectors()[j];
                if ((sector.getTaxIndex() & 1 << i) <= 0) continue;
                ++sectors;
            }
            int apply_cnt = 0;
            double apply_error = tax.getAmount() - tax.getAmount() / (double)sectors * (double)sectors;
            for (int j = 0; j < this.audit.getSectors().length; ++j) {
                ProrateSector sector = this.audit.getSectors()[j];
                if ((sector.getTaxIndex() & 1 << i) <= 0) continue;
                double taxValue = tax.getAmount() / (double)sectors / this.audit.getDay5Rate();
                sector.setTaxInLocal(sector.getTaxInLocal() + tax.getAmount() / (double)sectors);
                if (++apply_cnt == sectors) {
                    sector.setTaxInLocal(sector.getTaxInLocal() + apply_error);
                    sector.setTax(sector.getTaxInLocal() / this.audit.getDay5Rate());
                    this.getEngine().trace.traceTax(this.audit, taxValue, tax.getType(), tax.getAmount(), sectors, apply_error, j);
                    continue block0;
                }
                sector.setTax(sector.getTaxInLocal() / this.audit.getDay5Rate());
                this.getEngine().trace.traceTax(this.audit, taxValue, tax.getType(), tax.getAmount(), sectors, 0.0, j);
            }
        }
    }

    public ProrateAuditImpl getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(ProrateAuditImpl engine) {
        this.engine = engine;
    }
}

