/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateFunc;
import jp.sourceforge.gnp.prorate.ProrateRuleBool;
import jp.sourceforge.gnp.prorate.ProrateRuleMultival;
import jp.sourceforge.gnp.prorate.ProrateRuleObject;
import jp.sourceforge.gnp.prorate.ProrateRulePath;
import jp.sourceforge.gnp.prorate.ProrateRuleString;
import jp.sourceforge.gnp.prorate.ProrateRuntime;

class ProrateWithinFunc
extends ProrateFunc {
    ProrateWithinFunc(List in_args) {
        super(in_args);
    }

    @Override
    public ProrateRuleObject eval(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(2, "Within", runtime)) {
            return null;
        }
        ProrateRuleBool ret = new ProrateRuleBool(this.within(runtime));
        this.setEvaluatedObject(ret);
        return ret;
    }

    boolean within(ProrateRuntime runtime) throws Exception {
        if (!this.checkArgnum(2, "Within", runtime)) {
            return false;
        }
        this.args.set(0, ((ProrateRuleObject)this.args.get(0)).copy(runtime));
        ProrateRuleObject pathObj = ((ProrateRuleObject)this.args.get(0)).eval(runtime);
        if (pathObj == null) {
            this.setErrorObject();
            return false;
        }
        this.args.set(1, ((ProrateRuleObject)this.args.get(1)).copy(runtime));
        ProrateRuleObject withinObj = ((ProrateRuleObject)this.args.get(1)).eval(runtime);
        if (withinObj == null) {
            this.setErrorObject();
            return false;
        }
        if (!pathObj.isPath()) {
            this.error(2, "Within:1", runtime);
            return false;
        }
        if (withinObj.isMultival()) {
            List values = ((ProrateRuleMultival)withinObj).getValues();
            for (int i = 0; i < values.size(); ++i) {
                ProrateRuleObject pobj = ((ProrateRuleObject)values.get(i)).copy(runtime);
                values.set(i, pobj.copy(runtime));
                pobj = ((ProrateRuleObject)values.get(i)).eval(runtime);
                if (pobj == null) {
                    this.setErrorObject();
                    return false;
                }
                if (!this.withinCheck(pathObj, pobj, runtime)) continue;
                return true;
            }
            return false;
        }
        return this.withinCheck(pathObj, withinObj, runtime);
    }

    boolean withinCheck(ProrateRuleObject pathObj, ProrateRuleObject withinObj, ProrateRuntime runtime) throws Exception {
        boolean cmp = false;
        if (!withinObj.isString()) {
            this.error(2, "Within:2", runtime);
            return false;
        }
        for (int i = 0; i < ((ProrateRulePath)pathObj).getLength(); ++i) {
            ProrateRuleObject pobj = ((ProrateRulePath)pathObj).getPlace(i);
            cmp = false;
            if (pobj.isMultival()) {
                List values = ((ProrateRuleMultival)pobj).getValues();
                for (int j = 0; j < values.size(); ++j) {
                    ProrateRuleObject pobjEach = ((ProrateRuleObject)values.get(j)).copy(runtime);
                    values.set(j, pobjEach.copy(runtime));
                    ProrateRuleObject subobj = ((ProrateRuleObject)values.get(j)).eval(runtime);
                    if (subobj == null) {
                        this.setErrorObject();
                        return false;
                    }
                    if (!this.check(((ProrateRuleString)withinObj).getValue(), ((ProrateRuleString)subobj).getValue(), runtime)) continue;
                    cmp = true;
                    break;
                }
                if (!cmp) {
                    break;
                }
            } else if (this.check(((ProrateRuleString)withinObj).getValue(), ((ProrateRuleString)pobj).getValue(), runtime)) {
                cmp = true;
            }
            if (!cmp) break;
        }
        return cmp;
    }

    boolean check(String within, String place, ProrateRuntime runtime) {
        String pCountry = this.getCountryName(runtime, place);
        boolean isWithin = within.equals(pCountry);
        if (isWithin) {
            return isWithin;
        }
        String pArea = this.getAreaName(runtime, place);
        return this.multiEq(pArea, within);
    }

    @Override
    public ProrateRuleObject copy(ProrateRuntime runtime) {
        if (this.isCopied) {
            return this;
        }
        ProrateWithinFunc pobj = new ProrateWithinFunc(new Vector(this.args));
        pobj.isCopied = true;
        return pobj;
    }

    @Override
    public void dump() {
        System.out.print("Within(");
        super.dump();
    }

    @Override
    String operatorString() {
        return "Within";
    }
}

