/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.database;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.database.Agent;
import jp.sourceforge.gnp.prorate.database.AgentRdb;
import jp.sourceforge.gnp.prorate.database.AirCity;
import jp.sourceforge.gnp.prorate.database.AircityRdb;
import jp.sourceforge.gnp.prorate.database.Airline;
import jp.sourceforge.gnp.prorate.database.AirlineRdb;
import jp.sourceforge.gnp.prorate.database.BaseAmount;
import jp.sourceforge.gnp.prorate.database.ClassChg;
import jp.sourceforge.gnp.prorate.database.ClasschgRdb;
import jp.sourceforge.gnp.prorate.database.CodeShare;
import jp.sourceforge.gnp.prorate.database.CodeShareRdb;
import jp.sourceforge.gnp.prorate.database.Country;
import jp.sourceforge.gnp.prorate.database.CountryRdb;
import jp.sourceforge.gnp.prorate.database.FactorRdb;
import jp.sourceforge.gnp.prorate.database.FareCodes;
import jp.sourceforge.gnp.prorate.database.FarecodeRdb;
import jp.sourceforge.gnp.prorate.database.FixedFareChk;
import jp.sourceforge.gnp.prorate.database.FixedFareRdb;
import jp.sourceforge.gnp.prorate.database.GnpDatabase;
import jp.sourceforge.gnp.prorate.database.MultiAirport;
import jp.sourceforge.gnp.prorate.database.MultiRdb;
import jp.sourceforge.gnp.prorate.database.ProrateFactor;
import jp.sourceforge.gnp.prorate.database.ProrateTaxTable;
import jp.sourceforge.gnp.prorate.database.ProvisoRdb;
import jp.sourceforge.gnp.prorate.database.Rate;
import jp.sourceforge.gnp.prorate.database.RateRdb;
import jp.sourceforge.gnp.prorate.database.Sia;
import jp.sourceforge.gnp.prorate.database.SiaRdb;
import jp.sourceforge.gnp.prorate.database.TaxRdb;
import jp.sourceforge.gnp.prorate.export.Prorate;

public class ProrateRdb
implements ProrateDatabase,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int CODE_TABLES = 4;
    static final int CODE_TABLE_NORMAL = 0;
    static final int CODE_TABLE_SPECIAL = 1;
    static final int CODE_TABLE_DISCOUNT = 2;
    static final int CODE_TABLE_IDCHIN = 3;
    static final int CLASS_TABLES = 3;
    static final int CLASS_TABLE_FIRST = 0;
    static final int CLASS_TABLE_BUSINESS = 1;
    static final int CLASS_TABLE_ECONOMY = 2;
    Object[] codeTable = null;
    String[] classTable = null;
    int result = 0;
    String errCode = null;
    String errMessage = null;
    GnpDatabase database = null;
    Rate rate = null;
    GnpDatabase rateRdb = null;
    ProrateFactor factor = null;
    GnpDatabase factorRdb = null;
    BaseAmount baseAmount = null;
    GnpDatabase provisoRdb = null;
    AirCity airCity = null;
    GnpDatabase aircityRdb = null;
    MultiAirport multiAirport = null;
    GnpDatabase multiRdb = null;
    Airline airline = null;
    GnpDatabase airlineRdb = null;
    CodeShare codeShare = null;
    GnpDatabase codeShareRdb = null;
    FixedFareChk fixedFare = null;
    GnpDatabase fixedFareRdb = null;
    ProrateTaxTable tax = null;
    GnpDatabase taxRdb = null;
    FareCodes farecode = null;
    GnpDatabase farecodeRdb = null;
    Agent agent = null;
    GnpDatabase agentRdb = null;
    Country country = null;
    GnpDatabase countryRdb = null;
    ClassChg classchg = null;
    GnpDatabase classchgRdb = null;
    Sia sia = null;
    GnpDatabase siaRdb = null;

    @Override
    public boolean openDatabase() {
        String propertyFileName = System.getProperty("PRORATE_PROPERTY_FILE");
        if (propertyFileName == null) {
            propertyFileName = System.getProperty("user.home");
            propertyFileName = propertyFileName + System.getProperty("file.separator");
            propertyFileName = propertyFileName + ".prorate.properties";
            String separator = System.getProperty("file.separator");
            if (separator != null && separator.equals("\\")) {
                String homeDir = System.getProperty("user.home");
                System.err.println("user.home = " + homeDir);
                System.err.println("file.separator = " + separator);
                propertyFileName = homeDir + separator + "prorate.properties";
                System.err.println("WIN: propertyFileName = " + propertyFileName);
            }
        }
        FileInputStream propertyFile = null;
        try {
            propertyFile = new FileInputStream(propertyFileName);
        }
        catch (FileNotFoundException e) {
            propertyFile = null;
        }
        System.err.println("propertyFileName = " + propertyFileName + ", propertyFile = " + propertyFile);
        InputStream is = null;
        if (propertyFile == null) {
            ClassLoader loader = Prorate.class.getClassLoader();
            is = loader.getResourceAsStream("jp/sourceforge/gnp/prorate.properties");
        } else {
            is = propertyFile;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e2) {
            // empty catch block
        }
        String driver = properties.getProperty("GNP_DATABASE_DRIVER", "org.gjt.mm.mysql.Driver");
        String url = properties.getProperty("GNP_DATABASE_URL", "jdbc:mysql://localhost:3306/gnp");
        String user = properties.getProperty("GNP_DATABASE_USER", "gnp");
        String passwd = properties.getProperty("GNP_DATABASE_PASSWD", "gnp");
        System.err.println("ProrateRdb.openDatabase() driver = " + driver + ", url = " + url + ", user = " + user + ", passwd = " + passwd);
        this.database = new GnpDatabase();
        this.database.setDriver(driver);
        this.database.setUrl(url);
        this.database.setUser(user);
        this.database.setPasswd(passwd);
        this.database.initialize();
        try {
            if (!this.database.open()) {
                this.result = -1;
                this.errCode = "-1";
                this.errMessage = "open error";
                return false;
            }
        }
        catch (SQLException e) {
            this.result = -1;
            this.errCode = Integer.toString(e.getErrorCode());
            this.errMessage = e.getMessage();
            return false;
        }
        this.rate = new Rate();
        this.rateRdb = new RateRdb();
        this.rateRdb.setConnection(this.database.getConnection());
        this.rateRdb.setStatement(this.database.getStatement());
        this.rateRdb.setData(this.rate);
        this.factor = new ProrateFactor();
        this.factorRdb = new FactorRdb();
        this.factorRdb.setConnection(this.database.getConnection());
        this.factorRdb.setStatement(this.database.getStatement());
        this.factorRdb.setData(this.factor);
        this.baseAmount = new BaseAmount();
        this.provisoRdb = new ProvisoRdb();
        this.provisoRdb.setConnection(this.database.getConnection());
        this.provisoRdb.setStatement(this.database.getStatement());
        this.provisoRdb.setData(this.baseAmount);
        this.airCity = new AirCity();
        this.aircityRdb = new AircityRdb();
        this.aircityRdb.setConnection(this.database.getConnection());
        this.aircityRdb.setStatement(this.database.getStatement());
        this.aircityRdb.setData(this.airCity);
        this.multiAirport = new MultiAirport();
        this.multiRdb = new MultiRdb();
        this.multiRdb.setConnection(this.database.getConnection());
        this.multiRdb.setStatement(this.database.getStatement());
        this.multiRdb.setData(this.multiAirport);
        this.airline = new Airline();
        this.airlineRdb = new AirlineRdb();
        this.airlineRdb.setConnection(this.database.getConnection());
        this.airlineRdb.setStatement(this.database.getStatement());
        this.airlineRdb.setData(this.airline);
        this.codeShare = new CodeShare();
        this.codeShareRdb = new CodeShareRdb();
        this.codeShareRdb.setConnection(this.database.getConnection());
        this.codeShareRdb.setStatement(this.database.getStatement());
        this.codeShareRdb.setData(this.codeShare);
        this.fixedFare = new FixedFareChk();
        this.fixedFareRdb = new FixedFareRdb();
        this.fixedFareRdb.setConnection(this.database.getConnection());
        this.fixedFareRdb.setStatement(this.database.getStatement());
        this.fixedFareRdb.setData(this.fixedFare);
        this.tax = new ProrateTaxTable();
        this.taxRdb = new TaxRdb();
        this.taxRdb.setConnection(this.database.getConnection());
        this.taxRdb.setStatement(this.database.getStatement());
        this.taxRdb.setData(this.tax);
        this.agent = new Agent();
        this.agentRdb = new AgentRdb();
        this.agentRdb.setConnection(this.database.getConnection());
        this.agentRdb.setStatement(this.database.getStatement());
        this.agentRdb.setData(this.agent);
        this.country = new Country();
        this.countryRdb = new CountryRdb();
        this.countryRdb.setConnection(this.database.getConnection());
        this.countryRdb.setStatement(this.database.getStatement());
        this.countryRdb.setData(this.country);
        this.farecodeRdb = new FarecodeRdb();
        this.farecodeRdb.setConnection(this.database.getConnection());
        this.farecodeRdb.setStatement(this.database.getStatement());
        this.farecode = new FareCodes();
        this.farecodeRdb.setData(this.farecode);
        this.codeTable = new Object[4];
        for (int i = 0; i < 4; ++i) {
            this.farecode.type = i;
            if (!this.farecodeRdb.search()) {
                this.result = this.farecode.result;
                this.errCode = this.farecode.errCode;
                this.errMessage = this.farecode.errMessage;
                return false;
            }
            Object[] strarray = this.farecode.codes.toArray();
            Arrays.sort(strarray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String str1 = (String)o1;
                    String str2 = (String)o2;
                    if (str1.length() > str2.length()) {
                        return -1;
                    }
                    if (str1.length() < str2.length()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.codeTable[i] = strarray;
        }
        this.classTable = new String[3];
        this.classchgRdb = new ClasschgRdb();
        this.classchgRdb.setConnection(this.database.getConnection());
        this.classchgRdb.setStatement(this.database.getStatement());
        this.classchg = new ClassChg();
        this.classchgRdb.setData(this.classchg);
        this.classchg.mainClass = "F";
        if (!this.classchgRdb.search()) {
            this.result = this.classchg.result;
            this.errCode = this.classchg.errCode;
            this.errMessage = this.classchg.errMessage;
            return false;
        }
        this.classTable[0] = this.classchg.classes;
        this.classchg.mainClass = "C";
        if (!this.classchgRdb.search()) {
            this.result = this.classchg.result;
            this.errCode = this.classchg.errCode;
            this.errMessage = this.classchg.errMessage;
            return false;
        }
        this.classTable[1] = this.classchg.classes;
        this.classchg.mainClass = "Y";
        if (!this.classchgRdb.search()) {
            this.result = this.classchg.result;
            this.errCode = this.classchg.errCode;
            this.errMessage = this.classchg.errMessage;
            return false;
        }
        this.classTable[2] = this.classchg.classes;
        this.sia = new Sia();
        this.siaRdb = new SiaRdb();
        this.siaRdb.setConnection(this.database.getConnection());
        this.siaRdb.setStatement(this.database.getStatement());
        this.siaRdb.setData(this.sia);
        return true;
    }

    @Override
    public void closeDatabase() {
        this.codeTable = null;
        this.classTable = null;
        this.rate = null;
        this.rateRdb = null;
        this.factor = null;
        this.factorRdb = null;
        this.baseAmount = null;
        this.provisoRdb = null;
        this.airCity = null;
        this.aircityRdb = null;
        this.multiAirport = null;
        this.multiRdb = null;
        this.airline = null;
        this.airlineRdb = null;
        this.codeShare = null;
        this.codeShareRdb = null;
        this.fixedFare = null;
        this.fixedFareRdb = null;
        this.tax = null;
        this.taxRdb = null;
        this.farecode = null;
        this.farecodeRdb = null;
        this.agent = null;
        this.agentRdb = null;
        this.country = null;
        this.countryRdb = null;
        this.classchg = null;
        this.classchgRdb = null;
        this.sia = null;
        this.siaRdb = null;
        try {
            this.database.close();
        }
        catch (SQLException e) {
            this.result = -1;
            this.errCode = Integer.toString(e.getErrorCode());
            this.errMessage = e.getMessage();
        }
        this.database = null;
    }

    @Override
    public double getRoeRate(String currency, String date) {
        this.rate.currency = currency;
        this.rate.applyDate = date.substring(0, 6);
        if (!this.rateRdb.search()) {
            this.result = this.rate.result;
            this.errCode = this.rate.errCode;
            this.errMessage = this.rate.errMessage;
            if (this.result < 0) {
                System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return -1.0;
                }
                this.rate.currency = currency;
                this.rate.applyDate = date.substring(0, 6);
                if (!this.rateRdb.search()) {
                    this.result = this.rate.result;
                    this.errCode = this.rate.errCode;
                    this.errMessage = this.rate.errMessage;
                    return -1.0;
                }
                this.result = this.rate.result;
                this.errCode = this.rate.errCode;
                this.errMessage = this.rate.errMessage;
            } else {
                return -1.0;
            }
        }
        return this.rate.roeRate;
    }

    @Override
    public double get5dayRate(String currency, String date) {
        this.rate.currency = currency;
        this.rate.applyDate = date.substring(0, 6);
        if (!this.rateRdb.search()) {
            this.result = this.rate.result;
            this.errCode = this.rate.errCode;
            this.errMessage = this.rate.errMessage;
            if (this.result < 0) {
                System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return -1.0;
                }
                this.rate.currency = currency;
                this.rate.applyDate = date.substring(0, 6);
                if (!this.rateRdb.search()) {
                    this.result = this.rate.result;
                    this.errCode = this.rate.errCode;
                    this.errMessage = this.rate.errMessage;
                    return -1.0;
                }
                this.result = this.rate.result;
                this.errCode = this.rate.errCode;
                this.errMessage = this.rate.errMessage;
            } else {
                return -1.0;
            }
        }
        return this.rate.day5Rate;
    }

    @Override
    public double getMeanRate(String currency, String date) {
        this.rate.currency = currency;
        this.rate.applyDate = date.substring(0, 6);
        if (!this.rateRdb.search()) {
            this.result = this.rate.result;
            this.errCode = this.rate.errCode;
            this.errMessage = this.rate.errMessage;
            if (this.result < 0) {
                System.err.println("rateRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return -1.0;
                }
                this.rate.currency = currency;
                this.rate.applyDate = date.substring(0, 6);
                if (!this.rateRdb.search()) {
                    this.result = this.rate.result;
                    this.errCode = this.rate.errCode;
                    this.errMessage = this.rate.errMessage;
                    return -1.0;
                }
                this.result = this.rate.result;
                this.errCode = this.rate.errCode;
                this.errMessage = this.rate.errMessage;
            } else {
                return -1.0;
            }
        }
        return this.rate.meanRate;
    }

    @Override
    public double getProrateFactor(String from, String to, String date) {
        int yy = Integer.parseInt(date.substring(0, 4));
        int mm = Integer.parseInt(date.substring(4, 6));
        if (mm == 1 || mm == 2) {
            mm = 12;
            --yy;
        } else {
            mm -= mm % 3;
        }
        this.factor.depCity = from;
        this.factor.destCity = to;
        this.factor.applyDate = Integer.toString(yy * 100 + mm) + "01";
        if (!this.factorRdb.search()) {
            this.result = this.factor.result;
            this.errCode = this.factor.errCode;
            this.errMessage = this.factor.errMessage;
            if (this.result < 0) {
                System.err.println("factorRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return -1.0;
                }
                yy = Integer.parseInt(date.substring(0, 4));
                mm = Integer.parseInt(date.substring(4, 6));
                if (mm == 1 || mm == 2) {
                    mm = 12;
                    --yy;
                } else {
                    mm -= mm % 3;
                }
                this.factor.depCity = from;
                this.factor.destCity = to;
                this.factor.applyDate = Integer.toString(yy * 100 + mm) + "01";
                if (!this.factorRdb.search()) {
                    this.result = this.factor.result;
                    this.errCode = this.factor.errCode;
                    this.errMessage = this.factor.errMessage;
                    return -1.0;
                }
                this.result = this.factor.result;
                this.errCode = this.factor.errCode;
                this.errMessage = this.factor.errMessage;
            } else {
                return -1.0;
            }
        }
        return this.factor.prorateFactor;
    }

    @Override
    public ProrateDatabase.Amount getBaseAmount(String from, String to, String carrier, String code, String date) {
        this.baseAmount.depCity = from;
        this.baseAmount.destCity = to;
        this.baseAmount.carrier = carrier;
        this.baseAmount.class1 = code;
        this.baseAmount.applyDate = date.substring(0, 6) + "01";
        if (!this.provisoRdb.search()) {
            this.result = this.baseAmount.result;
            this.errCode = this.baseAmount.errCode;
            this.errMessage = this.baseAmount.errMessage;
            if (this.result < 0) {
                System.err.println("provisoRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return null;
                }
                this.baseAmount.depCity = from;
                this.baseAmount.destCity = to;
                this.baseAmount.carrier = carrier;
                this.baseAmount.class1 = code;
                this.baseAmount.applyDate = date.substring(0, 6) + "01";
                if (!this.provisoRdb.search()) {
                    this.result = this.baseAmount.result;
                    this.errCode = this.baseAmount.errCode;
                    this.errMessage = this.baseAmount.errMessage;
                    return null;
                }
                this.result = this.baseAmount.result;
                this.errCode = this.baseAmount.errCode;
                this.errMessage = this.baseAmount.errMessage;
            } else {
                return null;
            }
        }
        ProrateDatabase.Amount amount = new ProrateDatabase.Amount();
        amount.currency = this.baseAmount.currency;
        amount.value = this.baseAmount.baseAmount;
        return amount;
    }

    @Override
    public String getCountryName(String place, String date) {
        this.airCity.letter3Code = place;
        this.airCity.applyDate = date;
        if (!this.aircityRdb.search()) {
            this.result = this.airCity.result;
            this.errCode = this.airCity.errCode;
            this.errMessage = this.airCity.errMessage;
            if (this.result < 0) {
                System.err.println("aircityRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.airCity.letter3Code = place;
                this.airCity.applyDate = date;
                if (!this.aircityRdb.search()) {
                    this.result = this.airCity.result;
                    this.errCode = this.airCity.errCode;
                    this.errMessage = this.airCity.errMessage;
                    return "";
                }
                this.result = this.airCity.result;
                this.errCode = this.airCity.errCode;
                this.errMessage = this.airCity.errMessage;
            } else {
                return "";
            }
        }
        return this.airCity.country;
    }

    @Override
    public String getAreaName(String place, String date) {
        this.airCity.letter3Code = place;
        this.airCity.applyDate = date;
        if (!this.aircityRdb.search()) {
            this.result = this.airCity.result;
            this.errCode = this.airCity.errCode;
            this.errMessage = this.airCity.errMessage;
            if (this.result < 0) {
                System.err.println("aircityRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.airCity.letter3Code = place;
                this.airCity.applyDate = date;
                if (!this.aircityRdb.search()) {
                    this.result = this.airCity.result;
                    this.errCode = this.airCity.errCode;
                    this.errMessage = this.airCity.errMessage;
                    return "";
                }
                this.result = this.airCity.result;
                this.errCode = this.airCity.errCode;
                this.errMessage = this.airCity.errMessage;
            } else {
                return "";
            }
        }
        return this.airCity.area;
    }

    @Override
    public String getCityName(String place) {
        this.multiAirport.airport = place;
        if (!this.multiRdb.search()) {
            this.result = this.multiAirport.result;
            this.errCode = this.multiAirport.errCode;
            this.errMessage = this.multiAirport.errMessage;
            if (this.result < 0) {
                System.err.println("multiRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.multiAirport.airport = place;
                if (!this.multiRdb.search()) {
                    this.result = this.multiAirport.result;
                    this.errCode = this.multiAirport.errCode;
                    this.errMessage = this.multiAirport.errMessage;
                    if (this.result < 0) {
                        return "";
                    }
                    return place;
                }
                this.result = this.multiAirport.result;
                this.errCode = this.multiAirport.errCode;
                this.errMessage = this.multiAirport.errMessage;
            }
            return place;
        }
        return this.multiAirport.city;
    }

    @Override
    public String getAirwayId(String airwayNo, String date) {
        this.airline.airlineCode = airwayNo;
        this.airline.applyDate = date;
        if (!this.airlineRdb.search()) {
            this.result = this.airline.result;
            this.errCode = this.airline.errCode;
            this.errMessage = this.airline.errMessage;
            if (this.result < 0) {
                System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.airline.airlineCode = airwayNo;
                this.airline.applyDate = date;
                if (!this.airlineRdb.search()) {
                    this.result = this.airline.result;
                    this.errCode = this.airline.errCode;
                    this.errMessage = this.airline.errMessage;
                    return "";
                }
                this.result = this.airline.result;
                this.errCode = this.airline.errCode;
                this.errMessage = this.airline.errMessage;
            } else {
                return "";
            }
        }
        return this.airline.letter2Code;
    }

    @Override
    public String getAirwayName(String airwayNo, String date) {
        this.airline.airlineCode = airwayNo;
        this.airline.applyDate = date;
        if (!this.airlineRdb.search()) {
            this.result = this.airline.result;
            this.errCode = this.airline.errCode;
            this.errMessage = this.airline.errMessage;
            if (this.result < 0) {
                System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.airline.airlineCode = airwayNo;
                this.airline.applyDate = date;
                if (!this.airlineRdb.search()) {
                    this.result = this.airline.result;
                    this.errCode = this.airline.errCode;
                    this.errMessage = this.airline.errMessage;
                    return "";
                }
                this.result = this.airline.result;
                this.errCode = this.airline.errCode;
                this.errMessage = this.airline.errMessage;
            } else {
                return "";
            }
        }
        return this.airline.airlineName;
    }

    @Override
    public boolean checkAirwayId(String airwayId, String date) {
        this.airline.airlineCode = null;
        this.airline.letter2Code = airwayId;
        this.airline.applyDate = date;
        if (!this.airlineRdb.search()) {
            this.result = this.airline.result;
            this.errCode = this.airline.errCode;
            this.errMessage = this.airline.errMessage;
            if (this.result < 0) {
                System.err.println("airlineRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return false;
                }
                this.airline.airlineCode = null;
                this.airline.letter2Code = airwayId;
                this.airline.applyDate = date;
                if (!this.airlineRdb.search()) {
                    this.result = this.airline.result;
                    this.errCode = this.airline.errCode;
                    this.errMessage = this.airline.errMessage;
                    return false;
                }
                this.result = this.airline.result;
                this.errCode = this.airline.errCode;
                this.errMessage = this.airline.errMessage;
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getOpCarrier(String carrier, String flightNo, String date) {
        this.codeShare.tkCarrier = carrier;
        this.codeShare.flight = flightNo;
        this.codeShare.applyDate = date;
        this.codeShare.termscode = '\u0000';
        this.codeShare.spacode = '\u0000';
        if (!this.codeShareRdb.search()) {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            if (this.result < 0) {
                System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.codeShare.tkCarrier = carrier;
                this.codeShare.flight = flightNo;
                this.codeShare.applyDate = date;
                this.codeShare.termscode = '\u0000';
                this.codeShare.spacode = '\u0000';
                if (!this.codeShareRdb.search()) {
                    this.result = this.codeShare.result;
                    this.errCode = this.codeShare.errCode;
                    this.errMessage = this.codeShare.errMessage;
                    return "";
                }
                this.result = this.codeShare.result;
                this.errCode = this.codeShare.errCode;
                this.errMessage = this.codeShare.errMessage;
            } else {
                return "";
            }
        }
        return this.codeShare.flightCarrier;
    }

    @Override
    public String codeShareExcl(String carrier, String flightNo, String date) {
        this.codeShare.tkCarrier = carrier;
        this.codeShare.flight = flightNo;
        this.codeShare.applyDate = date;
        this.codeShare.termscode = (char)50;
        this.codeShare.spacode = '\u0000';
        if (!this.codeShareRdb.search()) {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            if (this.result < 0) {
                System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.codeShare.tkCarrier = carrier;
                this.codeShare.flight = flightNo;
                this.codeShare.applyDate = date;
                this.codeShare.termscode = (char)50;
                this.codeShare.spacode = '\u0000';
                if (!this.codeShareRdb.search()) {
                    this.result = this.codeShare.result;
                    this.errCode = this.codeShare.errCode;
                    this.errMessage = this.codeShare.errMessage;
                    return "";
                }
                this.result = this.codeShare.result;
                this.errCode = this.codeShare.errCode;
                this.errMessage = this.codeShare.errMessage;
            } else {
                return "";
            }
        }
        if (this.codeShare.termscode != '2') {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            return "";
        }
        return this.codeShare.flightCarrier;
    }

    @Override
    public String codeShareIncl(String carrier, String flightNo, String date) {
        this.codeShare.tkCarrier = carrier;
        this.codeShare.flight = flightNo;
        this.codeShare.applyDate = date;
        this.codeShare.termscode = (char)49;
        this.codeShare.spacode = '\u0000';
        if (!this.codeShareRdb.search()) {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            if (this.result < 0) {
                System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.codeShare.tkCarrier = carrier;
                this.codeShare.flight = flightNo;
                this.codeShare.applyDate = date;
                this.codeShare.termscode = (char)49;
                this.codeShare.spacode = '\u0000';
                if (!this.codeShareRdb.search()) {
                    this.result = this.codeShare.result;
                    this.errCode = this.codeShare.errCode;
                    this.errMessage = this.codeShare.errMessage;
                    return "";
                }
                this.result = this.codeShare.result;
                this.errCode = this.codeShare.errCode;
                this.errMessage = this.codeShare.errMessage;
            } else {
                return "";
            }
        }
        if (this.codeShare.termscode != '1') {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            return "";
        }
        return this.codeShare.flightCarrier;
    }

    @Override
    public String codeShareSpa(String carrier, String flightNo, String date) {
        this.codeShare.tkCarrier = carrier;
        this.codeShare.flight = flightNo;
        this.codeShare.applyDate = date;
        this.codeShare.termscode = '\u0000';
        this.codeShare.spacode = (char)49;
        if (!this.codeShareRdb.search()) {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            if (this.result < 0) {
                System.err.println("codeShareRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.codeShare.tkCarrier = carrier;
                this.codeShare.flight = flightNo;
                this.codeShare.applyDate = date;
                this.codeShare.termscode = '\u0000';
                this.codeShare.spacode = (char)49;
                if (!this.codeShareRdb.search()) {
                    this.result = this.codeShare.result;
                    this.errCode = this.codeShare.errCode;
                    this.errMessage = this.codeShare.errMessage;
                    return "";
                }
                this.result = this.codeShare.result;
                this.errCode = this.codeShare.errCode;
                this.errMessage = this.codeShare.errMessage;
            } else {
                return "";
            }
        }
        if (this.codeShare.spacode != '1') {
            this.result = this.codeShare.result;
            this.errCode = this.codeShare.errCode;
            this.errMessage = this.codeShare.errMessage;
            return "";
        }
        return this.codeShare.flightCarrier;
    }

    @Override
    public double getFixedFare(String date) {
        this.fixedFare.date = date;
        if (!this.fixedFareRdb.search()) {
            this.result = this.fixedFare.result;
            this.errCode = this.fixedFare.errCode;
            this.errMessage = this.fixedFare.errMessage;
            if (this.result < 0) {
                System.err.println("fixedFareRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return -1.0;
                }
                this.fixedFare.date = date;
                if (!this.fixedFareRdb.search()) {
                    this.result = this.fixedFare.result;
                    this.errCode = this.fixedFare.errCode;
                    this.errMessage = this.fixedFare.errMessage;
                    return -1.0;
                }
                this.result = this.fixedFare.result;
                this.errCode = this.fixedFare.errCode;
                this.errMessage = this.fixedFare.errMessage;
            } else {
                return -1.0;
            }
        }
        return this.fixedFare.fixedFare;
    }

    @Override
    public ProrateTaxTable getTaxTable(String taxCode, String date) {
        this.tax.code = taxCode;
        this.tax.applyDate = date;
        if (!this.taxRdb.search()) {
            this.result = this.tax.result;
            this.errCode = this.tax.errCode;
            this.errMessage = this.tax.errMessage;
            if (this.result < 0) {
                System.err.println("taxRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return null;
                }
                this.tax.code = taxCode;
                this.tax.applyDate = date;
                if (!this.taxRdb.search()) {
                    this.result = this.tax.result;
                    this.errCode = this.tax.errCode;
                    this.errMessage = this.tax.errMessage;
                    return null;
                }
                this.result = this.tax.result;
                this.errCode = this.tax.errCode;
                this.errMessage = this.tax.errMessage;
            } else {
                return null;
            }
        }
        return this.tax;
    }

    @Override
    public Object[] getNormalCodes() {
        return (Object[])this.codeTable[0];
    }

    @Override
    public Object[] getSpecialCodes() {
        return (Object[])this.codeTable[1];
    }

    @Override
    public Object[] getDiscountCodes() {
        return (Object[])this.codeTable[2];
    }

    @Override
    public Object[] getIDCHINCodes() {
        return (Object[])this.codeTable[3];
    }

    @Override
    public String getAgentCountry(String agentCode, String date) {
        this.agent.code = agentCode;
        this.agent.applyDate = date;
        if (!this.agentRdb.search()) {
            this.result = this.agent.result;
            this.errCode = this.agent.errCode;
            this.errMessage = this.agent.errMessage;
            if (this.result < 0) {
                System.err.println("agentRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.agent.code = agentCode;
                this.agent.applyDate = date;
                if (!this.agentRdb.search()) {
                    this.result = this.agent.result;
                    this.errCode = this.agent.errCode;
                    this.errMessage = this.agent.errMessage;
                    return "";
                }
                this.result = this.agent.result;
                this.errCode = this.agent.errCode;
                this.errMessage = this.agent.errMessage;
            } else {
                return "";
            }
        }
        this.country.code = this.agent.country;
        this.country.applyDate = this.agent.applyDate;
        if (!this.countryRdb.search()) {
            this.result = this.country.result;
            this.errCode = this.country.errCode;
            this.errMessage = this.country.errMessage;
            if (this.result < 0) {
                System.err.println("countryRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.country.code = this.agent.country;
                this.country.applyDate = this.agent.applyDate;
                if (!this.countryRdb.search()) {
                    this.result = this.country.result;
                    this.errCode = this.country.errCode;
                    this.errMessage = this.country.errMessage;
                    return "";
                }
                this.result = this.country.result;
                this.errCode = this.country.errCode;
                this.errMessage = this.country.errMessage;
            } else {
                return "";
            }
        }
        return this.country.country;
    }

    @Override
    public String getAgentArea(String agentCode, String date) {
        this.agent.code = agentCode;
        this.agent.applyDate = date;
        if (!this.agentRdb.search()) {
            this.result = this.agent.result;
            this.errCode = this.agent.errCode;
            this.errMessage = this.agent.errMessage;
            if (this.result < 0) {
                System.err.println("agentRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.agent.code = agentCode;
                this.agent.applyDate = date;
                if (!this.agentRdb.search()) {
                    this.result = this.agent.result;
                    this.errCode = this.agent.errCode;
                    this.errMessage = this.agent.errMessage;
                    return "";
                }
                this.result = this.agent.result;
                this.errCode = this.agent.errCode;
                this.errMessage = this.agent.errMessage;
            } else {
                return "";
            }
        }
        this.country.code = this.agent.country;
        this.country.applyDate = this.agent.applyDate;
        if (!this.countryRdb.search()) {
            this.result = this.country.result;
            this.errCode = this.country.errCode;
            this.errMessage = this.country.errMessage;
            if (this.result < 0) {
                System.err.println("countryRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return "";
                }
                this.country.code = this.agent.country;
                this.country.applyDate = this.agent.applyDate;
                if (!this.countryRdb.search()) {
                    this.result = this.country.result;
                    this.errCode = this.country.errCode;
                    this.errMessage = this.country.errMessage;
                    return "";
                }
                this.result = this.country.result;
                this.errCode = this.country.errCode;
                this.errMessage = this.country.errMessage;
            } else {
                return "";
            }
        }
        return this.country.area;
    }

    @Override
    public boolean checkSia(String carrier, String flightNo, String flightDate) {
        this.sia.mkCarrier = carrier;
        this.sia.flight = flightNo;
        this.sia.applyDate = flightDate;
        if (!this.siaRdb.search()) {
            this.result = this.sia.result;
            this.errCode = this.sia.errCode;
            this.errMessage = this.sia.errMessage;
            if (this.result < 0) {
                System.err.println("siaRdb re-open ProrateRdb.openDatabase() ");
                if (!this.openDatabase()) {
                    return false;
                }
                this.sia.mkCarrier = carrier;
                this.sia.flight = flightNo;
                this.sia.applyDate = flightDate;
                if (!this.siaRdb.search()) {
                    this.result = this.sia.result;
                    this.errCode = this.sia.errCode;
                    this.errMessage = this.sia.errMessage;
                    return false;
                }
                this.result = this.sia.result;
                this.errCode = this.sia.errCode;
                this.errMessage = this.sia.errMessage;
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getFClasses() {
        return this.classTable[0];
    }

    @Override
    public String getCClasses() {
        return this.classTable[1];
    }

    @Override
    public String getYClasses() {
        return this.classTable[2];
    }

    @Override
    public int getResult() {
        return this.result;
    }

    @Override
    public String getErrCode() {
        return this.errCode;
    }

    @Override
    public String getErrMessage() {
        return this.errMessage;
    }
}

