/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prorate.ejb;

import javax.ejb.Stateless;
import jp.sourceforge.gnp.dcheck.ejb.interfaces.CheckEjb;
import jp.sourceforge.gnp.dsearch.ejb.interfaces.GetDataEjb;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateException;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;

@Stateless
public class ProrateCheckGetDataEjbBean
implements ProrateEjb,
CheckEjb,
GetDataEjb {
    ProrateImpl prorate = null;

    public ProrateCheckGetDataEjbBean() throws Exception {
        XmlRulebaseLru rulebase = null;
        try {
            rulebase = new XmlRulebaseLru();
            XmlRulebaseLru.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProrateException("error in rulebase initialize", e);
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory(factory);
        this.prorate = new ProrateImpl();
        this.prorate.setRulebase(rulebase);
        this.prorate.setFcalc(new ProrateFCalcImpl());
        this.prorate.setTax(new ProrateTaxImpl());
        ProrateTraceString trace = new ProrateTraceString();
        this.prorate.setTrace(trace);
        this.prorate.setDatabase(new ProrateRdb());
        if (!this.prorate.getDatabase().openDatabase()) {
            throw new ProrateException("database open error:" + this.prorate.getDatabase().getErrMessage(), null);
        }
    }

    @Override
    public ProrateAudit prorate(ProrateAudit audit) throws ProrateException {
        this.prorate.getTrace().setData(audit);
        ProrateAudit auditRet = null;
        try {
            auditRet = this.prorate.prorate(audit);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProrateException("error in prorate", e);
        }
        this.prorate.getTrace().close();
        ProrateTraceString traceString = (ProrateTraceString)this.prorate.getTrace();
        String[] stringsArray = new String[traceString.getStrings().size()];
        for (int i = 0; i < traceString.getStrings().size(); ++i) {
            stringsArray[i] = (String)traceString.getStrings().get(i);
        }
        auditRet.setTraceStrings(stringsArray);
        return auditRet;
    }

    @Override
    public boolean checkPlace(String place, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        String country = database.getCountryName(place, date);
        return country != null && country != "";
    }

    @Override
    public boolean checkAirwayId(String airwayId, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        boolean retval = database.checkAirwayId(airwayId, date);
        System.err.println("CheckEjb.checkAirwayId() airwayId = " + airwayId + " date = " + date + " retval = " + retval + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return retval;
    }

    @Override
    public boolean checkAirwayNo(String airwayNo, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        String airwayId = database.getAirwayId(airwayNo, date);
        System.err.println("CheckEjb.checkAirwayNo() airwayNo = " + airwayNo + " date = " + date + " airwayId = " + airwayId + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return airwayId != null && airwayId != "";
    }

    @Override
    public boolean checkCurrency(String currency, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        double roeRate = database.getRoeRate(currency, date);
        System.err.println("CheckEjb.checkCurrency() currency = " + currency + " date = " + date + " roeRate = " + roeRate + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return !(roeRate < 0.0);
    }

    @Override
    public double getProrateFactor(String from, String to, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        from = database.getCityName(from);
        to = database.getCityName(to);
        double prorateFactor = database.getProrateFactor(from, to, date);
        System.err.println("GetDataEjb.getProrateFactor() from = " + from + "to = " + to + " date = " + date + " prorateFactor = " + prorateFactor + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return prorateFactor;
    }

    @Override
    public String getCityName(String place) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        String cityName = database.getCityName(place);
        System.err.println("GetDataEjb.getCityName() place = " + place + " cityName = " + cityName + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return cityName;
    }

    @Override
    public String getAirwayId(String airwayNumber, String date) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        String airwayId = database.getAirwayId(airwayNumber, date);
        System.err.println("GetDataEjb.getCityName() airwayNumber = " + airwayNumber + " date = " + date + " result = " + database.getResult() + " errCode = " + database.getErrCode() + " errMessage = " + database.getErrMessage());
        return airwayId;
    }

    @Override
    public String getClassesForMainClass(String mainClass) throws ProrateException {
        ProrateDatabase database = this.prorate.getDatabase();
        if (mainClass.equals("F")) {
            return database.getFClasses();
        }
        if (mainClass.equals("C")) {
            return database.getCClasses();
        }
        if (mainClass.equals("Y")) {
            return database.getYClasses();
        }
        return null;
    }
}

