/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.SqlResultSetMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class ResultsetMappingSecondPass
implements QuerySecondPass {
    private static Log log = LogFactory.getLog(ResultsetMappingSecondPass.class);
    private SqlResultSetMapping ann;
    private ExtendedMappings mappings;
    private boolean isDefault;

    public ResultsetMappingSecondPass(SqlResultSetMapping ann, ExtendedMappings mappings, boolean isDefault) {
        this.ann = ann;
        this.mappings = mappings;
        this.isDefault = isDefault;
    }

    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.ann == null) {
            return;
        }
        ResultSetMappingDefinition definition = new ResultSetMappingDefinition(this.ann.name());
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding resultset mapping: " + definition.getName()));
        }
        int entityAliasIndex = 0;
        for (EntityResult entityResult : this.ann.entities()) {
            ArrayList<FieldResult> properties = new ArrayList<FieldResult>();
            ArrayList<String> propertyNames = new ArrayList<String>();
            HashMap<String, Object> propertyresults = new HashMap<String, Object>();
            for (FieldResult fieldResult : entityResult.fields()) {
                String name = fieldResult.name();
                if (name.indexOf(46) == -1) {
                    properties.add(fieldResult);
                    propertyNames.add(name);
                    continue;
                }
                PersistentClass pc = this.mappings.getClass(entityResult.entityClass().getName());
                if (pc == null) {
                    throw new MappingException("Entity not found " + entityResult.entityClass().getName() + " in SqlResultsetMapping " + this.ann.name());
                }
                int dotIndex = name.lastIndexOf(46);
                String reducedName = name.substring(0, dotIndex);
                Iterator parentPropIter = this.getSubPropertyIterator(pc, reducedName);
                List followers = this.getFollowers(parentPropIter, reducedName, name);
                int index = propertyNames.size();
                int followersSize = followers.size();
                for (int loop = 0; loop < followersSize; ++loop) {
                    String follower = (String)followers.get(loop);
                    int currentIndex = ResultsetMappingSecondPass.getIndexOfFirstMatchingProperty(propertyNames, follower);
                    index = currentIndex != -1 && currentIndex < index ? currentIndex : index;
                }
                propertyNames.add(index, name);
                properties.add(index, fieldResult);
            }
            HashSet<String> uniqueReturnProperty = new HashSet<String>();
            for (FieldResult propertyresult : properties) {
                String string = propertyresult.name();
                if ("class".equals(string)) {
                    throw new MappingException("class is not a valid property name to use in a @FieldResult, use @Entity(discriminatorColumn) instead");
                }
                ArrayList<String> allResultColumns = new ArrayList<String>();
                allResultColumns.add(propertyresult.column());
                if (uniqueReturnProperty.contains(string)) {
                    throw new MappingException("duplicate @FieldResult for property " + string + " on @Entity " + entityResult.entityClass().getName() + " in " + this.ann.name());
                }
                uniqueReturnProperty.add(string);
                String key = StringHelper.root(string);
                ArrayList intermediateResults = (ArrayList)propertyresults.get(key);
                if (intermediateResults == null) {
                    propertyresults.put(key, allResultColumns);
                    continue;
                }
                intermediateResults.addAll(allResultColumns);
            }
            for (Map.Entry entry : propertyresults.entrySet()) {
                if (!(entry.getValue() instanceof ArrayList)) continue;
                ArrayList list = (ArrayList)entry.getValue();
                entry.setValue(list.toArray(new String[list.size()]));
            }
            if (!BinderHelper.isDefault(entityResult.discriminatorColumn())) {
                propertyresults.put("class", new String[]{entityResult.discriminatorColumn()});
            }
            propertyresults = propertyresults.isEmpty() ? CollectionHelper.EMPTY_MAP : propertyresults;
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn("alias" + entityAliasIndex++, entityResult.entityClass().getName(), propertyresults, LockMode.READ);
            definition.addQueryReturn((NativeSQLQueryReturn)nativeSQLQueryRootReturn);
        }
        for (Annotation annotation : this.ann.columns()) {
            definition.addQueryReturn((NativeSQLQueryReturn)new NativeSQLQueryScalarReturn(annotation.name(), null));
        }
        if (this.isDefault) {
            this.mappings.addDefaultResultSetMapping(definition);
        } else {
            this.mappings.addResultSetMapping(definition);
        }
    }

    private List getFollowers(Iterator parentPropIter, String reducedName, String name) {
        boolean hasFollowers = false;
        ArrayList<String> followers = new ArrayList<String>();
        while (parentPropIter.hasNext()) {
            String currentPropertyName = ((Property)parentPropIter.next()).getName();
            String currentName = reducedName + '.' + currentPropertyName;
            if (hasFollowers) {
                followers.add(currentName);
            }
            if (!name.equals(currentName)) continue;
            hasFollowers = true;
        }
        return followers;
    }

    private Iterator getSubPropertyIterator(PersistentClass pc, String reducedName) {
        Iterator parentPropIter;
        Value value = pc.getRecursiveProperty(reducedName).getValue();
        if (value instanceof Component) {
            Component comp = (Component)value;
            parentPropIter = comp.getPropertyIterator();
        } else if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            PersistentClass referencedPc = this.mappings.getClass(toOne.getReferencedEntityName());
            if (toOne.getReferencedPropertyName() != null) {
                try {
                    parentPropIter = ((Component)referencedPc.getRecursiveProperty(toOne.getReferencedPropertyName()).getValue()).getPropertyIterator();
                }
                catch (ClassCastException e) {
                    throw new MappingException("dotted notation reference neither a component nor a many/one to one", e);
                }
            } else {
                try {
                    if (referencedPc.getIdentifierMapper() == null) {
                        parentPropIter = ((Component)referencedPc.getIdentifierProperty().getValue()).getPropertyIterator();
                    }
                    parentPropIter = referencedPc.getIdentifierMapper().getPropertyIterator();
                }
                catch (ClassCastException e) {
                    throw new MappingException("dotted notation reference neither a component nor a many/one to one", e);
                }
            }
        } else {
            throw new MappingException("dotted notation reference neither a component nor a many/one to one");
        }
        return parentPropIter;
    }

    private static int getIndexOfFirstMatchingProperty(List propertyNames, String follower) {
        int propertySize = propertyNames.size();
        for (int propIndex = 0; propIndex < propertySize; ++propIndex) {
            if (!((String)propertyNames.get(propIndex)).startsWith(follower)) continue;
            return propIndex;
        }
        return -1;
    }
}

