/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.server;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import javax.swing.JButton;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.server.ChatManager;
import org.jboss.remoting.samples.chat.server.ChatManagerLauncher_exitButton_actionAdapter;
import org.jboss.remoting.samples.chat.server.ChatManagerLauncher_launchButton_actionAdapter;
import org.jboss.remoting.samples.chat.server.ChatManagerLauncher_shutDownButton_actionAdapter;
import org.jboss.remoting.samples.chat.utility.Parameters;
import org.jboss.remoting.transport.Connector;

public class ChatManagerLauncher
extends CloseableFrame {
    protected static final Logger log = Logger.getLogger(ChatManagerLauncher.class);
    private static final int PORT = 1969;
    private ChatManager chatManager;
    private InvokerLocator managerLocator;
    private Connector managerConnector;
    private JButton launchButton = new JButton();
    private JButton shutDownButton = new JButton();
    private JButton exitButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ChatManagerLauncher() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Parameters.initParameters(args);
        ChatManagerLauncher chatManagerLauncher = new ChatManagerLauncher();
    }

    private void jbInit() throws Exception {
        this.launchButton.setFont(new Font("SansSerif", 1, 12));
        this.launchButton.setActionCommand("startButton");
        this.launchButton.setText("Launch");
        this.launchButton.addActionListener(new ChatManagerLauncher_launchButton_actionAdapter(this));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.shutDownButton.setFont(new Font("SansSerif", 1, 12));
        this.shutDownButton.setText("Shut down");
        this.shutDownButton.addActionListener(new ChatManagerLauncher_shutDownButton_actionAdapter(this));
        this.exitButton.setFont(new Font("SansSerif", 1, 12));
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ChatManagerLauncher_exitButton_actionAdapter(this));
        this.getContentPane().add((Component)this.launchButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(188, 102, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.shutDownButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(188, 23, 0, 103), 0, 0));
        this.getContentPane().add((Component)this.exitButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(23, 154, 39, 173), 0, 0));
        this.center();
        this.pack();
        this.show();
    }

    void launchButton_actionPerformed(ActionEvent ae) {
        String managerUriString = Parameters.getParameter("chatManagerUri");
        try {
            this.managerLocator = new InvokerLocator(managerUriString);
            log.info("ChatManagerLauncher: manager uri = " + managerUriString);
        }
        catch (MalformedURLException e) {
            log.error("ChatManagerLauncher(): invalid locator uri: " + managerUriString);
            e.printStackTrace();
            System.exit(-1);
        }
        this.managerConnector = new Connector();
        try {
            this.managerConnector.setInvokerLocator(this.managerLocator.getLocatorURI());
            this.managerConnector.create();
            this.chatManager = new ChatManager();
            this.managerConnector.addInvocationHandler("chatManager", this.chatManager);
            this.managerConnector.start();
        }
        catch (Exception e) {
            log.error("Unable to start Connector for chat manager: " + e.getMessage());
            e.printStackTrace();
        }
        log.info("ChatManagerLauncher: created chat manager");
    }

    void shutDownButton_actionPerformed(ActionEvent ae) {
        if (this.chatManager == null) {
            System.out.println("ChatManagerLauncher: chat manager has not been launched");
            return;
        }
        try {
            this.chatManager.shutdown();
            System.out.println("ChatManagerLauncher: shut down chatManager");
        }
        catch (Exception e) {
            System.out.println("ChatManagerLauncher: unable to shut down");
            return;
        }
        System.out.println("ChatManagerLauncher: shut down web server");
    }

    void exitButton_actionPerformed(ActionEvent e) {
        System.exit(0);
    }
}

