/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex.invoker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class MultiplexInvokerServer {
    private SampleInvocationHandler handler;
    private Connector connector = null;

    public void init() throws Exception {
        this.connector = new Connector();
        InvokerLocator locator = new InvokerLocator("multiplex://localhost:9090");
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        this.handler = new SampleInvocationHandler();
        this.connector.addInvocationHandler("sample", this.handler);
        this.connector.start();
        System.out.println("Started server at: " + this.connector.getInvokerLocator());
    }

    public boolean isDone() {
        return this.handler.isDone();
    }

    protected void setUp() throws Exception {
        this.init();
    }

    protected void tearDown() throws Exception {
        if (this.connector != null) {
            this.connector.stop();
            this.connector.destroy();
        }
    }

    public static void main(String[] args) {
        MultiplexInvokerServer test = new MultiplexInvokerServer();
        try {
            test.setUp();
            while (!test.isDone()) {
                Thread.sleep(1000L);
            }
            test.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler,
    Runnable {
        private List listeners = new ArrayList();
        private boolean didCallbacks = false;

        public SampleInvocationHandler() {
            Thread callbackThread = new Thread(this);
            callbackThread.setDaemon(true);
            callbackThread.start();
        }

        public Object invoke(InvocationRequest invocation) throws Throwable {
            System.out.println("Invocation request is: " + invocation.getParameter());
            return invocation.getParameter();
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
            System.out.println("Adding callback listener.");
            this.listeners.add(callbackHandler);
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
            System.out.println("Removing callback listener.");
            this.listeners.remove(callbackHandler);
        }

        public void run() {
            while (this.listeners.isEmpty()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            for (int i = 0; i < 2; ++i) {
                Callback callback = new Callback(new Integer(29 * (i + 1)));
                System.out.println("generating callback value: " + callback.getCallbackObject());
                ArrayList localListeners = new ArrayList(this.listeners);
                Iterator itr = localListeners.iterator();
                while (itr.hasNext()) {
                    InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
                    try {
                        callbackHandler.handleCallback(callback);
                    }
                    catch (HandleCallbackException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ignored) {}
                }
            }
            this.didCallbacks = true;
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }

        public boolean isDone() {
            return this.didCallbacks;
        }
    }
}

