/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class TypeInfoCache {
    private static final Map _pgNameToSQLType;
    private Map _pgNameToJavaClass;
    private Map _oidToPgName;
    private Map _pgNameToOid;
    private Map _pgNameToPgObject;
    private BaseConnection _conn;
    private PreparedStatement _getOidStatement;
    private PreparedStatement _getNameStatement;
    private static final Object[][] types;
    static /* synthetic */ Class class$0;

    static {
        types = new Object[][]{{"int2", new Integer(21), new Integer(5), "java.lang.Short"}, {"int4", new Integer(23), new Integer(4), "java.lang.Integer"}, {"oid", new Integer(26), new Integer(4), "java.lang.Integer"}, {"int8", new Integer(20), new Integer(-5), "java.lang.Long"}, {"money", new Integer(790), new Integer(8), "java.lang.Double"}, {"numeric", new Integer(1700), new Integer(2), "java.math.BigDecimal"}, {"float4", new Integer(700), new Integer(7), "java.lang.Float"}, {"float8", new Integer(701), new Integer(8), "java.lang.Double"}, {"bpchar", new Integer(1042), new Integer(1), "java.lang.String"}, {"varchar", new Integer(1043), new Integer(12), "java.lang.String"}, {"text", new Integer(25), new Integer(12), "java.lang.String"}, {"name", new Integer(19), new Integer(12), "java.lang.String"}, {"bytea", new Integer(17), new Integer(-2), "java.io.InputStream"}, {"bool", new Integer(16), new Integer(-7), "java.lang.Boolean"}, {"bit", new Integer(1560), new Integer(-7), "java.lang.Boolean"}, {"date", new Integer(1082), new Integer(91), "java.sql.Date"}, {"time", new Integer(1083), new Integer(92), "java.sql.Time"}, {"timetz", new Integer(1266), new Integer(92), "java.sql.Time"}, {"timestamp", new Integer(1114), new Integer(93), "java.sql.Timestamp"}, {"timestamptz", new Integer(1184), new Integer(93), "java.sql.Timestamp"}};
        HashMap<Object, Object> pgNameToSQLType = new HashMap<Object, Object>();
        int i = 0;
        while (i < types.length) {
            pgNameToSQLType.put(types[i][0], types[i][2]);
            String arrayType = "_" + types[i][0];
            pgNameToSQLType.put(arrayType, new Integer(2003));
            ++i;
        }
        _pgNameToSQLType = Collections.unmodifiableMap(pgNameToSQLType);
    }

    public TypeInfoCache(BaseConnection conn) {
        this._conn = conn;
        this._oidToPgName = new HashMap();
        this._pgNameToOid = new HashMap();
        this._pgNameToJavaClass = new HashMap();
        this._pgNameToPgObject = new HashMap();
        int i = 0;
        while (i < types.length) {
            this._pgNameToJavaClass.put(types[i][0], types[i][3]);
            this._pgNameToOid.put(types[i][0], types[i][1]);
            this._oidToPgName.put(types[i][1], types[i][0]);
            String arrayType = "_" + types[i][0];
            this._pgNameToJavaClass.put(arrayType, "java.sql.Array");
            ++i;
        }
    }

    public synchronized void addDataType(String type, Class klass) throws SQLException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.postgresql.util.PGobject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(klass)) {
            throw new PSQLException(GT.tr("The class {0} does not implement org.postgresql.util.PGobject.", klass.toString()), PSQLState.INVALID_PARAMETER_TYPE);
        }
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    public static Iterator getPGTypeNamesWithSQLTypes() {
        return _pgNameToSQLType.keySet().iterator();
    }

    public int getSQLType(int oid) throws SQLException {
        return TypeInfoCache.getSQLType(this.getPGType(oid));
    }

    public static int getSQLType(String pgTypeName) {
        Integer i = (Integer)_pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        return 1111;
    }

    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = (Integer)this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT oid FROM pg_catalog.pg_type WHERE typname = ?" : "SELECT oid FROM pg_type WHERE typname = ?";
        if (this._getOidStatement == null) {
            this._getOidStatement = this._conn.prepareStatement(sql);
        }
        this._getOidStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this._getOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        oid = new Integer(0);
        ResultSet rs = this._getOidStatement.getResultSet();
        if (rs.next()) {
            oid = new Integer(rs.getInt(1));
            this._oidToPgName.put(oid, pgTypeName);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = (String)this._oidToPgName.get(new Integer(oid));
        if (pgTypeName != null) {
            return pgTypeName;
        }
        String sql = this._conn.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type WHERE oid = ?" : "SELECT typname FROM pg_type WHERE oid = ?";
        if (this._getNameStatement == null) {
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            pgTypeName = rs.getString(1);
            this._pgNameToOid.put(pgTypeName, new Integer(oid));
            this._oidToPgName.put(new Integer(oid), pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    public synchronized Class getPGobject(String type) {
        return (Class)this._pgNameToPgObject.get(type);
    }

    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        return (String)this._pgNameToJavaClass.get(pgTypeName);
    }
}

