package jp.sourceforge.gnp.prorate.fcalc;

%%

%{
  public boolean	get_end = false;
  public boolean	hpn_end = false;
  static final int	DATE = 257;
  static final int	FC = 258;
  static final int	PLACE = 260;
  static final int	PLACENOSTOP = 261;
  static final int	PLACENOSTOP2 = 262;
  static final int	PLACESPECIAL = 263;	/* No Use */
  static final int	PLACEEMA = 264;
  static final int	PLACERMR = 265;
  static final int	PLACENOPASS = 266;
  static final int	CARRIER = 270;
  static final int	CARRIERROUTE = 271;
  static final int	WALK = 272;
  static final int	MILEAGE = 280;
  static final int	MILEAGE1SECT = 281;
  static final int	MILEAGE2 = 282;
  static final int	ROUTE = 283;
  static final int	DIFF = 290;
  static final int	DIFF2 = 291;
  static final int	DIFFREV = 292;
  static final int	DIFFREV2 = 293;
  static final int	DIFFADT = 294;
  static final int	DIFFFCADT = 295;
  static final int	DIFFFADT = 296;
  static final int	DIFFCADT = 297;
  static final int	STOPOVER = 300;
  static final int	SECURE = 301;
  static final int	PLUSNORMAL = 310;
  static final int	PLUS1SECT = 312;
  static final int	PLUS2SECT = 315;
  static final int	PLUSHALFRT = 317;
  static final int	LESS = 318;
  static final int	LOWESTCOMBI = 319;
  static final int	LOWESTCOMBI2 = 320;
  static final int	MEQUALIZE = 321;
  static final int	PLUSYSECT = 322;
  static final int	PLUSLOWCOMBI = 323;	/* ;;; add '95.03.02	*/
  static final int	TOTAL  = 324;
  static final int	EXTRASEAT = 330;
  static final int	INCTOUR = 331;
  static final int	BINCTOUR = 332;
  static final int	END  = 340;
  static final int	END_ROE = 341;
  static final int	ROE  = 342;
  static final int	XT = 343;
  static final int	FTAX = 344;
  static final int	XFTAX = 345;
  static final int	INCTOUR2 = 346;	/* /IT */
  static final int	TOTAL2 = 347;	/* ̲ߥɡסܡ/IT */
  public int	getPos() {
    return	yychar + yytext().length();
  }
%}

%integer

%char

%debug

SPC = ([ \t\n]*)
PLC = ([A-Z]{3})
CAR = ([A-Z]{2}|[0-9][A-Z]|[A-Z][0-9])
SECT = {PLC}{SPC}{PLC}
AMT = ([0-9.]+)
CCY = ([A-Z]{3})
PLUS = (P|H|U)
PSECT = {SPC}{SECT}
PAMT = {SPC}{AMT}
DAT = ([0-9][0-9]?([A-Z]{3})(([0-9]{2})*))
NMSP = ([0-9]*|[0-9]+{SPC})
LPAREN = "("
RPAREN = ")"

%state placeinput carrierinput endstate taxstate

%%

<YYINITIAL> {
  {DAT}	{
    yybegin(placeinput);
    return DATE;
  }
  FC	{
    yybegin(placeinput);
    return FC;
  }
  {PLC}	{
    yybegin(carrierinput);
    return PLACE;
  }
  [ \t\n]	{
    /* space and tab are ignored */
  }
}

SITI\/?		{
  ;
}
SOTO\/?		{
  ;
}

" "\r\n		{
  /* \r\nפ̵ */
  ;
}

(\/FC-SOTO|\/FCSOTO|FC-SOTO|\/FC\ SOTO|FC\ SOTO|\/FC-SOTI|\/FCSOTI|FC-SOTI|\/FC\ SOTI|FC\ SOTI|\/FC-SITO|\/FCSITO|FC-SITO|\/FC\ SITO|FC\ SITO|\/FC-SITI|\/FCSITI|FC-SITI|\/FC\ SITI|FC\ SITI|\/FC-|\/FC|FC-|\/FC|FC)						{
  /* /FCסFC-SOTO̵ */
  ;
}
(\ Z\ )		{
  /*  Z פ̵ */
  ;
}

END	{
  get_end = true;
  hpn_end = true;
  yybegin(endstate);
  return END;
}

<placeinput> {
  {PLC}	{
    yybegin(carrierinput);
    return PLACE;
  }
  C\/{PLC}	{
    yybegin(carrierinput);
    return LOWESTCOMBI2;
  }
  X\/{PLC}	{
    yybegin(carrierinput);
    return PLACENOSTOP;
  }
  X\/[A-Z]*E\/{PLC}	{
    yybegin(carrierinput);
    return PLACENOSTOP2;
  }
  E\/{PLC}	{
    yybegin(carrierinput);
    return PLACEEMA;
  }
  L\/{PLC}	{
    yybegin(carrierinput);
    return PLACERMR;
  }
  T\/{PLC}	{
    /* ;;; add '94.01.27	*/
    yybegin(carrierinput);
    return PLACERMR;
    /* ;;; not exactly RMR, just ignored	*/
  }
  ROE{PAMT}	{
    if (!get_end){
      yybegin(endstate);
      get_end = true;
      return END_ROE;
    }
    else{
      return ROE;
    }
  }
  [ \t\n]	{
    /* space and tab are ignored */
  }
}

<carrierinput> {
  E\/XXX		 ; 		/* yama */
  {LPAREN}{PLC}{RPAREN}	{
    yybegin(carrierinput);
    return PLACENOPASS;
  }
  {CAR}	{
    yybegin(placeinput);
    return CARRIER;
  }
  {CAR}{SPC}[ (]([A-Z]{2})[)>]	{
    yybegin(placeinput);
    return CARRIERROUTE;
  }
  \/(\-|\/)	{
    yybegin(placeinput);
    return WALK;
  }
  {NMSP}M{PAMT}	{
    return MILEAGE;
  }
  {NMSP}M{LPAREN}([A-Z]{2}){RPAREN}{PAMT}	{
    /* ;;; add '94.01.27 */
    return MILEAGE;
    /* not exactly MILEAGE,"(TS)"ignored */
  }
  {NMSP}M{PAMT}{SPC}FREE	{
    /* ;;; add '94.01.27	*/
    return MILEAGE;
  }
  {NMSP}M{PSECT}{PAMT}	{
    return MILEAGE1SECT;
  }
  {AMT}	{
    return MILEAGE2;
  }
  {AMT}{SPC}FREE	{
    /* ;;; add '95.02.27	*/
    return MILEAGE2;
  }
  R{PAMT}	{
    return ROUTE;
  }
  R{PAMT}{SPC}FREE	{
    /* ;;; add '94.01.27	*/
    return ROUTE;
  }
  D{PSECT}{PAMT}	{
    return DIFF;
  }
  D{PSECT}{SPC}{NMSP}M{PAMT}	{
    return DIFF2;
  }
  D\-{PSECT}{PAMT}	{
    return DIFFREV;
  }
  D\-{PSECT}{SPC}{NMSP}M{PAMT}	{
    return DIFFREV2;
  }
  D{PSECT}{SPC}{NMSP}M{PSECT}{PAMT}	{
    return DIFFADT;
    /*    ADT means Actual Direction of Travel.    */
  }
  D{PSECT}{SPC}{NMSP}M{SPC}F\/{PSECT}{SPC}C\/{PSECT}{PAMT}	{
    return DIFFFCADT;
  }
  D{PSECT}{SPC}{NMSP}M{SPC}F\/{PSECT}{PAMT}	{
    return DIFFFADT;
  }
  D{PSECT}{SPC}{NMSP}M{SPC}C\/{PSECT}{PAMT}	{
    return DIFFCADT;
  }
  {NMSP}S{PAMT}	{
    return STOPOVER;
  }
  Q{PAMT}	{
    return SECURE;
  }
  {PLUS}{PAMT}	{
    /* ;;; '95.02.27 PLUS changed	*/
    return PLUSNORMAL;
  }
  {PLUS}{PSECT}{PAMT}	{
    return PLUS1SECT;
  }
  {PLUS}{PSECT}{PSECT}{PAMT}	{
    return PLUS2SECT;
  }
  {PLUS}{SPC}R\/{PLC}{PAMT}	{
    return PLUSHALFRT;
  }
  {PLUS}{SPC}R\/{PLC}\/{PLC}{PAMT}	{
    /* ;;; add '94.01.27 */
    return PLUSHALFRT;
    /* not exactly HALFRT, {PLC} ignored */
  }
  {PLUS}{SPC}Y{SPC}{PSECT}{PAMT}	{
    return PLUSYSECT;
  }
  {PLUS}{SPC}C\/{PLC}{PSECT}{PAMT}	{
    /* ;;; add '95.03.02	*/
    return PLUSLOWCOMBI;
  }
  LESS{PAMT}	{
    /* ;;; '95.02.27 PLUS change end	*/
    return LESS;
  }
  C\/{PLC}	{
    return LOWESTCOMBI;
  }
  B\/{PLC}	{
    return MEQUALIZE;
    /*	;;; I don't know what's this */
  }
  EXST{SPC}[A-Z]+{PAMT}	{
    return EXTRASEAT;
    /*	;;; I don't know
	;;; what to do about this */
  }
  M\/IT	{
    /* M/ITפλM100.00פȲ᤹ */
    return INCTOUR;
  }
  M\/BT	{
    return BINCTOUR;
    /*	;;; I don't know what's this */
  }

  \/IT	{
    /* /ITפλM100.00פȲ᤹ */
    return INCTOUR2;
  }

  ROE{PAMT}	{
    if (!get_end){
      yybegin(endstate);
      get_end = true;
      return END_ROE;
    }
    else{
      return ROE;
    }
  }
  {CCY}{SPC}{PAMT}	{
    return TOTAL;
  }
  TTL{SPC}NUC{PAMT}	{
    /* ;;; add '95.03.06 keichitsu */
    return TOTAL;
  }

  {CCY}{SPC}\/IT	{
    /* ̲ߥɡסܡ/ITפλ̲ߥɡסܡx00.00פȲ᤹ */
    return TOTAL2;
  }
  [ \t\n]	{
    /* space and tab are ignored */
  }
}

XT	{
  /* ;;; add 940118	*/
  yybegin(taxstate);
  return XT;
}
{PAMT}XF	{
  /* ;;; add 940127	*/
  yybegin(taxstate);
  return FTAX;
}

<endstate> {
  ROE{PAMT}	{
    if (!get_end){
      yybegin(endstate);
      get_end = true;
      return END_ROE;
    }
    else{
      return ROE;
    }
  }
  XF	{
    /* ;;; add 940119	*/
    yybegin(taxstate);
    return XFTAX;
  }
  .	{
    /* after end or tax are ignored	'95.02.27 */
  }
  [ \t\n]	{
    /* space and tab are ignored */
  }
}

<taxstate> {
  {CCY}{SPC}{PAMT}([A-Z]{2})	{
    return FTAX;
  }
  {PAMT}([A-Z]{2})	{
    return FTAX;
  }
  ([A-Z]{2}){PAMT}	{
    /* ;;; add 940119	*/
    return FTAX;
  }
  {PLC}[0-9]	{
    /* ;;; add 940118	*/
    return XFTAX;
  }
  {PLC}[0-9]/{SPC}{PLC}[0-9]	{
    /* ;;; add 940120	*/
    return XFTAX;
  }
  XF	{
    /* ;;; add 940119	*/
    return XFTAX;
  }
  . {
    /* after end or tax are ignored	'95.02.27 */
  }
  [ \t\n]	{
    /* space and tab are ignored */
  }
}

.	{
  return yytext().charAt(0);
}

[ \t\n]	{
  /* space and tab are ignored */
}
