// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ejb.EJB;

import jp.sourceforge.gnp.dcheck.ejb.interfaces.CheckEjb;

/**
 * class <code>DcheckClientEjb</code>
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
class DcheckClientEjb {

  static final String	DEFAULT_DATE = "20060401";

  static String	checkDate = DEFAULT_DATE;

  /**
   * variable <code>dcheck</code>	CheckEjb EJB3 object
   *
   */
  @EJB
    CheckEjb	dcheck = null;

  DcheckClientEjb() throws Exception {
    super();
    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    Object ref = null;
    try {
      ref = context.lookup(CheckEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    dcheck = (CheckEjb)ref;
  }
  
  public static void	main(String [] args) {
    if (args.length < 2) {
      System.err.println("usage : java DcheckClientEjb command arg [date]");
      return;
    }
    String	command = args[0];
    String	arg = args[1];
    if (args.length > 2) {
      checkDate = args[2];
    }
    DcheckClientEjb	client = null;
    try {
      client = new DcheckClientEjb();
    }
    catch (Exception e) {
      System.err.println("error in creating DcheckClientEjb() : "
			 + e.getMessage());
    }
    if (client == null) {
      return;
    }

    CheckEjb	dcheck = null;
    try {
      dcheck = client.dcheck;
    }
    catch (Exception e) {
      System.err.println("error in get dcheck from DcheckClientEjb instance : "
			 + e.getMessage());
      return;
    }

    boolean retval = false;
    try {
      if (command.equals("place")) {
	retval = dcheck.checkPlace(arg, checkDate);
      }
      else {
	retval = dcheck.checkAirwayId(arg, checkDate);
      }
    }
    catch (Exception e) {
      System.err.println("error in check " + command + " for " + arg + " : "
			 + e.getMessage());
      return;
    }
    System.out.println("check " + command + " for " + arg + " : " + retval);
  }

}
