// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

import jp.sourceforge.gnp.dcheck.dwr.CheckManager;
import jp.sourceforge.gnp.dcheck.dwr.DCheck;

/**
 * class <code>CheckManagerTest</code>
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
class CheckManagerTest {
  public static void	main(String [] args) {
    if (args.length < 2) {
      System.err.println("usage : java CheckManagerTest command arg");
      return;
    }
    String	command = args[0];
    String	arg = args[1];
    DCheck	retval = null;
    try {
      if (command.equals("place")) {
	retval = CheckManager.checkPlace(arg, 0);
      }
      else {
	retval = CheckManager.checkAirwayId(arg, 0);
      }
    }
    catch (Exception e) {
      System.err.println("error in check " + command + " for " + arg + " : "
			 + e.getMessage());
      return;
    }
    System.out.println("check " + command + " for " + arg + " : "
		       + retval.isRet() + "[" + retval.getValue() + "] ("
		       + retval.getElementId() + ")");
  }
}
