// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.ejb.client.ProrateEjbClient;

/**
 * <code>ProrateClientFileEjb</code>
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
class ProrateClientFileEjb extends ProrateTestFile {

  /**
   * variable <code>prorate</code>	ProrateEjb EJB3 object
   *
   */
  ProrateEjb	prorate = null;

  ProrateClientFileEjb() {
    super();
  }
  
  ProrateClientFileEjb(String filename) throws Exception {
    super(filename);
    prorate = ProrateEjbClient.makeInstance();
  }

  public static void	main(String [] args) {
    ProrateClientFileEjb	client = null;
    try {
      if (args.length > 0) {
	client = new ProrateClientFileEjb(args[0]);
      }
      else {
	client = new ProrateClientFileEjb("test_ticket");
      }
    }
    catch (Exception e) {
      System.err.println("error in creating ProrateClientFileEjb() : "
			 + e.getMessage());
    }
    if (client == null) {
      return;
    }

    // int	traceLevel = 10;	/* ;;; deBug */
    int	traceLevel = 10000;	/* ;;; deBug */
    if (args.length > 1) {
      traceLevel = Integer.parseInt(args[1]);
    }

    client.inputAudit();
    client.printAudit();

    client.audit.setTraceLevel(traceLevel);
    System.err.println("traceLevel = " + client.audit.getTraceLevel());

    ProrateEjb	prorate = null;
    try {
      prorate = client.prorate;
    }
    catch (Exception e) {
      String	errorString = e.getMessage();
      if (errorString == null) {
	errorString = e.toString();
      }
      StackTraceElement[]	traces = e.getStackTrace();
      for (int i = 0; i < traces.length; i++) {
	errorString += "\n" + traces[i].toString();
      }
      client.audit.setErrorString(errorString);
      if (client.audit != null) {
	client.printAudit();
      }
      return;
    }

    try {
      client.audit = prorate.prorate(client.audit);
    }
    catch (Exception e) {
      String	errorString = e.getMessage();
      if (errorString == null) {
	errorString = e.toString();
      }
      StackTraceElement[]	traces = e.getStackTrace();
      for (int i = 0; i < traces.length; i++) {
	errorString += "\n" + traces[i].toString();
      }
      client.audit.setErrorString(errorString);
    }
    if (client.audit != null) {
      client.printAudit();
    }
  }

}
