// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.


import jp.sourceforge.gnp.prorate.rmi.RemoteProrateClient;


class ProrateClientFileRmi extends ProrateTestFile {
  ProrateClientFileRmi() {
    super();
  }
  
  ProrateClientFileRmi(String filename) {
    super(filename);
  }

  public static void	main(String [] args) {
    ProrateClientFileRmi	client = null;
    if (args.length > 0) {
      client = new ProrateClientFileRmi(args[0]);
    }
    else {
      client = new ProrateClientFileRmi("test_ticket");
    }
    if (client == null) {
      return;
    }

    int	traceLevel = 10;	/* ;;; deBug */
    if (args.length > 1) {
      traceLevel = Integer.parseInt(args[1]);
    }

    client.inputAudit();
    client.printAudit();

    client.audit.setTraceLevel(traceLevel);
    System.err.println("traceLevel = " + client.audit.getTraceLevel());

    RemoteProrateClient	prorate = null;
    try {
      prorate = new RemoteProrateClient();
    }
    catch (Exception e) {
      String	errorString = e.getMessage();
      if (errorString == null) {
	errorString = e.toString();
      }
      StackTraceElement[]	traces = e.getStackTrace();
      for (int i = 0; i < traces.length; i++) {
	errorString += "\n" + traces[i].toString();
      }
      client.audit.setErrorString(errorString);
      if (client.audit != null) {
	client.printAudit();
      }
      return;
    }

    try {
      client.audit = prorate.prorate(client.audit);
    }
    catch (Exception e) {
      String	errorString = e.getMessage();
      if (errorString == null) {
	errorString = e.toString();
      }
      StackTraceElement[]	traces = e.getStackTrace();
      for (int i = 0; i < traces.length; i++) {
	errorString += "\n" + traces[i].toString();
      }
      client.audit.setErrorString(errorString);
    }
    prorate = null;
    
    if (client.audit != null) {
      client.printAudit();
    }
  }

}
