// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.


import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.List;

import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
/* ;;; deBug
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceFile;
*/
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;


class ProrateTestFile {
  BufferedReader	stream;

  /**
   * 
   * @uml.property name="audit"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  ProrateAudit	audit;
  /**
   * variable <code>ticketNumber</code>	ticket number
   *
   */
  String	ticketNumber;
  /**
   * variable <code>coupon</code>	coupon number
   *
   */
  int	ticketCoupon = -1;

  ProrateTestFile() {
    super();
    stream = null;
    audit = new ProrateAudit();
  }

  ProrateTestFile(String filename) {
    super();
    FileInputStream	in = null;
    try {
      in = new FileInputStream(filename);
    }
    catch (FileNotFoundException e) {
      System.out.print(filename);
      System.out.println(" not found");
      System.exit(100);
    }
    stream = new BufferedReader(new InputStreamReader(in));
    audit = new ProrateAudit();
  }

  void	inputAudit() {
    String	str = "";
    StringTokenizer getTok;

    /* ;;; outward is default */
    audit.setOwnAudit(false);
    audit.setInward(false);
    audit.setTicketing(false);
    audit.setNotRuleApply(false);
    audit.setNonProrateRest(false);
    audit.setOneComponent(false);
    audit.setIgnoreFareCalc(false);
    audit.setTourCode("");
    audit.setAgentCode("");

    str = readLine("ticket_number etc :");
    getTok = new StringTokenizer(str);
    if (getTok.hasMoreTokens()) {
      ticketNumber = getTok.nextToken();
      audit.setAirwayNumber(ticketNumber.substring(0, 3));
    }
    if (getTok.hasMoreTokens()) {
      ticketCoupon = Integer.parseInt(getTok.nextToken());
    }
    if (ticketCoupon < 0) {
      audit.setOwnAudit(true);
      audit.setTicketing(true);
    }
    if (getTok.hasMoreTokens()) {
      audit.setInwardNumber(getTok.nextToken());
    }
    else {
      audit.setInwardNumber("");
    }
    if (!audit.getInwardNumber().equals("")
	&& !audit.getInwardNumber().equals("0")
	&& !audit.getInwardNumber().equals("-1")) {
      audit.setOwnAudit(true);
      audit.setInward(true);
    }

    str = readLine("endorsement :");
    audit.setEndorsement(str);

    str = readLine("place_issue, date of issue :");
    getTok = new StringTokenizer(str);
    if (getTok.hasMoreTokens()) {
      audit.setIssuePlace(getTok.nextToken());
    }
    if (getTok.hasMoreTokens()) {
      audit.setIssueDate(getTok.nextToken());
    }
    if (audit.getIssueDate().length() >= 6) {
      audit.setInvoiceMonth(audit.getIssueDate().substring(0, 6));
    }
    else {
      audit.setInvoiceMonth(audit.getIssueDate());
    }

    str = readLine("origin, destination :");

    audit.setCurrency("");
    audit.setTicketFare((double)0);
    audit.setTotalNuc((double)0);
    audit.setStopOverCharge((double)0);
    audit.setSalesCurrency("");
    audit.setSalesFare((double)0);

    str = readLine("fare, total nuc :");
    getTok = new StringTokenizer(str);
    if (getTok.hasMoreTokens()) {
      audit.setCurrency(getTok.nextToken());
    }
    if (getTok.hasMoreTokens()) {
      audit.setTicketFare(Double.parseDouble(getTok.nextToken()));
    }
    if (getTok.hasMoreTokens()) {
      audit.setTotalNuc(Double.parseDouble(getTok.nextToken()));
    }
    if (getTok.hasMoreTokens()) {
      audit.setStopOverCharge(Double.parseDouble(getTok.nextToken()));
    }
    /*
    if (audit.isOwnAudit()) {
      audit.setSalesCurrency(audit.getCurrency());
      audit.setSalesFare(audit.getTicketFare());
    }
    */
    if (audit.isOwnAudit() && audit.isTicketing()) {
      if (audit.getSalesCurrency().equals("")) {
	audit.setSalesCurrency(audit.getCurrency());
      }
      if (audit.getSalesFare() == (double)0) {
	audit.setSalesFare(audit.getTicketFare());
      }
    }

    audit.setCommissionCurrency(audit.getCurrency());
    audit.setCommissionRate((double)9);
    audit.setCommissionAmt((double)0);
    audit.setRoeRate((double)0);
    audit.setDay5Rate((double)0);
    audit.setLessAmt((double)0);
    audit.setPlusAdjustment((double)0);
    audit.setLessAdjustment((double)0);

    str = readLine("tax :");
    getTok = new StringTokenizer(str);
    if (getTok.hasMoreTokens()) {
      audit.setNotDivideTax(false);
      int	taxes = 0;
      List	taxMiscs = (List<ProrateTaxData>)new Vector();
      List	tax3 = (List<ProrateTaxData>)new Vector();
      while (getTok.hasMoreTokens()) {
	String	taxStr = getTok.nextToken();
	/* ;;; indicator is ':'
	String	taxType = taxStr.substring(0, 2);
	String	taxAmountStr = taxStr.substring(3);
	*/
	int	index = taxStr.indexOf(':');
	int	padding = 1;
	if (index < 0) {
	  index = 2;
	  padding = 0;
	}
	String	taxType = taxStr.substring(0, index);
	String	taxAmountStr = taxStr.substring(index+padding);
	double	taxAmount = Double.parseDouble(taxAmountStr);
	ProrateTaxData	tax = new ProrateTaxData();
	tax.setType(taxType);
	tax.setAmount(taxAmount);
	taxMiscs.add(tax);
	if (taxes < 3) {
	  ProrateTaxData	tax3Data = new ProrateTaxData();
	  tax3Data.setType(taxType);
	  tax3Data.setAmount(taxAmount);
	  tax3.add(tax3Data);
	}
	taxes++;
      }
      ProrateTaxData[] taxMiscsArray = new ProrateTaxData[taxMiscs.size()];
      ProrateTaxData[] tax3Array = new ProrateTaxData[tax3.size()];
      for (int i = 0; i < taxMiscs.size(); i++) {
	taxMiscsArray[i] = (ProrateTaxData)taxMiscs.get(i);
      }
      for (int i = 0; i < tax3.size(); i++) {
	tax3Array[i] = (ProrateTaxData)tax3.get(i);
      }
      audit.setTaxMisc(taxMiscsArray);
      audit.setTax(tax3Array);
    }

    str = readLine("fare calculation :");
    audit.setFareCalculation(str);

    audit.setFixedFare((double)0);

    audit.setPlusFlg(false);
    audit.setOwnAirwayId("");

    List	sectors = new Vector();
    audit.setComponents(null);
    audit.setAskTable(null);

    str = readLine(" number of sectors :");
    int	noSectors = Integer.parseInt(str);

    for (int i = 0; i < noSectors; i++) {
      ProrateSector	sector = new ProrateSector();
      
      if (i == ticketCoupon) {
	sector.setInvoiceFlg(true);
      }
      else {
	sector.setInvoiceFlg(false);
      }

      sector.setSequenceNo(i);
      sector.setProrateValue((double)0);
      sector.setInvoiceValue((double)0);

      sector.setComponentIndex(0);
      sector.setComponentKind(0);
      sector.setFareComponent((double)0);
      sector.setSecureCharge((double)0);
      sector.setSecureIndex(0);
      sector.setClassDiffPlus((double)0);
      sector.setClassDiffIndex(0);

      str = readLine("sector info :");
      getTok = new StringTokenizer(str);
      if (getTok.hasMoreTokens()) {
	String	from = getTok.nextToken();
	if (from.substring(0, 2).equals("X/")) {
	  sector.setStopOver((byte)'X');
	  sector.setDepCode(from.substring(2));
	}
	else {
	  sector.setDepCode(from);
	}
      }
      if (getTok.hasMoreTokens()) {
	getTok.nextToken();	/* skip '-' */
      }
      if (getTok.hasMoreTokens()) {
	String	to = getTok.nextToken();
	if (to.substring(0, 2).equals("X/")) {
	  sector.setStopOver((byte)'X');
	  sector.setDestCode(to.substring(2));
	}
	else {
	  sector.setDestCode(to);
	}
      }
      if (getTok.hasMoreTokens()) {
	sector.setFareBasis(getTok.nextToken());
      }
      if (getTok.hasMoreTokens()) {
	sector.setCarrier(getTok.nextToken());
      }
      if (getTok.hasMoreTokens()) {
	sector.setClassOfService(getTok.nextToken());
      }
      if (getTok.hasMoreTokens()) {
	String	fareComponent = getTok.nextToken();
	sector.setFareComponent(Double.parseDouble(fareComponent));
	if (sector.getFareComponent() == (double)-2) {
	  sector.setFareComponent((double)0);
	}
	else if (sector.getFareComponent() == (double)0) {
	  sector.setFareComponent((double)-1);
	}
      }
      if (getTok.hasMoreTokens()) {
	String	flight_date = getTok.nextToken();
	int	slash = flight_date.indexOf('/');
	if (slash >= 0) {
	  int	month = Integer.parseInt(flight_date.substring(0, slash));
	  int	day = 0;
	  if (flight_date.length() > slash + 1) {
	    day = Integer.parseInt(flight_date.substring(slash+1));
	  }
	  String	date =
	    (audit.getIssueDate().substring(0, 4)
	     + (month < 10 ? "0" : "") + month
	     + (day < 10 ? "0" : "") + day);
	  sector.setFlightDate(date);
	}
	else if (flight_date.length() >= 6) {
	  sector.setFlightDate(flight_date);
	}
	else if (flight_date.length() >= 5) {
	  sector.setFlightDate((audit.getIssueDate().substring(0, 4)
				+ flight_date.substring(0, 2)
				+ flight_date.substring(3, 5)));
	}
	else {
	  sector.setFlightDate((audit.getIssueDate().substring(0, 4)
				+ flight_date.substring(0, 2) + "01"));
	}
      }
      if (getTok.hasMoreTokens()) {
	String	secureCharge = getTok.nextToken();
	sector.setSecureCharge(Double.parseDouble(secureCharge));
	if (sector.getSecureCharge() > (double)0) {
	  sector.setSecureIndex('Q');
	}
	else {
	  sector.setSecureIndex(0);
	}
      }
      if (getTok.hasMoreTokens()) {
	String	classDiffPlus = getTok.nextToken();
	sector.setClassDiffPlus(Double.parseDouble(classDiffPlus));
      }
      if (getTok.hasMoreTokens()) {
	String	isClassDiff = getTok.nextToken();
	if (Integer.parseInt(isClassDiff) > 1) {
	  sector.setClassDiffIndex('D');
	}
      }
      if (getTok.hasMoreTokens()) {
	String	sideTripIndex = getTok.nextToken();
	sector.setSideTripIndex(Integer.parseInt(sideTripIndex));
	if (sector.getSideTripIndex() > 0) {
	  sector.setSideTripPlus(sector.getFareComponent());
	  sector.setFareComponent((double)-1);
	}
      }
      if (getTok.hasMoreTokens()) {
	sector.setFlightNo(getTok.nextToken());
      }

      sector.setStopOverPlus((double)0);
      sector.setProrateFactor((double)0);
      sector.setCommission((double)0);
      sector.setAmountInLocal((double)0);
      sector.setClassDiffIndex(0);
      sector.setViaRouting("");
      sector.setProrationType(0);
      sector.setCertainty((double)1);
      sector.setSpaBaseAmtType("");
      sector.setSpaBaseAmt((double)0);
      sector.setSpaDay5Rate((double)0);
      sector.setSpaDiscountRate((double)0);
      sector.setSpaClassDiff((double)0);
      sector.setNpPvalues((double)0);
      sector.setApdpBaseAmtType("");
      sector.setApdpBaseAmt((double)0);
      sector.setApdpDay5Rate((double)0);
      sector.setApdpDiscountRate((double)0);
      sector.setApdpClassDiff((double)0);
      sector.setProratedClassDiff((double)0);
      sector.setExstPlus((double)0);
      sector.setProratedExstPlus((double)0);
      sector.setSpaNuc((double)0);
      sector.setApdpNuc((double)0);
      sector.setSrpNuc((double)0);
      sector.setFixedFareCheck((double)0);
      sector.setFixedFareDiscount((double)0);
      sector.setFixCurrency("");
      sector.setFixValue((double)0);
      sector.setOpCarrier("");
      sector.setErrorFlag(0);
      sector.setErrorString("");

      sectors.add(sector);
    }
    ProrateSector[]	sectorsArray = new ProrateSector[sectors.size()];
    for (int j = 0; j < sectors.size(); j++) {
      sectorsArray[j] = (ProrateSector)sectors.get(j);
    }
    audit.setSectors(sectorsArray);
  }

  private String	readLine(String message) {
    String	str = "";
    System.err.println(message);
    try {
      str = stream.readLine();
    } catch(IOException e) {
      System.out.println("IO Error");
      System.exit(100);
    }
    if (str == null) {
      return "";
    }
    System.err.println(str);	/* ;;; deBug */
    return str;
  }
  
  void	printAudit() {
    PrintStream	out = System.out;
    out.println("<" + (audit.isInward() ? "Inw" :
                       (audit.isOwnAudit() ? "Own" : "Out"))
		+ ">TICKET# " + ticketNumber);
    out.println("ISSUED BY "
		+ audit.getAirwayNumber() + ":" + audit.getAirwayId());
    out.println("ENDORSE: " + audit.getEndorsement()
		+ "	DATE OF ISSUE: " + audit.getIssueDate()
		+ "	PLACE: " + audit.getIssuePlace());
    out.println("FARE: " + audit.getCurrency() + " " + audit.getTicketFare()
		+ " SALES: "
		+ audit.getSalesCurrency() + " " + audit.getSalesFare()
		+ " TOTAL-NUC: " + audit.getTotalNuc());
    out.println("COMMISSION: " + audit.getCommissionCurrency()
		+ " " + audit.getCommissionAmt()
		+ " rate " + audit.getCommissionRate());
    /* ;;; not implemented for tax */
    out.println("");
    out.println("ERROR: "
		+ audit.getErrorFlag() + " " + audit.getErrorString());
    out.println("from - to car rou  fl# cl date     f-basis  secure differ sidetr fcomp");
    for (int i = 0; i < audit.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
      out.println("(" + sector.getSequenceNo() + ")"
		  + sector.getDepCode() + "-" + sector.getDestCode()
		  + " " + sector.getCarrier() + "()" /* ;;; route */
		  + " " + sector.getFlightNo()
		  + " " + sector.getClassOfService()
		  + " " + sector.getFlightDate()
		  + " " + sector.getFareBasis()
		  + " " + sector.getSecureIndex()
		  + ":" + sector.getSecureCharge()
		  + " " + sector.getClassDiffIndex()
		  + ":" + sector.getClassDiffPlus()
		  + " " + sector.getSideTripIndex()
		  + ":" + sector.getSideTripPlus()
		  + " " + sector.getFareComponent()
		  + " " + sector.getTax()
		  + " " + sector.getTaxInLocal());
      out.println("(" + sector.getComponentKind() + ")"
		  + "	SPA(" + sector.getSpaDiscountRate()*100 + "%of"
		  + sector.getSpaBaseAmtType() + sector.getSpaBaseAmt() + ")"
		  + sector.getSpaNuc()
		  + ":	APDP(" + sector.getApdpDiscountRate()*100 + "%of"
		  + sector.getApdpBaseAmtType() + sector.getApdpBaseAmt() + ")"
		  + sector.getApdpNuc() + "FIX" + sector.getFixedFareCheck()
		  + "/" + sector.getFixedFareDiscount()
		  + ":	SRP" + sector.getSrpNuc());
      out.println("	PRO-TYPE " + sector.getProrationType()
		  + " PRO_FACTOR " + sector.getProrateFactor()
		  + " PRO-VAL " + sector.getProrateValue()
		  + " NP " + sector.getNpPvalues());
      out.println("	DIFF " + sector.getClassDiffIndex()
		  + ":" + sector.getProratedClassDiff()
		  + " SEC " + sector.getSecureIndex()
		  + ":" + sector.getProratedSecureCharge()
		  + "/" + sector.getSecureChargeSaved());
      out.println("	ERROR: " + sector.getErrorFlag()
		  + " " + sector.getErrorString());
    }
    out.println("FARE_CAL: " + audit.getFareCalculation());

    /* trace strings */
    if (audit.getTraceStrings() != null) {
      out.println("TRACE: (level:" + audit.getTraceLevel() + ")");
      for (int i = 0; i < audit.getTraceStrings().length; i++) {
	String	traceStr = (String)audit.getTraceStrings()[i];
	out.println(traceStr);
      }
    }
  }

  public static void	main(String [] args) throws ProrateRulebaseException {
    ProrateTestFile	test = null;
    if (args.length > 0) {
      test = new ProrateTestFile(args[0]);
    }
    else {
      test = new ProrateTestFile("test_ticket");
    }
    int	traceLevel = 10;	/* ;;; deBug */
    if (args.length > 1) {
      traceLevel = Integer.parseInt(args[1]);
    }
    if (test == null) {
      return;
    }

    test.inputAudit();
    test.printAudit();

    test.audit.setTraceLevel(traceLevel);
    System.err.println("traceLevel = " + test.audit.getTraceLevel());

    ProrateImpl	prorate = new ProrateImpl();

    ProrateRulebase rulebase = null;
    try {
      /* ;;;
      rulebase = new XmlRulebase();
      XmlRulebase.initialize();
      */
      rulebase = new XmlRulebaseLru();
      XmlRulebaseLru.initialize();
    } catch (Exception e) {
      e.printStackTrace();
      System.err.println(e.getMessage());
      System.exit(1); // Force an exit because there might be other threads
    }
    ProrateRulebaseElementFactory factory = new ProrateRuleObjectFactory();
    rulebase.setElementFactory(factory);
    prorate.setRulebase(rulebase);
    prorate.setFcalc(new ProrateFCalcImpl());
    prorate.setDatabase(new ProrateRdb());
    if (!prorate.getDatabase().openDatabase()) {
      System.err.println("proration service database initialization failed:"
			 + prorate.getDatabase().getErrMessage());
      System.exit(1); // Force an exit because there might be other threads
    }
    prorate.setTax(new ProrateTaxImpl());

    try {
      test.audit = prorate.prorate(test.audit);
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    prorate.getDatabase().closeDatabase();
    prorate.setDatabase(null);
    prorate.setTrace(null);
    prorate.setFcalc(null);
    prorate.setRulebase(null);

    prorate = null;

    test.printAudit();
  }

}
