// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb;

import java.io.Serializable;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Column;
import javax.persistence.OneToMany;

/* model of the AUDIT whole data */
@Entity(name="audit")
/**
 * class <code>Audit</code>
 *	The entity of the whole audit (of all sectors in the itineraty).
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
  public class Audit implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
     * variable <code>ticketNumber</code>
     *	ticket number string
     *
     */
    @Id
      String	ticketNumber = "";
    /**
     * variable <code>couponNumber</code>
     *	ticket coupon number string
     *
     */
    @Column(name="couponNumber", length=2)
      String	couponNumber = "";
    /**
     * variable <code>inwardNumber</code>
     *	airway number(3 letter number) of the invoice airline
     *
     */
    @Column(name="inwardNumber", length=3)
      String	inwardNumber = "0";
    /**
     * variable <code>inwardId</code>
     *	airway id(2 letter alphabetic) of the invoice airline
     *
     */
    @Column(name="inwardId", length=2)
      String	inwardId = "";
    /**
     * variable <code>endorsement</code>
     *	ENDORSEMENT/RESTRICTION column string
     *
     */
    @Column(name="endorsement", length=1024)
      String	endorsement = "";
    /**
     * variable <code>issueDate</code>
     *	issue date column string
     *
     */
    @Column(name="issueDate", length=8)
      String	issueDate = "0";
    /**
     * variable <code>issuePlace</code>
     *	issue place column string
     *
     */
    @Column(name="issuePlace", length=128)
      String	issuePlace = "";
    /**
     * variable <code>invoiceMonth</code>
     *	invoice month
     *
     */
    @Column(name="invoiceMonth", length=8)
      String	invoiceMonth = "";
    /**
     * variable <code>origin</code>
     *	origin column string(airport 3letter code)
     *
     */
    @Column(name="origin", length=3)
      String	origin = "";
    /**
     * variable <code>destination</code>
     *	destination column string(airport 3letter code)
     *
     */
    @Column(name="destination", length=3)
      String	destination = "";
    /**
     * variable <code>currency</code>
     *	currency column string
     *
     */
    @Column(name="currency", length=3)
      String	currency = "";
    /**
     * variable <code>ticketFare</code>
     *	ticket fare column amount
     *
     */
    double	ticketFare;
    /**
     * variable <code>salesCurrency</code>
     *	sales currency column string
     *
     */
    @Column(name="salesCurrency", length=3)
      String	salesCurrency = "";
    /**
     * variable <code>salesFare</code>
     *	sales fare column amount
     *
     */
    double	salesFare;
    /**
     * variable <code>plusAdjustment</code>
     *	plus adjustment amount
     *
     */
    double	plusAdjustment;
    /**
     * variable <code>lessAdjustment</code>
     *	less adjustment amount
     *
     */
    double	lessAdjustment;
    /**
     * variable <code>commissionCurrency</code>
     *	commission currency column string
     *
     */
    @Column(name="commissionCurrency", length=3)
      String	commissionCurrency = "";
    /**
     * variable <code>commissionRate</code>
     *	commission applying rate value
     *
     */
    double	commissionRate;
    /**
     * variable <code>commissionAmt</code>
     *	commission amount value
     *
     */
    double	commissionAmt;
    /**
     * variable <code>totalNuc</code>
     *	total nuc column amount
     *
     */
    double	totalNuc;
    /**
     * variable <code>lessAmt</code>
     *	less amount value
     *
     */
    double	lessAmt;
    /**
     * variable <code>stopOverCharge</code>
     *	stop over charge amount
     *
     */
    double	stopOverCharge;
    /**
     * variable <code>tourCode</code>
     *	tour code string
     *
     */
    @Column(name="tourCode", length=1024)
      String	tourCode = "";
    /**
     * variable <code>agentCode</code>
     *	agent code string
     *
     */
    @Column(name="agentCode", length=128)
      String	agentCode = "";
    /**
     * variable <code>fareCalculation</code>
     *	fare calculation column string
     *
     */
    @Column(name="fareCalculation", length=4096)
      String	fareCalculation = "";
    /**
     * variable <code>airwayNumber</code>
     *	airway number(3 letter number) of the ticketing airline
     *
     */
    @Column(name="airwayNumber", length=3)
      String	airwayNumber = "0";
    /**
     * variable <code>airwayId</code>
     *	airway id(2 letter alphabetic) of the ticketing airline
     *
     */
    @Column(name="airwayId", length=2)
      String	airwayId = "";
    /**
     * variable <code>roeRate</code>
     *	roe rate value
     *
     */
    double	roeRate;
    /**
     * variable <code>day5Rate</code>
     *	5day rate value
     *
     */
    double	day5Rate;
    /**
     * variable <code>meanRate</code>
     *	mean 5day rate value
     *
     */
    double	meanRate;
    /**
     * variable <code>fixedFare</code>
     *	value for fixed fare check basis
     *
     */
    double	fixedFare;
    /**
     * variable <code>amountRatio</code>
     *	the ratio of amount in ticket fare to amounts in fare components
     *
     */
    double	amountRatio;
    /**
     * variable <code>plusFlg</code>
     *	the flag which is set when the plus is described in fare calculation
     *	and the proration calculation is done by the algothm with plus
     *
     */
    boolean plusFlg;

    /**
     * variable <code>components</code>
     *	the list of the analyzed and separeted fare components
     *
     */
    @OneToMany(mappedBy="audit", cascade=CascadeType.ALL)
      List<FareComponent>	components;
    /**
     * @uml.property  name="sectors"
     */
    @OneToMany(mappedBy="audit", cascade=CascadeType.ALL)
      List<Sector>	sectors;

    /**
     * variable <code>taxMisc</code>
     *	the list of 10 taxes column values(type and amount)
     *	misc_tax(type,amount)
     *
     */
    @OneToMany(mappedBy="audit", cascade=CascadeType.ALL)
      List<TaxData>	tax;			/* misc_tax(type,amount) */

    /**
     * variable <code>errorFlag</code>
     *	error specification number
     *	of the error which is occurred during proration
     *
     * @uml.property  name="errorFlag"
     */
    int	errorFlag;
    /**
     * variable <code>errorString</code>
     *	the message string of the error which is occurred during proration
     *
     */
    @Column(name="errorString", length=1024)
      String	errorString = "";

    /**
     * Creates a new <code>Audit</code> instance.
     *
     */
    public Audit() {
      super();
    }

    /**
     * @return  agentCode
     * @uml.property  name="agentCode"
     */
    public String getAgentCode() {
      return agentCode;
    }
    /**
     * @param agentCode  agentCode to be set
     * @uml.property  name="agentCode"
     */
    public void setAgentCode(String agentCode) {
      this.agentCode = agentCode;
    }
    /**
     * @return  airwayId
     * @uml.property  name="airwayId"
     */
    public String getAirwayId() {
      return airwayId;
    }
    /**
     * @param airwayId  airwayId to be set
     * @uml.property  name="airwayId"
     */
    public void setAirwayId(String airwayId) {
      this.airwayId = airwayId;
    }
    /**
     * @return  airwayNumber
     * @uml.property  name="airwayNumber"
     */
    public String getAirwayNumber() {
      return airwayNumber;
    }
    /**
     * @param airwayNumber  airwayNumber to be set
     * @uml.property  name="airwayNumber"
     */
    public void setAirwayNumber(String airwayNumber) {
      this.airwayNumber = airwayNumber;
    }
    /**
     * @return  amountRatio
     * @uml.property  name="amountRatio"
     */
    public double getAmountRatio() {
      return amountRatio;
    }
    /**
     * @param amountRatio  amountRatio to be set
     * @uml.property  name="amountRatio"
     */
    public void setAmountRatio(double amountRatio) {
      this.amountRatio = amountRatio;
    }
    /**
     * @return  commissionAmt
     * @uml.property  name="commissionAmt"
     */
    public double getCommissionAmt() {
      return commissionAmt;
    }
    /**
     * @param commissionAmt  commissionAmt to be set
     * @uml.property  name="commissionAmt"
     */
    public void setCommissionAmt(double commissionAmt) {
      this.commissionAmt = commissionAmt;
    }
    /**
     * @return  commissionCurrency
     * @uml.property  name="commissionCurrency"
     */
    public String getCommissionCurrency() {
      return commissionCurrency;
    }
    /**
     * @param commissionCurrency  commissionCurrency to be set
     * @uml.property  name="commissionCurrency"
     */
    public void setCommissionCurrency(String commissionCurrency) {
      this.commissionCurrency = commissionCurrency;
    }
    /**
     * @return  commissionRate
     * @uml.property  name="commissionRate"
     */
    public double getCommissionRate() {
      return commissionRate;
    }
    /**
     * @param commissionRate  commissionRate to be set
     * @uml.property  name="commissionRate"
     */
    public void setCommissionRate(double commissionRate) {
      this.commissionRate = commissionRate;
    }
    /**
     * @return  components
     * @uml.property  name="components"
     */
    public List<FareComponent> getComponents() {
      return components;
    }
    /**
     * @param components  components to be set
     * @uml.property  name="components"
     */
    public void setComponents(List<FareComponent> components) {
      this.components = components;
    }
    /**
     * @return  couponNumber
     * @uml.property  name="couponNumber"
     */
    public String getCouponNumber() {
      return couponNumber;
    }
    /**
     * @param couponNumber  couponNumber to be set
     * @uml.property  name="couponNumber"
     */
    public void setCouponNumber(String couponNumber) {
      this.couponNumber = couponNumber;
    }
    /**
     * @return  currency
     * @uml.property  name="currency"
     */
    public String getCurrency() {
      return currency;
    }
    /**
     * @param currency  currency to be set
     * @uml.property  name="currency"
     */
    public void setCurrency(String currency) {
      this.currency = currency;
    }
    /**
     * @return  day5Rate
     * @uml.property  name="day5Rate"
     */
    public double getDay5Rate() {
      return day5Rate;
    }
    /**
     * @param day5Rate  day5Rate to be set
     * @uml.property  name="day5Rate"
     */
    public void setDay5Rate(double day5Rate) {
      this.day5Rate = day5Rate;
    }
    /**
     * @return  destination
     * @uml.property  name="destination"
     */
    public String getDestination() {
      return destination;
    }
    /**
     * @param destination  destination to be set
     * @uml.property  name="destination"
     */
    public void setDestination(String destination) {
      this.destination = destination;
    }
    /**
     * @return  endorsement
     * @uml.property  name="endorsement"
     */
    public String getEndorsement() {
      return endorsement;
    }
    /**
     * @param endorsement  endorsement to be set
     * @uml.property  name="endorsement"
     */
    public void setEndorsement(String endorsement) {
      this.endorsement = endorsement;
    }
    /**
     * @return  errorFlag
     * @uml.property  name="errorFlag"
     */
    public int getErrorFlag() {
      return errorFlag;
    }
    /**
     * @param errorFlag  errorFlag to be set
     * @uml.property  name="errorFlag"
     */
    public void setErrorFlag(int errorFlag) {
      this.errorFlag = errorFlag;
    }
    /**
     * @return  errorString
     * @uml.property  name="errorString"
     */
    public String getErrorString() {
      return errorString;
    }
    /**
     * @param errorString  errorString to be set
     * @uml.property  name="errorString"
     */
    public void setErrorString(String errorString) {
      this.errorString = errorString;
    }
    /**
     * @return  fareCalculation
     * @uml.property  name="fareCalculation"
     */
    public String getFareCalculation() {
      return fareCalculation;
    }
    /**
     * @param fareCalculation  fareCalculation to be set
     * @uml.property  name="fareCalculation"
     */
    public void setFareCalculation(String fareCalculation) {
      this.fareCalculation = fareCalculation;
    }
    /**
     * @return  fixedFare
     * @uml.property  name="fixedFare"
     */
    public double getFixedFare() {
      return fixedFare;
    }
    /**
     * @param fixedFare  fixedFare to be set
     * @uml.property  name="fixedFare"
     */
    public void setFixedFare(double fixedFare) {
      this.fixedFare = fixedFare;
    }
     /**
     * @return  invoiceMonth
     * @uml.property  name="invoiceMonth"
     */
    public String getInvoiceMonth() {
      return invoiceMonth;
    }
    /**
     * @param invoiceMonth  invoiceMonth to be set
     * @uml.property  name="invoiceMonth"
     */
    public void setInvoiceMonth(String invoiceMonth) {
      this.invoiceMonth = invoiceMonth;
    }
    /**
     * @return  inwardId
     * @uml.property  name="inwardId"
     */
    public String getInwardId() {
      return inwardId;
    }
    /**
     * @param inwardId  inwardId to be set
     * @uml.property  name="inwardId"
     */
    public void setInwardId(String inwardId) {
      this.inwardId = inwardId;
    }
    /**
     * @return  inwardNumber
     * @uml.property  name="inwardNumber"
     */
    public String getInwardNumber() {
      return inwardNumber;
    }
    /**
     * @param inwardNumber  inwardNumber to be set
     * @uml.property  name="inwardNumber"
     */
    public void setInwardNumber(String inwardNumber) {
      this.inwardNumber = inwardNumber;
    }
    /**
     * @return  issueDate
     * @uml.property  name="issueDate"
     */
    public String getIssueDate() {
      return issueDate;
    }
    /**
     * @param issueDate  issueDate to be set
     * @uml.property  name="issueDate"
     */
    public void setIssueDate(String issueDate) {
      this.issueDate = issueDate;
    }
    /**
     * @return  issuePlace
     * @uml.property  name="issuePlace"
     */
    public String getIssuePlace() {
      return issuePlace;
    }
    /**
     * @param issuePlace  issuePlace to be set
     * @uml.property  name="issuePlace"
     */
    public void setIssuePlace(String issuePlace) {
      this.issuePlace = issuePlace;
    }
    /**
     * @return  lessAdjustment
     * @uml.property  name="lessAdjustment"
     */
    public double getLessAdjustment() {
      return lessAdjustment;
    }
    /**
     * @param lessAdjustment  lessAdjustment to be set
     * @uml.property  name="lessAdjustment"
     */
    public void setLessAdjustment(double lessAdjustment) {
      this.lessAdjustment = lessAdjustment;
    }
    /**
     * @return  lessAmt
     * @uml.property  name="lessAmt"
     */
    public double getLessAmt() {
      return lessAmt;
    }
    /**
     * @param lessAmt  lessAmt to be set
     * @uml.property  name="lessAmt"
     */
    public void setLessAmt(double lessAmt) {
      this.lessAmt = lessAmt;
    }
    /**
     * @return  meanRate
     * @uml.property  name="meanRate"
     */
    public double getMeanRate() {
      return meanRate;
    }
    /**
     * @param meanRate  meanRate to be set
     * @uml.property  name="meanRate"
     */
    public void setMeanRate(double meanRate) {
      this.meanRate = meanRate;
    }
    /**
     * @return  origin
     * @uml.property  name="origin"
     */
    public String getOrigin() {
      return origin;
    }
    /**
     * @param origin  origin to be set
     * @uml.property  name="origin"
     */
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    /**
     * @return  plusAdjustment
     * @uml.property  name="plusAdjustment"
     */
    public double getPlusAdjustment() {
      return plusAdjustment;
    }
    /**
     * @param plusAdjustment  plusAdjustment to be set
     * @uml.property  name="plusAdjustment"
     */
    public void setPlusAdjustment(double plusAdjustment) {
      this.plusAdjustment = plusAdjustment;
    }
    /**
     * @return  plusFlg
     * @uml.property  name="plusFlg"
     */
    public boolean isPlusFlg() {
      return plusFlg;
    }
    /**
     * @param plusFlg  plusFlg to be set
     * @uml.property  name="plusFlg"
     */
    public void setPlusFlg(boolean plusFlg) {
      this.plusFlg = plusFlg;
    }
    /**
     * @return  roeRate
     * @uml.property  name="roeRate"
     */
    public double getRoeRate() {
      return roeRate;
    }
    /**
     * @param roeRate  roeRate to be set
     * @uml.property  name="roeRate"
     */
    public void setRoeRate(double roeRate) {
      this.roeRate = roeRate;
    }
    /**
     * @return  salesCurrency
     * @uml.property  name="salesCurrency"
     */
    public String getSalesCurrency() {
      return salesCurrency;
    }
    /**
     * @param salesCurrency  salesCurrency to be set
     * @uml.property  name="salesCurrency"
     */
    public void setSalesCurrency(String salesCurrency) {
      this.salesCurrency = salesCurrency;
    }
    /**
     * @return  salesFare
     * @uml.property  name="salesFare"
     */
    public double getSalesFare() {
      return salesFare;
    }
    /**
     * @param salesFare  salesFare to be set
     * @uml.property  name="salesFare"
     */
    public void setSalesFare(double salesFare) {
      this.salesFare = salesFare;
    }
    /**
     * @return  sectors
     * @uml.property  name="sectors"
     */
    public List<Sector> getSectors() {
      return sectors;
    }
    /**
     * @param sectors  sectors to be set
     * @uml.property  name="sectors"
     */
    public void setSectors(List<Sector> sectors) {
      this.sectors = sectors;
    }
    /**
     * @return  stopOverCharge
     * @uml.property  name="stopOverCharge"
     */
    public double getStopOverCharge() {
      return stopOverCharge;
    }
    /**
     * @param stopOverCharge  stopOverCharge to be set
     * @uml.property  name="stopOverCharge"
     */
    public void setStopOverCharge(double stopOverCharge) {
      this.stopOverCharge = stopOverCharge;
    }
    /**
     * @return  ticketFare
     * @uml.property  name="ticketFare"
     */
    public double getTicketFare() {
      return ticketFare;
    }
    /**
     * @param ticketFare  ticketFare to be set
     * @uml.property  name="ticketFare"
     */
    public void setTicketFare(double ticketFare) {
      this.ticketFare = ticketFare;
    }
    /**
     * @return  ticketNumber
     * @uml.property  name="ticketNumber"
     */
    public String getTicketNumber() {
      return ticketNumber;
    }
    /**
     * @param ticketNumber  ticketNumber to be set
     * @uml.property  name="ticketNumber"
     */
    public void setTicketNumber(String ticketNumber) {
      this.ticketNumber = ticketNumber;
    }
    /**
     * @return  totalNuc
     * @uml.property  name="totalNuc"
     */
    public double getTotalNuc() {
      return totalNuc;
    }
    /**
     * @param totalNuc  totalNuc to be set
     * @uml.property  name="totalNuc"
     */
    public void setTotalNuc(double totalNuc) {
      this.totalNuc = totalNuc;
    }
    /**
     * @return  tourCode
     * @uml.property  name="tourCode"
     */
    public String getTourCode() {
      return tourCode;
    }
    /**
     * @param tourCode  tourCode to be set
     * @uml.property  name="tourCode"
     */
    public void setTourCode(String tourCode) {
      this.tourCode = tourCode;
    }
    /**
     * @return  tax
     * @uml.property  name="tax"
     */
    public List<TaxData> getTax() {
      return tax;
    }
    /**
     * @param tax  tax to be set
     * @uml.property  name="tax"
     */
    public void setTax(List<TaxData> tax) {
      this.tax = tax;
    }
  }
