// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb;

import java.util.List;
import java.util.Vector;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import jp.sourceforge.gnp.audit.ejb.interfaces.AuditEjb;
import jp.sourceforge.gnp.prorate.ejb.interfaces.ProrateEjb;
import jp.sourceforge.gnp.prorate.ejb.client.ProrateEjbClient;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;

/**
 * @ejb.bean name="AuditEjb"
 *           display-name="Name for AuditEjb"
 *           description="Description for AuditEjb"
 *           jndi-name="ejb/AuditEjb"
 *           type="Stateless"
 *           view-type="both"
 */
@Stateless
  public class AuditEjbBean implements AuditEjb {

    /**
     * variable <code>prorate</code>	ProrateEjb EJB3 object
     *
     */
    @EJB(beanName="ProrateEjb", mappedName="ejb/ProrateEjb")
      ProrateEjb	prorate = null;

    /**
     * <code>manager</code>	EntityManager object
     *
     */
    @PersistenceContext(unitName="audit")
      EntityManager manager;

    /**
     * Creates a new <code>AuditEjbBean</code> instance.
     *
     * @exception Exception if an error occurs
     */
    public AuditEjbBean() throws Exception {
      super();
    }

    /**
     * <code>persist</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @param audit a <code>ProrateAudit</code> value
     * @return a <code>boolean</code> value
     */
    public boolean persist(String ticketNumber, ProrateAudit audit) {
      Audit	auditEntity = null;
      boolean	newEntity = false;
      auditEntity = manager.find(Audit.class, ticketNumber);
      if (auditEntity == null) {
	auditEntity = new Audit();
	newEntity = true;
      }
      auditEntity.setTicketNumber(ticketNumber);
      String	couponNumber = "";
      if (ticketNumber.length() > 13) {
	couponNumber = ticketNumber.substring(13);
      }
      auditEntity.setCouponNumber(couponNumber);
      auditEntity.setInwardNumber(audit.getInwardNumber());
      auditEntity.setInwardId(audit.getInwardId());
      auditEntity.setEndorsement(audit.getEndorsement());
      auditEntity.setIssueDate(audit.getIssueDate());
      auditEntity.setIssuePlace(audit.getIssuePlace());
      auditEntity.setInvoiceMonth(audit.getInvoiceMonth());
      auditEntity.setOrigin(audit.getOrigin());
      auditEntity.setDestination(audit.getDestination());
      auditEntity.setCurrency(audit.getCurrency());
      auditEntity.setTicketFare(audit.getTicketFare());
      auditEntity.setSalesCurrency(audit.getSalesCurrency());
      auditEntity.setSalesFare(audit.getSalesFare());
      auditEntity.setPlusAdjustment(audit.getPlusAdjustment());
      auditEntity.setLessAdjustment(audit.getLessAdjustment());
      auditEntity.setCommissionCurrency(audit.getCommissionCurrency());
      auditEntity.setCommissionRate(audit.getCommissionRate());
      auditEntity.setCommissionAmt(audit.getCommissionAmt());
      auditEntity.setTotalNuc(audit.getTotalNuc());
      auditEntity.setLessAmt(audit.getLessAmt());
      auditEntity.setStopOverCharge(audit.getStopOverCharge());
      auditEntity.setTourCode(audit.getTourCode());
      auditEntity.setAgentCode(audit.getAgentCode());
      auditEntity.setFareCalculation(audit.getFareCalculation());
      auditEntity.setAirwayNumber(audit.getAirwayNumber());
      auditEntity.setAirwayId(audit.getAirwayId());
      auditEntity.setRoeRate(audit.getRoeRate());
      auditEntity.setDay5Rate(audit.getDay5Rate());
      auditEntity.setMeanRate(audit.getMeanRate());
      auditEntity.setFixedFare(audit.getFixedFare());
      auditEntity.setAmountRatio(audit.getAmountRatio());
      auditEntity.setPlusFlg(audit.isPlusFlg());
      auditEntity.setErrorFlag(audit.getErrorFlag());
      auditEntity.setErrorString(audit.getErrorString());
      /* Taxes */
      if (newEntity) {
	auditEntity.setTax(new Vector());
      }
      else if (auditEntity.getTax() != null) {
	if (audit.getTax() == null
	    || auditEntity.getTax().size() > audit.getTaxMisc().length) {
	  int	first = audit.getTax() == null  ? 0 : audit.getTax().length;
	  for (int i = auditEntity.getTax().size()-1; i >= first; i--) {
	    manager.remove(auditEntity.getTax().get(i));
	    auditEntity.getTax().remove(i);
	  }
	}
      }
      if (audit.getTaxMisc() != null && audit.getTaxMisc().length > 0) {
	for (int i = 0; i < audit.getTaxMisc().length; i++) {
	  ProrateTaxData tax = (ProrateTaxData)audit.getTaxMisc()[i];
	  TaxData	taxEntity = null;
	  boolean	newTax = false;
	  if (!newEntity && auditEntity.getTax() != null
	      && auditEntity.getTax().size() > i) {
	    taxEntity = auditEntity.getTax().get(i);
	  }
	  if (taxEntity == null) {
	    taxEntity = new TaxData();
	    newTax = true;
	  }
	  taxEntity.setAudit(auditEntity);
	  taxEntity.setAmount(tax.getAmount());
	  taxEntity.setType(tax.getType());
	  if (newTax) {
	    auditEntity.getTax().add(taxEntity);
	  }
	}
      }
      /* Sectors */
      if (newEntity) {
	auditEntity.setSectors(new Vector());
      }
      else if (auditEntity.getSectors() != null) {
	if (audit.getSectors() == null
	    || auditEntity.getSectors().size() > audit.getSectors().length) {
	  int	first =
	    audit.getSectors() == null  ? 0 : audit.getSectors().length;
	  for (int i = auditEntity.getSectors().size()-1; i >= first; i--) {
	    manager.remove(auditEntity.getSectors().get(i));
	    auditEntity.getSectors().remove(i);
	  }
	}
      }
      if (audit.getSectors() != null && audit.getSectors().length > 0) {
	List	sectors = new Vector();
	for (int i = 0; i < audit.getSectors().length; i++) {
	  ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	  Sector	sectorEntity = null;
	  if (!newEntity && auditEntity.getSectors() != null
	      && auditEntity.getSectors().size() > i) {
	    sectorEntity = auditEntity.getSectors().get(i);
	  }
	  if (sectorEntity == null) {
	    sectorEntity = new Sector();
	  }
	  sectorEntity.setAudit(auditEntity);
	  sectorEntity.setSequenceNo(sector.getSequenceNo());
	  sectorEntity.setStopOver(sector.getStopOver());
	  sectorEntity.setDepCode(sector.getDepCode());
	  sectorEntity.setDestCode(sector.getDestCode());
	  if (sector.getFareBasisFullStr() != null
	      && sector.getFareBasisFullStr().length() > 0) {
	    sectorEntity.setFareBasis(sector.getFareBasisFullStr());
	  }
	  else {
	    sectorEntity.setFareBasis(sector.getFareBasis());
	  }
	  sectorEntity.setCarrier(sector.getCarrier());
	  sectorEntity.setClassOfService(sector.getClassOfService());
	  sectorEntity.setFlightDate(sector.getFlightDate());
	  sectorEntity.setDepTime(sector.getDepTime());
	  sectorEntity.setFareComponent(sector.getFareComponent());
	  sectorEntity.setFlightNo(sector.getFlightNo());
	  sectorEntity.setClassDiffPlus(sector.getClassDiffPlus());
	  sectorEntity.setSecureCharge(sector.getSecureCharge());
	  sectorEntity.setSideTripPlus(sector.getSideTripPlus());
	  sectorEntity.setStopOverPlus(sector.getStopOverPlus());
	  sectorEntity.setProrateFactor(sector.getProrateFactor());
	  sectorEntity.setTax(sector.getTax());
	  sectorEntity.setTaxIndex(sector.getTaxIndex());
	  sectorEntity.setTaxInLocal(sector.getTaxInLocal());
	  sectorEntity.setCommission(sector.getCommission());
	  sectorEntity.setProrationType(sector.getProrationType());
	  sectorEntity.setSpaBaseAmtType(sector.getSpaBaseAmtType());
	  sectorEntity.setSpaBaseAmt(sector.getSpaBaseAmt());
	  sectorEntity.setSpaDay5Rate(sector.getSpaDay5Rate());
	  sectorEntity.setSpaDiscountRate(sector.getSpaDiscountRate());
	  sectorEntity.setSpaClassDiff(sector.getSpaClassDiff());
	  sectorEntity.setApdpBaseAmtType(sector.getApdpBaseAmtType());
	  sectorEntity.setApdpBaseAmt(sector.getApdpBaseAmt());
	  sectorEntity.setApdpDay5Rate(sector.getApdpDay5Rate());
	  sectorEntity.setApdpDiscountRate(sector.getApdpDiscountRate());
	  sectorEntity.setApdpClassDiff(sector.getApdpClassDiff());
	  sectorEntity.setProratedClassDiff(sector.getProratedClassDiff());
	  sectorEntity.setExstPlus(sector.getExstPlus());
	  sectorEntity.setProratedExstPlus(sector.getProratedExstPlus());
	  sectorEntity.setProrateError(sector.getProrateError());
	  sectorEntity.setSpaNuc(sector.getSpaNuc());
	  sectorEntity.setApdpNuc(sector.getApdpNuc());
	  sectorEntity.setNpPvalues(sector.getNpPvalues());
	  sectorEntity.setSrpNuc(sector.getSrpNuc());
	  sectorEntity.setProrateValue(sector.getProrateValue());
	  sectorEntity.setAmountInLocal(sector.getAmountInLocal());
	  sectorEntity.setInvoiceValue(sector.getInvoiceValue());
	  sectorEntity.setSideTripIndex(sector.getSideTripIndex());
	  sectorEntity.setClassDiffIndex(sector.getClassDiffIndex());
	  sectorEntity.setSecureIndex(sector.getSecureIndex());
	  sectorEntity.setFixedFareCheck(sector.getFixedFareCheck());
	  sectorEntity.setFixedFareDiscount(sector.getFixedFareDiscount());
	  sectorEntity.setComponentIndex(sector.getComponentIndex());
	  sectorEntity.setComponentKind(sector.getComponentKind());
	  sectorEntity.setViaRouting(sector.getViaRouting());
	  sectorEntity.setSecureCharge(sector.getSecureCharge());
	  sectorEntity.setFareType(sector.getFareType());
	  sectorEntity.setDepAirport(sector.getDepAirport());
	  sectorEntity.setDestAirport(sector.getDestAirport());
	  sectorEntity.setOpCarrier(sector.getOpCarrier());
	  sectorEntity.setNpClassDiff(sector.getNpClassDiff());
	  sectorEntity.setSecureChargeSaved(sector.getSecureChargeSaved());
	  sectorEntity
	    .setProratedSecureCharge(sector.getProratedSecureCharge());
	  sectorEntity.setErrorFlag(sector.getErrorFlag());
	  sectorEntity.setErrorString(sector.getErrorString());
	  sectorEntity.setFixValue(sector.getFixValue());
	  sectorEntity.setFixCurrency(sector.getFixCurrency());
	  sectorEntity.setFixAmount(sector.getFixAmount());
	  sectorEntity.setInvoiceFlg(sector.isInvoiceFlg());
	  sectorEntity.setCertainty(sector.getCertainty());
	  sectors.add(sectorEntity);
	}
	auditEntity.setSectors(sectors);
      }
      /* Components */
      if (newEntity) {
	auditEntity.setComponents(new Vector());
      }
      else if (auditEntity.getComponents() != null) {
	if (audit.getComponents() == null
	    || (auditEntity.getComponents().size()
		> audit.getComponents().length)) {
	  int	first =
	    (audit.getComponents() == null ? 0 : audit.getComponents().length);
	  for (int i = auditEntity.getComponents().size()-1; i >= first; i--) {
	    FareComponent
	      fcompEntity = (FareComponent)auditEntity.getComponents().get(i);
	    for (int j = 0; j < fcompEntity.getSectors().size(); j++) {
	      Sector	sectorEntity = (Sector)fcompEntity.getSectors().get(j);
	      sectorEntity.setFcomp(null);
	    }
	    manager.remove(fcompEntity);
	    auditEntity.getComponents().remove(i);
	  }
	}
      }
      if (audit.getComponents() != null && audit.getComponents().length > 0) {
	for (int i = 0; i < audit.getComponents().length; i++) {
	  ProrateFareComponent
	    fcomp = (ProrateFareComponent)audit.getComponents()[i];
	  FareComponent	fcompEntity = null;
	  boolean	newFcomp = false;
	  if (!newEntity && auditEntity.getComponents() != null
	      && auditEntity.getComponents().size() > i) {
	    fcompEntity = auditEntity.getComponents().get(i);
	  }
	  if (fcompEntity == null) {
	    fcompEntity = new FareComponent();
	    newFcomp = true;
	  }
	  fcompEntity.setAudit(auditEntity);
	  fcompEntity.setValue(fcomp.getValue());
	  fcompEntity.setKind(fcomp.getKind());
	  fcompEntity.setFixedFareDiscount(fcomp.getFixedFareDiscount());
	  if (!newFcomp && fcompEntity.getSectors() != null
	      && (fcomp.getSectors() == null
		  || (fcompEntity.getSectors().size()
		      > fcomp.getSectors().length))) {
	    int	first =
	      fcomp.getSectors() == null ? 0 : fcomp.getSectors().length;
	    for (int j = fcompEntity.getSectors().size()-1; j >= first; j--) {
	      Sector	sectorEntity = (Sector)fcompEntity.getSectors().get(j);
	      sectorEntity.setFcomp(null);
	      fcompEntity.getSectors().remove(j);
	    }
	  }
	  for (int j = 0; j < fcomp.getSectors().length; j++) {
	    ProrateSector sector = (ProrateSector)fcomp.getSectors()[j];
	    for (int k = 0; k < auditEntity.getSectors().size(); k++) {
	      Sector	sectorEntity = (Sector)auditEntity.getSectors().get(k);
	      if (sector.getSequenceNo() == sectorEntity.getSequenceNo()) {
		sectorEntity.setFcomp(fcompEntity);
		if (fcompEntity.getSectors() != null
		    && fcompEntity.getSectors().size() > j) {
		  fcompEntity.getSectors().set(j, sectorEntity);
		}
		else {
		  fcompEntity.getSectors().add(sectorEntity);
		}
		break;
	      }
	    }
	  }
	  if (newFcomp) {
	    auditEntity.getComponents().add(fcompEntity);
	  }
	}
      }

      if (newEntity) {
	manager.persist(auditEntity);
      }
      else {
	manager.merge(auditEntity);
      }
      manager.flush();
      return true;
    }

    /**
     * <code>remove</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @return a <code>boolean</code> value
     */
    public boolean remove(String ticketNumber) {
      Audit	auditEntity = null;
      auditEntity = manager.find(Audit.class, ticketNumber);
      if (auditEntity == null) {
	return false;
      }
      manager.remove(auditEntity);
      manager.flush();
      return true;
    }

    /**
     * <code>find</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @return a <code>ProrateAudit</code> value
     */
    public ProrateAudit find(String ticketNumber) {
      Audit	auditEntity = null;
      auditEntity = manager.find(Audit.class, ticketNumber);
      if (auditEntity == null) {
	return null;
      }
      ProrateAudit	audit = new ProrateAudit();
      audit.setInwardNumber(auditEntity.getInwardNumber());
      audit.setInwardId(auditEntity.getInwardId());
      audit.setEndorsement(auditEntity.getEndorsement());
      audit.setIssueDate(auditEntity.getIssueDate());
      audit.setIssuePlace(auditEntity.getIssuePlace());
      audit.setInvoiceMonth(auditEntity.getInvoiceMonth());
      audit.setOrigin(auditEntity.getOrigin());
      audit.setDestination(auditEntity.getDestination());
      audit.setCurrency(auditEntity.getCurrency());
      audit.setTicketFare(auditEntity.getTicketFare());
      audit.setSalesCurrency(auditEntity.getSalesCurrency());
      audit.setSalesFare(auditEntity.getSalesFare());
      audit.setPlusAdjustment(auditEntity.getPlusAdjustment());
      audit.setLessAdjustment(auditEntity.getLessAdjustment());
      audit.setCommissionCurrency(auditEntity.getCommissionCurrency());
      audit.setCommissionRate(auditEntity.getCommissionRate());
      audit.setCommissionAmt(auditEntity.getCommissionAmt());
      audit.setTotalNuc(auditEntity.getTotalNuc());
      audit.setLessAmt(auditEntity.getLessAmt());
      audit.setStopOverCharge(auditEntity.getStopOverCharge());
      audit.setTourCode(auditEntity.getTourCode());
      audit.setAgentCode(auditEntity.getAgentCode());
      audit.setFareCalculation(auditEntity.getFareCalculation());
      audit.setAirwayNumber(auditEntity.getAirwayNumber());
      audit.setAirwayId(auditEntity.getAirwayId());
      audit.setRoeRate(auditEntity.getRoeRate());
      audit.setDay5Rate(auditEntity.getDay5Rate());
      audit.setMeanRate(auditEntity.getMeanRate());
      audit.setFixedFare(auditEntity.getFixedFare());
      audit.setAmountRatio(auditEntity.getAmountRatio());
      audit.setPlusFlg(auditEntity.isPlusFlg());
      audit.setErrorFlag(auditEntity.getErrorFlag());
      audit.setErrorString(auditEntity.getErrorString());
      /* TaxMiscs, Taxes */
      if (auditEntity.getTax() != null && auditEntity.getTax().size() > 0) {
	List<ProrateTaxData>	taxMiscs = new Vector<ProrateTaxData>();
	List<ProrateTaxData>	taxes = new Vector<ProrateTaxData>();
	for (int i = 0; i < auditEntity.getTax().size(); i++) {
	  TaxData	taxEntity = (TaxData)auditEntity.getTax().get(i);
	  ProrateTaxData	tax = new ProrateTaxData();
	  tax.setAmount(taxEntity.getAmount());
	  tax.setType(taxEntity.getType());
	  taxMiscs.add(tax);
	  if (i < 3) {
	    ProrateTaxData	tax3 = new ProrateTaxData();
	    tax3.setAmount(taxEntity.getAmount());
	    tax3.setType(taxEntity.getType());
	    taxes.add(tax3);
	  }
	}
	ProrateTaxData[] taxMiscsArray = new ProrateTaxData[taxMiscs.size()];
	ProrateTaxData[] taxesArray = new ProrateTaxData[taxes.size()];
	for (int i = 0; i < taxMiscs.size(); i++) {
	  taxMiscsArray[i] = (ProrateTaxData)taxMiscs.get(i);
	}
	for (int i = 0; i < taxes.size(); i++) {
	  taxesArray[i] = (ProrateTaxData)taxes.get(i);
	}
	audit.setTaxMisc(taxMiscsArray);
	audit.setTax(taxesArray);
      }
      /* Sectors */
      if (auditEntity.getSectors() != null
	  && auditEntity.getSectors().size() > 0) {
	List	sectors = new Vector();
	for (int i = 0; i < auditEntity.getSectors().size(); i++) {
	  Sector	sectorEntity = (Sector)auditEntity.getSectors().get(i);
	  ProrateSector	sector = new ProrateSector();
	  sector.setSequenceNo(sectorEntity.getSequenceNo());
	  sector.setStopOver(sectorEntity.getStopOver());
	  sector.setDepCode(sectorEntity.getDepCode());
	  sector.setDestCode(sectorEntity.getDestCode());
	  sector.setFareBasis(sectorEntity.getFareBasis());
	  sector.setCarrier(sectorEntity.getCarrier());
	  sector.setClassOfService(sectorEntity.getClassOfService());
	  sector.setFlightDate(sectorEntity.getFlightDate());
	  sector.setDepTime(sectorEntity.getDepTime());
	  sector.setFareComponent(sectorEntity.getFareComponent());
	  sector.setFlightNo(sectorEntity.getFlightNo());
	  sector.setClassDiffPlus(sectorEntity.getClassDiffPlus());
	  sector.setSecureCharge(sectorEntity.getSecureCharge());
	  sector.setSideTripPlus(sectorEntity.getSideTripPlus());
	  sector.setStopOverPlus(sectorEntity.getStopOverPlus());
	  sector.setProrateFactor(sectorEntity.getProrateFactor());
	  sector.setTax(sectorEntity.getTax());
	  sector.setTaxIndex(sectorEntity.getTaxIndex());
	  sector.setTaxInLocal(sectorEntity.getTaxInLocal());
	  sector.setCommission(sectorEntity.getCommission());
	  sector.setProrationType(sectorEntity.getProrationType());
	  sector.setSpaBaseAmtType(sectorEntity.getSpaBaseAmtType());
	  sector.setSpaBaseAmt(sectorEntity.getSpaBaseAmt());
	  sector.setSpaDay5Rate(sectorEntity.getSpaDay5Rate());
	  sector.setSpaDiscountRate(sectorEntity.getSpaDiscountRate());
	  sector.setSpaClassDiff(sectorEntity.getSpaClassDiff());
	  sector.setApdpBaseAmtType(sectorEntity.getApdpBaseAmtType());
	  sector.setApdpBaseAmt(sectorEntity.getApdpBaseAmt());
	  sector.setApdpDay5Rate(sectorEntity.getApdpDay5Rate());
	  sector.setApdpDiscountRate(sectorEntity.getApdpDiscountRate());
	  sector.setApdpClassDiff(sectorEntity.getApdpClassDiff());
	  sector.setProratedClassDiff(sectorEntity.getProratedClassDiff());
	  sector.setExstPlus(sectorEntity.getExstPlus());
	  sector.setProratedExstPlus(sectorEntity.getProratedExstPlus());
	  sector.setProrateError(sectorEntity.getProrateError());
	  sector.setSpaNuc(sectorEntity.getSpaNuc());
	  sector.setApdpNuc(sectorEntity.getApdpNuc());
	  sector.setNpPvalues(sectorEntity.getNpPvalues());
	  sector.setSrpNuc(sectorEntity.getSrpNuc());
	  sector.setProrateValue(sectorEntity.getProrateValue());
	  sector.setAmountInLocal(sectorEntity.getAmountInLocal());
	  sector.setInvoiceValue(sectorEntity.getInvoiceValue());
	  sector.setSideTripIndex(sectorEntity.getSideTripIndex());
	  sector.setClassDiffIndex(sectorEntity.getClassDiffIndex());
	  sector.setSecureIndex(sectorEntity.getSecureIndex());
	  sector.setFixedFareCheck(sectorEntity.getFixedFareCheck());
	  sector.setFixedFareDiscount(sectorEntity.getFixedFareDiscount());
	  sector.setComponentIndex(sectorEntity.getComponentIndex());
	  sector.setComponentKind(sectorEntity.getComponentKind());
	  sector.setViaRouting(sectorEntity.getViaRouting());
	  sector.setSecureCharge(sectorEntity.getSecureCharge());
	  sector.setFareType(sectorEntity.getFareType());
	  sector.setDepAirport(sectorEntity.getDepAirport());
	  sector.setDestAirport(sectorEntity.getDestAirport());
	  sector.setOpCarrier(sectorEntity.getOpCarrier());
	  sector.setNpClassDiff(sectorEntity.getNpClassDiff());
	  sector.setSecureChargeSaved(sectorEntity.getSecureChargeSaved());
	  sector
	    .setProratedSecureCharge(sectorEntity.getProratedSecureCharge());
	  sector.setErrorFlag(sectorEntity.getErrorFlag());
	  sector.setErrorString(sectorEntity.getErrorString());
	  sector.setFixValue(sectorEntity.getFixValue());
	  sector.setFixCurrency(sectorEntity.getFixCurrency());
	  sector.setFixAmount(sectorEntity.getFixAmount());
	  sector.setInvoiceFlg(sector.isInvoiceFlg());
	  sector.setCertainty(sectorEntity.getCertainty());
	  sectors.add(sector);
	}
	ProrateSector[]	sectorsArray = new ProrateSector[sectors.size()];
	for (int i = 0; i < sectors.size(); i++) {
	  for (int j = 0; j < sectors.size(); j++) {
	    ProrateSector	sector = (ProrateSector)sectors.get(j);
	    if (sector.getSequenceNo() == i) {
	      sectorsArray[i] = sector;
	    }
	  }
	}
	audit.setSectors(sectorsArray);
      }
      /* Components */
      if (auditEntity.getComponents() != null
	  && auditEntity.getComponents().size() > 0) {
	List	components = new Vector();
	for (int i = 0; i < auditEntity.getComponents().size(); i++) {
	  FareComponent
	    fcompEntity = (FareComponent)auditEntity.getComponents().get(i);
	  ProrateFareComponent	fcomp = new ProrateFareComponent();
	  List	sectors = new Vector();
	  for (int j = 0; j < audit.getSectors().length; j++) {
	    ProrateSector sector = (ProrateSector)audit.getSectors()[j];
	    for (int k = 0; k < fcompEntity.getSectors().size(); k++) {
	      Sector	sectorEntity = (Sector)fcompEntity.getSectors().get(k);
	      if (sector.getSequenceNo() == sectorEntity.getSequenceNo()) {
		sectors.add(sector);
		break;
	      }
	    }
	  }
	  ProrateSector	sectorsArray[] = new ProrateSector[sectors.size()];
	  for (int j = 0; j < sectors.size(); j++) {
	    sectorsArray[j] = (ProrateSector)sectors.get(j);
	  }
	  fcomp.setSectors(sectorsArray);
	  fcomp.setAudit(audit);
	  fcomp.setValue(fcompEntity.getValue());
	  fcomp.setKind(fcompEntity.getKind());
	  fcomp.setFixedFareDiscount(fcompEntity.getFixedFareDiscount());
	  components.add(fcomp);
	}
	ProrateFareComponent[]
	  componentArray = new ProrateFareComponent[components.size()];
	for (int j = 0; j < components.size(); j++) {
	  componentArray[j] = (ProrateFareComponent)components.get(j);
	}
	audit.setComponents(componentArray);
      }
      return audit;
    }

    /**
     * Business method <code>prorate</code> method
     *
     * @param ticketNumber a <code>String</code> value
     * @param auditIn a <code>ProrateAudit</code> value
     * @return a <code>ProrateAudit</code> value
     * @exception Exception if an error occurs
     * @ejb.interface-method  view-type = "both"
     */
    public ProrateAudit prorate(String ticketNumber, ProrateAudit auditIn)
      throws Exception {
      ProrateAudit	audit = find(ticketNumber);
      if (audit == null) {
	return null;
      }
      audit.setOwnAudit(auditIn.isOwnAudit());
      audit.setTicketing(auditIn.isTicketing());
      audit.setInward(auditIn.isInward());
      audit.setTraceLevel(auditIn.getTraceLevel());
      audit.setOwnAirwayId(auditIn.getOwnAirwayId());
      if (audit.isOwnAudit() && audit.isTicketing()) {
	if (audit.getSalesCurrency().equals("")) {
	  audit.setSalesCurrency(audit.getCurrency());
	}
	if (audit.getSalesFare() == (double)0) {
	  audit.setSalesFare(audit.getTicketFare());
	}
      }
      ProrateAudit	auditRet = null;
      try {
	auditRet = prorate.prorate(audit);
      }
      catch (Exception e) {
	audit.setErrorString(e.getMessage());
	if (audit.getErrorString() == null) {
	  audit.setErrorString(e.toString());
	}
	return audit;
      }
      boolean	ret = persist(ticketNumber, auditRet);
      if (!ret) {
	auditRet = audit;
      }
      return auditRet;
    }
  }
