// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

/* Model of the FareComponent in the AUDIT */
@Entity(name="fcomp")
  /**
   * class <code>FareComponent</code>
   *	The model of the separated fare component.
   * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
   * @version   1.0
   */
  public class FareComponent implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * <code>id</code>	primary key of the entity bean
     *
     */
    @Id
      @GeneratedValue(strategy = GenerationType.AUTO) // ID auto numbered
      int	id;
    /**
     * variable <code>audit</code>
     *	the reference to the whole audit model object
     *	in which this fare component belongs
     *
     */
    @ManyToOne
      @JoinColumn(name = "ticketNumber")
      Audit	audit;
    /**
     * variable <code>sectors</code>
     *	the list of the all sectors in this fare component 
     * @uml.property  name="sectors"
     */
    @OneToMany(mappedBy = "fcomp")
      List<Sector>	sectors;
    /**
     * variable <code>value</code> the amount value of the fare compont
     * @uml.property  name="value"
     */
    double	value;
    /**
     * variable <code>kind</code>
     *	the classification number of the fare component type
     * @uml.property  name="kind"
     */
    int	kind;
    /**
     * variable <code>fixedFareDiscount</code>
     *	fixed fare check discounting rate Fixed
     * @uml.property  name="fixedFareDiscount"
     */
    double	fixedFareDiscount;

    /**
     * Creates a new <code>FareComponent</code> instance.
     *
     */
    public FareComponent() {
      sectors = new Vector();
    }

    public FareComponent(Audit audit_in, List<Sector> sectors_in) {
      audit = audit_in;
      sectors = sectors_in;
    }

    /**
     * <code>getId</code> method
     *
     * @return an <code>int</code> value
     */
    public int getId() {
      return id;
    }

    /**
     * <code>setId</code> method
     *
     * @param id an <code>int</code> value
     */
    public void setId(int id) {
      this.id = id;
    }

    /**
     * @return  audit
     * @uml.property  name="audit"
     */
    public Audit getAudit() {
      return audit;
    }

    /**
     * @param audit  audit to be set
     * @uml.property  name="audit"
     */
    public void setAudit(Audit audit) {
      this.audit = audit;
    }

    /**
     * @return  fixedFareDiscount
     * @uml.property  name="fixedFareDiscount"
     */
    public double getFixedFareDiscount() {
      return fixedFareDiscount;
    }

    /**
     * @param fixedFareDiscount  fixedFareDiscount to be set
     * @uml.property  name="fixedFareDiscount"
     */
    public void setFixedFareDiscount(double fixedFareDiscount) {
      this.fixedFareDiscount = fixedFareDiscount;
    }

    /**
     * @return  kind
     * @uml.property  name="kind"
     */
    public int getKind() {
      return kind;
    }

    /**
     * @param kind  kind to be set
     * @uml.property  name="kind"
     */
    public void setKind(int kind) {
      this.kind = kind;
    }

    /**
     * @return  sectors
     * @uml.property  name="sectors"
     */
    public List<Sector> getSectors() {
      return sectors;
    }

    /**
     * @param sectors  sectors to be set
     * @uml.property  name="sectors"
     */
    public void setSectors(List<Sector> sectors) {
      this.sectors = sectors;
    }

    /**
     * @return  value
     * @uml.property  name="value"
     */
    public double getValue() {
      return value;
    }

    /**
     * @param value  value to be set
     * @uml.property  name="value"
     */
    public void setValue(double value) {
      this.value = value;
    }
  }
