// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Column;

/* model of the Sector in the AUDIT */
@Entity(name="sector")
  /**
   * class <code>Sector</code> The model of the sector of the audit.
   * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
   * @version  1.0
   */
  public class Sector implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @Id
      @GeneratedValue(strategy = GenerationType.AUTO) // ID auto numbered
      /**
       * <code>id</code>	primary key of the entity bean
       *
       */
      int	id;
    /**
     * variable <code>audit</code>	the reference to the Audit
     *
     */
    @ManyToOne
      @JoinColumn(name = "ticketNumber")
      Audit	audit;
    /**
     * variable <code>fcomp</code>	the reference to the FareComponent
     *
     */
    @ManyToOne
      FareComponent	fcomp;
    
    /**
     * variable <code>stopOver</code>
     * 	the flag tells whether the stop over is not allowed
     * @uml.property  name="stopOver"
     */
    byte	stopOver;
    /**
     * variable <code>depCode</code>
     *	the 3letter code of the departure city or airport
     * @uml.property  name="depCode"
     */
    @Column(name="depCode", length=3)
      String	depCode = "";
    /**
     * variable <code>destCode</code>
     *	the 3letter code of the destination city or airport
     * @uml.property  name="destCode"
     */
    @Column(name="destCode", length=3)
      String	destCode = "";
    /**
     * variable <code>carrier</code> the 2letter code of the carrier
     * @uml.property  name="carrier"
     */
    @Column(name="carrier", length=2)
      String	carrier = "";
    /**
     * variable <code>flightNo</code> the flight no
     * @uml.property  name="flightNo"
     */
    @Column(name="flightNo", length=4)
      String	flightNo = "0";
    /**
     * variable <code>classOfService</code> class of service column string
     * @uml.property  name="classOfService"
     */
    @Column(name="classOfService", length=1)
      String	classOfService = "";
    /**
     * variable <code>flightDate</code> the flight date column string
     * @uml.property  name="flightDate"
     */
    @Column(name="flightDate", length=8)
      String	flightDate = "00000000";
    /**
     * variable <code>depTime</code> the departure time column string
     * @uml.property  name="depTime"
     */
    @Column(name="depTime", length=4)
      String	depTime = "";
    /**
     * variable <code>fareBasis</code> the fare basis column string
     * @uml.property  name="fareBasis"
     */
    @Column(name="fareBasis", length=128)
      String	fareBasis = "Y";
    /**
     * variable <code>fareComponent</code> fare component amount
     * @uml.property  name="fareComponent"
     */
    double	fareComponent;
    /**
     * variable <code>classDiffPlus</code> class differential plus amount
     * @uml.property  name="classDiffPlus"
     */
    double	classDiffPlus;
    /**
     * variable <code>secureCharge</code> security charge amount
     * @uml.property  name="secureCharge"
     */
    double	secureCharge;
    /**
     * variable <code>sideTripPlus</code> side trip plus amount
     * @uml.property  name="sideTripPlus"
     */
    double	sideTripPlus;
    /**
     * variable <code>stopOverPlus</code> stop over plus amount
     * @uml.property  name="stopOverPlus"
     */
    double	stopOverPlus;
    /**
     * variable <code>prorateFactor</code> prorate factor value
     * @uml.property  name="prorateFactor"
     */
    double	prorateFactor;
    /**
     * variable <code>tax</code> tax amount
     * @uml.property  name="tax"
     */
    double	tax;
    /**
     * variable <code>taxIndex</code> tax index
     * @uml.property  name="taxIndex"
     */
    int	taxIndex;
    /**
     * variable <code>taxInLocal</code> tax amount in local currency
     * @uml.property  name="taxInLocal"
     */
    double	taxInLocal;
    /**
     * variable <code>commission</code> commission amount
     * @uml.property  name="commission"
     */
    double	commission;
    /**
     * variable <code>prorationType</code>
     *	proration type (bits of the way the prorate value is calculated)
     * @uml.property  name="prorationType"
     */
    int	prorationType;
    /**
     * variable <code>spaBaseAmtType</code> spa base amount currency string
     * @uml.property  name="spaBaseAmtType"
     */
    @Column(name="spaBaseAmtType", length=3)
      String	spaBaseAmtType = "";
    /**
     * variable <code>spaBaseAmt</code> spa base amount value
     * @uml.property  name="spaBaseAmt"
     */
    double	spaBaseAmt;
    /**
     * variable <code>spaDay5Rate</code>
     *	5day rate used to calculate spa base amount value
     * @uml.property  name="spaDay5Rate"
     */
    double	spaDay5Rate;
    /**
     * variable <code>spaDiscountRate</code> spa discount rate value
     * @uml.property  name="spaDiscountRate"
     */
    double	spaDiscountRate;
    /**
     * variable <code>spaClassDiff</code> spa class differential amount
     * @uml.property  name="spaClassDiff"
     */
    double	spaClassDiff;
    /**
     * variable <code>apdpBaseAmtType</code> apdp base amount currency string
     * @uml.property  name="apdpBaseAmtType"
     */
    @Column(name="apdpBaseAmtType", length=3)
      String	apdpBaseAmtType = "";
    /**
     * variable <code>apdpBaseAmt</code> apdp base amount value
     * @uml.property  name="apdpBaseAmt"
     */
    double	apdpBaseAmt;
    /**
     * variable <code>apdpDay5Rate</code>
     *	5day rate used to calculate apdp base amount value
     * @uml.property  name="apdpDay5Rate"
     */
    double	apdpDay5Rate;
    /**
     * variable <code>apdpDiscountRate</code> apdp discount rate value
     * @uml.property  name="apdpDiscountRate"
     */
    double	apdpDiscountRate;
    /**
     * variable <code>apdpClassDiff</code> apdp class differential amount
     * @uml.property  name="apdpClassDiff"
     */
    double	apdpClassDiff;
    /**
     * variable <code>proratedClassDiff</code> prorated class differential amount
     * @uml.property  name="proratedClassDiff"
     */
    double	proratedClassDiff;
    /**
     * variable <code>exstPlus</code> exst additional value
     * @uml.property  name="exstPlus"
     */
    double	exstPlus;
    /**
     * variable <code>proratedExstPlus</code> prorated exst additional value
     * @uml.property  name="proratedExstPlus"
     */
    double	proratedExstPlus;
    /**
     * variable <code>prorateError</code>
     *	code value of the error which is occured in the proration calculation
     * @uml.property  name="prorateError"
     */
    int	prorateError;
    /**
     * variable <code>spaNuc</code> nuc amount value of spa
     * @uml.property  name="spaNuc"
     */
    double	spaNuc;
    /**
     * variable <code>apdpNuc</code> nuc amount value of apdp
     * @uml.property  name="apdpNuc"
     */
    double	apdpNuc;
    /**
     * variable <code>npPvalues</code> nuc amount value of the normal proration
     * @uml.property  name="npPvalues"
     */
    double	npPvalues;
    /**
     * variable <code>srpNuc</code>
     *	nuc amount value of the straight rate proration
     * @uml.property  name="srpNuc"
     */
    double	srpNuc;
    /**
     * variable <code>prorateValue</code>
     *	nuc amount value of the proration calculation result
     * @uml.property  name="prorateValue"
     */
    double	prorateValue;
    /**
     * variable <code>amountInLocal</code>
     *	amount value of the proration calculation result in local currency
     * @uml.property  name="amountInLocal"
     */
    double	amountInLocal;
    /**
     * variable <code>invoiceValue</code> amount value of the invoice proration
     * @uml.property  name="invoiceValue"
     */
    double	invoiceValue;
    /**
     * variable <code>sideTripIndex</code> side trip index number
     * @uml.property  name="sideTripIndex"
     */
    int	sideTripIndex;
    /**
     * variable <code>classDiffIndex</code> class differential index number
     * @uml.property  name="classDiffIndex"
     */
    int	classDiffIndex;
    /**
     * variable <code>secureIndex</code> security charge index number
     * @uml.property  name="secureIndex"
     */
    int	secureIndex;
    /**
     * variable <code>fixedFareCheck</code> fixed fare check percentage
     * @uml.property  name="fixedFareCheck"
     */
    double	fixedFareCheck;
    /**
     * variable <code>fixedFareDiscount</code> fixed fare check discounting rate
     * @uml.property  name="fixedFareDiscount"
     */
    double	fixedFareDiscount;
    /**
     * variable <code>componentIndex</code>
     *	index number of the fare component in which the sector belongs
     * @uml.property  name="componentIndex"
     */
    int	componentIndex;
    /**
     * variable <code>componentKind</code>
     *	the classification number of the fare component type
     *	in which the sector belongs
     * @uml.property  name="componentKind"
     */
    int	componentKind;
    /**
     * variable <code>viaRouting</code>
     *	via routing information string (ex. "AT", "PA" etc.)
     * @uml.property  name="viaRouting"
     */
    @Column(name="viaRouting", length=2)
      String	viaRouting = "";
    /**
     * variable <code>fareType</code>
     *	the classification number of the fare
     *	(normal, special, or promotional)
     * @uml.property  name="fareType"
     */
    int	fareType;
    /**
     * variable <code>sequenceNo</code> sequence number of the sector
     * @uml.property  name="sequenceNo"
     */
    int	sequenceNo;
    /**
     * variable <code>depAirport</code> the 3letter code of the departure airport
     * @uml.property  name="depAirport"
     */
    @Column(name="depAirport", length=3)
      String	depAirport = "";
    /**
     * variable <code>destAirport</code>
     *	the 3letter code of the destination airport
     * @uml.property  name="destAirport"
     */
    @Column(name="destAirport", length=3)
      String	destAirport = "";
    /**
     * variable <code>opCarrier</code>
     *	the 2letter code of the operation carrier of the code share
     * @uml.property  name="opCarrier"
     */
    @Column(name="opCarrier", length=2)
      String	opCarrier = "";
    /**
     * variable <code>npClassDiff</code>
     *	class differential value of the normal proration
     *	(before spa application)
     * @uml.property  name="npClassDiff"
     */
    double	npClassDiff;
    /**
     * variable <code>secureChargeSaved</code> the value of security charge saved
     * @uml.property  name="secureChargeSaved"
     */
    double	secureChargeSaved;
    /**
     * variable <code>proratedSecureCharge</code>
     *	the value of prorated security charge
     * @uml.property  name="proratedSecureCharge"
     */
    double	proratedSecureCharge;
    /**
     * variable <code>errorFlag</code>
     *	the classification number of the error
     *	which is occurred during proration
     * @uml.property  name="errorFlag"
     */
    int	errorFlag;
    /**
     * variable <code>errorString</code>
     *	the message string of the error which is occurred during proration
     * @uml.property  name="errorString"
     */
    @Column(name="errorString", length=1024)
      String	errorString = "";
    /**
     * variable <code>fixValue</code>
     *	the amount for comparison of the function High_spa_fix()/Low_spa_fix()
     * @uml.property  name="fixValue"
     */
    double	fixValue;
    /**
     * variable <code>fixCurrency</code>
     *	the fixed currency string of the function High_spa_fix()/Low_spa_fix()
     * @uml.property  name="fixCurrency"
     */
    @Column(name="fixCurrency", length=3)
      String	fixCurrency;
    /**
     * variable <code>fixAmount</code>
     *	the result amount of the function High_spa_fix()/Low_spa_fix()
     * @uml.property  name="fixAmount"
     */
    double	fixAmount;
    /**
     * variable <code>invoiceFlg</code>
     *	the flag tells whether the sector is to invoice or to be invoiced
     * @uml.property  name="invoiceFlg"
     */
    boolean	invoiceFlg;
    /**
     * variable <code>certainty</code> the certainty factor	not used now
     * @uml.property  name="certainty"
     */
    double	certainty;

    /**
     * Creates a new <code>Sector</code> instance.
     *
     */
    public Sector() {
      /* ;;; not implemented yet */
      super();
    }
    /**
     * <code>getId</code> method
     *
     * @return an <code>int</code> value
     */
    public int getId() {
      return id;
    }
    /**
     * <code>setId</code> method
     *
     * @param id an <code>int</code> value
     */
    public void setId(int id) {
      this.id = id;
    }
    /**
     * <code>getAudit</code> method
     *
     * @return an <code>int</code> value
     */
    public Audit getAudit() {
      return audit;
    }
    /**
     * <code>setAudit</code> method
     *
     * @param audit an <code>int</code> value
     */
    public void setAudit(Audit audit) {
      this.audit = audit;
    }
    /**
     * @return  amountInLocal
     * @uml.property  name="amountInLocal"
     */
    public double getAmountInLocal() {
      return amountInLocal;
    }
    /**
     * @param amountInLocal  amountInLocal to be set
     * @uml.property  name="amountInLocal"
     */
    public void setAmountInLocal(double amountInLocal) {
      this.amountInLocal = amountInLocal;
    }
    /**
     * @return  apdpBaseAmt
     * @uml.property  name="apdpBaseAmt"
     */
    public double getApdpBaseAmt() {
      return apdpBaseAmt;
    }
    /**
     * @param apdpBaseAmt  apdpBaseAmt to be set
     * @uml.property  name="apdpBaseAmt"
     */
    public void setApdpBaseAmt(double apdpBaseAmt) {
      this.apdpBaseAmt = apdpBaseAmt;
    }
    /**
     * @return  apdpBaseAmtType
     * @uml.property  name="apdpBaseAmtType"
     */
    public String getApdpBaseAmtType() {
      return apdpBaseAmtType;
    }
    /**
     * @param apdpBaseAmtType  apdpBaseAmtType to be set
     * @uml.property  name="apdpBaseAmtType"
     */
    public void setApdpBaseAmtType(String apdpBaseAmtType) {
      this.apdpBaseAmtType = apdpBaseAmtType;
    }
    /**
     * @return  apdpClassDiff
     * @uml.property  name="apdpClassDiff"
     */
    public double getApdpClassDiff() {
      return apdpClassDiff;
    }
    /**
     * @param apdpClassDiff  apdpClassDiff to be set
     * @uml.property  name="apdpClassDiff"
     */
    public void setApdpClassDiff(double apdpClassDiff) {
      this.apdpClassDiff = apdpClassDiff;
    }
    /**
     * @return  apdpDay5Rate
     * @uml.property  name="apdpDay5Rate"
     */
    public double getApdpDay5Rate() {
      return apdpDay5Rate;
    }
    /**
     * @param apdpDay5Rate  apdpDay5Rate to be set
     * @uml.property  name="apdpDay5Rate"
     */
    public void setApdpDay5Rate(double apdpDay5Rate) {
      this.apdpDay5Rate = apdpDay5Rate;
    }
    /**
     * @return  apdpDiscountRate
     * @uml.property  name="apdpDiscountRate"
     */
    public double getApdpDiscountRate() {
      return apdpDiscountRate;
    }
    /**
     * @param apdpDiscountRate  apdpDiscountRate to be set
     * @uml.property  name="apdpDiscountRate"
     */
    public void setApdpDiscountRate(double apdpDiscountRate) {
      this.apdpDiscountRate = apdpDiscountRate;
    }
    /**
     * @return  apdpNuc
     * @uml.property  name="apdpNuc"
     */
    public double getApdpNuc() {
      return apdpNuc;
    }
    /**
     * @param apdpNuc  apdpNuc to be set
     * @uml.property  name="apdpNuc"
     */
    public void setApdpNuc(double apdpNuc) {
      this.apdpNuc = apdpNuc;
    }
    /**
     * @return  carrier
     * @uml.property  name="carrier"
     */
    public String getCarrier() {
      return carrier;
    }
    /**
     * @param carrier  carrier to be set
     * @uml.property  name="carrier"
     */
    public void setCarrier(String carrier) {
      this.carrier = carrier;
    }
    /**
     * @return  certainty
     * @uml.property  name="certainty"
     */
    public double getCertainty() {
      return certainty;
    }
    /**
     * @param certainty  certainty to be set
     * @uml.property  name="certainty"
     */
    public void setCertainty(double certainty) {
      this.certainty = certainty;
    }
    /**
     * @return  classDiffIndex
     * @uml.property  name="classDiffIndex"
     */
    public int getClassDiffIndex() {
      return classDiffIndex;
    }
    /**
     * @param classDiffIndex  classDiffIndex to be set
     * @uml.property  name="classDiffIndex"
     */
    public void setClassDiffIndex(int classDiffIndex) {
      this.classDiffIndex = classDiffIndex;
    }
    /**
     * @return  classDiffPlus
     * @uml.property  name="classDiffPlus"
     */
    public double getClassDiffPlus() {
      return classDiffPlus;
    }
    /**
     * @param classDiffPlus  classDiffPlus to be set
     * @uml.property  name="classDiffPlus"
     */
    public void setClassDiffPlus(double classDiffPlus) {
      this.classDiffPlus = classDiffPlus;
    }
    /**
     * @return  classOfService
     * @uml.property  name="classOfService"
     */
    public String getClassOfService() {
      return classOfService;
    }
    /**
     * @param classOfService  classOfService to be set
     * @uml.property  name="classOfService"
     */
    public void setClassOfService(String classOfService) {
      this.classOfService = classOfService;
    }
    /**
     * @return  commission
     * @uml.property  name="commission"
     */
    public double getCommission() {
      return commission;
    }
    /**
     * @param commission  commission to be set
     * @uml.property  name="commission"
     */
    public void setCommission(double commission) {
      this.commission = commission;
    }
    /**
     * @return  componentIndex
     * @uml.property  name="componentIndex"
     */
    public int getComponentIndex() {
      return componentIndex;
    }
    /**
     * @param componentIndex  componentIndex to be set
     * @uml.property  name="componentIndex"
     */
    public void setComponentIndex(int componentIndex) {
      this.componentIndex = componentIndex;
    }
    /**
     * @return  componentKind
     * @uml.property  name="componentKind"
     */
    public int getComponentKind() {
      return componentKind;
    }
    /**
     * @param componentKind  componentKind to be set
     * @uml.property  name="componentKind"
     */
    public void setComponentKind(int componentKind) {
      this.componentKind = componentKind;
    }
    /**
     * @return  depAirport
     * @uml.property  name="depAirport"
     */
    public String getDepAirport() {
      return depAirport;
    }
    /**
     * @param depAirport  depAirport to be set
     * @uml.property  name="depAirport"
     */
    public void setDepAirport(String depAirport) {
      this.depAirport = depAirport;
    }
    /**
     * @return  depCode
     * @uml.property  name="depCode"
     */
    public String getDepCode() {
      return depCode;
    }
    /**
     * @param depCode  depCode to be set
     * @uml.property  name="depCode"
     */
    public void setDepCode(String depCode) {
      this.depCode = depCode;
    }
    /**
     * @return  depTime
     * @uml.property  name="depTime"
     */
    public String getDepTime() {
      return depTime;
    }
    /**
     * @param depTime  depTime to be set
     * @uml.property  name="depTime"
     */
    public void setDepTime(String depTime) {
      this.depTime = depTime;
    }
    /**
     * @return  destAirport
     * @uml.property  name="destAirport"
     */
    public String getDestAirport() {
      return destAirport;
    }
    /**
     * @param destAirport  destAirport to be set
     * @uml.property  name="destAirport"
     */
    public void setDestAirport(String destAirport) {
      this.destAirport = destAirport;
    }
    /**
     * @return  destCode
     * @uml.property  name="destCode"
     */
    public String getDestCode() {
      return destCode;
    }
    /**
     * @param destCode  destCode to be set
     * @uml.property  name="destCode"
     */
    public void setDestCode(String destCode) {
      this.destCode = destCode;
    }
    /**
     * @return  errorFlag
     * @uml.property  name="errorFlag"
     */
    public int getErrorFlag() {
      return errorFlag;
    }
    /**
     * @param errorFlag  errorFlag to be set
     * @uml.property  name="errorFlag"
     */
    public void setErrorFlag(int errorFlag) {
      this.errorFlag = errorFlag;
    }
    /**
     * @return  errorString
     * @uml.property  name="errorString"
     */
    public String getErrorString() {
      return errorString;
    }
    /**
     * @param errorString  errorString to be set
     * @uml.property  name="errorString"
     */
    public void setErrorString(String errorString) {
      this.errorString = errorString;
    }
    /**
     * @return  exstPlus
     * @uml.property  name="exstPlus"
     */
    public double getExstPlus() {
      return exstPlus;
    }
    /**
     * @param exstPlus  exstPlus to be set
     * @uml.property  name="exstPlus"
     */
    public void setExstPlus(double exstPlus) {
      this.exstPlus = exstPlus;
    }
    /**
     * @return  fareBasis
     * @uml.property  name="fareBasis"
     */
    public String getFareBasis() {
      return fareBasis;
    }
    /**
     * @param fareBasis  fareBasis to be set
     * @uml.property  name="fareBasis"
     */
    public void setFareBasis(String fareBasis) {
      this.fareBasis = fareBasis;
    }
    /**
     * @return  fareComponent
     * @uml.property  name="fareComponent"
     */
    public double getFareComponent() {
      return fareComponent;
    }
    /**
     * @param fareComponent  fareComponent to be set
     * @uml.property  name="fareComponent"
     */
    public void setFareComponent(double fareComponent) {
      this.fareComponent = fareComponent;
    }
    /**
     * @return  fareType
     * @uml.property  name="fareType"
     */
    public int getFareType() {
      return fareType;
    }
    /**
     * @param fareType  fareType to be set
     * @uml.property  name="fareType"
     */
    public void setFareType(int fareType) {
      this.fareType = fareType;
    }
    /**
     * @return  fixAmount
     * @uml.property  name="fixAmount"
     */
    public double getFixAmount() {
      return fixAmount;
    }
    /**
     * @param fixAmount  fixAmount to be set
     * @uml.property  name="fixAmount"
     */
    public void setFixAmount(double fixAmount) {
      this.fixAmount = fixAmount;
    }
    /**
     * @return  fixCurrency
     * @uml.property  name="fixCurrency"
     */
    public String getFixCurrency() {
      return fixCurrency;
    }
    /**
     * @param fixCurrency  fixCurrency to be set
     * @uml.property  name="fixCurrency"
     */
    public void setFixCurrency(String fixCurrency) {
      this.fixCurrency = fixCurrency;
    }
    /**
     * @return  fixedFareCheck
     * @uml.property  name="fixedFareCheck"
     */
    public double getFixedFareCheck() {
      return fixedFareCheck;
    }
    /**
     * @param fixedFareCheck  fixedFareCheck to be set
     * @uml.property  name="fixedFareCheck"
     */
    public void setFixedFareCheck(double fixedFareCheck) {
      this.fixedFareCheck = fixedFareCheck;
    }
    /**
     * @return  fixedFareDiscount
     * @uml.property  name="fixedFareDiscount"
     */
    public double getFixedFareDiscount() {
      return fixedFareDiscount;
    }
    /**
     * @param fixedFareDiscount  fixedFareDiscount to be set
     * @uml.property  name="fixedFareDiscount"
     */
    public void setFixedFareDiscount(double fixedFareDiscount) {
      this.fixedFareDiscount = fixedFareDiscount;
    }
    /**
     * @return  fixValue
     * @uml.property  name="fixValue"
     */
    public double getFixValue() {
      return fixValue;
    }
    /**
     * @param fixValue  fixValue to be set
     * @uml.property  name="fixValue"
     */
    public void setFixValue(double fixValue) {
      this.fixValue = fixValue;
    }
    /**
     * @return  flightDate
     * @uml.property  name="flightDate"
     */
    public String getFlightDate() {
      return flightDate;
    }
    /**
     * @param flightDate  flightDate to be set
     * @uml.property  name="flightDate"
     */
    public void setFlightDate(String flightDate) {
      this.flightDate = flightDate;
    }
    /**
     * @return  flightNo
     * @uml.property  name="flightNo"
     */
    public String getFlightNo() {
      return flightNo;
    }
    /**
     * @param flightNo  flightNo to be set
     * @uml.property  name="flightNo"
     */
    public void setFlightNo(String flightNo) {
      this.flightNo = flightNo;
    }
    /**
     * @return  invoiceFlg
     * @uml.property  name="invoiceFlg"
     */
    public boolean isInvoiceFlg() {
      return invoiceFlg;
    }
    /**
     * @param invoiceFlg  invoiceFlg to be set
     * @uml.property  name="invoiceFlg"
     */
    public void setInvoiceFlg(boolean invoiceFlg) {
      this.invoiceFlg = invoiceFlg;
    }
    /**
     * @return  invoiceValue
     * @uml.property  name="invoiceValue"
     */
    public double getInvoiceValue() {
      return invoiceValue;
    }
    /**
     * @param invoiceValue  invoiceValue to be set
     * @uml.property  name="invoiceValue"
     */
    public void setInvoiceValue(double invoiceValue) {
      this.invoiceValue = invoiceValue;
    }
    /**
     * @return  npClassDiff
     * @uml.property  name="npClassDiff"
     */
    public double getNpClassDiff() {
      return npClassDiff;
    }
    /**
     * @param npClassDiff  npClassDiff to be set
     * @uml.property  name="npClassDiff"
     */
    public void setNpClassDiff(double npClassDiff) {
      this.npClassDiff = npClassDiff;
    }
    /**
     * @return  npPvalues
     * @uml.property  name="npPvalues"
     */
    public double getNpPvalues() {
      return npPvalues;
    }
    /**
     * @param npPvalues  npPvalues to be set
     * @uml.property  name="npPvalues"
     */
    public void setNpPvalues(double npPvalues) {
      this.npPvalues = npPvalues;
    }
    /**
     * @return  opCarrier
     * @uml.property  name="opCarrier"
     */
    public String getOpCarrier() {
      return opCarrier;
    }
    /**
     * @param opCarrier  opCarrier to be set
     * @uml.property  name="opCarrier"
     */
    public void setOpCarrier(String opCarrier) {
      this.opCarrier = opCarrier;
    }
    /**
     * @return  proratedClassDiff
     * @uml.property  name="proratedClassDiff"
     */
    public double getProratedClassDiff() {
      return proratedClassDiff;
    }
    /**
     * @param proratedClassDiff  proratedClassDiff to be set
     * @uml.property  name="proratedClassDiff"
     */
    public void setProratedClassDiff(double proratedClassDiff) {
      this.proratedClassDiff = proratedClassDiff;
    }
    /**
     * @return  proratedExstPlus
     * @uml.property  name="proratedExstPlus"
     */
    public double getProratedExstPlus() {
      return proratedExstPlus;
    }
    /**
     * @param proratedExstPlus  proratedExstPlus to be set
     * @uml.property  name="proratedExstPlus"
     */
    public void setProratedExstPlus(double proratedExstPlus) {
      this.proratedExstPlus = proratedExstPlus;
    }
    /**
     * @return  proratedSecureCharge
     * @uml.property  name="proratedSecureCharge"
     */
    public double getProratedSecureCharge() {
      return proratedSecureCharge;
    }
    /**
     * @param proratedSecureCharge  proratedSecureCharge to be set
     * @uml.property  name="proratedSecureCharge"
     */
    public void setProratedSecureCharge(double proratedSecureCharge) {
      this.proratedSecureCharge = proratedSecureCharge;
    }
    /**
     * @return  prorateError
     * @uml.property  name="prorateError"
     */
    public int getProrateError() {
      return prorateError;
    }
    /**
     * @param prorateError  prorateError to be set
     * @uml.property  name="prorateError"
     */
    public void setProrateError(int prorateError) {
      this.prorateError = prorateError;
    }
    /**
     * @return  prorateFactor
     * @uml.property  name="prorateFactor"
     */
    public double getProrateFactor() {
      return prorateFactor;
    }
    /**
     * @param prorateFactor  prorateFactor to be set
     * @uml.property  name="prorateFactor"
     */
    public void setProrateFactor(double prorateFactor) {
      this.prorateFactor = prorateFactor;
    }
    /**
     * @return  prorateValue
     * @uml.property  name="prorateValue"
     */
    public double getProrateValue() {
      return prorateValue;
    }
    /**
     * @param prorateValue  prorateValue to be set
     * @uml.property  name="prorateValue"
     */
    public void setProrateValue(double prorateValue) {
      this.prorateValue = prorateValue;
    }
    /**
     * @return  prorationType
     * @uml.property  name="prorationType"
     */
    public int getProrationType() {
      return prorationType;
    }
    /**
     * @param prorationType  prorationType to be set
     * @uml.property  name="prorationType"
     */
    public void setProrationType(int prorationType) {
      this.prorationType = prorationType;
    }
    /**
     * @return  secureCharge
     * @uml.property  name="secureCharge"
     */
    public double getSecureCharge() {
      return secureCharge;
    }
    /**
     * @param secureCharge  secureCharge to be set
     * @uml.property  name="secureCharge"
     */
    public void setSecureCharge(double secureCharge) {
      this.secureCharge = secureCharge;
    }
    /**
     * @return  secureChargeSaved
     * @uml.property  name="secureChargeSaved"
     */
    public double getSecureChargeSaved() {
      return secureChargeSaved;
    }
    /**
     * @param secureChargeSaved  secureChargeSaved to be set
     * @uml.property  name="secureChargeSaved"
     */
    public void setSecureChargeSaved(double secureChargeSaved) {
      this.secureChargeSaved = secureChargeSaved;
    }
    /**
     * @return  secureIndex
     * @uml.property  name="secureIndex"
     */
    public int getSecureIndex() {
      return secureIndex;
    }
    /**
     * @param secureIndex  secureIndex to be set
     * @uml.property  name="secureIndex"
     */
    public void setSecureIndex(int secureIndex) {
      this.secureIndex = secureIndex;
    }
    /**
     * @return  sequenceNo
     * @uml.property  name="sequenceNo"
     */
    public int getSequenceNo() {
      return sequenceNo;
    }
    /**
     * @param sequenceNo  sequenceNo to be set
     * @uml.property  name="sequenceNo"
     */
    public void setSequenceNo(int sequenceNo) {
      this.sequenceNo = sequenceNo;
    }
    /**
     * @return  sideTripIndex
     * @uml.property  name="sideTripIndex"
     */
    public int getSideTripIndex() {
      return sideTripIndex;
    }
    /**
     * @param sideTripIndex  sideTripIndex to be set
     * @uml.property  name="sideTripIndex"
     */
    public void setSideTripIndex(int sideTripIndex) {
      this.sideTripIndex = sideTripIndex;
    }
    /**
     * @return  sideTripPlus
     * @uml.property  name="sideTripPlus"
     */
    public double getSideTripPlus() {
      return sideTripPlus;
    }
    /**
     * @param sideTripPlus  sideTripPlus to be set
     * @uml.property  name="sideTripPlus"
     */
    public void setSideTripPlus(double sideTripPlus) {
      this.sideTripPlus = sideTripPlus;
    }
    /**
     * @return  spaBaseAmt
     * @uml.property  name="spaBaseAmt"
     */
    public double getSpaBaseAmt() {
      return spaBaseAmt;
    }
    /**
     * @param spaBaseAmt  spaBaseAmt to be set
     * @uml.property  name="spaBaseAmt"
     */
    public void setSpaBaseAmt(double spaBaseAmt) {
      this.spaBaseAmt = spaBaseAmt;
    }
    /**
     * @return  spaBaseAmtType
     * @uml.property  name="spaBaseAmtType"
     */
    public String getSpaBaseAmtType() {
      return spaBaseAmtType;
    }
    /**
     * @param spaBaseAmtType  spaBaseAmtType to be set
     * @uml.property  name="spaBaseAmtType"
     */
    public void setSpaBaseAmtType(String spaBaseAmtType) {
      this.spaBaseAmtType = spaBaseAmtType;
    }
    /**
     * @return  spaClassDiff
     * @uml.property  name="spaClassDiff"
     */
    public double getSpaClassDiff() {
      return spaClassDiff;
    }
    /**
     * @param spaClassDiff  spaClassDiff to be set
     * @uml.property  name="spaClassDiff"
     */
    public void setSpaClassDiff(double spaClassDiff) {
      this.spaClassDiff = spaClassDiff;
    }
    /**
     * @return  spaDay5Rate
     * @uml.property  name="spaDay5Rate"
     */
    public double getSpaDay5Rate() {
      return spaDay5Rate;
    }
    /**
     * @param spaDay5Rate  spaDay5Rate to be set
     * @uml.property  name="spaDay5Rate"
     */
    public void setSpaDay5Rate(double spaDay5Rate) {
      this.spaDay5Rate = spaDay5Rate;
    }
    /**
     * @return  spaDiscountRate
     * @uml.property  name="spaDiscountRate"
     */
    public double getSpaDiscountRate() {
      return spaDiscountRate;
    }
    /**
     * @param spaDiscountRate  spaDiscountRate to be set
     * @uml.property  name="spaDiscountRate"
     */
    public void setSpaDiscountRate(double spaDiscountRate) {
      this.spaDiscountRate = spaDiscountRate;
    }
    /**
     * @return  spaNuc
     * @uml.property  name="spaNuc"
     */
    public double getSpaNuc() {
      return spaNuc;
    }
    /**
     * @param spaNuc  spaNuc to be set
     * @uml.property  name="spaNuc"
     */
    public void setSpaNuc(double spaNuc) {
      this.spaNuc = spaNuc;
    }
    /**
     * @return  srpNuc
     * @uml.property  name="srpNuc"
     */
    public double getSrpNuc() {
      return srpNuc;
    }
    /**
     * @param srpNuc  srpNuc to be set
     * @uml.property  name="srpNuc"
     */
    public void setSrpNuc(double srpNuc) {
      this.srpNuc = srpNuc;
    }
    /**
     * @return  stopOver
     * @uml.property  name="stopOver"
     */
    public byte getStopOver() {
      return stopOver;
    }
    /**
     * @param stopOver  stopOver to be set
     * @uml.property  name="stopOver"
     */
    public void setStopOver(byte stopOver) {
      this.stopOver = stopOver;
    }
    /**
     * @return  stopOverPlus
     * @uml.property  name="stopOverPlus"
     */
    public double getStopOverPlus() {
      return stopOverPlus;
    }
    /**
     * @param stopOverPlus  stopOverPlus to be set
     * @uml.property  name="stopOverPlus"
     */
    public void setStopOverPlus(double stopOverPlus) {
      this.stopOverPlus = stopOverPlus;
    }
    /**
     * @return  tax
     * @uml.property  name="tax"
     */
    public double getTax() {
      return tax;
    }
    /**
     * @param tax  tax to be set
     * @uml.property  name="tax"
     */
    public void setTax(double tax) {
      this.tax = tax;
    }
    /**
     * @return  taxIndex
     * @uml.property  name="taxIndex"
     */
    public int getTaxIndex() {
      return taxIndex;
    }
    /**
     * @param tax  taxIndex to be set
     * @uml.property  name="taxIndex"
     */
    public void setTaxIndex(int taxIndex) {
      this.taxIndex = taxIndex;
    }
    /**
     * @return  taxInLocal
     * @uml.property  name="taxInLocal"
     */
    public double getTaxInLocal() {
      return taxInLocal;
    }
    /**
     * @param tax  taxInLocal to be set
     * @uml.property  name="taxInLocal"
     */
    public void setTaxInLocal(double taxInLocal) {
      this.taxInLocal = taxInLocal;
    }
    /**
     * @return  viaRouting
     * @uml.property  name="viaRouting"
     */
    public String getViaRouting() {
      return viaRouting;
    }
    /**
     * @param viaRouting  viaRouting to be set
     * @uml.property  name="viaRouting"
     */
    public void setViaRouting(String viaRouting) {
      this.viaRouting = viaRouting;
    }
    public FareComponent getFcomp() {
      return fcomp;
    }
    public void setFcomp(FareComponent fcomp) {
      this.fcomp = fcomp;
    }
  }
