// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Column;

/* model of the TAX description in the AUDIT */

/**
 * class <code>TaxData</code>
 *	the model of the tax description in the audit
 * @author  <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
@Entity(name="tax")
  public class TaxData implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @Id
      @GeneratedValue(strategy = GenerationType.AUTO) // ID auto numbered
      /**
       * <code>id</code>	primary key of the entity bean
       *
       */
      int	id;
    /**
     * variable <code>audit</code>	the reference to the Audit
     *
     */
    @ManyToOne
      @JoinColumn(name = "ticketNumber")
      Audit	audit;	/* AUDIT whole data */
    /**
     * variable <code>type</code> the type string of the tax
     * @uml.property  name="type"
     */
    @Column(name="type", length=8)
      String	type;
    /**
     * variable <code>amount</code> the amount value of the tax
     * @uml.property  name="amount"
     */
    double	amount;
  
    /**
     * <code>getId</code> method
     *
     * @return an <code>int</code> value
     */
    public int getId() {
      return id;
    }
    /**
     * <code>setId</code> method
     *
     * @param id an <code>int</code> value
     */
    public void setId(int id) {
      this.id = id;
    }
    /**
     * <code>getAudit</code> method
     *
     * @return an <code>int</code> value
     */
    public Audit getAudit() {
      return audit;
    }
    /**
     * <code>setAudit</code> method
     *
     * @param audit an <code>int</code> value
     */
    public void setAudit(Audit audit) {
      this.audit = audit;
    }
    /**
     * <code>getAmount</code> method	returns amount
     * @return  a <code>double</code> value
     * @uml.property  name="amount"
     */
    public double getAmount() {
      return amount;
    }
    /**
     * <code>setAmount</code>	sets amount
     * @param amount  a <code>double</code> value
     * @uml.property  name="amount"
     */
    public void setAmount(double amount) {
      this.amount = amount;
    }
    /**
     * <code>getType</code> method	returns type
     * @return  a <code>String</code> value
     * @uml.property  name="type"
     */
    public String getType() {
      return type;
    }
    /**
     * <code>setType</code> method	sets type
     * @param type  a <code>String</code> value
     * @uml.property  name="type"
     */
    public void setType(String type) {
      this.type = type;
    }
  }
