// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb.client;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.sourceforge.gnp.audit.ejb.interfaces.AuditEjb;

public class AuditEjbClient {
  
  /**
   * <code>makeInstance</code> method
   *	creates and returnsAuditEjb client instance
   *
   * @return a <code>AuditEjb</code> value
   * @throws NamingException 
   */
  static public AuditEjb	makeInstance() throws NamingException {

    /**
     * variable <code>audit</code>	AuditEjb EJB3 object
     *
     */
    AuditEjb	audit = null;

    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    Object ref = null;
    try {
      ref = context.lookup(AuditEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    audit = (AuditEjb)ref;
    return audit;
  }
}

