// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.ejb.interfaces;

import javax.ejb.Remote;

import jp.sourceforge.gnp.prorate.export.ProrateAudit;

/**
 * Remote interface for AuditEjb.
 */
@Remote
  public interface AuditEjb
  {
    public static final String JNDI_NAME="ejb/AuditEjb";

    /**
     * <code>persist</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @param audit a <code>ProrateAudit</code> value
     * @return a <code>boolean</code> value
     * @exception Exception if an error occurs
     */
    public boolean persist(String ticketNumber, ProrateAudit audit)
      throws Exception;

    /**
     * <code>remove</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception Exception if an error occurs
     */
    public boolean remove(String ticketNumber) throws Exception;
    
    /**
     * <code>find</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @return a <code>ProrateAudit</code> value
     * @exception Exception if an error occurs
     */
    public ProrateAudit	find(String ticketNumber) throws Exception;

    /**
     * Business method <code>prorate</code>
     *
     * @param ticketNumber a <code>String</code> value
     * @param auditIn a <code>ProrateAudit</code> value
     * @return a <code>ProrateAudit</code> value
     * @exception Exception if an error occurs
     * @exception java.rmi.RemoteException if an error occurs
     */
    public ProrateAudit prorate(String ticketNumber, ProrateAudit auditIn)
      throws Exception;

  }
