// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.struts.form;

import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

/**
 * class <code>AuditForm</code> This ActionForm is used by the online audit appliation to validate input data facilities for proration calculation. If any of the required fields are empty or any of the input data are invalid when validate is called by the ActionServlet, error messages are created.
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class AuditForm extends ActionForm {

  /**
   * <code>serialVersionUID</code>
   */
  private static final long serialVersionUID = 1L;

  // Attributes
  /**
   * <code>ticketNumber</code>
   *
   */
  String	ticketNumber = "";

  /**
   * @uml.property  name="fareCalculation"
   */
  String	fareCalculation = "";

  /**
   * @uml.property  name="ownAirwayId"
   */
  String	ownAirwayId = "";
  /**
   * @uml.property  name="airwayNumber"
   */
  String	airwayNumber = "";
  /**
   * @uml.property  name="couponNumber"
   */
  String	couponNumber = "";
  /**
   * @uml.property  name="inwardNumber"
   */
  String	inwardNumber = "";
  /**
   * @uml.property  name="endorsement"
   */
  String	endorsement = "";
  /**
   * @uml.property  name="issueDate"
   */
  String	issueDate = "";
  /**
   * @uml.property  name="issuePlace"
   */
  String	issuePlace = "";
  /**
   * @uml.property  name="invoiceMonth"
   */
  String	invoiceMonth = "";
  /**
   * @uml.property  name="origin"
   */
  String	origin = "";
  /**
   * @uml.property  name="destination"
   */
  String	destination = "";
  /**
   * @uml.property  name="currency"
   */
  String	currency = "";
  /**
   * @uml.property  name="ticketFare"
   */
  String	ticketFare = "";
  /**
   * @uml.property  name="salesCurrency"
   */
  String	salesCurrency = "";
  /**
   * @uml.property  name="salesFare"
   */
  String	salesFare = "";
  /**
   * @uml.property  name="plusAdjustment"
   */
  String	plusAdjustment = "";
  /**
   * @uml.property  name="lessAdjustment"
   */
  String	lessAdjustment = "";
  /**
   * @uml.property  name="commissionCurrency"
   */
  String	commissionCurrency = "";
  /**
   * @uml.property  name="commissionRate"
   */
  String	commissionRate = "";
  /**
   * @uml.property  name="commissionAmt"
   */
  String	commissionAmt = "";
  /**
   * @uml.property  name="totalNuc"
   */
  String	totalNuc = "";
  /**
   * @uml.property  name="lessAmt"
   */
  String	lessAmt = "";
  /**
   * @uml.property  name="stopOverCharge"
   */
  String	stopOverCharge = "";
  /**
   * @uml.property  name="tourCode"
   */
  String	tourCode = "";
  /**
   * @uml.property  name="agentCode"
   */
  String	agentCode = "";
  /**
   * @uml.property  name="errorFlag"
   */
  String	errorFlag = "";
  /**
   * @uml.property  name="errorString"
   */
  String	errorString = "";

  /**
   * @uml.property  name="traceLevel"
   */
  String	traceLevel = "standard";
  /**
   * @uml.property  name="traceLevelList"
   */
  List	traceLevelList = null;

  /**
   * @uml.property  name="prorateType"
   */
  String	prorateType = "outward";
  /**
   * @uml.property  name="prorateTypeList"
   */
  List	prorateTypeList = null;

  // Attributes for tax
  /**
   * @uml.property  name="isNotDivideTax"
   */
  boolean	isNotDivideTax = false;
  /**
   * @uml.property  name="numTaxes"
   */
  int	numTaxes = 3;
  /**
   * @uml.property  name="taxType"
   */
  String[]	taxType = new String[numTaxes];
  /**
   * @uml.property  name="taxAmount"
   */
  String[]	taxAmount = new String[numTaxes];
  /**
   * @uml.property  name="numTaxMiscs"
   */
  int	numTaxMiscs = 10;
  /**
   * @uml.property  name="taxMiscType"
   */
  String[]	taxMiscType = new String[numTaxMiscs];
  /**
   * @uml.property  name="taxMiscAmount"
   */
  String[]	taxMiscAmount = new String[numTaxMiscs];

  // Attributes for Sectors
  /**
   * @uml.property  name="numSectors"
   */
  int	numSectors = 40;

  /**
   * @uml.property  name="stopOver"
   */
  String[]	stopOver = new String[numSectors];
  /**
   * @uml.property  name="depCode"
   */
  String[]	depCode = new String[numSectors];
  /**
   * @uml.property  name="destCode"
   */
  String[]	destCode = new String[numSectors];
  /**
   * @uml.property  name="fareBasis"
   */
  String[]	fareBasis = new String[numSectors];
  /**
   * @uml.property  name="carrier"
   */
  String[]	carrier = new String[numSectors];
  /**
   * @uml.property  name="classOfService"
   */
  String[]	classOfService = new String[numSectors];/* class of service */
  /**
   * @uml.property  name="fareComponent"
   */
  String[]	fareComponent = new String[numSectors];
  /**
   * @uml.property  name="flightNo"
   */
  String[]	flightNo = new String[numSectors];
  /**
   * @uml.property  name="flightDate"
   */
  String[]	flightDate = new String[numSectors];
  /**
   * @uml.property  name="classDiffPlus"
   */
  String[]	classDiffPlus = new String[numSectors];
  /**
   * @uml.property  name="secureCharge"
   */
  String[]	secureCharge = new String[numSectors];
  /**
   * @uml.property  name="sideTripPlus"
   */
  String[]	sideTripPlus = new String[numSectors];
  /**
   * @uml.property  name="stopOverPlus"
   */
  String[]	stopOverPlus = new String[numSectors];
  /**
   * variable <code>tax</code>	tax value for the sector
   *
   */
  String[]	tax = new String[numSectors];

  // Constructor
  /**
   * Creates a new <code>AuditForm</code> instance.
   *
   */
  public AuditForm() {
    super();
    resetFields();
    List	traceLevelList = new Vector();
    traceLevelList.add("standard");
    traceLevelList.add("detail");
    setTraceLevelList(traceLevelList);
    List	prorateTypeList = new Vector();
    prorateTypeList.add("issued by own carrier");
    prorateTypeList.add("outward");
    prorateTypeList.add("inward");
    setProrateTypeList(prorateTypeList);
  }

  // Operations
  /**
   * Describe <code>validate</code> method
   * Called by the framework to validate the fields
   * in which user has entered the data for proration calculation.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   * @return an <code>ActionErrors</code> value
   */
  public ActionErrors validate(ActionMapping mapping,
			       HttpServletRequest request) {
    ActionErrors	errors = new ActionErrors();

    // Get access to the message resources for this application
    // There's not an easy way to access the resources from an ActionForm
    MessageResources	resources =
      (MessageResources)request.getAttribute( Globals.MESSAGES_KEY );

    // Check and see if the uid is missing
    if (false/*error*/) {
      String	label = resources.getMessage( "label" );
      ActionMessage	newError =
        new ActionMessage("global.error.login.requiredfield", label );
      errors.add(ActionMessages.GLOBAL_MESSAGE, newError);
    }

    // Return the ActionErrors, in any.
    return errors;
  }

  /**
   * <code>reset</code> method
   * Called by the framework to reset the fields back to their default values.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    // Clear out the uid and passwd fields
    resetFields();
  }

  /**
   * <code>resetFields</code> method
   * Reset the fields back to their defaults.
   *
   */
  protected void resetFields() {
  }

  /**
   * @return  ownAirwayId
   * @uml.property  name="ownAirwayId"
   */
  public String getOwnAirwayId() {
    return ownAirwayId;
  }
  /**
   * @param ownAirwayId  ownAirwayId
   * @uml.property  name="ownAirwayId"
   */
  public void setOwnAirwayId(String ownAirwayId) {
    this.ownAirwayId = ownAirwayId;
  }

  /**
   * @return  agentCode
   * @uml.property  name="agentCode"
   */
  public String getAgentCode() {
    return agentCode;
  }
  /**
   * @param agentCode  agentCode
   * @uml.property  name="agentCode"
   */
  public void setAgentCode(String agentCode) {
    this.agentCode = agentCode;
  }
  /**
   * @return  airwayNumber
   * @uml.property  name="airwayNumber"
   */
  public String getAirwayNumber() {
    return airwayNumber;
  }
  /**
   * @param airwayNumber  airwayNumber
   * @uml.property  name="airwayNumber"
   */
  public void setAirwayNumber(String airwayNumber) {
    this.airwayNumber = airwayNumber;
  }
  /**
   * @return  commissionAmt
   * @uml.property  name="commissionAmt"
   */
  public String getCommissionAmt() {
    return commissionAmt;
  }
  /**
   * @param commissionAmt  commissionAmt
   * @uml.property  name="commissionAmt"
   */
  public void setCommissionAmt(String commissionAmt) {
    this.commissionAmt = commissionAmt;
  }
  /**
   * @return  commissionCurrency
   * @uml.property  name="commissionCurrency"
   */
  public String getCommissionCurrency() {
    return commissionCurrency;
  }
  /**
   * @param commissionCurrency  commissionCurrency
   * @uml.property  name="commissionCurrency"
   */
  public void setCommissionCurrency(String commissionCurrency) {
    this.commissionCurrency = commissionCurrency;
  }
  /**
   * @return  commissionRate
   * @uml.property  name="commissionRate"
   */
  public String getCommissionRate() {
    return commissionRate;
  }
  /**
   * @param commissionRate  commissionRate
   * @uml.property  name="commissionRate"
   */
  public void setCommissionRate(String commissionRate) {
    this.commissionRate = commissionRate;
  }
  /**
   * @return  couponNumber
   * @uml.property  name="couponNumber"
   */
  public String getCouponNumber() {
    return couponNumber;
  }
  /**
   * @param couponNumber  couponNumber
   * @uml.property  name="couponNumber"
   */
  public void setCouponNumber(String couponNumber) {
    this.couponNumber = couponNumber;
  }
  /**
   * @return  currency
   * @uml.property  name="currency"
   */
  public String getCurrency() {
    return currency;
  }
  /**
   * @param currency  currency
   * @uml.property  name="currency"
   */
  public void setCurrency(String currency) {
    this.currency = currency;
  }
  /**
   * @return  destination
   * @uml.property  name="destination"
   */
  public String getDestination() {
    return destination;
  }
  /**
   * @param destination  destination
   * @uml.property  name="destination"
   */
  public void setDestination(String destination) {
    this.destination = destination;
  }
  /**
   * @return  endorsement
   * @uml.property  name="endorsement"
   */
  public String getEndorsement() {
    return endorsement;
  }
  /**
   * @param endorsement  endorsement
   * @uml.property  name="endorsement"
   */
  public void setEndorsement(String endorsement) {
    this.endorsement = endorsement;
  }
  /**
   * @return  errorFlag
   * @uml.property  name="errorFlag"
   */
  public String getErrorFlag() {
    return errorFlag;
  }
  /**
   * @param errorFlag  errorFlag
   * @uml.property  name="errorFlag"
   */
  public void setErrorFlag(String errorFlag) {
    this.errorFlag = errorFlag;
  }
  /**
   * @return  errorString
   * @uml.property  name="errorString"
   */
  public String getErrorString() {
    return errorString;
  }
  /**
   * @param errorString  errorString
   * @uml.property  name="errorString"
   */
  public void setErrorString(String errorString) {
    this.errorString = errorString;
  }
  /**
   * @return  fareCalculation
   * @uml.property  name="fareCalculation"
   */
  public String getFareCalculation() {
    return fareCalculation;
  }
  /**
   * @param fareCalculation  fareCalculation
   * @uml.property  name="fareCalculation"
   */
  public void setFareCalculation(String fareCalculation) {
    this.fareCalculation = fareCalculation;
  }
  /**
   * @return  invoiceMonth
   * @uml.property  name="invoiceMonth"
   */
  public String getInvoiceMonth() {
    return invoiceMonth;
  }
  /**
   * @param invoiceMonth  invoiceMonth
   * @uml.property  name="invoiceMonth"
   */
  public void setInvoiceMonth(String invoiceMonth) {
    this.invoiceMonth = invoiceMonth;
  }
  /**
   * @return  inwardNumber
   * @uml.property  name="inwardNumber"
   */
  public String getInwardNumber() {
    return inwardNumber;
  }
  /**
   * @param inwardNumber  inwardNumber
   * @uml.property  name="inwardNumber"
   */
  public void setInwardNumber(String inwardNumber) {
    this.inwardNumber = inwardNumber;
  }
  /**
   * @return  issueDate
   * @uml.property  name="issueDate"
   */
  public String getIssueDate() {
    return issueDate;
  }
  /**
   * @param issueDate  issueDate
   * @uml.property  name="issueDate"
   */
  public void setIssueDate(String issueDate) {
    this.issueDate = issueDate;
  }
  /**
   * @return  issuePlace
   * @uml.property  name="issuePlace"
   */
  public String getIssuePlace() {
    return issuePlace;
  }
  /**
   * @param issuePlace  issuePlace
   * @uml.property  name="issuePlace"
   */
  public void setIssuePlace(String issuePlace) {
    this.issuePlace = issuePlace;
  }
  /**
   * @return  lessAdjustment
   * @uml.property  name="lessAdjustment"
   */
  public String getLessAdjustment() {
    return lessAdjustment;
  }
  /**
   * @param lessAdjustment  lessAdjustment
   * @uml.property  name="lessAdjustment"
   */
  public void setLessAdjustment(String lessAdjustment) {
    this.lessAdjustment = lessAdjustment;
  }
  /**
   * @return  lessAmt
   * @uml.property  name="lessAmt"
   */
  public String getLessAmt() {
    return lessAmt;
  }
  /**
   * @param lessAmt  lessAmt
   * @uml.property  name="lessAmt"
   */
  public void setLessAmt(String lessAmt) {
    this.lessAmt = lessAmt;
  }
  /**
   * @return  origin
   * @uml.property  name="origin"
   */
  public String getOrigin() {
    return origin;
  }
  /**
   * @param origin  origin
   * @uml.property  name="origin"
   */
  public void setOrigin(String origin) {
    this.origin = origin;
  }
  /**
   * @return  plusAdjustment
   * @uml.property  name="plusAdjustment"
   */
  public String getPlusAdjustment() {
    return plusAdjustment;
  }
  /**
   * @param plusAdjustment  plusAdjustment
   * @uml.property  name="plusAdjustment"
   */
  public void setPlusAdjustment(String plusAdjustment) {
    this.plusAdjustment = plusAdjustment;
  }
  /**
   * @return  salesCurrency
   * @uml.property  name="salesCurrency"
   */
  public String getSalesCurrency() {
    return salesCurrency;
  }
  /**
   * @param salesCurrency  salesCurrency
   * @uml.property  name="salesCurrency"
   */
  public void setSalesCurrency(String salesCurrency) {
    this.salesCurrency = salesCurrency;
  }
  /**
   * @return  salesFare
   * @uml.property  name="salesFare"
   */
  public String getSalesFare() {
    return salesFare;
  }
  /**
   * @param salesFare  salesFare
   * @uml.property  name="salesFare"
   */
  public void setSalesFare(String salesFare) {
    this.salesFare = salesFare;
  }
  /**
   * @return  stopOverCharge
   * @uml.property  name="stopOverCharge"
   */
  public String getStopOverCharge() {
    return stopOverCharge;
  }
  /**
   * @param stopOverCharge  stopOverCharge
   * @uml.property  name="stopOverCharge"
   */
  public void setStopOverCharge(String stopOverCharge) {
    this.stopOverCharge = stopOverCharge;
  }
  /**
   * @return  ticketFare
   * @uml.property  name="ticketFare"
   */
  public String getTicketFare() {
    return ticketFare;
  }
  /**
   * @param ticketFare  ticketFare
   * @uml.property  name="ticketFare"
   */
  public void setTicketFare(String ticketFare) {
    this.ticketFare = ticketFare;
  }
  /**
   * @return  totalNuc
   * @uml.property  name="totalNuc"
   */
  public String getTotalNuc() {
    return totalNuc;
  }
  /**
   * @param totalNuc  totalNuc
   * @uml.property  name="totalNuc"
   */
  public void setTotalNuc(String totalNuc) {
    this.totalNuc = totalNuc;
  }
  /**
   * @return  numSectors
   * @uml.property  name="numSectors"
   */
  public int getNumSectors() {
    return numSectors;
  }
  /**
   * @param numSectors  numSectors
   * @uml.property  name="numSectors"
   */
  public void setNumSectors(int numSectors) {
    this.numSectors = numSectors;
  }

  // TODO: ;;; FIXME: property="propertyName[i]" does not work. why???
  /**
   * @return  carrier
   * @uml.property  name="carrier"
   */
  public String[] getCarrier() {
    return carrier;
  }
  /**
   * @param carrier  carrier
   * @uml.property  name="carrier"
   */
  public void setCarrier(String[] carrier) {
    this.carrier = carrier;
  }
  /**
   * @return carrier
   */
  public String getCarrier(int i) {
    return carrier[i];
  }
  /**
   * @param carrier carrier
   */
  public void setCarrier(int i, String carrier) {
    this.carrier[i] = carrier;
  }
  /**
   * @return  classDiffPlus
   * @uml.property  name="classDiffPlus"
   */
  public String[] getClassDiffPlus() {
    return classDiffPlus;
  }
  /**
   * @param classDiffPlus  classDiffPlus
   * @uml.property  name="classDiffPlus"
   */
  public void setClassDiffPlus(String[] classDiffPlus) {
    this.classDiffPlus = classDiffPlus;
  }
  /**
   * @return classDiffPlus
   */
  public String getClassDiffPlus(int i) {
    return classDiffPlus[i];
  }
  /**
   * @param classDiffPlus classDiffPlus
   */
  public void setClassDiffPlus(int i, String classDiffPlus) {
    this.classDiffPlus[i] = classDiffPlus;
  }
  /**
   * @return  classOfService
   * @uml.property  name="classOfService"
   */
  public String[] getClassOfService() {
    return classOfService;
  }
  /**
   * @param classOfService  classOfService
   * @uml.property  name="classOfService"
   */
  public void setClassOfService(String[] classOfService) {
    this.classOfService = classOfService;
  }
  /**
   * @return classOfService
   */
  public String getClassOfService(int i) {
    return classOfService[i];
  }
  /**
   * @param classOfService classOfService
   */
  public void setClassOfService(int i, String classOfService) {
    this.classOfService[i] = classOfService;
  }
  /**
   * @return  depCode
   * @uml.property  name="depCode"
   */
  public String[] getDepCode() {
    return depCode;
  }
  /**
   * @param depCode  depCode
   * @uml.property  name="depCode"
   */
  public void setDepCode(String[] depCode) {
    this.depCode = depCode;
  }
  /**
   * @return depCode
   */
  public String getDepCode(int i) {
    return depCode[i];
  }
  /**
   * @param depCode depCode
   */
  public void setDepCode(int i, String depCode) {
    this.depCode[i] = depCode;
  }
  /**
   * @return  destCode
   * @uml.property  name="destCode"
   */
  public String[] getDestCode() {
    return destCode;
  }
  /**
   * @param destCode  destCode
   * @uml.property  name="destCode"
   */
  public void setDestCode(String[] destCode) {
    this.destCode = destCode;
  }
  /**
   * @return destCode
   */
  public String getDestCode(int i) {
    return destCode[i];
  }
  /**
   * @param destCode destCode
   */
  public void setDestCode(int i, String destCode) {
    this.destCode[i] = destCode;
  }
  /**
   * @return  fareBasis
   * @uml.property  name="fareBasis"
   */
  public String[] getFareBasis() {
    return fareBasis;
  }
  /**
   * @param fareBasis  fareBasis
   * @uml.property  name="fareBasis"
   */
  public void setFareBasis(String[] fareBasis) {
    this.fareBasis = fareBasis;
  }
  /**
   * @return fareBasis
   */
  public String getFareBasis(int i) {
    return fareBasis[i];
  }
  /**
   * @param fareBasis fareBasis
   */
  public void setFareBasis(int i, String fareBasis) {
    this.fareBasis[i] = fareBasis;
  }
  /**
   * @return  fareComponent
   * @uml.property  name="fareComponent"
   */
  public String[] getFareComponent() {
    return fareComponent;
  }
  /**
   * @param fareComponent  fareComponent
   * @uml.property  name="fareComponent"
   */
  public void setFareComponent(String[] fareComponent) {
    this.fareComponent = fareComponent;
  }
  /**
   * @return fareComponent
   */
  public String getFareComponent(int i) {
    return fareComponent[i];
  }
  /**
   * @param fareComponent fareComponent
   */
  public void setFareComponent(int i, String fareComponent) {
    this.fareComponent[i] = fareComponent;
  }
  /**
   * @return  flightDate
   * @uml.property  name="flightDate"
   */
  public String[] getFlightDate() {
    return flightDate;
  }
  /**
   * @param flightDate  flightDate
   * @uml.property  name="flightDate"
   */
  public void setFlightDate(String[] flightDate) {
    this.flightDate = flightDate;
  }
  /**
   * @return flightDate
   */
  public String getFlightDate(int i) {
    return flightDate[i];
  }
  /**
   * @param flightDate flightDate
   */
  public void setFlightDate(int i, String flightDate) {
    this.flightDate[i] = flightDate;
  }
  /**
   * @return  flightNo
   * @uml.property  name="flightNo"
   */
  public String[] getFlightNo() {
    return flightNo;
  }
  /**
   * @param flightNo  flightNo
   * @uml.property  name="flightNo"
   */
  public void setFlightNo(String[] flightNo) {
    this.flightNo = flightNo;
  }
  /**
   * @return flightNo
   */
  public String getFlightNo(int i) {
    return flightNo[i];
  }
  /**
   * @param flightNo flightNo
   */
  public void setFlightNo(int i, String flightNo) {
    this.flightNo[i] = flightNo;
  }
  /**
   * @return  secureCharge
   * @uml.property  name="secureCharge"
   */
  public String[] getSecureCharge() {
    return secureCharge;
  }
  /**
   * @param secureCharge  secureCharge
   * @uml.property  name="secureCharge"
   */
  public void setSecureCharge(String[] secureCharge) {
    this.secureCharge = secureCharge;
  }
  /**
   * @return secureCharge
   */
  public String getSecureCharge(int i) {
    return secureCharge[i];
  }
  /**
   * @param secureCharge secureCharge
   */
  public void setSecureCharge(int i, String secureCharge) {
    this.secureCharge[i] = secureCharge;
  }
  /**
   * @return  sideTripPlus
   * @uml.property  name="sideTripPlus"
   */
  public String[] getSideTripPlus() {
    return sideTripPlus;
  }
  /**
   * @param sideTripPlus  sideTripPlus
   * @uml.property  name="sideTripPlus"
   */
  public void setSideTripPlus(String[] sideTripPlus) {
    this.sideTripPlus = sideTripPlus;
  }
  /**
   * @return sideTripPlus
   */
  public String getSideTripPlus(int i) {
    return sideTripPlus[i];
  }
  /**
   * @param sideTripPlus sideTripPlus
   */
  public void setSideTripPlus(int i, String sideTripPlus) {
    this.sideTripPlus[i] = sideTripPlus;
  }
  /**
   * @return  stopOver
   * @uml.property  name="stopOver"
   */
  public String[] getStopOver() {
    return stopOver;
  }
  /**
   * @param stopOver  stopOver
   * @uml.property  name="stopOver"
   */
  public void setStopOver(String[] stopOver) {
    this.stopOver = stopOver;
  }
  /**
   * @return stopOver
   */
  public String getStopOver(int i) {
    return stopOver[i];
  }
  /**
   * @param stopOver stopOver
   */
  public void setStopOver(int i, String stopOver) {
    this.stopOver[i] = stopOver;
  }
  /**
   * @return  stopOverPlus
   * @uml.property  name="stopOverPlus"
   */
  public String[] getStopOverPlus() {
    return stopOverPlus;
  }
  /**
   * @param stopOverPlus  stopOverPlus
   * @uml.property  name="stopOverPlus"
   */
  public void setStopOverPlus(String[] stopOverPlus) {
    this.stopOverPlus = stopOverPlus;
  }
  /**
   * @return stopOverPlus
   */
  public String getStopOverPlus(int i) {
    return stopOverPlus[i];
  }
  /**
   * @param stopOverPlus stopOverPlus
   */
  public void setStopOverPlus(int i, String stopOverPlus) {
    this.stopOverPlus[i] = stopOverPlus;
  }
  /**
   * @return  tax
   * @uml.property  name="tax"
   */
  public String[] getTax() {
    return tax;
  }
  /**
   * @param tax  tax
   * @uml.property  name="tax"
   */
  public void setTax(String[] tax) {
    this.tax = tax;
  }
  /**
   * @return tax
   */
  public String getTax(int i) {
    return tax[i];
  }
  /**
   * @param tax tax
   */
  public void setTax(int i, String tax) {
    this.tax[i] = tax;
  }
  /**
   * @return  tourCode
   * @uml.property  name="tourCode"
   */
  public String getTourCode() {
    return tourCode;
  }
  /**
   * @param tourCode  tourCode
   * @uml.property  name="tourCode"
   */
  public void setTourCode(String tourCode) {
    this.tourCode = tourCode;
  }
  /**
   * @return  traceLevel
   * @uml.property  name="traceLevel"
   */
  public String getTraceLevel() {
    return traceLevel;
  }
  /**
   * @param traceLevel  traceLevel
   * @uml.property  name="traceLevel"
   */
  public void setTraceLevel(String traceLevel) {
    this.traceLevel = traceLevel;
  }
  /**
   * @return  traceLevelList
   * @uml.property  name="traceLevelList"
   */
  public List getTraceLevelList() {
    return traceLevelList;
  }
  /**
   * @param traceLevelList  traceLevelList
   * @uml.property  name="traceLevelList"
   */
  public void setTraceLevelList(List traceLevelList) {
    this.traceLevelList = traceLevelList;
  }
  /**
   * @return  prorateType
   * @uml.property  name="prorateType"
   */
  public String getProrateType() {
    return prorateType;
  }
  /**
   * @param prorateType  prorateType
   * @uml.property  name="prorateType"
   */
  public void setProrateType(String prorateType) {
    this.prorateType = prorateType;
  }
  /**
   * @return  prorateTypeList
   * @uml.property  name="prorateTypeList"
   */
  public List getProrateTypeList() {
    return prorateTypeList;
  }
  /**
   * @param prorateTypeList  prorateTypeList
   * @uml.property  name="prorateTypeList"
   */
  public void setProrateTypeList(List prorateTypeList) {
    this.prorateTypeList = prorateTypeList;
  }

  /**
   * @return  isNotDivideTax
   * @uml.property  name="isNotDivideTax"
   */
  public boolean isNotDivideTax() {
    return isNotDivideTax;
  }

  /**
   * @param isNotDivideTax   isNotDivideTax
   * @uml.property  name="isNotDivideTax"
   */
  public void setNotDivideTax(boolean isNotDivideTax) {
    this.isNotDivideTax = isNotDivideTax;
  }

  /**
   * @return  numTaxes
   * @uml.property  name="numTaxes"
   */
  public int getNumTaxes() {
    return numTaxes;
  }

  /**
   * @param numTaxes  numTaxes
   * @uml.property  name="numTaxes"
   */
  public void setNumTaxes(int numTaxes) {
    this.numTaxes = numTaxes;
  }

  /**
   * @return  numTaxMiscs
   * @uml.property  name="numTaxMiscs"
   */
  public int getNumTaxMiscs() {
    return numTaxMiscs;
  }

  /**
   * @param numTaxMiscs  numTaxMiscs
   * @uml.property  name="numTaxMiscs"
   */
  public void setNumTaxMiscs(int numTaxMiscs) {
    this.numTaxMiscs = numTaxMiscs;
  }

  /**
   * @return  taxAmount
   * @uml.property  name="taxAmount"
   */
  public String[] getTaxAmount() {
    return taxAmount;
  }

  /**
   * @param taxAmount  taxAmount
   * @uml.property  name="taxAmount"
   */
  public void setTaxAmount(String[] taxAmount) {
    this.taxAmount = taxAmount;
  }

  /**
   * @return taxAmount
   */
  public String getTaxAmount(int i) {
    return taxAmount[i];
  }
  /**
   * @param taxAmount taxAmount
   */
  public void setTaxAmount(int i, String taxAmount) {
    this.taxAmount[i] = taxAmount;
  }

  /**
   * @return  taxType
   * @uml.property  name="taxType"
   */
  public String[] getTaxType() {
    return taxType;
  }

  /**
   * @param taxType  taxType
   * @uml.property  name="taxType"
   */
  public void setTaxType(String[] taxType) {
    this.taxType = taxType;
  }

  /**
   * @return taxType
   */
  public String getTaxType(int i) {
    return taxType[i];
  }
  /**
   * @param taxType taxType
   */
  public void setTaxType(int i, String taxType) {
    this.taxType[i] = taxType;
  }

  /**
   * @return  taxMiscAmount
   * @uml.property  name="taxMiscAmount"
   */
  public String[] getTaxMiscAmount() {
    return taxMiscAmount;
  }

  /**
   * @param taxMiscAmount  taxMiscAmount
   * @uml.property  name="taxMiscAmount"
   */
  public void setTaxMiscAmount(String[] taxMiscAmount) {
    this.taxMiscAmount = taxMiscAmount;
  }

  /**
   * @return taxMiscAmount
   */
  public String getTaxMiscAmount(int i) {
    return taxMiscAmount[i];
  }
  /**
   * @param taxMiscAmount taxMiscAmount
   */
  public void setTaxMiscAmount(int i, String taxMiscAmount) {
    this.taxMiscAmount[i] = taxMiscAmount;
  }

  /**
   * @return  taxMiscType
   * @uml.property  name="taxMiscType"
   */
  public String[] getTaxMiscType() {
    return taxMiscType;
  }

  /**
   * @param taxMiscType  taxMiscType
   * @uml.property  name="taxMiscType"
   */
  public void setTaxMiscType(String[] taxMiscType) {
    this.taxMiscType = taxMiscType;
  }

  /**
   * @return taxMiscType
   */
  public String getTaxMiscType(int i) {
    return taxMiscType[i];
  }
  /**
   * @param taxMiscType taxMiscType
   */
  public void setTaxMiscType(int i, String taxMiscType) {
    this.taxMiscType[i] = taxMiscType;
  }

  /**
   * <code>getTicketNumber</code> method
   *
   * @return a <code>String</code> value
   */
  public String getTicketNumber() {
    return ticketNumber;
  }

  /**
   * <code>setTicketNumber</code> method
   *
   * @param ticketNumber a <code>String</code> value
   */
  public void setTicketNumber(String ticketNumber) {
    this.ticketNumber = ticketNumber;
  }
}
