// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.struts.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

/**
 * class <code>SelectForm</code> This ActionForm is used by the online audit appliation to validate input data facilities for selecting audit data. If any of the required fields are empty or any of the input data are invalid when validate is called by the ActionServlet, error messages are created.
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class SelectForm extends ActionForm {

  /**
   * <code>serialVersionUID</code>
   */
  private static final long serialVersionUID = 1L;

  // Attributes
  /**
   * @uml.property  name="ticketNumber"
   */
  String	ticketNumber = "";
  /**
   * @uml.property  name="couponNumber"
   */
  String	couponNumber = "";
  /**
   * @uml.property  name="inwardNumber"
   */
  String	inwardNumber = "";

  // Constructor
  /**
   * Creates a new <code>AuditForm</code> instance.
   *
   */
  public SelectForm() {
    super();
    resetFields();
  }

  // Operations
  /**
   * Describe <code>validate</code> method
   * Called by the framework to validate the fields
   * in which user has entered the data for proration calculation.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   * @return an <code>ActionErrors</code> value
   */
  public ActionErrors validate(ActionMapping mapping,
			       HttpServletRequest request) {
    ActionErrors	errors = new ActionErrors();

    // Get access to the message resources for this application
    // There's not an easy way to access the resources from an ActionForm
    MessageResources	resources =
      (MessageResources)request.getAttribute( Globals.MESSAGES_KEY );

    // Check and see if the uid is missing
    if (false/*error*/) {
      String	label = resources.getMessage( "label" );
      ActionMessage	newError =
        new ActionMessage("global.error.login.requiredfield", label );
      errors.add(ActionMessages.GLOBAL_MESSAGE, newError);
    }

    // Return the ActionErrors, in any.
    return errors;
  }

  /**
   * <code>reset</code> method
   * Called by the framework to reset the fields back to their default values.
   *
   * @param mapping an <code>ActionMapping</code> value
   * @param request a <code>HttpServletRequest</code> value
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    // Clear out the uid and passwd fields
    resetFields();
  }

  /**
   * <code>resetFields</code> method
   * Reset the fields back to their defaults.
   *
   */
  protected void resetFields() {
  }

  /**
   * @return  ticketNumber
   * @uml.property  name="ticketNumber"
   */
  public String getTicketNumber() {
    return ticketNumber;
  }
  /**
   * @param ticketNumber  ticketNumber
   * @uml.property  name="ticketNumber"
   */
  public void setTicketNumber(String ticketNumber) {
    this.ticketNumber = ticketNumber;
  }
  /**
   * @return  couponNumber
   * @uml.property  name="couponNumber"
   */
  public String getCouponNumber() {
    return couponNumber;
  }
  /**
   * @param couponNumber  couponNumber
   * @uml.property  name="couponNumber"
   */
  public void setCouponNumber(String couponNumber) {
    this.couponNumber = couponNumber;
  }
  /**
   * @return  inwardNumber
   * @uml.property  name="inwardNumber"
   */
  public String getInwardNumber() {
    return inwardNumber;
  }
  /**
   * @param inwardNumber  inwardNumber
   * @uml.property  name="inwardNumber"
   */
  public void setInwardNumber(String inwardNumber) {
    this.inwardNumber = inwardNumber;
  }
}
