// Copyright (c) 2002-2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.struts.service;

import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import jp.sourceforge.gnp.audit.ejb.interfaces.AuditEjb;
//import jp.sourceforge.gnp.audit.ejb.client.AuditEjbClient;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.audit.struts.view.AuditView;
import jp.sourceforge.gnp.audit.struts.view.ProrateView;

/**
 * Describe class <code>AuditServiceEjb</code> here. struts proration service using remote audit client
 * @author   <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version   1.0
 */
public class AuditServiceEjb extends AuditService {

  /**
   * variable <code>audit</code>	AuditEjb EJB3 object
   *
   */
  AuditEjb	ejb = null;

  // Constructor
  /**
   * Creates a new <code>AuditServiceEjb</code> instance.
   * @throws Exception 
   *
   */
  public AuditServiceEjb() throws Exception {
    super();
    /* ;;; This does not work properly
    ejb = AuditEjbClient.makeInstance();
    */
    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    Object ref = null;
    try {
      ref = context.lookup(AuditEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      throw e;
    }
    ejb = (AuditEjb)ref;
  }

  // Operations
  /**
   * <code>persist</code> method 
   *
   * @param ticketNumber a <code>String</code> value
   * @param audit a <code>ProrateAudit</code> value
   * @return an <code>AuditView</code> value
   */
  public AuditView persist(String ticketNumber, ProrateAudit audit) {
    boolean	ret = false;
    try {
      ret = ejb.persist(ticketNumber, audit);
    }
    catch (Exception e) {
      e.printStackTrace();
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    if (!ret) {
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString("ticketNumber [" + ticketNumber
			       + "] : audit persistence failed");
      return errorView;
    }
    AuditView	auditView = createView(ticketNumber, audit);
    return auditView;
  }

  /**
   * <code>remove</code> method
   *
   * @param ticketNumber a <code>String</code> value
   * @return an <code>AuditView</code> value
   */
  public AuditView remove(String ticketNumber, ProrateAudit audit) {
    boolean	ret = false;
    try {
      ret = ejb.remove(ticketNumber);
    }
    catch (Exception e) {
      e.printStackTrace();
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    if (!ret) {
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString("ticketNumber ["
			       + ticketNumber + "] : audit not found");
      return errorView;
    }
    AuditView	auditView = createView(ticketNumber, audit);
    return auditView;
  }

  /**
   * <code>find</code> method
   *
   * @param ticketNumber a <code>String</code> value
   * @return a <code>ProrateView</code> value
   */
  public AuditView find(String ticketNumber, ProrateAudit audit) {
    ProrateAudit	auditRet = null;
    try {
      auditRet = ejb.find(ticketNumber);
    }
    catch (Exception e) {
      e.printStackTrace();
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    if (auditRet == null) {
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString("ticketNumber ["
			       + ticketNumber + "] : audit not found");
      return errorView;
    }
    auditRet.setOwnAirwayId(audit.getOwnAirwayId());
    auditRet.setOwnAudit(audit.isOwnAudit());
    auditRet.setTicketing(audit.isTicketing());
    auditRet.setInward(audit.isInward());
    auditRet.setTraceLevel(audit.getTraceLevel());
    ProrateView	prorateView = createProrateView(ticketNumber, auditRet);
    return prorateView;
  }

  /**
   * <code>prorate</code> method
   *	creates prorate Ejb3 client session Bean object,
   *	requests a prorate calculation to the Ejb3 proration session Bean.
   *	creates prorate view, sets data from the proration result,
   *	and returns it.
   *
   * @param ticketNumber a <code>String</code> value
   * @param audit a <code>ProrateAudit</code> value
   * @return a <code>ProrateView</code> value
   */
  public AuditView prorate(String ticketNumber, ProrateAudit audit) {
    ProrateAudit	auditRet = null;
    try {
      auditRet = ejb.prorate(ticketNumber, audit);
    }
    catch (Exception e) {
      e.printStackTrace();
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString(e.getMessage());
      if (errorView.getErrorString() == null) {
	errorView.setErrorString(e.toString());
      }
      return errorView;
    }
    if (auditRet == null) {
      AuditView	errorView = createErrorView(ticketNumber, audit);
      errorView.setErrorString("ticketNumber ["
			       + ticketNumber + "] : audit not found");
      return errorView;
    }
    ProrateView	prorateView = createProrateView(ticketNumber, auditRet);
    return prorateView;
  }
}
