// Copyright (c) 2005  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.audit.struts.view;

import java.io.Serializable;
import java.util.List;
import jp.sourceforge.gnp.audit.struts.view.AuditView;

/**
 * class <code>ProrateView</code> A value object for that wraps all of the proration result information
 * @author  <a href="mailto:gnp@sourceforge.jp">Hitoshi Guutara Maruyama</a>
 * @version  1.0
 */
public class ProrateView extends AuditView implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  // Attributes
  /**
   * @uml.property  name="airwayId"
   */
  String	airwayId = "";
  /**
   * @uml.property  name="inwardId"
   */
  String	inwardId = "";
  /**
   * @uml.property  name="roeRate"
   */
  String	roeRate = "";
  /**
   * @uml.property  name="day5Rate"
   */
  String	day5Rate = "";
  /**
   * @uml.property  name="meanRate"
   */
  String	meanRate = "";
  /**
   * @uml.property  name="fixedFare"
   */
  String	fixedFare = "";

  /**
   * @uml.property  name="traceRows"
   */
  int	traceRows = 0;
  /**
   * @uml.property  name="traceString"
   */
  String	traceString;
  /**
   * variable <code>fatalError</code>	flag to indicate fatal error
   *
   */
  boolean	fatalError;

  // Attributes for Sectors
  /**
   * @uml.property  name="sectorsList"
   */
  List	sectorsList;

  // Constructor
  /**
   * Creates a new <code>ProrateView</code> instance.
   *
   */
  public ProrateView() {
    super();
  }

  /**
   * @return  airwayId
   * @uml.property  name="airwayId"
   */
  public String getAirwayId() {
    return airwayId;
  }
  /**
   * @param airwayId  airwayId
   * @uml.property  name="airwayId"
   */
  public void setAirwayId(String airwayId) {
    this.airwayId = airwayId;
  }
  /**
   * @return  day5Rate
   * @uml.property  name="day5Rate"
   */
  public String getDay5Rate() {
    return day5Rate;
  }
  /**
   * @param day5Rate  day5Rate
   * @uml.property  name="day5Rate"
   */
  public void setDay5Rate(String day5Rate) {
    this.day5Rate = day5Rate;
  }
  /**
   * @return  fixedFare
   * @uml.property  name="fixedFare"
   */
  public String getFixedFare() {
    return fixedFare;
  }
  /**
   * @param fixedFare  fixedFare
   * @uml.property  name="fixedFare"
   */
  public void setFixedFare(String fixedFare) {
    this.fixedFare = fixedFare;
  }
  /**
   * @return  inwardId
   * @uml.property  name="inwardId"
   */
  public String getInwardId() {
    return inwardId;
  }
  /**
   * @param inwardId  inwardId
   * @uml.property  name="inwardId"
   */
  public void setInwardId(String inwardId) {
    this.inwardId = inwardId;
  }
  /**
   * @return  meanRate
   * @uml.property  name="meanRate"
   */
  public String getMeanRate() {
    return meanRate;
  }
  /**
   * @param meanRate  meanRate
   * @uml.property  name="meanRate"
   */
  public void setMeanRate(String meanRate) {
    this.meanRate = meanRate;
  }
  /**
   * @return  roeRate
   * @uml.property  name="roeRate"
   */
  public String getRoeRate() {
    return roeRate;
  }
  /**
   * @param roeRate  roeRate
   * @uml.property  name="roeRate"
   */
  public void setRoeRate(String roeRate) {
    this.roeRate = roeRate;
  }

  /**
   * @return  traceRows
   * @uml.property  name="traceRows"
   */
  public int getTraceRows() {
    return traceRows;
  }
  /**
   * @param traceRows  traceRows
   * @uml.property  name="traceRows"
   */
  public void setTraceRows(int traceRows) {
    this.traceRows = traceRows;
  }
  /**
   * @return  traceString
   * @uml.property  name="traceString"
   */
  public String getTraceString() {
    return traceString;
  }
  /**
   * @param traceStrings  traceStrings
   * @uml.property  name="traceString"
   */
  public void setTraceString(String traceString) {
    this.traceString = traceString;
  }

  /**
   * <code>isFatalError</code> method	returns fatalError
   *
   * @return a <code>boolean</code> value
   */
  public boolean isFatalError() {
    return fatalError;
  }
  /**
   * <code>setFatalError</code> method	set fatalError
   *
   * @param fatalError a <code>boolean</code> value
   */
  public void setFatalError(boolean fatalError) {
    this.fatalError = fatalError;
  }

  /**
   * @return  sectorsList
   * @uml.property  name="sectorsList"
   */
  public List getSectorsList() {
    return sectorsList;
  }
  /**
   * @param sectorsList  sectorsList
   * @uml.property  name="sectorsList"
   */
  public void setSectorsList(List sectorsList) {
    this.sectorsList = sectorsList;
  }
}
