// Copyright (c) 2009  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.dcheck.dwr;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ejb.EJB;

import jp.sourceforge.gnp.dcheck.ejb.interfaces.CheckEjb;
import jp.sourceforge.gnp.prorate.export.ProrateException;

/**
 * class <code>CheckManager</code>	DWR CheckManager java class
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class CheckManager {
  static final String	DEFAULT_DATE = null;	/* ;;; date is not used now */

  static String	checkDate = DEFAULT_DATE;

  /**
   * variable <code>dcheck</code>	CheckEjb EJB3 object
   *
   */
  @EJB
    static CheckEjb	dcheck = null;

  /**
   * <code>checkPlace</code> method	DWR checkPlace method
   *
   * @param place a <code>String</code> value
   * @return a <code>String</code> value
   */
  static public DCheck checkPlace(String place, int elementId) {
    dcheck = getCheck();
    if (dcheck == null) {
      return null;
    }
    boolean	result = false;
    try {
      result = dcheck.checkPlace(place, checkDate);
    }
    catch (ProrateException e) {
    }
    DCheck	retval = new DCheck();
    retval.setValue(place);
    retval.setElementId(elementId);
    retval.setRet(result);
    return retval;
  }

  /**
   * <code>checkAirwayId</code> method	DWR checkAirwayId method
   *
   * @param airwayId a <code>String</code> value
   * @return a <code>String</code> value
   */
  static public DCheck checkAirwayId(String airwayId, int elementId) {
    dcheck = getCheck();
    if (dcheck == null) {
      return null;
    }
    boolean	result = false;
    try {
      result = dcheck.checkAirwayId(airwayId, checkDate);
    }
    catch (ProrateException e) {
    }
    DCheck	retval = new DCheck();
    retval.setValue(airwayId);
    retval.setElementId(elementId);
    retval.setRet(result);
    return retval;
  }
  
  /**
   * <code>checkAirwayNo</code> method	DWR checkAirwayNo method
   *
   * @param airwayNo a <code>String</code> value
   * @return a <code>String</code> value
   */
  static public DCheck checkAirwayNo(String airwayNo, int elementId) {
    dcheck = getCheck();
    if (dcheck == null) {
      return null;
    }
    boolean	result = false;
    try {
      result = dcheck.checkAirwayNo(airwayNo, checkDate);
    }
    catch (ProrateException e) {
    }
    DCheck	retval = new DCheck();
    retval.setValue(airwayNo);
    retval.setElementId(elementId);
    retval.setRet(result);
    return retval;
  }
  
  /**
   * <code>checkCurrency</code> method	DWR checkCurrency method
   *	;;; not used now
   *
   * @param currency a <code>String</code> value
   * @return a <code>String</code> value
   */
  static public DCheck checkCurrency(String currency, int elementId) {
    dcheck = getCheck();
    if (dcheck == null) {
      return null;
    }
    boolean	result = false;
    try {
      result = dcheck.checkCurrency(currency, checkDate);
    }
    catch (ProrateException e) {
    }
    DCheck	retval = new DCheck();
    retval.setValue(currency);
    retval.setElementId(elementId);
    retval.setRet(result);
    return retval;
  }
  
  static private CheckEjb	getCheck() {
    Context context = null;
    try {
      context = new InitialContext();
    } catch (NamingException e) {
      e.printStackTrace();
      return null;
    }
    Object ref = null;
    try {
      ref = context.lookup(CheckEjb.JNDI_NAME);
    } catch (NamingException e) {
      e.printStackTrace();
      return null;
    }
    return (CheckEjb)ref;
  }

  /**
   * <code>setDate</code> method	set issue date ;;; date not used now
   *
   * @param date a <code>String</code> value
   */
  static public void	setDate(String date) {
    checkDate = date;
  }
  
}
