package jp.sourceforge.gnp.dcheck.ejb.interfaces;

import javax.ejb.Remote;

import jp.sourceforge.gnp.prorate.export.ProrateException;

/**
 * Remote interface for CheckEjb.
 */
@Remote
  public interface CheckEjb
  {
    public static final String JNDI_NAME="ejb/CheckEjb";

    /**
     * Business method checkPlace
     * @param place a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @exception java.rmi.RemoteException if an error occurs
     */
    public boolean checkPlace( String place, String date )
      throws ProrateException;

    /**
     * Business method checkAirwayId
     * @param airwayId a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @exception java.rmi.RemoteException if an error occurs
     */
    public boolean checkAirwayId( String airwayId, String date )
      throws ProrateException;

    /**
     * Business method checkAirwayNo
     * @param airwayNo a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @exception java.rmi.RemoteException if an error occurs
     */
    public boolean checkAirwayNo( String airwayNo, String date )
      throws ProrateException;

    /**
     * Business method checkCurrency
     * @param currency a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>boolean</code> value
     * @exception ProrateException 
     * @exception java.rmi.RemoteException if an error occurs
     */
    public boolean checkCurrency( String currency, String date )
      throws ProrateException;
  }
