package jp.sourceforge.gnp.dsearch.ejb.interfaces;

import javax.ejb.Remote;

import jp.sourceforge.gnp.prorate.export.ProrateException;

/**
 * Remote interface for GetDataEjb.
 */
@Remote
  public interface GetDataEjb
  {
    public static final String JNDI_NAME="ejb/GetDataEjb";

    /**
     * Business method <code>getProrateFactor</code>
     * @param from a <code>String</code> value
     * @param to a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>double</code> value
     * @exception ProrateException 
     */
    public double getProrateFactor( String from, String to, String date )
      throws ProrateException;

    /**
     * Business method <code>getCityName</code>
     * @param place a <code>String</code> value
     * @return a <code>String</code> value
     * @exception ProrateException if an error occurs
     */
    public String	getCityName(String place) throws ProrateException;

    /**
     * Business method <code>getAirwayId</code>
     * @param airwayNumber a <code>String</code> value
     * @param date a <code>String</code> value
     * @return a <code>String</code> value
     * @exception ProrateException if an error occurs
     */
    public String getAirwayId(String airwayNumber, String date)
      throws ProrateException;

    /**
     * Business method <code>getClassesForMainClass</code>
     *
     * @param mainClass a <code>String</code> value
     * @return a <code>String</code> value
     * @exception ProrateException if an error occurs
     */
    public String	getClassesForMainClass(String mainClass)
      throws ProrateException;
  }
