// Copyright (c) 2002  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.gnp.prorate;

import java.util.List;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.export.ProrateAskTable;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateFareComponent;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;

/**
 * <code>ProrateAuditImpl</code>	AUDITΡιˤΥǥ
 *
 * @author <a href="mailto:maruyama@sh.rim.or.jp">Hitoshi Guutara Maruyama</a>
 * @version 1.0
 */
public class ProrateAuditImpl {

  /**
   * variable <code>audit</code>	ץ졼оAUDIT
   *
   */
  ProrateAudit	audit;

  /**
   * 
   * @uml.property name="rulebase"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  public ProrateRulebase rulebase; /* ץ졼˻Ȥ롼١ */

  /**
   * 
   * @uml.property name="database"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  public ProrateDatabase database; /* ץ졼ǻȤǡ١ */

  /**
   * 
   * @uml.property name="fcalc"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  public ProrateFcalc fcalc; /* Fare Calculationϥ󥸥 */

  /**
   * 
   * @uml.property name="trace"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  public ProrateTrace trace; /* ȥ졼 */

  /**
   * 
   * @uml.property name="trace"
   * @uml.associationEnd multiplicity="(0 1)"
   */
  public ProrateTax tax; /* ȥ졼 */

  public ProrateAuditImpl() {
    super();
  }

  public ProrateAuditImpl(ProrateRulebase rulebase_in) {
    rulebase = rulebase_in;	/* 롼١Υå*/
  }

  public boolean	prorate(ProrateAudit audit) throws Exception {
    this.audit = audit;
    if (!preProcess()) {
      return false;
    }

    /* ;;; prorate_init() untin == 0 && untin_pay == 0 */
    /* ҷޤFareʤɤȤ0ἫҶ֤Τߤ̵ */
    if (audit.isOwnAudit() && audit.getTicketFare() == (double)0) {
      return prorateZero();
    }

    if (audit.getComponents() == null || audit.getComponents().length == 0) {
      if (!divideFareComponent()) {
	return false;
      }
    }
    /* ¾ҷFareCompoʤɤ0¾ҷ̵ */
    if (audit.getTotalNuc() == (double)0
	&& audit.getTicketFare() == (double)0) {
      return prorateZero();
    }

    for (int i = 0; i < audit.getComponents().length; i++) {
      ProrateFareComponentImpl	fcompImpl = new ProrateFareComponentImpl();
      ProrateFareComponent
	fcomp = (ProrateFareComponent)audit.getComponents()[i];
      if (!fcompImpl.prorate(this, audit, fcomp, rulebase)) {
	fcompImpl = null;
	return false;
      }
      fcompImpl = null;
    }
    if (!prorateRest()) {
      return false;
    }

    if (!postProcess()) {
      return false;
    }
    return true;
  }

  boolean	preProcess() {

    /* ;;; prorate_init() tasha_inf_set() tk_carrier */
    if ((audit.getAirwayId() == null || audit.getAirwayId().equals(""))) {
      audit.setAirwayId(database.getAirwayId(audit.getAirwayNumber(),
					     audit.getIssueDate()));
      if (audit.getAirwayId().equals("")) {
	if (database.getResult() > 1) {
	  DBError(null, "getAirwayId",
		  audit.getAirwayNumber(), audit.getIssueDate());
	  return false;
	}
	error(ProrateAudit.ASK_AIRWAYID,
	      "Airway No [" + audit.getAirwayNumber() + "]");
	return false;
      }
    }

    /* λҶֹ椫IDԤХ顼λ ;;;??? */
    if (audit.isInward()
	&& (audit.getInwardId() == null || audit.getInwardId().equals(""))) {
      audit.setInwardId(database.getAirwayId(audit.getInwardNumber(),
					     audit.getInvoiceMonth()));
      if (audit.getInwardId().equals("")) {
	if (database.getResult() > 1) {
	  DBError(null, "getAirwayId",
		  audit.getInwardNumber(), audit.getInvoiceMonth());
	  return false;
	}
	error(ProrateAudit.ASK_AIRWAYID,
	      "Inward Airway No [" + audit.getInwardNumber() + "]");
	return false;
      }
    }

    /* ;;; prorate_init() tasha_inf_set() date_of_issue */
    if (audit.getIssueDate().length() == 6) {
      audit.setIssueDate(audit.getIssueDate() + "01");
    }
    /* ;;; prorate_init() jisha_inf_set() global_inf.flight_date */
    if (audit.getInvoiceMonth().equals("")) {
      if ((!audit.isOwnAudit() || audit.isInward())
	  && audit.getSectors().length > 0
	  && (((ProrateSector)audit.getSectors()[0])
	      .getFlightDate().length() > 0)) {
	audit.setInvoiceMonth(((ProrateSector)audit.getSectors()[0])
			      .getFlightDate());
	if (audit.getInvoiceMonth().length() == 6) {
	  audit.setInvoiceMonth(audit.getInvoiceMonth() + "01");
	}
      }
      else {
	audit.setInvoiceMonth(audit.getIssueDate());
      }
    }

    /* ;;; prorate_init() Fixed_Fare */
    if (!setFixedFare()) {
      return false;
    }

    /* ;;; prorate_init() roe_rate */
    if (audit.getRoeRate() <= (double)0) {
      audit.setRoeRate(database.getRoeRate(audit.getCurrency(),
					   audit.getIssueDate()));
      if (audit.getRoeRate() < (double)0) {
	if (database.getResult() > 1) {
	  DBError(null, "getRoeRate",
		  audit.getCurrency(), audit.getIssueDate());
	  return false;
	}
	error(ProrateAudit.ASK_ROERATE,
	      audit.getCurrency() + ":" + audit.getIssueDate());
	return false;
      }
    }

    /* ;;; prorate_init() day5_rate */
    if (audit.getDay5Rate() <= (double)0) {
      audit.setDay5Rate(database.getMeanRate(audit.getCurrency(),
					     audit.getInvoiceMonth()));
      if (audit.getDay5Rate() <= (double)0) {
	audit.setDay5Rate(database.get5dayRate(audit.getCurrency(),
					       audit.getInvoiceMonth()));
	if (audit.getDay5Rate() < (double)0) {
	  if (database.getResult() > 1) {
	    DBError(null, "get5dayRate",
		    audit.getCurrency(), audit.getInvoiceMonth());
	    return false;
	  }
	  error(ProrateAudit.ASK_5DAYRATE,
		audit.getCurrency() + ":" + audit.getInvoiceMonth());
	  return false;
	}
      }
    }
    if (audit.getOrigin() == null || audit.getOrigin().equals("")
	&& audit.getSectors().length > 0) {
      audit.setOrigin(((ProrateSector)audit.getSectors()[0]).getDepCode());
    }
    if (audit.getDestination() == null || audit.getDestination().equals("")
	&& audit.getSectors().length > 0) {
      int	index = audit.getSectors().length - 1;
      audit.setDestination(((ProrateSector)audit.getSectors()[index])
			   .getDestCode());
    }

    boolean	isError = false;

    for (int i = 0; i < audit.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
      /* ;;; prorate_init() tasha_inf_set() flight_date */
      if (sector.getFlightDate().length() == 6) {
	sector.setFlightDate(sector.getFlightDate() + "01");
      }
      else if (sector.getFlightDate().length() == 0) {
	sector.setFlightDate(audit.getIssueDate());
      }
      /* ;;; prorate_init() jisha_inf_set() flight_date ??? */
      /* ;;; modify_sectors() change_airport_name() */
      sector.setDepAirport(sector.getDepCode());
      sector.setDepCode(database.getCityName(sector.getDepCode()));
      if (sector.getDepCode().equals("")) {
	if (database.getResult() > 1) {
	  DBError(sector, "getCityName", sector.getDepCode());
	  return false;
	}
      }
      sector.setDestAirport(sector.getDestCode());
      sector.setDestCode(database.getCityName(sector.getDestCode()));
      if (sector.getDestCode().equals("")) {
	if (database.getResult() > 1) {
	  DBError(sector, "getCityName", sector.getDestCode());
	  return false;
	}
      }
      if (sector.getCarrier().equals("") || sector.getCarrier().equals("  ")) {
	sector.setCarrier("YY");
      }
      /* ;;; add 2001.06.07 ??? */
      if (sector.getCarrier().equals("XX")) {
	continue;
      }

      /* ;;; modify_sectors() mdfy_basis */
      sector.setFareBasisFullStr(sector.getFareBasis());
      String	f_basis = sector.getFareBasis();
      if (f_basis.length() > 4 && f_basis.substring(1, 5).equals("INTL")) {
	String	f_basis_tmp = f_basis;
	f_basis = f_basis.substring(0, 1);
	f_basis += f_basis_tmp.substring(5);
      }
      else if (f_basis.length() > 5
	       && f_basis.substring(2, 6).equals("INTL")) {
	String	f_basis_tmp = f_basis;
	f_basis = f_basis.substring(0, 2);
	f_basis += f_basis_tmp.substring(6);
      }
      else if (f_basis.length() > 6
	       && f_basis.substring(3, 7).equals("INTL")) {
	String	f_basis_tmp = f_basis;
	f_basis = f_basis.substring(0, 3);
	f_basis += f_basis_tmp.substring(7);
      }
      else if (f_basis.length() > 1 && f_basis.charAt(0) == ' ') {
	f_basis = f_basis.substring(1);
      }
      int	j = f_basis.lastIndexOf("/");
      if (j > 0) {
	f_basis = f_basis.substring(0, j);
      }
      int	k = f_basis.indexOf("//");
      if (k > 0) {
	f_basis = f_basis.substring(0, k);
      }
      sector.setFareBasis(f_basis.toString());
      f_basis = null;

      /* Proration Type */
      if ((sector.getProrationType() & ProrateAudit.PRT_USETS) > 0) {
	sector.setProrationType(sector.getProrationType()
				& ProrateAudit.PRT_USETS);
      }
      else {
	sector.setProrationType(0);
      }

      /* ɥԥꥢ򸡺 ;;; version 3 */
      sector.setOpCarrier("");
      if (sector.getFlightNo() == null || sector.getFlightNo().equals("")) {
	sector.setFlightNo("-1");
      }
      String
	op = database.getOpCarrier(sector.getCarrier(), sector.getFlightNo(),
				   sector.getFlightDate());
      if (op.equals("") && database.getResult() > 1) {
	DBError(sector, "getOpCarrier",
		sector.getCarrier(), sector.getFlightNo());
	return false;
      }
      else if (!op.equals("")) {
	sector.setOpCarrier(op);
      }

      /* ֤Υץ졼ȥե */
      if (sector.getProrateFactor() <= (double)0) {
	sector.setProrateFactor(database
				.getProrateFactor(sector.getDepCode(),
						  sector.getDestCode(),
						  audit.getIssueDate()));
	if (sector.getProrateFactor() < (double)0) {
	  if (database.getResult() > 1) {
	    DBError(sector, "getProrateFactor",
		    sector.getDepCode(), sector.getDestCode());
	    return false;
	  }
	  isError = true;
	  error(sector, ProrateAudit.ASK_FACTOR);
	}
      }
    }

    if (isError) {
      return false;
    }

    /* եʸ󽸹ꤹ */
    ProrateRuleObject.classInitialize(database);
    /* Ѵơ֥ꤹ */
    ProrateRuleObject.codeConversionInitialize();

    return true;
  }

  boolean	divideFareComponent() {

    /* Fare CalculationꤵƤСϤ */
    if (audit.getFareCalculation().length() > 0) {
      boolean	isFareComponent = false;    /* ֤fareComponent뤫 */
      for (int i = 0; i < audit.getSectors().length; i++) {
	if (((ProrateSector)audit.getSectors()[i]).getFareComponent()
	    >= (double)0) {
	  isFareComponent = true;
	}
      }
      if (!isFareComponent && !audit.isIgnoreFareCalc()) {
	/* ֤fareComponentʤΤ߲Ϥ */
	if (!fcalc.analyze(this, audit)) {
	  if (audit.getSectors().length == 1) {
	    /* ιñ֤ʤϼԤ̵ */
	    ((ProrateSector)audit.getSectors()[0])
	      .setFareComponent((double)1);
	    error(0);
	  }
	  else if (audit.isOneComponent()) {
	    /* ñ쥳ݡͥȥե饰ONʤϼԤ̵ */
	    int	idx = audit.getSectors().length - 1;
	    ((ProrateSector)audit.getSectors()[idx])
	      .setFareComponent((double)1);
	    error(0);
	  }
	  else {
	    for (int i = 0; i < audit.getSectors().length; i++) {
	      ProrateSector
		sector = ((ProrateSector)audit.getSectors()[i]);
	      /* Ƽȯꥢ֤ʤϼԤ̵ */
	      if (audit.getOwnAirwayId().equals(audit.getAirwayId())
		  && ((sector.getCarrier().equals(audit.getAirwayId())
		       && sector.getOpCarrier().equals(""))
		      || sector.getOpCarrier().equals(audit.getAirwayId()))) {
	      }
	      else {
		/* ȯꥢְʳвϼ */
		return false;
	      }
	    }
	    error(0);
	  }
	}
      }
    }

    /* ֤ʤХץ졼Ǥʤ */
    if (audit.getSectors().length == 0) {
      return false;
    }

    /* ;;; plus_index not implemented(yet?) */

    final int	FC_MAX = 20;

    /* Fare Componentʬۤ˴ؤǡ */
    double[]	componentValue = new double[FC_MAX+1];	/* ;;; component_fvs */
    for (int i = 0; i < FC_MAX+1; i++) {
      componentValue[i] = (double)0;
    }
    int	componentIndex = 0;	/* ;;; mileage */
    int[]	sectorsInComponent = new int[FC_MAX+1];	/* ;;; loc_cnt */
    for (int i = 0; i < FC_MAX+1; i++) {
      sectorsInComponent[i] = (int)0;
    }
    boolean	fetched = false;
    boolean	emptyfc = false;

    /* Total Nucʬۤ˴ؤǡ */
    double	totalNucValue = (double)0;

    /* Side Tripʬۤ˴ؤǡ */
    double	totalSideTripValue = (double)0;	/* ;;; side_chrg */
    int	sideIndex = 0;	/* ;;; side_cnt */
    boolean	sideIn = false;	/* ;;; side_in */
    boolean	emptyst = false;

    /* Class DifferentialϤ˴ؤǡ */
    double	totalClassDiffPlus = (double)0;
    int	diffIndex = 1;	/* ;;; diff_cnt */

    /* Stop Over Chargeʬۤ˴ؤǡ */
    /* ;;; component_soc */
    double[]	componentStopOverCharge = new double[FC_MAX+1];
    int	stopOverCnt = 0;	/* ;;; mdbl_cnt */

    /* Security Chargeʬۤ˴ؤǡ */
    double	totalSecureCharge = (double)0;
    int	secIndex = 1;	/* ;;; phase 3 */

    /* ٤Ƥζ֤ФơʬۤΤβϤԤʤ */
    for (int i = 0; i < audit.getSectors().length; i++) {

      ProrateSector	sector = ((ProrateSector)audit.getSectors()[i]);
      /* "XX" ֤Fare Component˴ޤʤ(ץ졼ۤ0Ȥ) */
      if (sector.getCarrier().equals("XX")) {
	sector.setComponentIndex(-1);
	sector.setProrationType(ProrateAudit.PRT_SRP);
	sector.setProrateValue((double)0);
	continue;
      }

      /* Security ChargeפindexͿ */
      if (sector.getSecureIndex() == 'Q') {
	sector.setSecureIndex(secIndex);
	if (sector.getSecureCharge() > (double)0) {
	  totalSecureCharge += sector.getSecureCharge();
	  secIndex++;
	}
      }
      else {
	sector.setSecureIndex(0);
      }

      /* Class DifferentialפindexͿ */
      if (sector.getClassDiffIndex() == 'D') {
	sector.setClassDiffIndex(diffIndex);
	if (sector.getClassDiffPlus() != (double)0) {
	  totalClassDiffPlus += sector.getClassDiffPlus();
	  diffIndex++;
	}
      }
      else {
	sector.setClassDiffIndex(0);
      }

      /* Side Trip֤ΩFare ComponentȤindexͿ */
      if (sector.getSideTripIndex() == 'S') {
	int	j = componentIndex + sideIndex + 1;
	emptyst = true;
	sideIn = true;
	sector.setComponentIndex(j);
	sectorsInComponent[j]++;

	/* Side TripκǸζ֤ΥǡǡFare Componentͳۤ */
	if (sector.getSideTripPlus() >= (double)0) {
	  emptyst = false;
	  componentValue[j] = sector.getSideTripPlus();
	  totalNucValue += componentValue[j];

	  /* Stop Over Charge2ְʾFare Componentʬ */
	  componentStopOverCharge[j] = (double)0;
	  /* ;;; 2001.09.11
	     if (audit.getStopOverCharge() && sectorsInComponent[j] > 1) {
	     stopOverCnt++;
	     componentStopOverCharge[j] = (double)1;
	     }
	  */

	  totalSideTripValue += sector.getSideTripPlus();
	  sideIndex++;
	}
      }

      /* Side TripǤʤ֤ΩFare ComnponentȤindexͿ */
      else {
	emptyfc = true;

	/* ɥȥå׳ۤʤХ顼 */
	if (sideIn) {
	  sideIn = false;
	  if (emptyst) {
	    error(ProrateAudit.ERA_SIDETRIP);
	    return false;
	  }
	}

	sector.setComponentIndex(componentIndex);
	sectorsInComponent[componentIndex]++;
      }

      /* Fare ComponentκǸζ֤ΥǡFare Componentͳۤ */
      if (sector.getFareComponent() >= (double)0) {
	fetched = true;
	emptyfc = false;

	/* ɥȥå׳ۤʤХ顼 */
	if (sideIn) {
	  sideIn = false;
	  if (emptyst) {
	    error(ProrateAudit.ERA_SIDETRIP);
	    return false;
	  }
	}
	/* եݡͥȤ°֤ĤʤХ顼 */
	if (sectorsInComponent[componentIndex] == 0) {
	  error(ProrateAudit.ERA_FCOMPEMPTY);
	  return false;
	}

	if (sector.getComponentKind() == 0) {
	  sector.setComponentKind(ProrateAudit.FCT_MILEAGE);
	}

	componentValue[componentIndex] = sector.getFareComponent();
	totalNucValue += componentValue[componentIndex];

	/* Stop Over Charge2ְʾFare Componentʬ */
	componentStopOverCharge[componentIndex] = (double)0;
	if (audit.getStopOverCharge() > 0
	    && sectorsInComponent[componentIndex] > 1) {
	  stopOverCnt++;
	  componentStopOverCharge[componentIndex] = (double)1;
	}

	/* Fare ComponentˤĤindex(Fare Component)򥻥åȤ */
	componentIndex += sideIndex;
	sideIndex = 0;
	componentIndex++;
	sectorsInComponent[componentIndex] = 0;
      }

    }	/* ٤Ƥζ֤ˤĤƤʬۤΤβϽλ */

    /* ǸFare ComponentFareǡä֤ʤäǡ */
    if (fetched && emptyfc) {
      error(ProrateAudit.ERA_FCOMP);
      return false;
    }
    /* FareǡʤtotalNucȯۤʤǡ */
    if (emptyfc	&& audit.getTotalNuc() == (double)0
	&& audit.getTicketFare() == (double)0) {
      error(ProrateAudit.ERA_FCOMP);
      return false;
    }

    /* Ǹζ֤Side TripλΥǡåFare ComponentΥå */
    if (sideIn) {
      /* ǸSide TripFareǡä֤ʤäǡ */
      if (emptyst) {
	error(ProrateAudit.ERA_LASTSIDE);
	return false;
      }
      /* ǽեݡͥȤɥȥåפä */
      int	idx = audit.getSectors().length - 1;
      if (!emptyfc
	  && (((ProrateSector)audit.getSectors()[idx]).getFareComponent()
	      < (double)0)) {
	/* ɥȥåץݡͥȤΥǥå򷫤夲 */
	int	j = 0;
	for (int k = 0; k < sideIndex; k++) {
	  j = componentIndex + k + 1;
	  for (int i = 0; i < audit.getSectors().length; i++) {
	    if (((ProrateSector)audit.getSectors()[i])
		.getComponentIndex() == j) {
	      ((ProrateSector)audit.getSectors()[i])
		.setComponentIndex(j-1);
	    }
	  }
	  componentValue[j-1] = componentValue[j];
	  componentValue[j] = (double)0;
	  sectorsInComponent[j-1] = sectorsInComponent[j];
	  sectorsInComponent[j] = 0;
	  componentStopOverCharge[j-1] = componentStopOverCharge[j];
	  componentStopOverCharge[j] = (double)0;
	}
	componentIndex = j;
      }
    }

    /* ǸFare Componentۤʤ硢totalNucͳۤ */
    if (emptyfc) {
      if (audit.getTotalNuc() > (double)0) {
	componentValue[componentIndex] =
	  audit.getTotalNuc() - totalNucValue - audit.getStopOverCharge()
	  - (totalSecureCharge + totalClassDiffPlus - audit.getLessAmt());
      }
      else {	/* totalNuc0ʤ̳(ticketFare)totalNuc򻻽 */
	audit.setTotalNuc(audit.getTicketFare() / audit.getRoeRate());
	componentValue[componentIndex] =
	  audit.getTotalNuc() - totalNucValue - audit.getStopOverCharge()
	  - (totalSecureCharge + totalClassDiffPlus - audit.getLessAmt());
      }
      totalNucValue += componentValue[componentIndex];
      /* Stop Over Charge2ְʾFare Componentʬ */
      componentStopOverCharge[componentIndex] = (double)0;
      if (audit.getStopOverCharge() > 0
	  && sectorsInComponent[componentIndex] > 1) {
	stopOverCnt++;
	componentStopOverCharge[componentIndex] = (double)1;
      }
      componentIndex += sideIndex;
      componentIndex++;
    }

    totalNucValue +=
      totalSecureCharge + totalClassDiffPlus - audit.getLessAmt();

    /* lessСFare ComponentϢ뤷totalNuc򤽤βͳۤȤ */
    if (audit.getLessAmt() > (double)0) {
      /*
	componentValue[0] = totalNucValue;
      */
      componentValue[0] =
	totalNucValue - totalSecureCharge - totalClassDiffPlus;
      for (int i = 0; i < audit.getSectors().length; i++) {
	((ProrateSector)audit.getSectors()[i]).setComponentIndex(0);
      }
      componentIndex = 1;
      if (stopOverCnt > 1) {
	stopOverCnt = 1;
	componentStopOverCharge[0] = (double)1;
      }
    }

    /* Stop Over Charge2ְʾFare Componentʬۤ */
    if (audit.getStopOverCharge() > 0 && stopOverCnt > 0) {
      for (int i = 0; i < componentIndex; i++) {
	if (componentStopOverCharge[i] == (double)1) {
	  componentStopOverCharge[i] =
	    audit.getStopOverCharge() / stopOverCnt;
	  componentValue[i] += componentStopOverCharge[i];
	  totalNucValue += componentStopOverCharge[i];
	}
      }
    }

    /* 㤤顼ǡΤ() */
    if (totalNucValue == (double)0 && audit.getTicketFare() != (double)0) {
      error(ProrateAudit.ERA_TOTALNUC);
      return false;
    }

    /* ʬۤǡFare ComponentǡΥ饹󥹥󥹤 */

    if (!audit.isOwnAudit()) {	/* ¾ҷ϶֤fareʤɤζۤͥ */
      /* ;;; not for return */
      audit.setTicketFare(totalNucValue * audit.getRoeRate());
      audit.setTotalNuc(totalNucValue);
      audit.setAmountRatio((double)1);
    }
    else {	/* ҷ϶֤fareʤɤΨ˷̳/totalNucʬ */
      if (audit.getTicketFare() > (double)0) {
	audit.setTotalNuc(audit.getTicketFare() / audit.getRoeRate());
      }
      audit.setAmountRatio(audit.getTotalNuc() / totalNucValue);
      for (int i = 0; i < componentIndex; i++) {
	componentValue[i] *= audit.getAmountRatio();
      }
    }

    List<ProrateFareComponent> components = new Vector<ProrateFareComponent>();
    for (int ix = 0; ix < componentIndex; ix++) {
      List<ProrateSector>	fSectors = new Vector<ProrateSector>();
      int	componentKind = 0;
      for (int j = 0; j < audit.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
	if (sector.getComponentIndex() == ix) {
	  fSectors.add(sector);
	  componentKind = sector.getComponentKind();
	}
      }
      ProrateSector	sectorsArray[] = new ProrateSector[fSectors.size()];
      for (int j = 0; j < fSectors.size(); j++) {
	sectorsArray[j] = (ProrateSector)fSectors.get(j);
      }
      ProrateFareComponent
	component = new ProrateFareComponent(audit, sectorsArray);
      /* ;;; ???
	 components[ix].value = componentValue[ix];
      */
      component.setValue(componentValue[ix] * audit.getRoeRate()
			 / audit.getDay5Rate());
      component.setKind(componentKind);
      components.add(component);
      ((ProrateSector)fSectors.get(fSectors.size()-1))
	.setFareComponent(component.getValue());

      trace.trace(component, ix, componentValue[ix],
		  audit.getRoeRate(), audit.getDay5Rate());
    }
    ProrateFareComponent[]
      componentArray = new ProrateFareComponent[components.size()];
    for (int j = 0; j < components.size(); j++) {
      componentArray[j] = (ProrateFareComponent)components.get(j);
    }
    audit.setComponents(componentArray);

    return true;
  }

  boolean	prorateRest() {

    double	totalProrateValue = (double)0;

    if (audit.isNonProrateRest()) {	/* ;;; version 3 */
      return true;
    }

    /* ιζ֤ˤĤƷꤵ줿ץ졼ȥХ塼û */
    for (int i = 0; i < audit.getSectors().length; i++) {
      totalProrateValue +=
	((ProrateSector)audit.getSectors()[i]).getProrateValue();
    }

    /* ץ졼ȥХ塼­ʬ */
    double valueRest =
      (audit.getTotalNuc() * audit.getRoeRate() / audit.getDay5Rate())
      - totalProrateValue;

    /* ץ졼ȥХ塼ۤtotalNuc¤Ȱפʤ(SPAΤ) */
    if (valueRest != (double)0) {
      boolean	found = false;
      double	totalProrateFactor = (double)0;
      /* ȯꥢ֤СΥץ졼ȥե¤ */
      for (int i = 0; i < audit.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	if ((sector.getCarrier().equals(audit.getAirwayId())
	     && sector.getOpCarrier().equals(""))
	    || sector.getOpCarrier().equals(audit.getAirwayId())) {
	  totalProrateFactor += sector.getProrateFactor();
	  found = true;
	}
      }
      if (!found) {
	return true;
      }
      /* ȯꥢζ֤صŪ˰ʬƲäƤ */
      for (int j = 0; j < audit.getSectors().length; j++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
	if ((sector.getCarrier().equals(audit.getAirwayId())
	     && sector.getOpCarrier().equals(""))
	    || sector.getOpCarrier().equals(audit.getAirwayId())) {
	  sector.setProrateValue(sector.getProrateValue() +
				 valueRest * sector.getProrateFactor()
				 / totalProrateFactor);
	  trace.traceRest(audit, valueRest, totalProrateFactor, j);
	}
      }
    }

    return true;
  }
  
  boolean	postProcess() {
    if (!setDiscountedValue()) {
      return false;
    }
    /* ;;; version 3 */
    if (audit.isOwnAudit() && audit.isTicketing() && !audit.isInward()) {
      if (!prorateDiscount()) {
	return false;
      }
    }
    if (audit.isOwnAudit() && audit.isTicketing()) {
      if (tax.divide(audit)) {
	// return false;	/* dividing tax algothythm is excluded */
      }
    }
    if (!prorateCommission()) {
      return false;
    }
    return true;
  }

  double	discountedValue = (double)0;
  boolean	setDiscountedValue() {
    if (!audit.getSalesCurrency().equals("")
	&& !audit.getSalesCurrency().equals(audit.getCurrency())) {
      double	day5Rate;	/* rate for salesCurrency */
      if ((day5Rate = database.getMeanRate(audit.getSalesCurrency(),
					   audit.getInvoiceMonth()))
	  <= (double)0
	  && ((day5Rate = database.get5dayRate(audit.getSalesCurrency(),
					       audit.getInvoiceMonth()))
	      < (double)0)) {
	if (database.getResult() > 1) {
	  DBError(null, "get5dayRate",
		  audit.getSalesCurrency(), audit.getInvoiceMonth());
	}
	error(ProrateAudit.ASK_5DAYRATE,
	      audit.getSalesCurrency() + ":" + audit.getInvoiceMonth());
	return false;
      }
      discountedValue = audit.getSalesFare() / day5Rate;
    }
    else {
      /* rate for currency */
      discountedValue = audit.getSalesFare() / audit.getDay5Rate();
    }
    return true;
  }

  boolean	prorateDiscount() {
    double	totalProrateValue = (double)0;

    if (audit.isNonProrateRest()) {	/* ;;; version 3 */
      return true;
    }

    /* ιζ֤ˤĤƷꤵ줿ץ졼ȥХ塼û */
    for (int i = 0; i < audit.getSectors().length; i++) {
      totalProrateValue
	+= ((ProrateSector)audit.getSectors()[i]).getProrateValue();
    }

    /* Ͱۤץ졼ȥХ塼ۤȰפʤ */
    if (Math.abs(totalProrateValue - discountedValue) > 0.01) {
      boolean	found = false;
      double	totalProrateFactor = (double)0;
      double	valueRest = discountedValue;
      for (int i = 0; i < audit.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	/* ͰĴоݤȤƼҶ֤õ */
	if ((sector.getCarrier().equals(audit.getAirwayId())
	     && sector.getOpCarrier().equals(""))
	    || sector.getOpCarrier().equals(audit.getAirwayId())) {
	  totalProrateFactor += sector.getProrateFactor();
	  found = true;
	}
	else {	/* ҶְʳprorateValueͰۤ */
	  valueRest -= sector.getProrateValue();
	}
      }
      if (found) {	/* Ҷ֤СͰۤλĤʬ */
	for (int i = 0; i < audit.getSectors().length; i++) {
	  ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	  if ((sector.getCarrier().equals(audit.getAirwayId())
	       && sector.getOpCarrier().equals(""))
	      || sector.getOpCarrier().equals(audit.getAirwayId())) {
	    sector.setProrateValue(valueRest * sector.getProrateFactor()
				   / totalProrateFactor);
	    trace.traceDiscount(audit, valueRest, false,
				totalProrateFactor, i);
	  }
	}
      }
      else {	/* Ҷ֤ʤС֤ͰκۤĴ */
	((ProrateSector)audit.getSectors()[0])
	  .setProrateValue(((ProrateSector)audit.getSectors()[0])
			   .getProrateValue()
			   + discountedValue - totalProrateValue);
	trace.traceDiscount(audit, discountedValue - totalProrateValue,
			    true, (double)0, 0);
      }

      /* ͰĴ֤prorateValue¤ */
      totalProrateValue = (double)0;
      for (int j = 0; j < audit.getSectors().length; j++) {
	totalProrateValue
	  += ((ProrateSector)audit.getSectors()[j]).getProrateValue();
      }
      /* ¤Ͱۤ԰פλprorateValue>0κǽζ֤Ĵ */
      if (totalProrateValue != discountedValue) {
	for (int i = 0; i < audit.getSectors().length; i++) {
	  ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	  if (sector.getProrateValue() > 0) {
	    sector.setProrateValue(sector.getProrateValue()
				   + discountedValue - totalProrateValue);
	    trace.traceDiscount(audit,
				discountedValue - totalProrateValue,
				true, (double)0, i);
	    break;
	  }
	}
      }
    }

    double	totalProrateFactor = (double)0;
    boolean	found = false;	/* prorateValue < 0 ζ֤õ */
    for (int j = 0; j < audit.getSectors().length; j++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[j];
      if (sector.getProrateValue() < (double)0) {
	found = true;
      }
      totalProrateFactor += sector.getProrateFactor();
    }
    if (found) {	/* prorateValue < 0 ζ֤SRPȤ */
      totalProrateValue = (double)0;	/* SRP̤ProrateValue */
      for (int i = 0; i < audit.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	sector.setProrateValue(discountedValue * sector.getProrateFactor()
			       / totalProrateFactor);
	totalProrateValue += sector.getProrateValue();
	trace.traceDiscount(audit, discountedValue,
			    false, totalProrateFactor, i);
      }
      /* ;;; ??? ֤ۤĴ */
      if (totalProrateValue != discountedValue) {
	((ProrateSector)audit.getSectors()[0])
	  .setProrateValue(((ProrateSector)audit.getSectors()[0])
			   .getProrateValue()
			   + discountedValue - totalProrateValue);
	trace.traceDiscount(audit, discountedValue - totalProrateValue,
			    true, (double)0, 0);
      }
    }

    return true;
  }

  boolean	prorateZero() {
    for (int i = 0; i < audit.getSectors().length; i++) {
      ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
      sector.setSrpNuc((double)0);
      sector.setProrateValue((double)0);
      sector.setProrationType(0);
    }
    return true;
  }

  public boolean	prorateCommission() {
    if (audit.isOwnAudit() && audit.isTicketing()) {	/* ;;; version 3 */
      /* ҷcommission */
      double	commissionTotal = (double)0;
      int	restIndex = -1;
      boolean	noAmt = false;
      if (audit.getCommissionAmt() == (double)0) {
	/* ;;; commission from salesFare */
	audit.setCommissionAmt(discountedValue
			       * audit.getCommissionRate() / 100);
      }
      else if (!audit.getCommissionCurrency().equals("")
	       && !audit.getCommissionCurrency().equals(audit.getCurrency())) {
	double	day5Rate = (double)0;	/* rate for commissionCurrency */
	if (((day5Rate = database.getMeanRate(audit.getCommissionCurrency(),
					      audit.getInvoiceMonth()))
	     <= (double)0)
	    && ((day5Rate = database.get5dayRate(audit.getCommissionCurrency(),
						 audit.getInvoiceMonth()))
		< (double)0)) {
	  if (database.getResult() > 1) {
	    DBError(null, "get5dayRate",
		    audit.getCommissionCurrency(), audit.getInvoiceMonth());
	    return false;
	  }
	  error(ProrateAudit.ASK_5DAYRATE,
		audit.getCommissionCurrency() + ":" + audit.getInvoiceMonth());
	  return false;
	}
	audit.setCommissionAmt(audit.getCommissionAmt() / day5Rate);
      }
      else {
	if (audit.getDay5Rate() <= (double)0) {
	  audit.setDay5Rate(database.getMeanRate(audit.getCurrency(),
						 audit.getInvoiceMonth()));
	  if (audit.getDay5Rate() <= (double)0) {
	    audit.setDay5Rate(database.get5dayRate(audit.getCurrency(),
						   audit.getInvoiceMonth()));
	    if (audit.getDay5Rate() < (double)0) {
	      if (database.getResult() > 1) {
		DBError(null, "get5dayRate",
			audit.getCurrency(), audit.getInvoiceMonth());
		return false;
	      }
	      error(ProrateAudit.ASK_5DAYRATE,
		    audit.getCurrency() + ":" + audit.getInvoiceMonth());
	      return false;
	    }
	  }
	}
	/* rate for currency */
	audit.setCommissionAmt(audit.getCommissionAmt() / audit.getDay5Rate());
      }

      for (int i = 0; i < audit.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	if (discountedValue != (double)0) {
	  /* ;;; commission from salesFare */
	  sector.setCommission(sector.getProrateValue()
			       * audit.getCommissionAmt()
			       / discountedValue);
	}
	else {
	  sector.setCommission((double)0);
	}
	commissionTotal += sector.getCommission();
	/* ;;; ??? amountInLocal
	   sector->commissionInLocal =
	   sector->amountInLocal * commissionRate / 100;
	*/
	sector.setInvoiceValue(sector.getProrateValue()
			       + sector.getTax() - sector.getCommission());
      }
      if (commissionTotal > audit.getCommissionAmt()) {
	for (int i = 0; i < audit.getSectors().length; i++) {
	  ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	  if (sector.getCarrier().equals(audit.getAirwayId())) {
	    sector.setCommission(sector.getCommission() + commissionTotal
				 - audit.getCommissionAmt());
	    restIndex = i;
	    break;
	  }
	}
      }
      else {
	for (int i = 0; i < audit.getSectors().length; i++) {
	  ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	  if (!sector.getCarrier().equals(audit.getAirwayId())) {
	    sector.setCommission(sector.getCommission() + commissionTotal
				 - audit.getCommissionAmt());
	    restIndex = i;
	    break;
	  }
	}
      }
      trace.traceCommission(audit, noAmt, discountedValue, restIndex,
			    commissionTotal - audit.getCommissionAmt());
    }
    else {	/* ;;; ??? ¾ҷμ amountInLocal, taxInLocal ?? */
      for (int i = 0; i < audit.getSectors().length; i++) {
	ProrateSector	sector = (ProrateSector)audit.getSectors()[i];
	/* ;;; ??? amountInLocal
	   sectors[i]->amountInLocal = sectors[i]->prorateValue * day5Rate;
	*/
	/* ;;; ??? taxInLocal
	   sectors[i]->tax = sectors[i]->taxInLocal / day5Rate;
	*/
	sector.setCommission(sector.getProrateValue()
			     * audit.getCommissionRate() / 100);
	/* ;;; ??? amountInLocal
	   sectors[i]->commissionInLocal =
	   sectors[i]->amountInLocal * commissionRate / 100;
	*/
	sector.setInvoiceValue(sector.getProrateValue() + sector.getTax()
			       - sector.getCommission());
      }
      trace.traceCommission(audit, false, discountedValue, -1, (double)0);
    }
    return true;
  }
  
  public String	getCountryName(String place) {
    String	country = database.getCountryName(place, audit.getIssueDate());
    if (country.equals("")) {
      for (int i = 0; i < audit.getAskTable().length; i++) {
	ProrateAskTable	tbl = (ProrateAskTable)audit.getAskTable()[i];
	if (!tbl.isArea && tbl.place.equals(place)) {
	  country = tbl.answer;
	  break;
	}
      }
    }
    return country;
  }
  
  String	getAreaName(String place) {
    String	area = database.getAreaName(place, audit.getIssueDate());
    if (area.equals("")) {
      for (int i = 0; i < audit.getAskTable().length; i++) {
	ProrateAskTable	tbl = (ProrateAskTable)audit.getAskTable()[i];
	if (!tbl.isArea && tbl.place.equals(place)) {
	  area = tbl.answer;
	  break;
	}
      }
    }
    return area;
  }

  boolean	setFixedFare() {
    audit.setFixedFare(database.getFixedFare(audit.getIssueDate()));
    if (audit.getFixedFare() < (double)0) {
      if (database.getResult() > 1) {
	DBError(null, "getFixedFare", audit.getIssueDate());
	return false;
      }
      error(ProrateAudit.ASK_FIXEDFARE, audit.getIssueDate());
      return false;
    }
    return true;
  }

  void	DBError(ProrateSector sector, String pointStr) {
    StringBuffer	errorStr = new StringBuffer(pointStr);
    errorStr.append(":");
    errorStr.append(database.getErrCode());
    errorStr.append(":");
    errorStr.append(database.getErrMessage());
    if (sector != null) {
      error(sector, ProrateAudit.ERR_DATABASE, errorStr.toString());
      return;	/* ;;; ??? */
    }
    error(ProrateAudit.ERA_DATABASE, errorStr.toString());
  }

  void	DBError(String pointStr) {
    DBError(null, pointStr);
  }
  
  public void	DBError(ProrateSector sector, String pointStr, String arg) {
    StringBuffer	errorStr = new StringBuffer(pointStr);
    errorStr.append("(");
    errorStr.append(arg);
    errorStr.append(")");
    DBError(sector, errorStr.toString());
  }

  public void	DBError(ProrateSector sector, String pointStr,
			String arg, String arg2) {
    StringBuffer	errorStr = new StringBuffer(pointStr);
    errorStr.append("(");
    errorStr.append(arg);
    errorStr.append(",");
    errorStr.append(arg2);
    errorStr.append(")");
    DBError(sector, errorStr.toString());
  }
  
  public void	error(int errorNo) {
    error(errorNo, "");
  }
  
  public void	error(int errorNo, String errorStr) {
    audit.setErrorFlag(errorNo);
    audit.setErrorString(errorStr);
  }

  public void	error(ProrateSector sector, int errorNo) {
    error(sector, errorNo, "");
  }
  
  public void	error(ProrateSector sector, int errorNo, String errorStr) {
    sector.setErrorFlag(errorNo);
    sector.setErrorString(errorStr);
  }

  public ProrateAudit getAudit() {
    return audit;
  }

  public void setAudit(ProrateAudit audit) {
    this.audit = audit;
  }

  public ProrateDatabase getDatabase() {
    return database;
  }

  public void setDatabase(ProrateDatabase database) {
    this.database = database;
  }

  public ProrateFcalc getFcalc() {
    return fcalc;
  }

  public void setFcalc(ProrateFcalc fcalc) {
    this.fcalc = fcalc;
  }

  public ProrateRulebase getRulebase() {
    return rulebase;
  }

  public void setRulebase(ProrateRulebase rulebase) {
    this.rulebase = rulebase;
  }

  public ProrateTax getTax() {
    return tax;
  }

  public void setTax(ProrateTax tax) {
    this.tax = tax;
  }

  public ProrateTrace getTrace() {
    return trace;
  }

  public void setTrace(ProrateTrace trace) {
    this.trace = trace;
  }
}
